/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive;

import com.google.common.base.MoreObjects;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.Multiset;
import com.google.common.io.MoreFiles;
import com.google.common.io.RecursiveDeleteOption;
import io.opentelemetry.sdk.trace.data.SpanData;
import io.trino.filesystem.Location;
import io.trino.filesystem.tracing.FileSystemAttributes;
import io.trino.plugin.hive.HiveQueryRunner;
import io.trino.testing.AbstractTestQueryFramework;
import io.trino.testing.DistributedQueryRunner;
import io.trino.testing.MultisetAssertions;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.intellij.lang.annotations.Language;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@Execution(value=ExecutionMode.SAME_THREAD)
public class TestHiveFileOperations
extends AbstractTestQueryFramework {
    private static final Pattern DATA_FILE_PATTERN = Pattern.compile(".*?/(?<partition>key=[^/]*/)?(?<queryId>\\d{8}_\\d{6}_\\d{5}_\\w{5})_(?<uuid>[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12})");

    protected DistributedQueryRunner createQueryRunner() throws Exception {
        Path metastoreDirectory = Files.createTempDirectory("hive", new FileAttribute[0]);
        this.closeAfterClass(() -> MoreFiles.deleteRecursively((Path)metastoreDirectory, (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE}));
        ImmutableMap hiveProperties = ImmutableMap.builder().put((Object)"hive.file-status-cache-tables", (Object)"*").put((Object)"hive.metastore", (Object)"file").put((Object)"hive.metastore.catalog.dir", (Object)metastoreDirectory.toUri().toString()).buildOrThrow();
        return ((HiveQueryRunner.Builder)((HiveQueryRunner.Builder)HiveQueryRunner.builder().setCoordinatorProperties((Map)ImmutableMap.of((Object)"node-scheduler.include-coordinator", (Object)"false"))).setHiveProperties((Map<String, String>)hiveProperties).setWorkerCount(1)).build();
    }

    @Test
    public void testCacheDirectoryListingOperations() {
        this.assertQuerySucceeds("CALL system.flush_metadata_cache()");
        this.assertUpdate("DROP TABLE IF EXISTS test_directory_listing_partitioned_a");
        this.assertUpdate("DROP TABLE IF EXISTS test_directory_listing_unpartitioned");
        this.assertUpdate("CREATE TABLE test_directory_listing_partitioned_a(data varchar, key varchar) WITH (partitioned_by=ARRAY['key'], format='parquet')");
        this.assertUpdate("INSERT INTO test_directory_listing_partitioned_a VALUES ('1-abc', 'p1')", 1L);
        this.assertUpdate("CREATE TABLE test_directory_listing_unpartitioned(data varchar, key varchar) WITH (format='parquet')");
        this.assertUpdate("INSERT INTO test_directory_listing_unpartitioned VALUES ('1-abc', 'p1')", 1L);
        this.assertUpdate("INSERT INTO test_directory_listing_unpartitioned VALUES ('2-xyz', 'p2')", 1L);
        this.assertFileSystemAccesses("SELECT * FROM test_directory_listing_partitioned_a", (Multiset<FileOperation>)ImmutableMultiset.builder().add((Object)new FileOperation("Input.readTail", "key=p1/")).add((Object)new FileOperation("FileSystem.listFiles", "test_directory_listing_partitioned_a")).add((Object)new FileOperation("FileSystem.listFiles", "key=p1")).build());
        this.assertFileSystemAccesses("SELECT * FROM test_directory_listing_partitioned_a", (Multiset<FileOperation>)ImmutableMultiset.builder().add((Object)new FileOperation("Input.readTail", "key=p1/")).add((Object)new FileOperation("FileSystem.listFiles", "test_directory_listing_partitioned_a")).build());
        this.assertFileSystemAccesses("SELECT * FROM test_directory_listing_unpartitioned", (Multiset<FileOperation>)ImmutableMultiset.builder().addCopies((Object)new FileOperation("Input.readTail", "no partition"), 2).add((Object)new FileOperation("FileSystem.listFiles", "test_directory_listing_unpartitioned")).build());
        this.assertFileSystemAccesses("SELECT * FROM test_directory_listing_unpartitioned", (Multiset<FileOperation>)ImmutableMultiset.builder().addCopies((Object)new FileOperation("Input.readTail", "no partition"), 2).build());
        this.assertUpdate("INSERT INTO test_directory_listing_partitioned_a VALUES ('2-xyz', 'p2')", 1L);
        this.assertFileSystemAccesses("SELECT * FROM test_directory_listing_partitioned_a", (Multiset<FileOperation>)ImmutableMultiset.builder().add((Object)new FileOperation("Input.readTail", "key=p1/")).add((Object)new FileOperation("Input.readTail", "key=p2/")).add((Object)new FileOperation("FileSystem.listFiles", "test_directory_listing_partitioned_a")).add((Object)new FileOperation("FileSystem.listFiles", "key=p2")).build());
        this.assertFileSystemAccesses("SELECT * FROM test_directory_listing_partitioned_a", (Multiset<FileOperation>)ImmutableMultiset.builder().add((Object)new FileOperation("Input.readTail", "key=p1/")).add((Object)new FileOperation("Input.readTail", "key=p2/")).add((Object)new FileOperation("FileSystem.listFiles", "test_directory_listing_partitioned_a")).build());
        this.assertQuerySucceeds("CALL system.flush_metadata_cache(schema_name => CURRENT_SCHEMA, table_name => 'test_directory_listing_partitioned_a', partition_columns => ARRAY['key'],partition_values => ARRAY['p1'])");
        this.assertFileSystemAccesses("SELECT * FROM test_directory_listing_partitioned_a", (Multiset<FileOperation>)ImmutableMultiset.builder().add((Object)new FileOperation("Input.readTail", "key=p1/")).add((Object)new FileOperation("Input.readTail", "key=p2/")).add((Object)new FileOperation("FileSystem.listFiles", "test_directory_listing_partitioned_a")).add((Object)new FileOperation("FileSystem.listFiles", "key=p1")).build());
        this.assertFileSystemAccesses("SELECT * FROM test_directory_listing_unpartitioned", (Multiset<FileOperation>)ImmutableMultiset.builder().addCopies((Object)new FileOperation("Input.readTail", "no partition"), 2).build());
        this.assertQuerySucceeds("CALL system.flush_metadata_cache(schema_name => CURRENT_SCHEMA, table_name => 'test_directory_listing_partitioned_a')");
        this.assertFileSystemAccesses("SELECT * FROM test_directory_listing_partitioned_a", (Multiset<FileOperation>)ImmutableMultiset.builder().add((Object)new FileOperation("Input.readTail", "key=p1/")).add((Object)new FileOperation("Input.readTail", "key=p2/")).add((Object)new FileOperation("FileSystem.listFiles", "test_directory_listing_partitioned_a")).add((Object)new FileOperation("FileSystem.listFiles", "key=p1")).add((Object)new FileOperation("FileSystem.listFiles", "key=p2")).build());
        this.assertFileSystemAccesses("SELECT * FROM test_directory_listing_unpartitioned", (Multiset<FileOperation>)ImmutableMultiset.builder().addCopies((Object)new FileOperation("Input.readTail", "no partition"), 2).build());
        this.assertQuerySucceeds("CALL system.flush_metadata_cache()");
        this.assertFileSystemAccesses("SELECT * FROM test_directory_listing_partitioned_a", (Multiset<FileOperation>)ImmutableMultiset.builder().add((Object)new FileOperation("Input.readTail", "key=p1/")).add((Object)new FileOperation("Input.readTail", "key=p2/")).add((Object)new FileOperation("FileSystem.listFiles", "test_directory_listing_partitioned_a")).add((Object)new FileOperation("FileSystem.listFiles", "key=p1")).add((Object)new FileOperation("FileSystem.listFiles", "key=p2")).build());
        this.assertFileSystemAccesses("SELECT * FROM test_directory_listing_unpartitioned", (Multiset<FileOperation>)ImmutableMultiset.builder().addCopies((Object)new FileOperation("Input.readTail", "no partition"), 2).add((Object)new FileOperation("FileSystem.listFiles", "test_directory_listing_unpartitioned")).build());
        this.assertUpdate("DROP TABLE test_directory_listing_partitioned_a");
        this.assertUpdate("DROP TABLE test_directory_listing_unpartitioned");
    }

    private void assertFileSystemAccesses(@Language(value="SQL") String query, Multiset<FileOperation> expectedAccesses) {
        DistributedQueryRunner queryRunner = this.getDistributedQueryRunner();
        queryRunner.executeWithPlan(queryRunner.getDefaultSession(), query);
        MultisetAssertions.assertMultisetsEqual(this.getFileOperations(), expectedAccesses);
    }

    private Multiset<FileOperation> getFileOperations() {
        return (Multiset)this.getQueryRunner().getSpans().stream().filter(span -> span.getName().startsWith("Input.") || span.getName().startsWith("InputFile.") || span.getName().startsWith("FileSystem.list")).filter(span -> !span.getName().startsWith("InputFile.newInput")).filter(span -> !TestHiveFileOperations.isTrinoSchemaOrPermissions(Objects.requireNonNull((String)span.getAttributes().get(FileSystemAttributes.FILE_LOCATION)))).map(FileOperation::createFileOperation).collect(Collectors.toCollection(HashMultiset::create));
    }

    private static boolean isTrinoSchemaOrPermissions(String path) {
        return path.endsWith(".trinoSchema") || path.contains(".trinoPermissions") || path.contains(".roleGrants") || path.contains(".roles");
    }

    private record FileOperation(String operationName, String fileName) {
        public FileOperation {
            Objects.requireNonNull(operationName, "operationName is null");
            Objects.requireNonNull(fileName, "fileName is null");
        }

        private static FileOperation createFileOperation(SpanData span) {
            Matcher matcher;
            String operationName = span.getName();
            String path = Objects.requireNonNull((String)span.getAttributes().get(FileSystemAttributes.FILE_LOCATION));
            String fileName = Location.of((String)path).fileName();
            if (!path.contains("/.trino") && (matcher = DATA_FILE_PATTERN.matcher(path)).matches()) {
                return new FileOperation(operationName, (String)MoreObjects.firstNonNull((Object)matcher.group("partition"), (Object)"no partition"));
            }
            return new FileOperation(operationName, fileName);
        }
    }
}

