/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.trino.block.BlockAssertions;
import io.trino.metastore.HiveType;
import io.trino.plugin.hive.HiveColumnHandle;
import io.trino.plugin.hive.HivePageSourceProvider;
import io.trino.plugin.hive.TestHiveReaderProjectionsUtil;
import io.trino.plugin.hive.util.HiveTypeTranslator;
import io.trino.spi.Page;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.RowBlock;
import io.trino.spi.block.SqlRow;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ConnectorPageSource;
import io.trino.spi.connector.FixedPageSource;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class TestHivePageSourceProvider {
    private static final HiveColumnHandle BASE_COLUMN = HiveColumnHandle.createBaseColumn((String)"col", (int)0, (HiveType)HiveTypeTranslator.toHiveType((Type)TestHiveReaderProjectionsUtil.ROWTYPE_OF_ROW_AND_PRIMITIVES), (Type)TestHiveReaderProjectionsUtil.ROWTYPE_OF_ROW_AND_PRIMITIVES, (HiveColumnHandle.ColumnType)HiveColumnHandle.ColumnType.REGULAR, Optional.empty());

    TestHivePageSourceProvider() {
    }

    @Test
    void testProjectColumnDereferences() throws Exception {
        Page outputPage;
        ImmutableList columns = ImmutableList.of((Object)TestHiveReaderProjectionsUtil.createProjectedColumnHandle(BASE_COLUMN, (List<Integer>)ImmutableList.of((Object)0, (Object)0)), (Object)TestHiveReaderProjectionsUtil.createProjectedColumnHandle(BASE_COLUMN, (List<Integer>)ImmutableList.of((Object)0)));
        try (ConnectorPageSource connectorPageSource = HivePageSourceProvider.projectColumnDereferences((List)columns, TestHivePageSourceProvider::createPageSource);){
            outputPage = connectorPageSource.getNextSourcePage().getPage();
        }
        Block baseInputBlock = TestHivePageSourceProvider.createInputPage().getBlock(0);
        int columnsSize = columns.size();
        for (int i = 0; i < columnsSize; ++i) {
            HiveColumnHandle column = (HiveColumnHandle)columns.get(i);
            TestHivePageSourceProvider.verifyBlock(outputPage.getBlock(i), column.getType(), baseInputBlock, BASE_COLUMN.getType(), HivePageSourceProvider.getProjection((ColumnHandle)column, (ColumnHandle)BASE_COLUMN));
        }
    }

    private static FixedPageSource createPageSource(List<HiveColumnHandle> columns) {
        Assertions.assertThat(columns).containsOnly((Object[])new HiveColumnHandle[]{BASE_COLUMN});
        return new FixedPageSource((List)ImmutableList.of((Object)TestHivePageSourceProvider.createInputPage()));
    }

    private static Page createInputPage() {
        ArrayList<Object> inputBlockData = new ArrayList<Object>();
        inputBlockData.add(RowData.rowData(RowData.rowData(11L, 12L, 13L), 1L));
        inputBlockData.add(RowData.rowData(null, 2L));
        inputBlockData.add(null);
        inputBlockData.add(RowData.rowData(RowData.rowData(31L, 32L, 33L), 3L));
        return new Page(new Block[]{TestHivePageSourceProvider.createInputBlock(inputBlockData, BASE_COLUMN.getType())});
    }

    private static Block createInputBlock(List<Object> data, Type type) {
        if (type instanceof RowType) {
            RowType rowType = (RowType)type;
            return TestHivePageSourceProvider.createRowBlock(data, rowType);
        }
        if (BigintType.BIGINT.equals((Object)type)) {
            return TestHivePageSourceProvider.createLongArrayBlock(data);
        }
        throw new UnsupportedOperationException();
    }

    private static Block createRowBlock(List<Object> data, RowType rowType) {
        int positionCount = data.size();
        boolean[] isNull = new boolean[positionCount];
        int fieldCount = rowType.getFields().size();
        ArrayList fieldsData = new ArrayList();
        for (int i = 0; i < fieldCount; ++i) {
            fieldsData.add(new ArrayList());
        }
        for (int position = 0; position < data.size(); ++position) {
            int field;
            RowData row = (RowData)data.get(position);
            if (row == null) {
                isNull[position] = true;
                for (field = 0; field < fieldCount; ++field) {
                    ((List)fieldsData.get(field)).add(null);
                }
                continue;
            }
            for (field = 0; field < fieldCount; ++field) {
                ((List)fieldsData.get(field)).add(row.getField(field));
            }
        }
        Block[] fieldBlocks = new Block[fieldCount];
        for (int field = 0; field < fieldCount; ++field) {
            fieldBlocks[field] = TestHivePageSourceProvider.createInputBlock((List)fieldsData.get(field), ((RowType.Field)rowType.getFields().get(field)).getType());
        }
        return RowBlock.fromNotNullSuppressedFieldBlocks((int)positionCount, Optional.of(isNull), (Block[])fieldBlocks);
    }

    private static Block createLongArrayBlock(List<Object> data) {
        BlockBuilder builder = BigintType.BIGINT.createFixedSizeBlockBuilder(data.size());
        for (Object datum : data) {
            if (datum == null) {
                builder.appendNull();
                continue;
            }
            BigintType.BIGINT.writeLong(builder, ((Long)datum).longValue());
        }
        return builder.build();
    }

    private static void verifyBlock(Block actualBlock, Type outputType, Block input, Type inputType, List<Integer> dereferences) {
        Assertions.assertThat((Object)inputType).isInstanceOf(RowType.class);
        Block expectedOutputBlock = TestHivePageSourceProvider.createProjectedColumnBlock(input, outputType, (RowType)inputType, dereferences);
        BlockAssertions.assertBlockEquals((Type)outputType, (Block)actualBlock, (Block)expectedOutputBlock);
    }

    private static Block createProjectedColumnBlock(Block data, Type finalType, RowType blockType, List<Integer> dereferences) {
        if (dereferences.isEmpty()) {
            return data;
        }
        BlockBuilder builder = finalType.createBlockBuilder(null, data.getPositionCount());
        for (int i = 0; i < data.getPositionCount(); ++i) {
            RowType sourceType = blockType;
            SqlRow currentData = null;
            boolean isNull = data.isNull(i);
            if (!isNull) {
                currentData = sourceType.getObject(data, i);
            }
            for (int j = 0; j < dereferences.size() - 1 && !isNull; ++j) {
                int fieldIndex = dereferences.get(j);
                Block fieldBlock = currentData.getRawFieldBlock(fieldIndex);
                RowType rowType = sourceType;
                int rawIndex = currentData.getRawIndex();
                if (fieldBlock.isNull(rawIndex)) {
                    currentData = null;
                } else {
                    sourceType = (RowType)((RowType.Field)rowType.getFields().get(fieldIndex)).getType();
                    currentData = sourceType.getObject(fieldBlock, rawIndex);
                }
                isNull = currentData == null;
            }
            if (isNull) {
                builder.appendNull();
                continue;
            }
            int lastDereference = dereferences.getLast();
            finalType.appendTo(currentData.getRawFieldBlock(lastDereference), currentData.getRawIndex(), builder);
        }
        return builder.build();
    }

    static class RowData {
        private final List<?> data;

        private RowData(Object ... data) {
            this.data = Arrays.asList(Objects.requireNonNull(data, "data is null"));
        }

        static RowData rowData(Object ... data) {
            return new RowData(data);
        }

        Object getField(int field) {
            Preconditions.checkArgument((field >= 0 && field < this.data.size() ? 1 : 0) != 0);
            return this.data.get(field);
        }
    }
}

