/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import io.trino.plugin.hive.HiveErrorCode;
import io.trino.plugin.hive.HiveToTrinoTranslator;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.sql.parser.SqlParser;
import io.trino.testing.assertions.TrinoExceptionAssert;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestHiveQlTranslation {
    private final SqlParser parser = new SqlParser();
    private static Map<String, String> simpleColumnNames = ImmutableMap.builder().put((Object)"unquoted", (Object)"unquoted").put((Object)"`backquoted`", (Object)"\"backquoted\"").put((Object)"`sometable`.`backquoted`", (Object)"\"sometable\".\"backquoted\"").put((Object)"'single quoted'", (Object)"'single quoted'").put((Object)"\"double quoted\"", (Object)"'double quoted'").put((Object)"''", (Object)"''").put((Object)"\"\"", (Object)"''").put((Object)"'\\''", (Object)"''''").put((Object)"\"\\\"\"", (Object)"'\"'").buildOrThrow();
    private static Map<String, String> extendedColumnNames = ImmutableMap.builder().putAll(simpleColumnNames).put((Object)"`id: ``back`", (Object)"\"id: `back\"").put((Object)"`id: \"double`", (Object)"\"id: \"\"double\"").put((Object)"`id: \"\"two double`", (Object)"\"id: \"\"\"\"two double\"").put((Object)"`id: two back`````", (Object)"\"id: two back``\"").put((Object)"'single: \"double'", (Object)"'single: \"double'").put((Object)"'single: \\'single'", (Object)"'single: ''single'").put((Object)"'single: \\'\\'two singles'", (Object)"'single: ''''two singles'").put((Object)"\"double: double\\\"\"", (Object)"'double: double\"'").put((Object)"\"double: single'\"", (Object)"'double: single'''").put((Object)"\"double: two singles''\"", (Object)"'double: two singles'''''").buildOrThrow();

    private static List<String> getNColumns(int n, Collection<String> columns) {
        return Lists.cartesianProduct(Collections.nCopies(n, List.copyOf(columns))).stream().map(names -> String.join((CharSequence)", ", names)).toList();
    }

    @Test
    public void testIdentifiers() {
        this.assertTranslation("SELECT * FROM nation", "SELECT * FROM nation");
        this.assertTranslation("SELECT * FROM `nation`", "SELECT * FROM \"nation\"");
        this.assertTranslation("SELECT `nation`.`nationkey` FROM `nation`", "SELECT \"nation\".\"nationkey\" FROM \"nation\"");
        this.assertTranslation("SELECT * FROM `it's a table`", "SELECT * FROM \"it's a table\"");
    }

    @Test
    public void testNumberLiterals() {
        this.assertTranslation("SELECT 1", "SELECT 1");
    }

    @Test
    public void testStringLiterals() {
        this.assertTranslation("SELECT '`'", "SELECT '`'");
        this.assertTranslation("SELECT 'it\\'s an \"apple\"'", "SELECT 'it''s an \"apple\"'");
        this.assertTranslation("SELECT \"it's an \\\"apple\\\"\"", "SELECT 'it''s an \"apple\"'");
        this.assertTranslation("SELECT \"`\"", "SELECT '`'");
        this.assertTranslation("SELECT '\"'", "SELECT '\"'");
        this.assertTranslation("SELECT \"'\"", "SELECT ''''");
        this.assertTranslation("SELECT '\\'`'", "SELECT '''`'");
        this.assertTranslation("SELECT '\\\\\\''", "SELECT '\\'''");
        this.assertTranslation("SELECT \"\\'`\"", "SELECT '''`'");
    }

    @Test
    public void testStringLiteralsWithNewLine() {
        this.assertTranslation("SELECT \"'\n'\"", "SELECT '''\n'''");
        this.assertTranslation("SELECT '\\'\n`'", "SELECT '''\n`'");
        this.assertTranslation("SELECT \"\\\n'`\"", "SELECT '\n''`'");
    }

    @Test
    public void testPredicates() {
        this.assertTranslation("SELECT \"'\" = \"'\" OR false", "SELECT '''' = '''' OR false");
    }

    @Test
    public void testSimpleColumns() {
        ImmutableList hiveColumns = ImmutableList.builder().addAll(TestHiveQlTranslation.getNColumns(1, simpleColumnNames.keySet())).addAll(TestHiveQlTranslation.getNColumns(3, simpleColumnNames.keySet())).build();
        ImmutableList trinoColumns = ImmutableList.builder().addAll(TestHiveQlTranslation.getNColumns(1, simpleColumnNames.values())).addAll(TestHiveQlTranslation.getNColumns(3, simpleColumnNames.values())).build();
        for (int i = 0; i < hiveColumns.size(); ++i) {
            this.assertTranslation(String.format("SELECT %s FROM sometable", hiveColumns.get(i)), String.format("SELECT %s FROM sometable", trinoColumns.get(i)));
        }
    }

    @Test
    public void testExtendedColumns() {
        ImmutableList hiveColumns = ImmutableList.builder().addAll(TestHiveQlTranslation.getNColumns(1, extendedColumnNames.keySet())).addAll(TestHiveQlTranslation.getNColumns(3, extendedColumnNames.keySet())).build();
        ImmutableList trinoColumns = ImmutableList.builder().addAll(TestHiveQlTranslation.getNColumns(1, extendedColumnNames.values())).addAll(TestHiveQlTranslation.getNColumns(3, extendedColumnNames.values())).build();
        for (int i = 0; i < hiveColumns.size(); ++i) {
            this.assertTranslation(String.format("SELECT %s FROM sometable", hiveColumns.get(i)), String.format("SELECT %s FROM sometable", trinoColumns.get(i)));
        }
    }

    @Test
    public void testEarlyEndOfInput() {
        String inString = "unexpected end of input in string";
        String inIdentifier = "unexpected end of input in identifier";
        this.assertViewTranslationError("SELECT \"open", inString);
        this.assertViewTranslationError("SELECT 'open", inString);
        this.assertViewTranslationError("SELECT `open", inIdentifier);
        this.assertViewTranslationError("SELECT \"open\\\"", inString);
        this.assertViewTranslationError("SELECT 'open\\'", inString);
        this.assertViewTranslationError("SELECT `open``", inIdentifier);
    }

    @Test
    public void testStringEscapes() {
        this.assertTranslation("SELECT '\\n' FROM sometable", "SELECT '\n' FROM sometable");
        this.assertTranslation("SELECT 'abc\\u03B5xyz' FROM sometable", "SELECT 'abc\u03b5xyz' FROM sometable");
    }

    private void assertTranslation(String hiveSql, String expectedTrinoSql) {
        String actualTrinoSql = HiveToTrinoTranslator.translateHiveViewToTrino((String)hiveSql);
        Assertions.assertThat((String)actualTrinoSql).isEqualTo(expectedTrinoSql);
        this.assertTrinoSqlIsParsable(expectedTrinoSql);
        this.assertTrinoSqlIsParsable(actualTrinoSql);
    }

    private void assertTrinoSqlIsParsable(String actualTrinoSql) {
        this.parser.createStatement(actualTrinoSql);
    }

    private void assertViewTranslationError(String badHiveQl, String expectMessage) {
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> HiveToTrinoTranslator.translateHiveViewToTrino((String)badHiveQl)).hasErrorCode(new ErrorCodeSupplier[]{HiveErrorCode.HIVE_VIEW_TRANSLATION_ERROR}).hasMessageContaining(expectMessage);
    }
}

