/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive;

import com.google.common.collect.ImmutableMap;
import io.trino.Session;
import io.trino.metastore.Table;
import io.trino.plugin.base.util.UncheckedCloseable;
import io.trino.plugin.hive.BaseS3AndGlueMetastoreTest;
import io.trino.plugin.hive.HiveQueryRunner;
import io.trino.plugin.hive.TestingHiveUtils;
import io.trino.plugin.hive.metastore.glue.GlueHiveMetastore;
import io.trino.spi.security.Identity;
import io.trino.spi.security.SelectedRole;
import io.trino.spi.type.Type;
import io.trino.sql.query.QueryAssertions;
import io.trino.testing.DistributedQueryRunner;
import io.trino.testing.MaterializedResult;
import io.trino.testing.QueryRunner;
import io.trino.testing.SystemEnvironmentUtils;
import io.trino.testing.TestingNames;
import io.trino.testing.TestingSession;
import io.trino.testing.assertions.TrinoExceptionAssert;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestHiveS3AndGlueMetastoreTest
extends BaseS3AndGlueMetastoreTest {
    public TestHiveS3AndGlueMetastoreTest() {
        super("partitioned_by", "external_location", SystemEnvironmentUtils.requireEnv((String)"S3_BUCKET"));
    }

    protected QueryRunner createQueryRunner() throws Exception {
        Session session = this.createSession(Optional.of(new SelectedRole(SelectedRole.Type.ROLE, Optional.of("admin"))));
        DistributedQueryRunner queryRunner = ((HiveQueryRunner.Builder)((Object)((HiveQueryRunner.Builder)((Object)((HiveQueryRunner.Builder)((Object)((HiveQueryRunner.Builder)((Object)((HiveQueryRunner.Builder)((Object)((HiveQueryRunner.Builder)((Object)((HiveQueryRunner.Builder)((HiveQueryRunner.Builder)((HiveQueryRunner.Builder)HiveQueryRunner.builder(session).addExtraProperty("sql.path", "hive.functions")).addExtraProperty("sql.default-function-catalog", "hive")).addExtraProperty("sql.default-function-schema", "functions")).setCreateTpchSchemas(false))).addHiveProperty("hive.metastore", "glue"))).addHiveProperty("hive.metastore.glue.default-warehouse-dir", this.schemaPath()))).addHiveProperty("hive.security", "allow-all"))).addHiveProperty("hive.non-managed-table-writes-enabled", "true"))).addHiveProperty("fs.native-s3.enabled", "true"))).build();
        queryRunner.execute("CREATE SCHEMA " + this.schemaName + " WITH (location = '" + this.schemaPath() + "')");
        queryRunner.execute("CREATE SCHEMA IF NOT EXISTS functions");
        this.metastore = TestingHiveUtils.getConnectorService((QueryRunner)queryRunner, GlueHiveMetastore.class);
        return queryRunner;
    }

    private Session createSession(Optional<SelectedRole> role) {
        return TestingSession.testSessionBuilder().setIdentity(Identity.forUser((String)"hive").withConnectorRoles((Map)role.map(selectedRole -> ImmutableMap.of((Object)"hive", (Object)selectedRole)).orElse(ImmutableMap.of())).build()).setCatalog("hive").setSchema(this.schemaName).build();
    }

    @Override
    protected Session sessionForOptimize() {
        return Session.builder((Session)this.getSession()).setCatalogSessionProperty((String)this.getSession().getCatalog().orElseThrow(), "non_transactional_optimize_enabled", "true").build();
    }

    @Override
    protected void validateDataFiles(String partitionColumn, String tableName, String location) {
        this.getActiveFiles(tableName).forEach(dataFile -> {
            Object locationDirectory = location.endsWith("/") ? location : location + "/";
            Object partitionPart = partitionColumn.isEmpty() ? "" : partitionColumn + "=[a-z0-9]+/";
            Assertions.assertThat((String)dataFile).matches((CharSequence)("^" + Pattern.quote((String)locationDirectory) + (String)partitionPart + "[a-zA-Z0-9_-]+$"));
            this.verifyPathExist((String)dataFile);
        });
    }

    @Override
    protected void validateMetadataFiles(String location) {
    }

    @Override
    protected Set<String> getAllDataFilesFromTableDirectory(String tableLocation) {
        return new HashSet<String>(this.getTableFiles(tableLocation));
    }

    @Override
    protected void validateFilesAfterOptimize(String location, Set<String> initialFiles, Set<String> updatedFiles) {
        Assertions.assertThat(updatedFiles).hasSizeLessThan(initialFiles.size());
        Assertions.assertThat(this.getAllDataFilesFromTableDirectory(location)).isEqualTo(updatedFiles);
    }

    @Override
    protected void testBasicOperationsWithProvidedTableLocation(boolean partitioned, BaseS3AndGlueMetastoreTest.LocationPattern locationPattern) {
        String tableName = "test_basic_operations_" + TestingNames.randomNameSuffix();
        String location = locationPattern.locationForTable(this.bucketName, this.schemaName, tableName);
        String partitionQueryPart = partitioned ? ",partitioned_by = ARRAY['col_int']" : "";
        String create = "CREATE TABLE " + tableName + "(col_str, col_int)WITH (external_location = '" + location + "'" + partitionQueryPart + ") AS VALUES ('str1', 1), ('str2', 2), ('str3', 3)";
        if (locationPattern == BaseS3AndGlueMetastoreTest.LocationPattern.DOUBLE_SLASH || locationPattern == BaseS3AndGlueMetastoreTest.LocationPattern.TRIPLE_SLASH || locationPattern == BaseS3AndGlueMetastoreTest.LocationPattern.TWO_TRAILING_SLASHES) {
            this.assertQueryFails(create, "\\QUnsupported location that cannot be internally represented: " + location);
            return;
        }
        this.assertUpdate(create, 3L);
        try (UncheckedCloseable ignored = this.onClose("DROP TABLE " + tableName);){
            this.assertQuery("SELECT * FROM " + tableName, "VALUES ('str1', 1), ('str2', 2), ('str3', 3)");
            String actualTableLocation = this.getTableLocation(tableName);
            Assertions.assertThat((String)actualTableLocation).isEqualTo(location);
            this.assertUpdate("INSERT INTO " + tableName + " VALUES ('str4', 4)", 1L);
            this.assertQuery("SELECT * FROM " + tableName, "VALUES ('str1', 1), ('str2', 2), ('str3', 3), ('str4', 4)");
            Assertions.assertThat(this.getTableFiles(actualTableLocation)).isNotEmpty();
            this.validateDataFiles(partitioned ? "col_int" : "", tableName, actualTableLocation);
        }
    }

    @Test
    public void testBasicOperationsWithProvidedTableLocationNonCTAS() {
        for (BaseS3AndGlueMetastoreTest.LocationPattern locationPattern : BaseS3AndGlueMetastoreTest.LocationPattern.values()) {
            this.testBasicOperationsWithProvidedTableLocationNonCTAS(false, locationPattern);
            this.testBasicOperationsWithProvidedTableLocationNonCTAS(true, locationPattern);
        }
    }

    private void testBasicOperationsWithProvidedTableLocationNonCTAS(boolean partitioned, BaseS3AndGlueMetastoreTest.LocationPattern locationPattern) {
        String tableName = "test_basic_operations_" + TestingNames.randomNameSuffix();
        String location = locationPattern.locationForTable(this.bucketName, this.schemaName, tableName);
        String partitionQueryPart = partitioned ? ",partitioned_by = ARRAY['col_int']" : "";
        String create = "CREATE TABLE " + tableName + "(col_str varchar, col_int integer) WITH (external_location = '" + location + "' " + partitionQueryPart + ")";
        if (locationPattern == BaseS3AndGlueMetastoreTest.LocationPattern.DOUBLE_SLASH || locationPattern == BaseS3AndGlueMetastoreTest.LocationPattern.TRIPLE_SLASH || locationPattern == BaseS3AndGlueMetastoreTest.LocationPattern.TWO_TRAILING_SLASHES) {
            this.assertQueryFails(create, "\\QUnsupported location that cannot be internally represented: " + location);
            return;
        }
        this.assertUpdate(create);
        try (UncheckedCloseable ignored = this.onClose("DROP TABLE " + tableName);){
            String actualTableLocation = this.getTableLocation(tableName);
            Assertions.assertThat((String)actualTableLocation).isEqualTo(location);
            this.assertUpdate("INSERT INTO " + tableName + " VALUES ('str1', 1), ('str2', 2), ('str3', 3), ('str4', 4)", 4L);
            this.assertQuery("SELECT * FROM " + tableName, "VALUES ('str1', 1), ('str2', 2), ('str3', 3), ('str4', 4)");
            Assertions.assertThat(this.getTableFiles(actualTableLocation)).isNotEmpty();
            this.validateDataFiles(partitioned ? "col_int" : "", tableName, actualTableLocation);
        }
    }

    @Override
    protected void testBasicOperationsWithProvidedSchemaLocation(boolean partitioned, BaseS3AndGlueMetastoreTest.LocationPattern locationPattern) {
        String actualTableLocation;
        String schemaName = "test_basic_operations_schema_" + TestingNames.randomNameSuffix();
        String schemaLocation = locationPattern.locationForSchema(this.bucketName, schemaName);
        String tableName = "test_basic_operations_table_" + TestingNames.randomNameSuffix();
        String qualifiedTableName = schemaName + "." + tableName;
        String partitionQueryPart = partitioned ? " WITH (partitioned_by = ARRAY['col_int'])" : "";
        this.assertUpdate("CREATE SCHEMA " + schemaName + " WITH (location = '" + schemaLocation + "')");
        try (UncheckedCloseable ignoredDropSchema = this.onClose("DROP SCHEMA " + schemaName);){
            Assertions.assertThat((String)this.getSchemaLocation(schemaName)).isEqualTo(schemaLocation);
            this.assertUpdate("CREATE TABLE " + qualifiedTableName + "(col_str varchar, col_int int)" + partitionQueryPart);
            try (UncheckedCloseable ignoredDropTable = this.onClose("DROP TABLE " + qualifiedTableName);){
                String expectedTableLocation = (String)(schemaLocation.endsWith("/") ? schemaLocation : schemaLocation + "/") + tableName;
                actualTableLocation = ((Table)this.metastore.getTable(schemaName, tableName).orElseThrow()).getStorage().getLocation();
                Assertions.assertThat((String)actualTableLocation).isEqualTo(expectedTableLocation);
                this.assertUpdate("INSERT INTO " + qualifiedTableName + "  VALUES ('str1', 1), ('str2', 2), ('str3', 3)", 3L);
                this.assertQuery("SELECT * FROM " + qualifiedTableName, "VALUES ('str1', 1), ('str2', 2), ('str3', 3)");
                Assertions.assertThat(this.getTableFiles(actualTableLocation)).isNotEmpty();
                this.validateDataFiles(partitioned ? "col_int" : "", qualifiedTableName, actualTableLocation);
            }
            Assertions.assertThat(this.getTableFiles(actualTableLocation)).isEmpty();
        }
        this.validateFilesAfterDrop(actualTableLocation);
    }

    @Override
    public void testMergeWithProvidedTableLocation(boolean partitioned, BaseS3AndGlueMetastoreTest.LocationPattern locationPattern) {
    }

    @Override
    protected void testOptimizeWithProvidedTableLocation(boolean partitioned, BaseS3AndGlueMetastoreTest.LocationPattern locationPattern) {
        if (locationPattern == BaseS3AndGlueMetastoreTest.LocationPattern.DOUBLE_SLASH || locationPattern == BaseS3AndGlueMetastoreTest.LocationPattern.TRIPLE_SLASH || locationPattern == BaseS3AndGlueMetastoreTest.LocationPattern.TWO_TRAILING_SLASHES) {
            Assertions.assertThatThrownBy(() -> super.testOptimizeWithProvidedTableLocation(partitioned, locationPattern)).hasMessageStartingWith("Unsupported location that cannot be internally represented: ").hasStackTraceContaining("SQL: CREATE TABLE test_optimize_");
            return;
        }
        super.testOptimizeWithProvidedTableLocation(partitioned, locationPattern);
    }

    @Test
    public void testAnalyzeWithProvidedTableLocation() {
        for (BaseS3AndGlueMetastoreTest.LocationPattern locationPattern : BaseS3AndGlueMetastoreTest.LocationPattern.values()) {
            this.testAnalyzeWithProvidedTableLocation(false, locationPattern);
            this.testAnalyzeWithProvidedTableLocation(true, locationPattern);
        }
    }

    private void testAnalyzeWithProvidedTableLocation(boolean partitioned, BaseS3AndGlueMetastoreTest.LocationPattern locationPattern) {
        String tableName = "test_analyze_" + TestingNames.randomNameSuffix();
        String location = locationPattern.locationForTable(this.bucketName, this.schemaName, tableName);
        String partitionQueryPart = partitioned ? ",partitioned_by = ARRAY['col_int']" : "";
        String create = "CREATE TABLE " + tableName + "(col_str, col_int)WITH (external_location = '" + location + "'" + partitionQueryPart + ") AS VALUES ('str1', 1), ('str2', 2), ('str3', 3)";
        if (locationPattern == BaseS3AndGlueMetastoreTest.LocationPattern.DOUBLE_SLASH || locationPattern == BaseS3AndGlueMetastoreTest.LocationPattern.TRIPLE_SLASH || locationPattern == BaseS3AndGlueMetastoreTest.LocationPattern.TWO_TRAILING_SLASHES) {
            this.assertQueryFails(create, "\\QUnsupported location that cannot be internally represented: " + location);
            return;
        }
        this.assertUpdate(create, 3L);
        try (UncheckedCloseable ignored = this.onClose("DROP TABLE " + tableName);){
            this.assertUpdate("INSERT INTO " + tableName + " VALUES ('str4', 4)", 1L);
            this.assertQuery("SELECT * FROM " + tableName, "VALUES ('str1', 1), ('str2', 2), ('str3', 3), ('str4', 4)");
            if (partitioned) {
                this.assertQuery("SHOW STATS FOR " + tableName, "VALUES\n('col_str', 16.0, 1.0, 0.0, null, null, null),\n('col_int', null, 4.0, 0.0, null, 1, 4),\n(null, null, null, null, 4.0, null, null)");
            } else {
                this.assertQuery("SHOW STATS FOR " + tableName, "VALUES\n('col_str', 16.0, 3.0, 0.0, null, null, null),\n('col_int', null, 3.0, 0.0, null, 1, 4),\n(null, null, null, null, 4.0, null, null)");
            }
            this.assertUpdate("ANALYZE " + tableName, 4L);
            if (partitioned) {
                this.assertQuery("SHOW STATS FOR " + tableName, "VALUES\n('col_str', 16.0, 1.0, 0.0, null, null, null),\n('col_int', null, 4.0, 0.0, null, 1, 4),\n(null, null, null, null, 4.0, null, null)");
            } else {
                this.assertQuery("SHOW STATS FOR " + tableName, "VALUES\n('col_str', 16.0, 4.0, 0.0, null, null, null),\n('col_int', null, 4.0, 0.0, null, 1, 4),\n(null, null, null, null, 4.0, null, null)");
            }
        }
    }

    @Test
    public void testPartitionProjectionWithProvidedTableLocation() {
        for (BaseS3AndGlueMetastoreTest.LocationPattern locationPattern : BaseS3AndGlueMetastoreTest.LocationPattern.values()) {
            if (locationPattern == BaseS3AndGlueMetastoreTest.LocationPattern.DOUBLE_SLASH || locationPattern == BaseS3AndGlueMetastoreTest.LocationPattern.TRIPLE_SLASH || locationPattern == BaseS3AndGlueMetastoreTest.LocationPattern.TWO_TRAILING_SLASHES) {
                Assertions.assertThatThrownBy(() -> this.testPartitionProjectionWithProvidedTableLocation(locationPattern)).hasMessageStartingWith("Unsupported location that cannot be internally represented: ").hasStackTraceContaining("SQL: CREATE TABLE");
                continue;
            }
            this.testPartitionProjectionWithProvidedTableLocation(locationPattern);
        }
    }

    private void testPartitionProjectionWithProvidedTableLocation(BaseS3AndGlueMetastoreTest.LocationPattern locationPattern) {
        String tableName = "test_partition_projection_" + TestingNames.randomNameSuffix();
        String tableLocation = locationPattern.locationForTable(this.bucketName, this.schemaName, tableName);
        this.computeActual(String.format("CREATE TABLE %s (\nname varchar(25),\nshort_name varchar WITH (\n    partition_projection_type='date',\n    partition_projection_format='yyyy-MM-dd HH',\n    partition_projection_range=ARRAY['2001-01-22 00', '2001-01-22 06'],\n    partition_projection_interval=1,\n    partition_projection_interval_unit='HOURS'\n  )\n)\nWITH (\n  partitioned_by=ARRAY['short_name'],\n  partition_projection_enabled=true,\n  external_location = '%s'\n)\n", tableName, tableLocation));
        this.assertUpdate("INSERT INTO " + tableName + " VALUES ('name1', '2001-01-22 00')", 1L);
        this.assertQuery(String.format("SELECT name FROM %s", tableName), "VALUES ('name1')");
    }

    @Test
    public void testInvalidSchemaNameLocation() {
        String schemaNameSuffix = TestingNames.randomNameSuffix();
        String schemaName = "../test_create_schema_invalid_location_" + schemaNameSuffix;
        String tableName = "test_table_schema_invalid_location_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE SCHEMA \"%2$s\" WITH (location = 's3://%1$s/%2$s')".formatted(this.bucketName, schemaName));
        try (UncheckedCloseable uncheckedCloseable = this.onClose("DROP SCHEMA \"" + schemaName + "\"");){
            ((TrinoExceptionAssert)((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("CREATE TABLE \"" + schemaName + "\"." + tableName + " (col) AS VALUES 1"))).failure().hasMessage("Error committing write to Hive")).cause().cause().hasMessageMatching("Put failed for bucket \\[\\S+] key \\[\\.\\./test_create_schema_invalid_location_\\w+/test_table_schema_invalid_location_\\w+/\\S+]: .*").cause().hasMessageMatching("\\(Service: S3, Status Code: 400, Request ID: .*");
        }
    }

    @Test
    public void testSchemaNameEscape() {
        String schemaNameSuffix = TestingNames.randomNameSuffix();
        String schemaName = "../test_create_schema_escaped_" + schemaNameSuffix;
        String tableName = "test_table_schema_escaped_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE SCHEMA \"%2$s\"".formatted(this.bucketName, schemaName));
        try (UncheckedCloseable uncheckedCloseable = this.onClose("DROP SCHEMA \"" + schemaName + "\"");){
            this.assertUpdate("CREATE TABLE \"" + schemaName + "\"." + tableName + " (col) AS VALUES 1", 1L);
            this.assertUpdate("DROP TABLE \"" + schemaName + "\"." + tableName);
        }
    }

    @Test
    public void testCreateFunction() {
        String name = "test_" + TestingNames.randomNameSuffix();
        String name2 = "test_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE FUNCTION " + name + "(x integer) RETURNS bigint COMMENT 't42' RETURN x * 42");
        this.assertQuery("SELECT " + name + "(99)", "SELECT 4158");
        this.assertQueryFails("SELECT " + name + "(2.9)", ".*Unexpected parameters.*");
        this.assertUpdate("CREATE FUNCTION " + name + "(x double) RETURNS double COMMENT 't88' RETURN x * 8.8");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SHOW FUNCTIONS"))).result().skippingTypesCheck().containsAll(MaterializedResult.resultBuilder((Session)this.getSession(), (Type[])new Type[0]).row(new Object[]{name, "bigint", "integer", "scalar", true, "t42"}).row(new Object[]{name, "double", "double", "scalar", true, "t88"}).build());
        this.assertQuery("SELECT " + name + "(99)", "SELECT 4158");
        this.assertQuery("SELECT " + name + "(2.9)", "SELECT 25.52");
        this.assertQueryFails("CREATE FUNCTION " + name + "(x int) RETURNS bigint RETURN x", "line 1:1: Function already exists");
        this.assertQuery("SELECT " + name + "(99)", "SELECT 4158");
        this.assertQuery("SELECT " + name + "(2.9)", "SELECT 25.52");
        this.assertUpdate("CREATE OR REPLACE FUNCTION " + name + "(x bigint) RETURNS bigint RETURN x * 23");
        this.assertUpdate("CREATE FUNCTION " + name2 + "(s varchar) RETURNS varchar RETURN 'Hello ' || s");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SHOW FUNCTIONS"))).result().skippingTypesCheck().containsAll(MaterializedResult.resultBuilder((Session)this.getSession(), (Type[])new Type[0]).row(new Object[]{name, "bigint", "integer", "scalar", true, "t42"}).row(new Object[]{name, "bigint", "bigint", "scalar", true, ""}).row(new Object[]{name, "double", "double", "scalar", true, "t88"}).row(new Object[]{name2, "varchar", "varchar", "scalar", true, ""}).build());
        this.assertQuery("SELECT " + name + "(99)", "SELECT 4158");
        this.assertQuery("SELECT " + name + "(cast(99 as bigint))", "SELECT 2277");
        this.assertQuery("SELECT " + name + "(2.9)", "SELECT 25.52");
        this.assertQuery("SELECT " + name2 + "('world')", "SELECT 'Hello world'");
        this.assertQueryFails("DROP FUNCTION " + name + "(varchar)", "line 1:1: Function not found");
        this.assertUpdate("DROP FUNCTION " + name + "(z bigint)");
        this.assertUpdate("DROP FUNCTION " + name + "(double)");
        this.assertUpdate("DROP FUNCTION " + name + "(int)");
        this.assertQueryFails("DROP FUNCTION " + name + "(bigint)", "line 1:1: Function not found");
        this.assertUpdate("DROP FUNCTION IF EXISTS " + name + "(bigint)");
        this.assertUpdate("DROP FUNCTION " + name2 + "(varchar)");
        this.assertQueryFails("DROP FUNCTION " + name2 + "(varchar)", "line 1:1: Function not found");
    }
}

