/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Provider;
import io.airlift.json.JsonCodec;
import io.airlift.json.JsonCodecFactory;
import io.airlift.json.ObjectMapperProvider;
import io.trino.filesystem.Location;
import io.trino.metastore.HiveType;
import io.trino.metastore.HiveTypeName;
import io.trino.plugin.base.TypeDeserializer;
import io.trino.plugin.hive.AcidInfo;
import io.trino.plugin.hive.HiveColumnHandle;
import io.trino.plugin.hive.HivePartitionKey;
import io.trino.plugin.hive.HiveSplit;
import io.trino.plugin.hive.Schema;
import io.trino.plugin.hive.util.HiveBucketing;
import io.trino.spi.HostAddress;
import io.trino.spi.SplitWeight;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.TestingTypeManager;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeManager;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestHiveSplit {
    @Test
    public void testJsonRoundTrip() {
        ObjectMapperProvider objectMapperProvider = new ObjectMapperProvider();
        objectMapperProvider.setJsonDeserializers((Map)ImmutableMap.of(Type.class, (Object)new TypeDeserializer((TypeManager)new TestingTypeManager())));
        JsonCodec codec = new JsonCodecFactory((Provider)objectMapperProvider).jsonCodec(HiveSplit.class);
        ImmutableMap schema = ImmutableMap.builder().put((Object)"foo", (Object)"bar").put((Object)"bar", (Object)"baz").buildOrThrow();
        ImmutableList partitionKeys = ImmutableList.of((Object)new HivePartitionKey("a", "apple"), (Object)new HivePartitionKey("b", "42"));
        ImmutableList addresses = ImmutableList.of((Object)HostAddress.fromParts((String)"127.0.0.1", (int)44), (Object)HostAddress.fromParts((String)"127.0.0.1", (int)45));
        AcidInfo.Builder acidInfoBuilder = AcidInfo.builder((Location)Location.of((String)"file:///data/fullacid"));
        acidInfoBuilder.addDeleteDelta(Location.of((String)"file:///data/fullacid/delete_delta_0000004_0000004_0000"));
        acidInfoBuilder.addDeleteDelta(Location.of((String)"file:///data/fullacid/delete_delta_0000007_0000007_0000"));
        AcidInfo acidInfo = (AcidInfo)acidInfoBuilder.build().get();
        HiveSplit expected = new HiveSplit("partitionId", "path", 42L, 87L, 88L, Instant.now().toEpochMilli(), new Schema("abc", true, (Map)schema), (List)partitionKeys, (List)addresses, OptionalInt.empty(), OptionalInt.empty(), true, (Map)ImmutableMap.of((Object)1, (Object)new HiveTypeName("string")), Optional.of(new HiveSplit.BucketConversion(HiveBucketing.BucketingVersion.BUCKETING_V1, 32, 16, (List)ImmutableList.of((Object)HiveColumnHandle.createBaseColumn((String)"col", (int)5, (HiveType)HiveType.HIVE_LONG, (Type)BigintType.BIGINT, (HiveColumnHandle.ColumnType)HiveColumnHandle.ColumnType.REGULAR, Optional.of("comment"))))), Optional.empty(), Optional.of(acidInfo), SplitWeight.fromProportion((double)2.0));
        String json = codec.toJson((Object)expected);
        HiveSplit actual = (HiveSplit)codec.fromJson(json);
        Assertions.assertThat((String)actual.getPartitionName()).isEqualTo(expected.getPartitionName());
        Assertions.assertThat((String)actual.getPath()).isEqualTo(expected.getPath());
        Assertions.assertThat((long)actual.getStart()).isEqualTo(expected.getStart());
        Assertions.assertThat((long)actual.getLength()).isEqualTo(expected.getLength());
        Assertions.assertThat((long)actual.getEstimatedFileSize()).isEqualTo(expected.getEstimatedFileSize());
        Assertions.assertThat((Object)actual.getSchema()).isEqualTo((Object)expected.getSchema());
        Assertions.assertThat((List)actual.getPartitionKeys()).isEqualTo((Object)expected.getPartitionKeys());
        Assertions.assertThat((Map)actual.getHiveColumnCoercions()).isEqualTo((Object)expected.getHiveColumnCoercions());
        Assertions.assertThat((Optional)actual.getBucketConversion()).isEqualTo((Object)expected.getBucketConversion());
        Assertions.assertThat((boolean)actual.isForceLocalScheduling()).isEqualTo(expected.isForceLocalScheduling());
        Assertions.assertThat((Object)((AcidInfo)actual.getAcidInfo().get())).isEqualTo(expected.getAcidInfo().get());
        Assertions.assertThat((Object)actual.getSplitWeight()).isEqualTo((Object)expected.getSplitWeight());
    }
}

