/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive;

import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.airlift.concurrent.Threads;
import io.airlift.slice.Slice;
import io.airlift.stats.Distribution;
import io.airlift.units.DataSize;
import io.trino.Session;
import io.trino.filesystem.Location;
import io.trino.filesystem.TrinoFileSystemFactory;
import io.trino.hive.orc.MemoryManager;
import io.trino.hive.orc.NullMemoryManager;
import io.trino.hive.orc.impl.WriterImpl;
import io.trino.metadata.FunctionManager;
import io.trino.metadata.Split;
import io.trino.metastore.HiveType;
import io.trino.operator.DriverContext;
import io.trino.operator.ScanFilterAndProjectOperator;
import io.trino.operator.SourceOperator;
import io.trino.operator.TableScanOperator;
import io.trino.operator.project.PageProcessor;
import io.trino.orc.OrcReaderOptions;
import io.trino.plugin.base.metrics.FileFormatDataSourceStats;
import io.trino.plugin.hive.HiveColumnHandle;
import io.trino.plugin.hive.HiveConfig;
import io.trino.plugin.hive.HivePageSourceProvider;
import io.trino.plugin.hive.HivePartitionKey;
import io.trino.plugin.hive.HiveSessionProperties;
import io.trino.plugin.hive.HiveTestUtils;
import io.trino.plugin.hive.Schema;
import io.trino.plugin.hive.acid.AcidTransaction;
import io.trino.plugin.hive.orc.OrcPageSourceFactory;
import io.trino.plugin.hive.orc.OrcReaderConfig;
import io.trino.plugin.hive.orc.OrcWriterConfig;
import io.trino.plugin.hive.parquet.ParquetReaderConfig;
import io.trino.plugin.hive.parquet.ParquetWriterConfig;
import io.trino.plugin.hive.util.HiveTypeUtil;
import io.trino.spi.Page;
import io.trino.spi.classloader.ThreadContextClassLoader;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ConnectorPageSource;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorSplit;
import io.trino.spi.connector.DynamicFilter;
import io.trino.spi.connector.SourcePage;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeManager;
import io.trino.spi.type.VarcharType;
import io.trino.sql.gen.CursorProcessorCompiler;
import io.trino.sql.gen.ExpressionCompiler;
import io.trino.sql.gen.PageFunctionCompiler;
import io.trino.sql.gen.columnar.ColumnarFilterCompiler;
import io.trino.sql.planner.plan.PlanNodeId;
import io.trino.sql.relational.Expressions;
import io.trino.testing.TestingConnectorSession;
import io.trino.testing.TestingHandles;
import io.trino.testing.TestingSession;
import io.trino.testing.TestingSplit;
import io.trino.testing.TestingTaskContext;
import io.trino.type.InternalTypeManager;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.hive.ql.io.orc.CompressionKind;
import org.apache.hadoop.hive.ql.io.orc.OrcFile;
import org.apache.hadoop.hive.ql.io.orc.OrcOutputFormat;
import org.apache.hadoop.hive.ql.io.orc.OrcSerde;
import org.apache.hadoop.hive.ql.io.orc.Writer;
import org.apache.hadoop.hive.serde2.Serializer;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.StandardStructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.FileSplit;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.joda.time.DateTimeZone;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Execution(value=ExecutionMode.CONCURRENT)
public class TestOrcPageSourceMemoryTracking {
    private static final String ORC_RECORD_WRITER = OrcOutputFormat.class.getName() + "$OrcRecordWriter";
    private static final Constructor<? extends FileSinkOperator.RecordWriter> WRITER_CONSTRUCTOR = TestOrcPageSourceMemoryTracking.getOrcWriterConstructor();
    private static final Configuration CONFIGURATION = new Configuration(false);
    private static final int NUM_ROWS = 50000;
    private static final int STRIPE_ROWS = 20000;
    private static final FunctionManager functionManager = FunctionManager.createTestingFunctionManager();
    private static final ExpressionCompiler EXPRESSION_COMPILER = new ExpressionCompiler(new CursorProcessorCompiler(functionManager), new PageFunctionCompiler(functionManager, 0), new ColumnarFilterCompiler(functionManager, 0));
    private static final ConnectorSession UNCACHED_SESSION = HiveTestUtils.getHiveSession(new HiveConfig(), new OrcReaderConfig().setTinyStripeThreshold(DataSize.of((long)0L, (DataSize.Unit)DataSize.Unit.BYTE)));
    private static final ConnectorSession CACHED_SESSION = HiveTestUtils.SESSION;
    private final Random random = new Random();
    private final List<TestColumn> testColumns = ImmutableList.builder().add((Object)new TestColumn("p_empty_string", (ObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector, () -> "", true)).add((Object)new TestColumn("p_string", (ObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector, () -> Long.toHexString(this.random.nextLong()), false)).build();
    private File tempFile;
    private TestPreparer testPreparer;

    @BeforeAll
    public void setUp() throws Exception {
        this.tempFile = File.createTempFile("trino_test_orc_page_source_memory_tracking", "orc");
        Verify.verify((boolean)this.tempFile.delete());
        this.testPreparer = new TestPreparer(this, this.tempFile.getAbsolutePath());
    }

    @AfterAll
    public void tearDown() {
        Verify.verify((boolean)this.tempFile.delete());
    }

    @Test
    public void testPageSourceUncached() throws Exception {
        this.testPageSource(false);
    }

    @Test
    public void testPageSourceCached() throws Exception {
        this.testPageSource(true);
    }

    private void testPageSource(boolean useCache) throws Exception {
        int totalRows;
        SourcePage page;
        FileFormatDataSourceStats stats = new FileFormatDataSourceStats();
        ConnectorPageSource pageSource = this.testPreparer.newPageSource(stats, useCache ? CACHED_SESSION : UNCACHED_SESSION);
        if (useCache) {
            Assertions.assertThat((long)pageSource.getMemoryUsage()).isBetween(Long.valueOf(this.testPreparer.getFileSize()), Long.valueOf(this.testPreparer.getFileSize() + 200L));
        } else {
            Assertions.assertThat((long)pageSource.getMemoryUsage()).isEqualTo(0L);
        }
        long memoryUsage = -1L;
        for (totalRows = 0; totalRows < 20000; totalRows += page.getPositionCount()) {
            Assertions.assertThat((boolean)pageSource.isFinished()).isFalse();
            page = pageSource.getNextSourcePage();
            Assertions.assertThat((Object)page).isNotNull();
            if (memoryUsage == -1L) {
                if (useCache) {
                    Assertions.assertThat((long)pageSource.getMemoryUsage()).isBetween(Long.valueOf(this.testPreparer.getFileSize()), Long.valueOf(this.testPreparer.getFileSize() + 2000L));
                } else {
                    Assertions.assertThat((long)pageSource.getMemoryUsage()).isBetween(Long.valueOf(0L), Long.valueOf(1000L));
                }
                VarcharType.VARCHAR.getSlice(page.getBlock(1), page.getPositionCount() - 1);
                memoryUsage = pageSource.getMemoryUsage();
                if (useCache) {
                    Assertions.assertThat((long)pageSource.getMemoryUsage()).isBetween(Long.valueOf(this.testPreparer.getFileSize() + 270000L), Long.valueOf(this.testPreparer.getFileSize() + 280000L));
                } else {
                    Assertions.assertThat((long)memoryUsage).isBetween(Long.valueOf(460000L), Long.valueOf(469999L));
                }
            }
            Assertions.assertThat((long)pageSource.getMemoryUsage()).isEqualTo(memoryUsage);
            VarcharType.VARCHAR.getSlice(page.getBlock(1), page.getPositionCount() - 1);
            Assertions.assertThat((long)pageSource.getMemoryUsage()).isEqualTo(memoryUsage);
        }
        memoryUsage = -1L;
        while (totalRows < 40000) {
            Assertions.assertThat((boolean)pageSource.isFinished()).isFalse();
            page = pageSource.getNextSourcePage();
            Assertions.assertThat((Object)page).isNotNull();
            if (memoryUsage == -1L) {
                if (useCache) {
                    Assertions.assertThat((long)pageSource.getMemoryUsage()).isBetween(Long.valueOf(this.testPreparer.getFileSize()), Long.valueOf(this.testPreparer.getFileSize() + 2000L));
                } else {
                    Assertions.assertThat((long)pageSource.getMemoryUsage()).isBetween(Long.valueOf(0L), Long.valueOf(1000L));
                }
                VarcharType.VARCHAR.getSlice(page.getBlock(1), page.getPositionCount() - 1);
                memoryUsage = pageSource.getMemoryUsage();
                if (useCache) {
                    Assertions.assertThat((long)pageSource.getMemoryUsage()).isBetween(Long.valueOf(this.testPreparer.getFileSize() + 270000L), Long.valueOf(this.testPreparer.getFileSize() + 280000L));
                } else {
                    Assertions.assertThat((long)memoryUsage).isBetween(Long.valueOf(460000L), Long.valueOf(469999L));
                }
            }
            Assertions.assertThat((long)pageSource.getMemoryUsage()).isEqualTo(memoryUsage);
            VarcharType.VARCHAR.getSlice(page.getBlock(1), page.getPositionCount() - 1);
            Assertions.assertThat((long)pageSource.getMemoryUsage()).isEqualTo(memoryUsage);
            totalRows += page.getPositionCount();
        }
        memoryUsage = -1L;
        while (totalRows < 50000) {
            Assertions.assertThat((boolean)pageSource.isFinished()).isFalse();
            page = pageSource.getNextSourcePage();
            Assertions.assertThat((Object)page).isNotNull();
            if (memoryUsage == -1L) {
                if (useCache) {
                    Assertions.assertThat((long)pageSource.getMemoryUsage()).isBetween(Long.valueOf(this.testPreparer.getFileSize()), Long.valueOf(this.testPreparer.getFileSize() + 2000L));
                } else {
                    Assertions.assertThat((long)pageSource.getMemoryUsage()).isBetween(Long.valueOf(0L), Long.valueOf(1000L));
                }
                VarcharType.VARCHAR.getSlice(page.getBlock(1), page.getPositionCount() - 1);
                memoryUsage = pageSource.getMemoryUsage();
                if (useCache) {
                    Assertions.assertThat((long)pageSource.getMemoryUsage()).isBetween(Long.valueOf(this.testPreparer.getFileSize() + 260000L), Long.valueOf(this.testPreparer.getFileSize() + 270000L));
                } else {
                    Assertions.assertThat((long)memoryUsage).isBetween(Long.valueOf(360000L), Long.valueOf(369999L));
                }
            }
            Assertions.assertThat((long)pageSource.getMemoryUsage()).isEqualTo(memoryUsage);
            VarcharType.VARCHAR.getSlice(page.getBlock(1), page.getPositionCount() - 1);
            Assertions.assertThat((long)pageSource.getMemoryUsage()).isEqualTo(memoryUsage);
            totalRows += page.getPositionCount();
        }
        Assertions.assertThat((boolean)pageSource.isFinished()).isFalse();
        Assertions.assertThat((Object)pageSource.getNextSourcePage()).isNull();
        Assertions.assertThat((boolean)pageSource.isFinished()).isTrue();
        if (useCache) {
            Assertions.assertThat((long)pageSource.getMemoryUsage()).isBetween(Long.valueOf(this.testPreparer.getFileSize()), Long.valueOf(this.testPreparer.getFileSize() + 200L));
        } else {
            Assertions.assertThat((long)pageSource.getMemoryUsage()).isEqualTo(0L);
        }
        pageSource.close();
    }

    @Test
    public void testMaxReadBytes() throws Exception {
        this.testMaxReadBytes(50000);
        this.testMaxReadBytes(10000);
        this.testMaxReadBytes(5000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testMaxReadBytes(int rowCount) throws Exception {
        int maxReadBytes = 1000;
        HiveSessionProperties hiveSessionProperties = new HiveSessionProperties(new HiveConfig(), new OrcReaderConfig().setMaxBlockSize(DataSize.ofBytes((long)maxReadBytes)), new OrcWriterConfig(), new ParquetReaderConfig(), new ParquetWriterConfig());
        TestingConnectorSession session = TestingConnectorSession.builder().setPropertyMetadata(hiveSessionProperties.getSessionProperties()).build();
        FileFormatDataSourceStats stats = new FileFormatDataSourceStats();
        int numColumns = 5;
        int step = 250;
        ImmutableList.Builder columnBuilder = ImmutableList.builder().add((Object)new TestColumn("p_empty_string", (ObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector, () -> "", true));
        GrowingTestColumn[] dataColumns = new GrowingTestColumn[numColumns];
        for (int i = 0; i < numColumns; ++i) {
            dataColumns[i] = new GrowingTestColumn("p_string_" + i, (ObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector, () -> Long.toHexString(this.random.nextLong()), false, step * (i + 1));
            columnBuilder.add((Object)dataColumns[i]);
        }
        ImmutableList testColumns = columnBuilder.build();
        File tempFile = File.createTempFile("trino_test_orc_page_source_max_read_bytes", "orc");
        Verify.verify((boolean)tempFile.delete());
        TestPreparer testPreparer = new TestPreparer(this, tempFile.getAbsolutePath(), (List<TestColumn>)testColumns, rowCount, rowCount);
        ConnectorPageSource pageSource = testPreparer.newPageSource(stats, (ConnectorSession)session);
        try {
            int positionCount = 0;
            while (true) {
                SourcePage page = pageSource.getNextSourcePage();
                if (pageSource.isFinished()) break;
                Assertions.assertThat((Object)page).isNotNull();
                page.getPage();
                if ((positionCount += page.getPositionCount()) <= 8192) continue;
                Assertions.assertThat((page.getSizeInBytes() < (long)maxReadBytes * (long)(8192 / step) || 1 == page.getPositionCount() ? 1 : 0) != 0).isTrue();
            }
            pageSource.close();
            Distribution distribution = stats.getMaxCombinedBytesPerRow().getAllTime();
            Assertions.assertThat((int)((int)distribution.getCount())).isEqualTo(1);
            Assertions.assertThat((int)((int)distribution.getMax())).isEqualTo(Arrays.stream(dataColumns).mapToInt(GrowingTestColumn::getMaxSize).sum() + 5 * numColumns);
            pageSource.close();
        }
        finally {
            Verify.verify((boolean)tempFile.delete());
        }
    }

    @Test
    public void testTableScanOperator() throws Exception {
        DriverContext driverContext = this.testPreparer.newDriverContext();
        try (SourceOperator operator = this.testPreparer.newTableScanOperator(driverContext);){
            int totalRows;
            Page page;
            Assertions.assertThat((long)driverContext.getMemoryUsage()).isEqualTo(0L);
            long memoryUsage = -1L;
            for (totalRows = 0; totalRows < 20000; totalRows += page.getPositionCount()) {
                Assertions.assertThat((boolean)operator.isFinished()).isFalse();
                page = operator.getOutput();
                Assertions.assertThat((Object)page).isNotNull();
                if (memoryUsage == -1L) {
                    memoryUsage = driverContext.getMemoryUsage();
                    Assertions.assertThat((long)memoryUsage).isBetween(Long.valueOf(460000L), Long.valueOf(469999L));
                    continue;
                }
                Assertions.assertThat((long)driverContext.getMemoryUsage()).isEqualTo(memoryUsage);
            }
            memoryUsage = -1L;
            while (totalRows < 40000) {
                Assertions.assertThat((boolean)operator.isFinished()).isFalse();
                page = operator.getOutput();
                Assertions.assertThat((Object)page).isNotNull();
                if (memoryUsage == -1L) {
                    memoryUsage = driverContext.getMemoryUsage();
                    Assertions.assertThat((long)memoryUsage).isBetween(Long.valueOf(460000L), Long.valueOf(469999L));
                } else {
                    Assertions.assertThat((long)driverContext.getMemoryUsage()).isEqualTo(memoryUsage);
                }
                totalRows += page.getPositionCount();
            }
            memoryUsage = -1L;
            while (totalRows < 50000) {
                Assertions.assertThat((boolean)operator.isFinished()).isFalse();
                page = operator.getOutput();
                Assertions.assertThat((Object)page).isNotNull();
                if (memoryUsage == -1L) {
                    memoryUsage = driverContext.getMemoryUsage();
                    Assertions.assertThat((long)memoryUsage).isBetween(Long.valueOf(360000L), Long.valueOf(369999L));
                } else {
                    Assertions.assertThat((long)driverContext.getMemoryUsage()).isEqualTo(memoryUsage);
                }
                totalRows += page.getPositionCount();
            }
            Assertions.assertThat((boolean)operator.isFinished()).isFalse();
            Assertions.assertThat((Object)operator.getOutput()).isNull();
            Assertions.assertThat((boolean)operator.isFinished()).isTrue();
            Assertions.assertThat((long)driverContext.getMemoryUsage()).isEqualTo(0L);
        }
    }

    @Test
    public void testScanFilterAndProjectOperator() throws Exception {
        DriverContext driverContext = this.testPreparer.newDriverContext();
        try (SourceOperator operator = this.testPreparer.newScanFilterAndProjectOperator(driverContext);){
            Page page;
            Assertions.assertThat((long)driverContext.getMemoryUsage()).isEqualTo(0L);
            for (int totalRows = 0; totalRows < 50000; totalRows += page.getPositionCount()) {
                Assertions.assertThat((boolean)operator.isFinished()).isFalse();
                page = operator.getOutput();
                Assertions.assertThat((Object)page).isNotNull();
                long memoryUsage = driverContext.getMemoryUsage();
                ((AbstractBooleanAssert)Assertions.assertThat((memoryUsage < 1000L || memoryUsage > 150000L && memoryUsage < 630000L ? 1 : 0) != 0).describedAs(String.format("Memory usage (%s) outside of bounds", memoryUsage), new Object[0])).isTrue();
            }
            Assertions.assertThat((Object)operator.getOutput()).isNull();
            Assertions.assertThat((boolean)operator.isFinished()).isTrue();
            Assertions.assertThat((long)driverContext.getMemoryUsage()).isBetween(Long.valueOf(0L), Long.valueOf(500L));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static FileSplit createTestFile(String filePath, Serializer serializer, List<TestColumn> testColumns, int numRows, int stripeRows) throws Exception {
        testColumns = (List)testColumns.stream().filter(column -> !column.isPartitionKey()).collect(ImmutableList.toImmutableList());
        Properties tableProperties = new Properties();
        tableProperties.setProperty("columns", testColumns.stream().map(TestColumn::getName).collect(Collectors.joining(",")));
        tableProperties.setProperty("columns.comments", testColumns.stream().map(TestColumn::getType).collect(Collectors.joining(",")));
        serializer.initialize(CONFIGURATION, tableProperties);
        FileSinkOperator.RecordWriter recordWriter = TestOrcPageSourceMemoryTracking.createRecordWriter(new Path(filePath), CONFIGURATION);
        try {
            StandardStructObjectInspector objectInspector = ObjectInspectorFactory.getStandardStructObjectInspector((List)((List)testColumns.stream().map(TestColumn::getName).collect(ImmutableList.toImmutableList())), (List)((List)testColumns.stream().map(TestColumn::getObjectInspector).collect(ImmutableList.toImmutableList())));
            Object row = objectInspector.create();
            ImmutableList fields = ImmutableList.copyOf((Collection)objectInspector.getAllStructFieldRefs());
            for (int rowNumber = 0; rowNumber < numRows; ++rowNumber) {
                for (int i = 0; i < testColumns.size(); ++i) {
                    Object writeValue = ((TestColumn)testColumns.get(i)).getWriteValue();
                    if (writeValue instanceof Slice) {
                        writeValue = ((Slice)writeValue).getBytes();
                    }
                    objectInspector.setStructFieldData(row, (StructField)fields.get(i), writeValue);
                }
                Writable record = serializer.serialize(row, (ObjectInspector)objectInspector);
                recordWriter.write(record);
                if (rowNumber % stripeRows != stripeRows - 1) continue;
                TestOrcPageSourceMemoryTracking.flushStripe(recordWriter);
            }
        }
        finally {
            recordWriter.close(false);
        }
        Path path = new Path(filePath);
        path.getFileSystem(CONFIGURATION).setVerifyChecksum(true);
        File file = new File(filePath);
        return new FileSplit(path, 0L, file.length(), new String[0]);
    }

    private static void flushStripe(FileSinkOperator.RecordWriter recordWriter) {
        try {
            Field writerField = OrcOutputFormat.class.getClassLoader().loadClass(ORC_RECORD_WRITER).getDeclaredField("writer");
            writerField.setAccessible(true);
            Writer writer = (Writer)writerField.get(recordWriter);
            Method flushStripe = WriterImpl.class.getDeclaredMethod("flushStripe", new Class[0]);
            flushStripe.setAccessible(true);
            flushStripe.invoke((Object)writer, new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    private static FileSinkOperator.RecordWriter createRecordWriter(Path target, Configuration conf) {
        try (ThreadContextClassLoader threadContextClassLoader = new ThreadContextClassLoader(FileSystem.class.getClassLoader());){
            OrcFile.WriterOptions options = OrcFile.writerOptions((Configuration)conf).memory((MemoryManager)new NullMemoryManager()).compress(CompressionKind.ZLIB);
            try {
                FileSinkOperator.RecordWriter recordWriter = WRITER_CONSTRUCTOR.newInstance(target, options);
                return recordWriter;
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static Constructor<? extends FileSinkOperator.RecordWriter> getOrcWriterConstructor() {
        try {
            Constructor<FileSinkOperator.RecordWriter> constructor = OrcOutputFormat.class.getClassLoader().loadClass(ORC_RECORD_WRITER).asSubclass(FileSinkOperator.RecordWriter.class).getDeclaredConstructor(Path.class, OrcFile.WriterOptions.class);
            constructor.setAccessible(true);
            return constructor;
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    public static class TestColumn {
        private final String name;
        private final ObjectInspector objectInspector;
        private final Supplier<?> writeValue;
        private final boolean partitionKey;

        public TestColumn(String name, ObjectInspector objectInspector, Supplier<?> writeValue, boolean partitionKey) {
            this.name = Objects.requireNonNull(name, "name is null");
            this.objectInspector = Objects.requireNonNull(objectInspector, "objectInspector is null");
            this.writeValue = writeValue;
            this.partitionKey = partitionKey;
        }

        public String getName() {
            return this.name;
        }

        public String getType() {
            return this.objectInspector.getTypeName();
        }

        public ObjectInspector getObjectInspector() {
            return this.objectInspector;
        }

        public Object getWriteValue() {
            return this.writeValue.get();
        }

        public boolean isPartitionKey() {
            return this.partitionKey;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("TestColumn{");
            sb.append("name='").append(this.name).append('\'');
            sb.append(", objectInspector=").append(this.objectInspector);
            sb.append(", partitionKey=").append(this.partitionKey);
            sb.append('}');
            return sb.toString();
        }
    }

    private class TestPreparer {
        private final FileSplit fileSplit;
        private final Schema schema;
        private final List<HiveColumnHandle> columns;
        private final List<Type> types;
        private final String partitionName;
        private final List<HivePartitionKey> partitionKeys;
        private final ExecutorService executor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)"TestOrcPageSourceMemoryTracking-executor-%s"));
        private final ScheduledExecutorService scheduledExecutor = Executors.newScheduledThreadPool(2, Threads.daemonThreadsNamed((String)"TestOrcPageSourceMemoryTracking-scheduledExecutor-%s"));

        public TestPreparer(TestOrcPageSourceMemoryTracking testOrcPageSourceMemoryTracking, String tempFilePath) throws Exception {
            this(testOrcPageSourceMemoryTracking, tempFilePath, testOrcPageSourceMemoryTracking.testColumns, 50000, 20000);
        }

        public TestPreparer(TestOrcPageSourceMemoryTracking testOrcPageSourceMemoryTracking, String tempFilePath, List<TestColumn> testColumns, int numRows, int stripeRows) throws Exception {
            OrcSerde serde = new OrcSerde();
            this.schema = new Schema(serde.getClass().getName(), false, (Map)ImmutableMap.builder().put((Object)"columns", (Object)testColumns.stream().map(TestColumn::getName).collect(Collectors.joining(","))).put((Object)"columns.types", (Object)testColumns.stream().map(TestColumn::getType).collect(Collectors.joining(","))).buildOrThrow());
            this.partitionKeys = testColumns.stream().filter(TestColumn::isPartitionKey).map(input -> new HivePartitionKey(input.getName(), (String)input.getWriteValue())).collect(Collectors.toList());
            this.partitionName = String.join((CharSequence)"/", (Iterable)this.partitionKeys.stream().map(partitionKey -> String.format("%s=%s", partitionKey.name(), partitionKey.value())).collect(ImmutableList.toImmutableList()));
            ImmutableList.Builder columnsBuilder = ImmutableList.builder();
            ImmutableList.Builder typesBuilder = ImmutableList.builder();
            int nextHiveColumnIndex = 0;
            for (TestColumn testColumn : testColumns) {
                int columnIndex = testColumn.isPartitionKey() ? -1 : nextHiveColumnIndex++;
                ObjectInspector inspector = testColumn.getObjectInspector();
                HiveType hiveType = HiveType.valueOf((String)inspector.getTypeName());
                Type type = InternalTypeManager.TESTING_TYPE_MANAGER.getType(HiveTypeUtil.getTypeSignature((HiveType)hiveType));
                columnsBuilder.add((Object)HiveColumnHandle.createBaseColumn((String)testColumn.getName(), (int)columnIndex, (HiveType)hiveType, (Type)type, (HiveColumnHandle.ColumnType)(testColumn.isPartitionKey() ? HiveColumnHandle.ColumnType.PARTITION_KEY : HiveColumnHandle.ColumnType.REGULAR), Optional.empty()));
                typesBuilder.add((Object)type);
            }
            this.columns = columnsBuilder.build();
            this.types = typesBuilder.build();
            this.fileSplit = TestOrcPageSourceMemoryTracking.createTestFile(tempFilePath, (Serializer)serde, testColumns, numRows, stripeRows);
        }

        public long getFileSize() {
            return this.fileSplit.getLength();
        }

        public ConnectorPageSource newPageSource() {
            return this.newPageSource(new FileFormatDataSourceStats(), UNCACHED_SESSION);
        }

        public ConnectorPageSource newPageSource(FileFormatDataSourceStats stats, ConnectorSession session) {
            OrcPageSourceFactory orcPageSourceFactory = new OrcPageSourceFactory(new OrcReaderOptions(), (TrinoFileSystemFactory)HiveTestUtils.HDFS_FILE_SYSTEM_FACTORY, stats, DateTimeZone.UTC);
            List columnMappings = HivePageSourceProvider.ColumnMapping.buildColumnMappings((String)this.partitionName, this.partitionKeys, this.columns, (List)ImmutableList.of(), (Map)ImmutableMap.of(), (String)this.fileSplit.getPath().toString(), (OptionalInt)OptionalInt.empty(), (long)this.fileSplit.getLength(), (long)Instant.now().toEpochMilli());
            ConnectorPageSource connectorPageSource = (ConnectorPageSource)HivePageSourceProvider.createHivePageSource((Set)ImmutableSet.of((Object)orcPageSourceFactory), (ConnectorSession)session, (Location)Location.of((String)this.fileSplit.getPath().toString()), (OptionalInt)OptionalInt.empty(), (long)this.fileSplit.getStart(), (long)this.fileSplit.getLength(), (long)this.fileSplit.getLength(), (long)12345L, (Schema)this.schema, (TupleDomain)TupleDomain.all(), (TypeManager)InternalTypeManager.TESTING_TYPE_MANAGER, Optional.empty(), Optional.empty(), Optional.empty(), (boolean)false, (AcidTransaction)AcidTransaction.NO_ACID_TRANSACTION, (List)columnMappings).orElseThrow();
            return connectorPageSource;
        }

        public SourceOperator newTableScanOperator(DriverContext driverContext) {
            ConnectorPageSource pageSource = this.newPageSource();
            TableScanOperator.TableScanOperatorFactory sourceOperatorFactory = new TableScanOperator.TableScanOperatorFactory(0, new PlanNodeId("0"), new PlanNodeId("0"), catalog -> (session, split, table, columnHandles, dynamicFilter) -> pageSource, TestingHandles.TEST_TABLE_HANDLE, (Iterable)this.columns.stream().map(ColumnHandle.class::cast).collect(ImmutableList.toImmutableList()), DynamicFilter.EMPTY);
            SourceOperator operator = sourceOperatorFactory.createOperator(driverContext);
            operator.addSplit(new Split(TestingHandles.TEST_CATALOG_HANDLE, (ConnectorSplit)TestingSplit.createLocalSplit()));
            return operator;
        }

        public SourceOperator newScanFilterAndProjectOperator(DriverContext driverContext) {
            ConnectorPageSource pageSource = this.newPageSource();
            ImmutableList.Builder projectionsBuilder = ImmutableList.builder();
            for (int i = 0; i < this.types.size(); ++i) {
                projectionsBuilder.add((Object)Expressions.field((int)i, (Type)this.types.get(i)));
            }
            Supplier cursorProcessor = EXPRESSION_COMPILER.compileCursorProcessor(Optional.empty(), (List)projectionsBuilder.build(), (Object)"key");
            Supplier pageProcessor = EXPRESSION_COMPILER.compilePageProcessor(Optional.empty(), (List)projectionsBuilder.build());
            ScanFilterAndProjectOperator.ScanFilterAndProjectOperatorFactory sourceOperatorFactory = new ScanFilterAndProjectOperator.ScanFilterAndProjectOperatorFactory(0, new PlanNodeId("test"), new PlanNodeId("0"), catalog -> (session, split, table, columnHandles, dynamicFilter) -> pageSource, cursorProcessor, arg_0 -> TestPreparer.lambda$newScanFilterAndProjectOperator$2((Supplier)pageProcessor, arg_0), TestingHandles.TEST_TABLE_HANDLE, (Iterable)this.columns.stream().map(ColumnHandle.class::cast).collect(Collectors.toList()), DynamicFilter.EMPTY, this.types, DataSize.ofBytes((long)0L), 0);
            SourceOperator operator = sourceOperatorFactory.createOperator(driverContext);
            operator.addSplit(new Split(TestingHandles.TEST_CATALOG_HANDLE, (ConnectorSplit)TestingSplit.createLocalSplit()));
            operator.noMoreSplits();
            return operator;
        }

        private DriverContext newDriverContext() {
            return TestingTaskContext.createTaskContext((Executor)this.executor, (ScheduledExecutorService)this.scheduledExecutor, (Session)TestingSession.testSessionBuilder().build()).addPipelineContext(0, true, true, false).addDriverContext();
        }

        private static /* synthetic */ PageProcessor lambda$newScanFilterAndProjectOperator$2(Supplier pageProcessor, DynamicFilter dynamicFilter) {
            return (PageProcessor)pageProcessor.get();
        }
    }

    public static final class GrowingTestColumn
    extends TestColumn {
        private final Supplier<String> writeValue;
        private final int step;
        private int counter;
        private int maxSize;

        public GrowingTestColumn(String name, ObjectInspector objectInspector, Supplier<String> writeValue, boolean partitionKey, int step) {
            super(name, objectInspector, writeValue, partitionKey);
            this.writeValue = writeValue;
            this.counter = step;
            this.step = step;
        }

        @Override
        public Object getWriteValue() {
            StringBuilder builder = new StringBuilder();
            String source = this.writeValue.get();
            builder.append(source.repeat(Math.max(0, this.counter / this.step)));
            ++this.counter;
            if (builder.length() > this.maxSize) {
                this.maxSize = builder.length();
            }
            return builder.toString();
        }

        public int getMaxSize() {
            return this.maxSize;
        }
    }
}

