/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.MoreCollectors;
import com.google.common.io.Resources;
import io.trino.Session;
import io.trino.execution.QueryStats;
import io.trino.filesystem.Location;
import io.trino.filesystem.TrinoFileSystem;
import io.trino.filesystem.TrinoFileSystemFactory;
import io.trino.operator.OperatorStats;
import io.trino.plugin.hive.HiveQueryRunner;
import io.trino.plugin.hive.TestingHiveUtils;
import io.trino.spi.QueryId;
import io.trino.spi.metrics.Count;
import io.trino.spi.security.ConnectorIdentity;
import io.trino.testing.AbstractTestQueryFramework;
import io.trino.testing.DistributedQueryRunner;
import io.trino.testing.MaterializedResult;
import io.trino.testing.QueryAssertions;
import io.trino.testing.QueryRunner;
import io.trino.testing.TestingNames;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.Map;
import java.util.UUID;
import org.assertj.core.api.Assertions;
import org.intellij.lang.annotations.Language;
import org.junit.jupiter.api.Test;

public class TestParquetPageSkipping
extends AbstractTestQueryFramework {
    private TrinoFileSystem fileSystem;

    protected QueryRunner createQueryRunner() throws Exception {
        DistributedQueryRunner queryRunner = HiveQueryRunner.builder().setHiveProperties((Map<String, String>)ImmutableMap.of((Object)"parquet.use-column-index", (Object)"true", (Object)"parquet.max-buffer-size", (Object)"1MB")).build();
        this.fileSystem = TestingHiveUtils.getConnectorService((QueryRunner)queryRunner, TrinoFileSystemFactory.class).create(ConnectorIdentity.ofUser((String)"test"));
        return queryRunner;
    }

    @Test
    public void testRowGroupPruningFromPageIndexes() throws Exception {
        Location dataFile = this.copyInDataFile("parquet_page_skipping/orders_sorted_by_totalprice/data.parquet");
        String tableName = "test_row_group_pruning_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE %s (\n   orderkey bigint,\n   custkey bigint,\n   orderstatus varchar(1),\n   totalprice double,\n   orderdate date,\n   orderpriority varchar(15),\n   clerk varchar(15),\n   shippriority integer,\n   comment varchar(79),\n   rvalues double array)\nWITH (\n   format = 'PARQUET',\n   external_location = '%s')\n".formatted(tableName, dataFile.parentDirectory()));
        int rowCount = this.assertColumnIndexResults("SELECT * FROM " + tableName + " WHERE totalprice BETWEEN 100000 AND 131280 AND clerk = 'Clerk#000000624'");
        Assertions.assertThat((int)rowCount).isGreaterThan(0);
        this.assertRowGroupPruning("SELECT * FROM " + tableName + " WHERE totalprice BETWEEN 51890 AND 51900 AND orderkey > 0");
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testPageSkippingWithNonSequentialOffsets() throws IOException {
        Location dataFile = this.copyInDataFile("parquet_page_skipping/random/data.parquet");
        String tableName = "test_random_" + TestingNames.randomNameSuffix();
        this.assertUpdate(String.format("CREATE TABLE %s (col double) WITH (format = 'PARQUET', external_location = '%s')", tableName, dataFile.parentDirectory()));
        for (double i = 0.0; i < 1.0; i += 0.1) {
            this.assertColumnIndexResults(String.format("SELECT * FROM %s WHERE col BETWEEN %f AND %f", tableName, i - 1.0E-5, i + 1.0E-5));
        }
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testFilteringOnColumnNameWithDot() throws IOException {
        Location dataFile = this.copyInDataFile("parquet_page_skipping/column_name_with_dot/data.parquet");
        String nameInSql = "\"a.dot\"";
        String tableName = "test_column_name_with_dot_" + TestingNames.randomNameSuffix();
        this.assertUpdate(String.format("CREATE TABLE %s (key varchar(50), %s varchar(50)) WITH (format = 'PARQUET', external_location = '%s')", tableName, nameInSql, dataFile.parentDirectory()));
        this.assertQuery("SELECT key FROM " + tableName + " WHERE " + nameInSql + " IS NULL", "VALUES ('null value')");
        this.assertQuery("SELECT key FROM " + tableName + " WHERE " + nameInSql + " = 'abc'", "VALUES ('sample value')");
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testUnsupportedColumnIndex() throws IOException {
        String tableName = "test_unsupported_column_index_" + TestingNames.randomNameSuffix();
        Location dataFile = this.copyInDataFile("parquet_page_skipping/unsupported_column_index/data.parquet");
        this.assertUpdate(String.format("CREATE TABLE %s (stime timestamp(3), btime timestamp(3), detail varchar) WITH (format = 'PARQUET', external_location = '%s')", tableName, dataFile.parentDirectory()));
        this.assertQuery("SELECT * FROM " + tableName + " WHERE btime >= timestamp '2023-03-27 13:30:00'", "VALUES ('2023-03-31 18:00:00.000', '2023-03-31 18:00:00.000', 'record_1')");
        this.assertQuery("SELECT * FROM " + tableName + " WHERE detail = 'record_2'", "VALUES ('2023-03-31 18:00:00.000', null, 'record_2')");
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testPageSkipping() {
        this.testPageSkipping("orderkey", "bigint", new Object[][]{{2, 7520, 7523, 14950}});
        this.testPageSkipping("totalprice", "double", new Object[][]{{974.04, 131094.34, 131279.97, 406938.36}});
        this.testPageSkipping("totalprice", "real", new Object[][]{{974.04, 131094.34, 131279.97, 406938.36}});
        this.testPageSkipping("totalprice", "decimal(12,2)", new Object[][]{{974.04, 131094.34, 131279.97, 406938.36}, {973, 131095, 131280, 406950}, {974.04123, 131094.34123, 131279.97012, 406938.36555}});
        this.testPageSkipping("totalprice", "decimal(12,0)", new Object[][]{{973, 131095, 131280, 406950}});
        this.testPageSkipping("totalprice", "decimal(35,2)", new Object[][]{{974.04, 131094.34, 131279.97, 406938.36}, {973, 131095, 131280, 406950}, {974.04123, 131094.34123, 131279.97012, 406938.36555}});
        this.testPageSkipping("orderdate", "date", new Object[][]{{"DATE '1992-01-05'", "DATE '1995-10-13'", "DATE '1995-10-13'", "DATE '1998-07-29'"}});
        this.testPageSkipping("orderdate", "timestamp", new Object[][]{{"TIMESTAMP '1992-01-05'", "TIMESTAMP '1995-10-13'", "TIMESTAMP '1995-10-14'", "TIMESTAMP '1998-07-29'"}});
        this.testPageSkipping("clerk", "varchar(15)", new Object[][]{{"'Clerk#000000006'", "'Clerk#000000508'", "'Clerk#000000513'", "'Clerk#000000996'"}});
        this.testPageSkipping("custkey", "integer", new Object[][]{{4, 634, 640, 1493}});
        this.testPageSkipping("custkey", "smallint", new Object[][]{{4, 634, 640, 1493}});
    }

    private void testPageSkipping(String sortByColumn, String sortByColumnType, Object[][] valuesArray) {
        String tableName = "test_page_skipping_" + TestingNames.randomNameSuffix();
        this.buildSortedTables(tableName, sortByColumn, sortByColumnType);
        for (Object[] values : valuesArray) {
            Object lowValue = values[0];
            Object middleLowValue = values[1];
            Object middleHighValue = values[2];
            Object highValue = values[3];
            this.assertColumnIndexResults(String.format("SELECT %s FROM %s WHERE %s = %s", sortByColumn, tableName, sortByColumn, middleLowValue));
            Assertions.assertThat((int)this.assertColumnIndexResults(String.format("SELECT %s FROM %s WHERE %s < %s", sortByColumn, tableName, sortByColumn, lowValue))).isGreaterThan(0);
            Assertions.assertThat((int)this.assertColumnIndexResults(String.format("SELECT %s FROM %s WHERE %s > %s", sortByColumn, tableName, sortByColumn, highValue))).isGreaterThan(0);
            Assertions.assertThat((int)this.assertColumnIndexResults(String.format("SELECT %s FROM %s WHERE %s BETWEEN %s AND %s", sortByColumn, tableName, sortByColumn, middleLowValue, middleHighValue))).isGreaterThan(0);
            this.assertColumnIndexResults(String.format("SELECT * FROM %s WHERE %s = %s", tableName, sortByColumn, middleLowValue));
            Assertions.assertThat((int)this.assertColumnIndexResults(String.format("SELECT * FROM %s WHERE %s < %s", tableName, sortByColumn, lowValue))).isGreaterThan(0);
            Assertions.assertThat((int)this.assertColumnIndexResults(String.format("SELECT * FROM %s WHERE %s > %s", tableName, sortByColumn, highValue))).isGreaterThan(0);
            Assertions.assertThat((int)this.assertColumnIndexResults(String.format("SELECT * FROM %s WHERE %s BETWEEN %s AND %s", tableName, sortByColumn, middleLowValue, middleHighValue))).isGreaterThan(0);
            this.assertColumnIndexResults(String.format("SELECT rvalues FROM %s WHERE %s IN (%s, %s, %s, %s)", tableName, sortByColumn, lowValue, middleLowValue, middleHighValue, highValue));
            this.assertColumnIndexResults(String.format("SELECT orderkey, orderdate FROM %s WHERE %s IN (%s, %s, %s, %s)", tableName, sortByColumn, lowValue, middleLowValue, middleHighValue, highValue));
        }
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testFilteringWithColumnIndex() throws IOException {
        Location dataFile = this.copyInDataFile("parquet_page_skipping/lineitem_sorted_by_suppkey/data.parquet");
        String tableName = "test_page_filtering_" + TestingNames.randomNameSuffix();
        this.assertUpdate(String.format("CREATE TABLE %s (suppkey bigint, extendedprice decimal(12, 2), shipmode varchar(10), comment varchar(44)) WITH (format = 'PARQUET', external_location = '%s')", tableName, dataFile.parentDirectory()));
        this.verifyFilteringWithColumnIndex("SELECT * FROM " + tableName + " WHERE suppkey = 10");
        this.verifyFilteringWithColumnIndex("SELECT * FROM " + tableName + " WHERE suppkey BETWEEN 25 AND 35");
        this.verifyFilteringWithColumnIndex("SELECT * FROM " + tableName + " WHERE suppkey >= 60");
        this.verifyFilteringWithColumnIndex("SELECT * FROM " + tableName + " WHERE suppkey <= 40");
        this.verifyFilteringWithColumnIndex("SELECT * FROM " + tableName + " WHERE suppkey IN (25, 35, 50, 80)");
        this.assertUpdate("DROP TABLE " + tableName);
    }

    private void verifyFilteringWithColumnIndex(@Language(value="SQL") String query) {
        DistributedQueryRunner queryRunner = this.getDistributedQueryRunner();
        QueryRunner.MaterializedResultWithPlan resultWithoutColumnIndex = queryRunner.executeWithPlan(this.noParquetColumnIndexFiltering(this.getSession()), query);
        QueryStats queryStatsWithoutColumnIndex = this.getQueryStats(resultWithoutColumnIndex.queryId());
        Assertions.assertThat((long)queryStatsWithoutColumnIndex.getPhysicalInputPositions()).isGreaterThan(0L);
        Map metricsWithoutColumnIndex = this.getScanOperatorStats(resultWithoutColumnIndex.queryId()).getConnectorMetrics().getMetrics();
        Assertions.assertThat((Map)metricsWithoutColumnIndex).doesNotContainKey((Object)"ParquetColumnIndexRowsFiltered");
        QueryRunner.MaterializedResultWithPlan resultWithColumnIndex = queryRunner.executeWithPlan(this.getSession(), query);
        QueryStats queryStatsWithColumnIndex = this.getQueryStats(resultWithColumnIndex.queryId());
        Assertions.assertThat((long)queryStatsWithColumnIndex.getPhysicalInputPositions()).isGreaterThan(0L);
        Assertions.assertThat((long)queryStatsWithColumnIndex.getPhysicalInputPositions()).isLessThan(queryStatsWithoutColumnIndex.getPhysicalInputPositions());
        Map metricsWithColumnIndex = this.getScanOperatorStats(resultWithColumnIndex.queryId()).getConnectorMetrics().getMetrics();
        Assertions.assertThat((Map)metricsWithColumnIndex).containsKey((Object)"ParquetColumnIndexRowsFiltered");
        Assertions.assertThat((long)((Count)metricsWithColumnIndex.get("ParquetColumnIndexRowsFiltered")).getTotal()).isGreaterThan(0L);
        QueryAssertions.assertEqualsIgnoreOrder((Iterable)resultWithColumnIndex.result(), (Iterable)resultWithoutColumnIndex.result());
    }

    private int assertColumnIndexResults(String query) {
        MaterializedResult withColumnIndexing = this.computeActual(query);
        MaterializedResult withoutColumnIndexing = this.computeActual(this.noParquetColumnIndexFiltering(this.getSession()), query);
        QueryAssertions.assertEqualsIgnoreOrder((Iterable)withColumnIndexing, (Iterable)withoutColumnIndexing);
        return withoutColumnIndexing.getRowCount();
    }

    private void assertRowGroupPruning(@Language(value="SQL") String sql) {
        this.assertQueryStats(this.noParquetColumnIndexFiltering(this.getSession()), sql, queryStats -> {
            Assertions.assertThat((long)queryStats.getPhysicalInputPositions()).isGreaterThan(0L);
            Assertions.assertThat((long)queryStats.getProcessedInputPositions()).isEqualTo(queryStats.getPhysicalInputPositions());
        }, results -> Assertions.assertThat((int)results.getRowCount()).isEqualTo(0));
        this.assertQueryStats(this.getSession(), sql, queryStats -> {
            Assertions.assertThat((long)queryStats.getPhysicalInputPositions()).isEqualTo(0L);
            Assertions.assertThat((long)queryStats.getProcessedInputPositions()).isEqualTo(0L);
        }, results -> Assertions.assertThat((int)results.getRowCount()).isEqualTo(0));
    }

    private Session noParquetColumnIndexFiltering(Session session) {
        return Session.builder((Session)session).setCatalogSessionProperty((String)session.getCatalog().orElseThrow(), "parquet_use_column_index", "false").build();
    }

    private QueryStats getQueryStats(QueryId queryId) {
        return this.getDistributedQueryRunner().getCoordinator().getQueryManager().getFullQueryInfo(queryId).getQueryStats();
    }

    private OperatorStats getScanOperatorStats(QueryId queryId) {
        return (OperatorStats)this.getQueryStats(queryId).getOperatorSummaries().stream().filter(summary -> summary.getOperatorType().startsWith("TableScan") || summary.getOperatorType().startsWith("Scan")).collect(MoreCollectors.onlyElement());
    }

    private void buildSortedTables(String tableName, String sortByColumnName, String sortByColumnType) {
        String createTableTemplate = "CREATE TABLE %s (    orderkey bigint,    custkey bigint,    orderstatus varchar(1),    totalprice double,    orderdate date,    orderpriority varchar(15),    clerk varchar(15),    shippriority integer,    comment varchar(79),    rvalues double array ) WITH (    format = 'PARQUET',    bucketed_by = array['orderstatus'],    bucket_count = 1,    sorted_by = array['%s'] )";
        createTableTemplate = createTableTemplate.replaceFirst(sortByColumnName + "[ ]+([^,]*)", sortByColumnName + " " + sortByColumnType);
        this.assertUpdate(String.format(createTableTemplate, tableName, sortByColumnName));
        String catalog = (String)this.getSession().getCatalog().orElseThrow();
        this.assertUpdate(Session.builder((Session)this.getSession()).setCatalogSessionProperty(catalog, "parquet_writer_page_size", "10000B").setCatalogSessionProperty(catalog, "parquet_writer_block_size", "2GB").build(), String.format("INSERT INTO %s SELECT *, ARRAY[rand(), rand(), rand()] FROM tpch.tiny.orders", tableName), 15000L);
    }

    private Location copyInDataFile(String resourceFileName) throws IOException {
        URL resourceLocation = Resources.getResource((String)resourceFileName);
        Location tempDir = Location.of((String)("local:///temp_" + String.valueOf(UUID.randomUUID())));
        this.fileSystem.createDirectory(tempDir);
        Location dataFile = tempDir.appendPath("data.parquet");
        try (OutputStream out = this.fileSystem.newOutputFile(dataFile).create();){
            Resources.copy((URL)resourceLocation, (OutputStream)out);
        }
        return dataFile;
    }
}

