/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive;

import com.google.common.collect.ImmutableList;
import io.airlift.json.JsonCodec;
import io.trino.filesystem.Location;
import io.trino.plugin.hive.PartitionUpdate;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestPartitionUpdate {
    private static final JsonCodec<PartitionUpdate> CODEC = JsonCodec.jsonCodec(PartitionUpdate.class);

    @Test
    public void testRoundTrip() {
        PartitionUpdate expected = new PartitionUpdate("test", PartitionUpdate.UpdateMode.APPEND, "/writePath", "/targetPath", (List)ImmutableList.of((Object)"file1", (Object)"file3"), 123L, 456L, 789L);
        PartitionUpdate actual = (PartitionUpdate)CODEC.fromJson(CODEC.toJson((Object)expected));
        Assertions.assertThat((String)actual.getName()).isEqualTo("test");
        Assertions.assertThat((Comparable)actual.getUpdateMode()).isEqualTo((Object)PartitionUpdate.UpdateMode.APPEND);
        Assertions.assertThat((Object)actual.getWritePath()).isEqualTo((Object)Location.of((String)"/writePath"));
        Assertions.assertThat((Object)actual.getTargetPath()).isEqualTo((Object)Location.of((String)"/targetPath"));
        Assertions.assertThat((List)actual.getFileNames()).isEqualTo((Object)ImmutableList.of((Object)"file1", (Object)"file3"));
        Assertions.assertThat((long)actual.getRowCount()).isEqualTo(123L);
        Assertions.assertThat((long)actual.getInMemoryDataSizeInBytes()).isEqualTo(456L);
        Assertions.assertThat((long)actual.getOnDiskDataSizeInBytes()).isEqualTo(789L);
    }
}

