/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive;

import com.google.common.collect.ImmutableMap;
import io.trino.filesystem.Location;
import io.trino.plugin.hive.HiveQueryRunner;
import io.trino.testing.AbstractTestQueryFramework;
import io.trino.testing.MaterializedResult;
import io.trino.testing.QueryAssertions;
import io.trino.testing.QueryRunner;
import java.io.IOException;
import java.util.Map;
import java.util.UUID;
import org.junit.jupiter.api.Test;

public class TestRegexTable
extends AbstractTestQueryFramework {
    protected QueryRunner createQueryRunner() throws Exception {
        return HiveQueryRunner.builder().setHiveProperties((Map<String, String>)ImmutableMap.of((Object)"hive.non-managed-table-writes-enabled", (Object)"true")).build();
    }

    @Test
    public void testCreateExternalTableWithData() throws IOException {
        Location tempDir = Location.of((String)("local:///temp_" + String.valueOf(UUID.randomUUID())));
        String createTableSql = "CREATE TABLE test_regex_data\nWITH (\n    format = 'textfile',\n    textfile_field_separator = 'x',\n    external_location = '%s')\nAS SELECT nationkey, name FROM tpch.tiny.nation\n".formatted(tempDir);
        this.assertUpdate(createTableSql, 25L);
        MaterializedResult expected = this.computeActual("SELECT nationkey, name FROM tpch.tiny.nation");
        MaterializedResult actual = this.computeActual("SELECT nationkey, name FROM test_regex_data");
        QueryAssertions.assertEqualsIgnoreOrder((Iterable)actual.getMaterializedRows(), (Iterable)expected.getMaterializedRows());
        createTableSql = "CREATE TABLE test_regex (\n    nationkey BIGINT,\n    name VARCHAR)\nWITH (\n    format = 'regex',\n    regex = '(\\d+)x(.+)',\n    external_location = '%s')\n".formatted(tempDir);
        this.assertUpdate(createTableSql);
        actual = this.computeActual("SELECT nationkey, name FROM test_regex");
        QueryAssertions.assertEqualsIgnoreOrder((Iterable)actual.getMaterializedRows(), (Iterable)expected.getMaterializedRows());
        this.assertQueryFails("INSERT INTO test_regex VALUES (42, 'name')", "REGEX format is read-only");
        this.assertUpdate("DROP TABLE test_regex");
        createTableSql = "CREATE TABLE test_regex (\n    nationkey BIGINT,\n    name VARCHAR)\nWITH (\n    format = 'regex',\n    regex = '(\\d+)X(.+)',\n    regex_case_insensitive = true,\n    external_location = '%s')\n".formatted(tempDir);
        this.assertUpdate(createTableSql);
        actual = this.computeActual("SELECT nationkey, name FROM test_regex");
        QueryAssertions.assertEqualsIgnoreOrder((Iterable)actual.getMaterializedRows(), (Iterable)expected.getMaterializedRows());
        this.assertUpdate("DROP TABLE test_regex");
        createTableSql = "CREATE TABLE test_regex (\n    nationkey BIGINT,\n    name VARCHAR)\nWITH (\n    format = 'regex',\n    regex = '(\\d+)X(.+)',\n    external_location = '%s')\n".formatted(tempDir);
        this.assertUpdate(createTableSql);
        this.assertQueryReturnsEmptyResult("SELECT nationkey, name FROM test_regex WHERE nationkey IS NOT NULL AND name IS NOT NULL");
        this.assertUpdate("DROP TABLE test_regex");
        this.assertUpdate("DROP TABLE test_regex_data");
    }

    @Test
    public void testRegexPropertyIsRequired() {
        this.assertQueryFails("CREATE TABLE test_regex_property_required (\n    nationkey BIGINT,\n    name VARCHAR)\nWITH (format = 'regex')\n", "REGEX format requires the 'regex' table property");
    }

    @Test
    public void testInvalidRegexProperty() {
        this.assertQueryFails("CREATE TABLE test_regex_property_required (\n    nationkey BIGINT,\n    name VARCHAR)\nWITH (\n    format = 'regex',\n    regex = '\\J')\n", "Invalid REGEX pattern value: \\\\J");
    }
}

