/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive;

import io.trino.plugin.hive.TableOfflineException;
import io.trino.spi.connector.SchemaTableName;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestTableOfflineException {
    @Test
    public void testMessage() {
        TestTableOfflineException.assertMessage(new SchemaTableName("schema", "table"), false, "", "Table 'schema.table' is offline");
        TestTableOfflineException.assertMessage(new SchemaTableName("schema", "table"), false, null, "Table 'schema.table' is offline");
        TestTableOfflineException.assertMessage(new SchemaTableName("schema", "table"), true, "", "Table 'schema.table' is offline for Presto");
        TestTableOfflineException.assertMessage(new SchemaTableName("schema", "table"), true, null, "Table 'schema.table' is offline for Presto");
        TestTableOfflineException.assertMessage(new SchemaTableName("schema", "table"), false, "offline reason", "Table 'schema.table' is offline: offline reason");
        TestTableOfflineException.assertMessage(new SchemaTableName("schema", "table"), true, "offline reason", "Table 'schema.table' is offline for Presto: offline reason");
    }

    private static void assertMessage(SchemaTableName tableName, boolean forPresto, String offlineMessage, String expectedMessage) {
        TableOfflineException tableOfflineException = new TableOfflineException(tableName, forPresto, offlineMessage);
        Assertions.assertThat((String)tableOfflineException.getMessage()).isEqualTo(expectedMessage);
    }
}

