/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive;

import com.google.common.collect.ImmutableMap;
import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.multibindings.MapBinder;
import io.airlift.configuration.ConfigBinder;
import io.trino.filesystem.TrinoFileSystemFactory;
import io.trino.filesystem.local.LocalFileSystemFactory;
import io.trino.metastore.HiveMetastore;
import io.trino.plugin.hive.HiveConnectorFactory;
import io.trino.plugin.hive.metastore.file.FileHiveMetastoreConfig;
import io.trino.spi.connector.Connector;
import io.trino.spi.connector.ConnectorContext;
import io.trino.spi.connector.ConnectorFactory;
import java.nio.file.Path;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class TestingHiveConnectorFactory
implements ConnectorFactory {
    private final Optional<HiveMetastore> metastore;
    private final Module module;

    public TestingHiveConnectorFactory(Path localFileSystemRootPath) {
        this(localFileSystemRootPath, Optional.empty());
    }

    @Deprecated
    public TestingHiveConnectorFactory(Path localFileSystemRootPath, Optional<HiveMetastore> metastore) {
        this.metastore = Objects.requireNonNull(metastore, "metastore is null");
        boolean ignored = localFileSystemRootPath.toFile().mkdirs();
        this.module = binder -> {
            MapBinder.newMapBinder((Binder)binder, String.class, TrinoFileSystemFactory.class).addBinding((Object)"local").toInstance((Object)new LocalFileSystemFactory(localFileSystemRootPath));
            ConfigBinder.configBinder((Binder)binder).bindConfigDefaults(FileHiveMetastoreConfig.class, config -> config.setCatalogDirectory("local:///"));
        };
    }

    public String getName() {
        return "hive";
    }

    public Connector create(String catalogName, Map<String, String> config, ConnectorContext context) {
        ImmutableMap.Builder configBuilder = ImmutableMap.builder().putAll(config).put((Object)"bootstrap.quiet", (Object)"true");
        if (this.metastore.isEmpty() && !config.containsKey("hive.metastore")) {
            configBuilder.put((Object)"hive.metastore", (Object)"file");
        }
        return HiveConnectorFactory.createConnector((String)catalogName, (Map)configBuilder.buildOrThrow(), (ConnectorContext)context, (Module)this.module, this.metastore, Optional.empty());
    }
}

