/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.coercions;

import io.airlift.slice.Slices;
import io.trino.metastore.HiveType;
import io.trino.plugin.hive.HiveStorageFormat;
import io.trino.plugin.hive.HiveTimestampPrecision;
import io.trino.plugin.hive.coercions.CoercionUtils;
import io.trino.plugin.hive.coercions.TypeCoercer;
import io.trino.plugin.hive.util.HiveTypeTranslator;
import io.trino.spi.block.Block;
import io.trino.spi.predicate.Utils;
import io.trino.spi.type.CharType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeManager;
import io.trino.spi.type.VarcharType;
import io.trino.type.InternalTypeManager;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestCharToVarcharCoercer {
    @Test
    public void testCharToSmallerVarcharCoercions() {
        TestCharToVarcharCoercer.assertCharToVarcharCoercion("a", (Type)CharType.createCharType((int)3), "a", (Type)VarcharType.createVarcharType((int)2));
        TestCharToVarcharCoercer.assertCharToVarcharCoercion(" a", (Type)CharType.createCharType((int)3), " a", (Type)VarcharType.createVarcharType((int)2));
        TestCharToVarcharCoercer.assertCharToVarcharCoercion(" aa", (Type)CharType.createCharType((int)4), " a", (Type)VarcharType.createVarcharType((int)2));
        TestCharToVarcharCoercer.assertCharToVarcharCoercion("a", (Type)CharType.createCharType((int)3), "a", (Type)VarcharType.createVarcharType((int)2));
        TestCharToVarcharCoercer.assertCharToVarcharCoercion("\ud83d\udcb0\ud83d\udcb0\ud83d\udcb0", (Type)CharType.createCharType((int)3), "\ud83d\udcb0", (Type)VarcharType.createVarcharType((int)1));
        TestCharToVarcharCoercer.assertCharToVarcharCoercion("\ud83d\udcb0\ud83d\udcb0", (Type)CharType.createCharType((int)7), "\ud83d\udcb0\ud83d\udcb0", (Type)VarcharType.createVarcharType((int)6));
        TestCharToVarcharCoercer.assertCharToVarcharCoercion("\ud83d\udcb0", (Type)CharType.createCharType((int)3), "\ud83d\udcb0", (Type)VarcharType.createVarcharType((int)1));
        TestCharToVarcharCoercer.assertCharToVarcharCoercion("\ud83d\udcb0 \ud83d\udcb0", (Type)CharType.createCharType((int)7), "\ud83d\udcb0 \ud83d\udcb0", (Type)VarcharType.createVarcharType((int)6));
    }

    private static void assertCharToVarcharCoercion(String actualValue, Type fromType, String expectedValue, Type toType) {
        Block coercedBlock = ((TypeCoercer)CoercionUtils.createCoercer((TypeManager)InternalTypeManager.TESTING_TYPE_MANAGER, (HiveType)HiveTypeTranslator.toHiveType((Type)fromType), (HiveType)HiveTypeTranslator.toHiveType((Type)toType), (CoercionUtils.CoercionContext)new CoercionUtils.CoercionContext(HiveTimestampPrecision.DEFAULT_PRECISION, HiveStorageFormat.PARQUET)).orElseThrow()).apply(Utils.nativeValueToBlock((Type)fromType, (Object)Slices.utf8Slice((String)actualValue)));
        Assertions.assertThat((Object)Utils.blockToNativeValue((Type)toType, (Block)coercedBlock)).isEqualTo((Object)Slices.utf8Slice((String)expectedValue));
    }
}

