/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.coercions;

import io.airlift.slice.Slices;
import io.trino.metastore.HiveType;
import io.trino.plugin.hive.HiveStorageFormat;
import io.trino.plugin.hive.HiveTimestampPrecision;
import io.trino.plugin.hive.coercions.CoercionUtils;
import io.trino.plugin.hive.coercions.TypeCoercer;
import io.trino.plugin.hive.util.HiveTypeTranslator;
import io.trino.spi.TrinoException;
import io.trino.spi.block.Block;
import io.trino.spi.predicate.Utils;
import io.trino.spi.type.DateType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeManager;
import io.trino.spi.type.VarcharType;
import io.trino.type.InternalTypeManager;
import java.time.LocalDate;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestDateCoercer {
    @Test
    public void testValidVarcharToDate() {
        this.assertVarcharToDateCoercion((Type)VarcharType.createUnboundedVarcharType(), "+10000-04-13");
        this.assertVarcharToDateCoercion((Type)VarcharType.createUnboundedVarcharType(), "1900-01-01");
        this.assertVarcharToDateCoercion((Type)VarcharType.createUnboundedVarcharType(), "2000-01-01");
        this.assertVarcharToDateCoercion((Type)VarcharType.createUnboundedVarcharType(), "2023-03-12");
    }

    @Test
    public void testThrowsExceptionWhenStringIsNotAValidDate() {
        Assertions.assertThatThrownBy(() -> this.assertVarcharToDateCoercion((Type)VarcharType.createUnboundedVarcharType(), "2023-01-40", null)).hasMessageMatching(".*Invalid date value.*is not a valid date.*");
        Assertions.assertThatThrownBy(() -> this.assertVarcharToDateCoercion((Type)VarcharType.createUnboundedVarcharType(), "2023-15-13", null)).hasMessageMatching(".*Invalid date value.*is not a valid date.*");
        Assertions.assertThatThrownBy(() -> this.assertVarcharToDateCoercion((Type)VarcharType.createUnboundedVarcharType(), "invalidDate", null)).hasMessageMatching(".*Invalid date value.*is not a valid date.*");
    }

    @Test
    public void testThrowsExceptionWhenDateIsTooOld() {
        Assertions.assertThatThrownBy(() -> this.assertVarcharToDateCoercion((Type)VarcharType.createUnboundedVarcharType(), "1899-12-31", null)).hasMessageMatching(".*Coercion on historical dates is not supported.*");
    }

    @Test
    public void testDateToVarchar() {
        this.assertDateToVarcharCoercion((Type)VarcharType.createUnboundedVarcharType(), LocalDate.parse("2023-01-10"), "2023-01-10");
        this.assertDateToVarcharCoercion((Type)VarcharType.createUnboundedVarcharType(), LocalDate.parse("+10000-04-25"), "+10000-04-25");
    }

    @Test
    public void testDateToLowerBoundedVarchar() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.assertDateToVarcharCoercion((Type)VarcharType.createVarcharType((int)8), LocalDate.parse("2023-10-23"), "2023-10-23")).isInstanceOf(TrinoException.class)).hasMessageContaining("Varchar representation of '2023-10-23' exceeds varchar(8) bounds");
    }

    @Test
    public void testHistoricalDateToVarchar() {
        Assertions.assertThatThrownBy(() -> this.assertDateToVarcharCoercion((Type)VarcharType.createUnboundedVarcharType(), LocalDate.parse("1899-12-31"), null)).hasMessageMatching(".*Coercion on historical dates is not supported.*");
    }

    private void assertVarcharToDateCoercion(Type fromType, String date) {
        this.assertVarcharToDateCoercion(fromType, date, this.fromDateToEpochDate(date));
    }

    private void assertVarcharToDateCoercion(Type fromType, String date, Long expected) {
        Block coercedValue = ((TypeCoercer)CoercionUtils.createCoercer((TypeManager)InternalTypeManager.TESTING_TYPE_MANAGER, (HiveType)HiveTypeTranslator.toHiveType((Type)fromType), (HiveType)HiveTypeTranslator.toHiveType((Type)DateType.DATE), (CoercionUtils.CoercionContext)new CoercionUtils.CoercionContext(HiveTimestampPrecision.DEFAULT_PRECISION, HiveStorageFormat.PARQUET)).orElseThrow()).apply(Utils.nativeValueToBlock((Type)fromType, (Object)Slices.utf8Slice((String)date)));
        Assertions.assertThat((Object)Utils.blockToNativeValue((Type)DateType.DATE, (Block)coercedValue)).isEqualTo((Object)expected);
    }

    private void assertDateToVarcharCoercion(Type toType, LocalDate date, String expected) {
        Block coercedValue = ((TypeCoercer)CoercionUtils.createCoercer((TypeManager)InternalTypeManager.TESTING_TYPE_MANAGER, (HiveType)HiveTypeTranslator.toHiveType((Type)DateType.DATE), (HiveType)HiveTypeTranslator.toHiveType((Type)toType), (CoercionUtils.CoercionContext)new CoercionUtils.CoercionContext(HiveTimestampPrecision.DEFAULT_PRECISION, HiveStorageFormat.PARQUET)).orElseThrow()).apply(Utils.nativeValueToBlock((Type)DateType.DATE, (Object)date.toEpochDay()));
        Assertions.assertThat((Object)Utils.blockToNativeValue((Type)VarcharType.VARCHAR, (Block)coercedValue)).isEqualTo((Object)Slices.utf8Slice((String)expected));
    }

    private long fromDateToEpochDate(String dateString) {
        LocalDate date = LocalDate.parse(dateString);
        return date.toEpochDay();
    }
}

