/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.coercions;

import io.trino.metastore.HiveType;
import io.trino.plugin.hive.HiveStorageFormat;
import io.trino.plugin.hive.HiveTimestampPrecision;
import io.trino.plugin.hive.coercions.CoercionUtils;
import io.trino.plugin.hive.coercions.TypeCoercer;
import io.trino.plugin.hive.util.HiveTypeTranslator;
import io.trino.spi.block.Block;
import io.trino.spi.predicate.Utils;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.DecimalParseResult;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.Decimals;
import io.trino.spi.type.Int128;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeManager;
import io.trino.type.InternalTypeManager;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestDecimalCoercers {
    @Test
    public void testDecimalToIntCoercion() {
        this.testDecimalToIntCoercion("12.120000000000000000", (Type)TinyintType.TINYINT, 12L);
        this.testDecimalToIntCoercion("-12.120000000000000000", (Type)TinyintType.TINYINT, -12L);
        this.testDecimalToIntCoercion("12.120", (Type)TinyintType.TINYINT, 12L);
        this.testDecimalToIntCoercion("-12.120", (Type)TinyintType.TINYINT, -12L);
        this.testDecimalToIntCoercion("141.120000000000000000", (Type)TinyintType.TINYINT, null);
        this.testDecimalToIntCoercion("-141.120", (Type)TinyintType.TINYINT, null);
        this.testDecimalToIntCoercion("130.120000000000000000", (Type)SmallintType.SMALLINT, 130L);
        this.testDecimalToIntCoercion("-130.120000000000000000", (Type)SmallintType.SMALLINT, -130L);
        this.testDecimalToIntCoercion("130.120", (Type)SmallintType.SMALLINT, 130L);
        this.testDecimalToIntCoercion("-130.120", (Type)SmallintType.SMALLINT, -130L);
        this.testDecimalToIntCoercion("66000.30120000000000000", (Type)SmallintType.SMALLINT, null);
        this.testDecimalToIntCoercion("-66000.120", (Type)SmallintType.SMALLINT, null);
        this.testDecimalToIntCoercion("33000.12000000000000000", (Type)IntegerType.INTEGER, 33000L);
        this.testDecimalToIntCoercion("-33000.12000000000000000", (Type)IntegerType.INTEGER, -33000L);
        this.testDecimalToIntCoercion("33000.120", (Type)IntegerType.INTEGER, 33000L);
        this.testDecimalToIntCoercion("-33000.120", (Type)IntegerType.INTEGER, -33000L);
        this.testDecimalToIntCoercion("3300000000.1200000000000", (Type)IntegerType.INTEGER, null);
        this.testDecimalToIntCoercion("3300000000.120", (Type)IntegerType.INTEGER, null);
        this.testDecimalToIntCoercion("3300000000.1200000000000", (Type)BigintType.BIGINT, 3300000000L);
        this.testDecimalToIntCoercion("-3300000000.120000000000", (Type)BigintType.BIGINT, -3300000000L);
        this.testDecimalToIntCoercion("3300000000.12", (Type)BigintType.BIGINT, 3300000000L);
        this.testDecimalToIntCoercion("-3300000000.12", (Type)BigintType.BIGINT, -3300000000L);
        this.testDecimalToIntCoercion("330000000000000000000.12000000000", (Type)BigintType.BIGINT, null);
        this.testDecimalToIntCoercion("-330000000000000000000.12000000000", (Type)BigintType.BIGINT, null);
        this.testDecimalToIntCoercion("3300000", (Type)IntegerType.INTEGER, 3300000L);
    }

    private void testDecimalToIntCoercion(String decimalString, Type coercedType, Object expectedValue) {
        DecimalParseResult parseResult = Decimals.parse((String)decimalString);
        if (decimalString.length() > 19) {
            Assertions.assertThat((boolean)parseResult.getType().isShort()).isFalse();
        } else {
            Assertions.assertThat((boolean)parseResult.getType().isShort()).isTrue();
        }
        TestDecimalCoercers.assertCoercion((Type)parseResult.getType(), parseResult.getObject(), coercedType, expectedValue);
    }

    @Test
    public void testTinyintToDecimalCoercion() {
        TestDecimalCoercers.assertCoercion((Type)TinyintType.TINYINT, 12L, (Type)DecimalType.createDecimalType((int)10), 12L);
        TestDecimalCoercers.assertCoercion((Type)TinyintType.TINYINT, 12L, (Type)DecimalType.createDecimalType((int)10, (int)2), 1200L);
        TestDecimalCoercers.assertCoercion((Type)TinyintType.TINYINT, 12L, (Type)DecimalType.createDecimalType((int)10, (int)5), 1200000L);
        TestDecimalCoercers.assertCoercion((Type)TinyintType.TINYINT, 0L, (Type)DecimalType.createDecimalType(), Int128.ZERO);
        TestDecimalCoercers.assertCoercion((Type)TinyintType.TINYINT, 0L, (Type)DecimalType.createDecimalType(), Int128.ZERO);
        TestDecimalCoercers.assertCoercion((Type)TinyintType.TINYINT, 12L, (Type)DecimalType.createDecimalType(), Int128.valueOf((long)12L));
        TestDecimalCoercers.assertCoercion((Type)TinyintType.TINYINT, -12L, (Type)DecimalType.createDecimalType(), Int128.valueOf((long)-12L));
        TestDecimalCoercers.assertCoercion((Type)TinyintType.TINYINT, 127L, (Type)DecimalType.createDecimalType(), Int128.valueOf((long)127L));
        TestDecimalCoercers.assertCoercion((Type)TinyintType.TINYINT, -128L, (Type)DecimalType.createDecimalType(), Int128.valueOf((long)-128L));
        TestDecimalCoercers.assertCoercion((Type)TinyintType.TINYINT, 12L, (Type)DecimalType.createDecimalType((int)20, (int)10), Int128.valueOf((String)"120000000000"));
        TestDecimalCoercers.assertCoercion((Type)TinyintType.TINYINT, 42L, (Type)DecimalType.createDecimalType((int)6, (int)5), null);
    }

    @Test
    public void testSmallintToDecimalCoercion() {
        TestDecimalCoercers.assertCoercion((Type)SmallintType.SMALLINT, 12L, (Type)DecimalType.createDecimalType((int)10), 12L);
        TestDecimalCoercers.assertCoercion((Type)SmallintType.SMALLINT, 12L, (Type)DecimalType.createDecimalType((int)10, (int)2), 1200L);
        TestDecimalCoercers.assertCoercion((Type)SmallintType.SMALLINT, 12L, (Type)DecimalType.createDecimalType((int)10, (int)5), 1200000L);
        TestDecimalCoercers.assertCoercion((Type)SmallintType.SMALLINT, 12L, (Type)DecimalType.createDecimalType((int)20, (int)10), Int128.valueOf((String)"120000000000"));
        TestDecimalCoercers.assertCoercion((Type)SmallintType.SMALLINT, 0L, (Type)DecimalType.createDecimalType(), Int128.ZERO);
        TestDecimalCoercers.assertCoercion((Type)SmallintType.SMALLINT, 128L, (Type)DecimalType.createDecimalType(), Int128.valueOf((long)128L));
        TestDecimalCoercers.assertCoercion((Type)SmallintType.SMALLINT, -128L, (Type)DecimalType.createDecimalType(), Int128.valueOf((long)-128L));
        TestDecimalCoercers.assertCoercion((Type)SmallintType.SMALLINT, 32767L, (Type)DecimalType.createDecimalType(), Int128.valueOf((long)32767L));
        TestDecimalCoercers.assertCoercion((Type)SmallintType.SMALLINT, -32768L, (Type)DecimalType.createDecimalType(), Int128.valueOf((long)-32768L));
        TestDecimalCoercers.assertCoercion((Type)SmallintType.SMALLINT, 128L, (Type)DecimalType.createDecimalType((int)7, (int)5), null);
        TestDecimalCoercers.assertCoercion((Type)SmallintType.SMALLINT, 128L, (Type)DecimalType.createDecimalType((int)20, (int)18), null);
    }

    @Test
    public void testIntToDecimalCoercion() {
        TestDecimalCoercers.assertCoercion((Type)IntegerType.INTEGER, 123456L, (Type)DecimalType.createDecimalType((int)10), 123456L);
        TestDecimalCoercers.assertCoercion((Type)IntegerType.INTEGER, 123456L, (Type)DecimalType.createDecimalType((int)10, (int)3), 123456000L);
        TestDecimalCoercers.assertCoercion((Type)IntegerType.INTEGER, 0L, (Type)DecimalType.createDecimalType(), Int128.ZERO);
        TestDecimalCoercers.assertCoercion((Type)IntegerType.INTEGER, 128L, (Type)DecimalType.createDecimalType(), Int128.valueOf((long)128L));
        TestDecimalCoercers.assertCoercion((Type)IntegerType.INTEGER, -128L, (Type)DecimalType.createDecimalType(), Int128.valueOf((long)-128L));
        TestDecimalCoercers.assertCoercion((Type)IntegerType.INTEGER, Integer.MAX_VALUE, (Type)DecimalType.createDecimalType(), Int128.valueOf((long)Integer.MAX_VALUE));
        TestDecimalCoercers.assertCoercion((Type)IntegerType.INTEGER, Integer.MIN_VALUE, (Type)DecimalType.createDecimalType(), Int128.valueOf((long)Integer.MIN_VALUE));
        TestDecimalCoercers.assertCoercion((Type)IntegerType.INTEGER, 123456L, (Type)DecimalType.createDecimalType((int)20, (int)10), Int128.valueOf((String)"1234560000000000"));
        TestDecimalCoercers.assertCoercion((Type)IntegerType.INTEGER, 123456789L, (Type)DecimalType.createDecimalType((int)10, (int)5), null);
        TestDecimalCoercers.assertCoercion((Type)IntegerType.INTEGER, 123456789L, (Type)DecimalType.createDecimalType((int)20, (int)13), null);
    }

    @Test
    public void testBigintToDecimalCoercion() {
        TestDecimalCoercers.assertCoercion((Type)BigintType.BIGINT, 0L, (Type)DecimalType.createDecimalType((int)10), 0L);
        TestDecimalCoercers.assertCoercion((Type)BigintType.BIGINT, 123456789L, (Type)DecimalType.createDecimalType((int)12), 123456789L);
        TestDecimalCoercers.assertCoercion((Type)BigintType.BIGINT, 123456789L, (Type)DecimalType.createDecimalType((int)12, (int)3), 123456789000L);
        TestDecimalCoercers.assertCoercion((Type)BigintType.BIGINT, 0L, (Type)DecimalType.createDecimalType(), Int128.ZERO);
        TestDecimalCoercers.assertCoercion((Type)BigintType.BIGINT, 128L, (Type)DecimalType.createDecimalType(), Int128.valueOf((long)128L));
        TestDecimalCoercers.assertCoercion((Type)BigintType.BIGINT, -128L, (Type)DecimalType.createDecimalType(), Int128.valueOf((long)-128L));
        TestDecimalCoercers.assertCoercion((Type)BigintType.BIGINT, Long.MAX_VALUE, (Type)DecimalType.createDecimalType(), Int128.valueOf((long)Long.MAX_VALUE));
        TestDecimalCoercers.assertCoercion((Type)BigintType.BIGINT, Long.MIN_VALUE, (Type)DecimalType.createDecimalType(), Int128.valueOf((long)Long.MIN_VALUE));
        TestDecimalCoercers.assertCoercion((Type)BigintType.BIGINT, 123456789L, (Type)DecimalType.createDecimalType((int)20, (int)5), Int128.valueOf((String)"12345678900000"));
        TestDecimalCoercers.assertCoercion((Type)BigintType.BIGINT, 123456789L, (Type)DecimalType.createDecimalType((int)20, (int)10), Int128.valueOf((String)"1234567890000000000"));
        TestDecimalCoercers.assertCoercion((Type)BigintType.BIGINT, Long.MAX_VALUE, (Type)DecimalType.createDecimalType((int)38, (int)2), Int128.valueOf((String)"922337203685477580700"));
        TestDecimalCoercers.assertCoercion((Type)BigintType.BIGINT, 123456789L, (Type)DecimalType.createDecimalType((int)10, (int)5), null);
        TestDecimalCoercers.assertCoercion((Type)BigintType.BIGINT, Long.MAX_VALUE, (Type)DecimalType.createDecimalType((int)25, (int)8), null);
    }

    private static void assertCoercion(Type fromType, Object valueToBeCoerced, Type toType, Object expectedValue) {
        Block coercedValue = ((TypeCoercer)CoercionUtils.createCoercer((TypeManager)InternalTypeManager.TESTING_TYPE_MANAGER, (HiveType)HiveTypeTranslator.toHiveType((Type)fromType), (HiveType)HiveTypeTranslator.toHiveType((Type)toType), (CoercionUtils.CoercionContext)new CoercionUtils.CoercionContext(HiveTimestampPrecision.DEFAULT_PRECISION, HiveStorageFormat.PARQUET)).orElseThrow()).apply(Utils.nativeValueToBlock((Type)fromType, (Object)valueToBeCoerced));
        Assertions.assertThat((Object)Utils.blockToNativeValue((Type)toType, (Block)coercedValue)).isEqualTo(expectedValue);
    }
}

