/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.coercions;

import io.airlift.slice.Slices;
import io.trino.metastore.HiveType;
import io.trino.plugin.hive.HiveStorageFormat;
import io.trino.plugin.hive.HiveTimestampPrecision;
import io.trino.plugin.hive.coercions.CoercionUtils;
import io.trino.plugin.hive.coercions.TypeCoercer;
import io.trino.plugin.hive.util.HiveTypeTranslator;
import io.trino.spi.TrinoException;
import io.trino.spi.block.Block;
import io.trino.spi.predicate.Utils;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeManager;
import io.trino.spi.type.VarcharType;
import io.trino.type.InternalTypeManager;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestDoubleToVarcharCoercions {
    @Test
    public void testDoubleToVarcharCoercions() {
        this.testDoubleToVarcharCoercions(Double.NEGATIVE_INFINITY, true);
        this.testDoubleToVarcharCoercions((Double)Double.MIN_VALUE, true);
        this.testDoubleToVarcharCoercions((Double)Double.MAX_VALUE, true);
        this.testDoubleToVarcharCoercions(Double.POSITIVE_INFINITY, true);
        this.testDoubleToVarcharCoercions(Double.parseDouble("123456789.12345678"), true);
        this.testDoubleToVarcharCoercions(Double.NEGATIVE_INFINITY, false);
        this.testDoubleToVarcharCoercions((Double)Double.MIN_VALUE, false);
        this.testDoubleToVarcharCoercions((Double)Double.MAX_VALUE, false);
        this.testDoubleToVarcharCoercions(Double.POSITIVE_INFINITY, false);
        this.testDoubleToVarcharCoercions(Double.parseDouble("123456789.12345678"), false);
    }

    private void testDoubleToVarcharCoercions(Double doubleValue, boolean treatNaNAsNull) {
        TestDoubleToVarcharCoercions.assertCoercions((Type)DoubleType.DOUBLE, doubleValue, (Type)VarcharType.createUnboundedVarcharType(), Slices.utf8Slice((String)doubleValue.toString()), treatNaNAsNull ? HiveStorageFormat.ORC : HiveStorageFormat.PARQUET);
    }

    @Test
    public void testDoubleSmallerVarcharCoercions() {
        this.testDoubleSmallerVarcharCoercions(Double.NEGATIVE_INFINITY, true);
        this.testDoubleSmallerVarcharCoercions((Double)Double.MIN_VALUE, true);
        this.testDoubleSmallerVarcharCoercions((Double)Double.MAX_VALUE, true);
        this.testDoubleSmallerVarcharCoercions(Double.POSITIVE_INFINITY, true);
        this.testDoubleSmallerVarcharCoercions(Double.parseDouble("123456789.12345678"), true);
        this.testDoubleSmallerVarcharCoercions(Double.NEGATIVE_INFINITY, false);
        this.testDoubleSmallerVarcharCoercions((Double)Double.MIN_VALUE, false);
        this.testDoubleSmallerVarcharCoercions((Double)Double.MAX_VALUE, false);
        this.testDoubleSmallerVarcharCoercions(Double.POSITIVE_INFINITY, false);
        this.testDoubleSmallerVarcharCoercions(Double.parseDouble("123456789.12345678"), false);
    }

    private void testDoubleSmallerVarcharCoercions(Double doubleValue, boolean treatNaNAsNull) {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TestDoubleToVarcharCoercions.assertCoercions((Type)DoubleType.DOUBLE, doubleValue, (Type)VarcharType.createVarcharType((int)1), doubleValue.toString(), treatNaNAsNull ? HiveStorageFormat.ORC : HiveStorageFormat.PARQUET)).isInstanceOf(TrinoException.class)).hasMessageContaining("Varchar representation of %s exceeds varchar(1) bounds", new Object[]{doubleValue});
    }

    @Test
    public void testNaNToVarcharCoercions() {
        TestDoubleToVarcharCoercions.assertCoercions((Type)DoubleType.DOUBLE, Double.NaN, (Type)VarcharType.createUnboundedVarcharType(), null, HiveStorageFormat.ORC);
        TestDoubleToVarcharCoercions.assertCoercions((Type)DoubleType.DOUBLE, Double.NaN, (Type)VarcharType.createUnboundedVarcharType(), Slices.utf8Slice((String)"NaN"), HiveStorageFormat.PARQUET);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TestDoubleToVarcharCoercions.assertCoercions((Type)DoubleType.DOUBLE, Double.NaN, (Type)VarcharType.createVarcharType((int)1), "NaN", HiveStorageFormat.PARQUET)).isInstanceOf(TrinoException.class)).hasMessageContaining("Varchar representation of NaN exceeds varchar(1) bounds");
    }

    public static void assertCoercions(Type fromType, Object valueToBeCoerced, Type toType, Object expectedValue, HiveStorageFormat storageFormat) {
        Block coercedValue = ((TypeCoercer)CoercionUtils.createCoercer((TypeManager)InternalTypeManager.TESTING_TYPE_MANAGER, (HiveType)HiveTypeTranslator.toHiveType((Type)fromType), (HiveType)HiveTypeTranslator.toHiveType((Type)toType), (CoercionUtils.CoercionContext)new CoercionUtils.CoercionContext(HiveTimestampPrecision.DEFAULT_PRECISION, storageFormat)).orElseThrow()).apply(Utils.nativeValueToBlock((Type)fromType, (Object)valueToBeCoerced));
        Assertions.assertThat((Object)Utils.blockToNativeValue((Type)toType, (Block)coercedValue)).isEqualTo(expectedValue);
    }
}

