/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.coercions;

import io.airlift.slice.Slices;
import io.trino.metastore.HiveType;
import io.trino.plugin.hive.HiveStorageFormat;
import io.trino.plugin.hive.HiveTimestampPrecision;
import io.trino.plugin.hive.coercions.CoercionUtils;
import io.trino.plugin.hive.coercions.TypeCoercer;
import io.trino.plugin.hive.util.HiveTypeTranslator;
import io.trino.spi.TrinoException;
import io.trino.spi.block.Block;
import io.trino.spi.predicate.Utils;
import io.trino.spi.type.RealType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeManager;
import io.trino.spi.type.VarcharType;
import io.trino.type.InternalTypeManager;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestFloatToVarcharCoercions {
    @Test
    public void testFloatToVarcharCoercions() {
        this.testFloatToVarcharCoercions(Float.valueOf(Float.NEGATIVE_INFINITY), true);
        this.testFloatToVarcharCoercions(Float.valueOf(Float.MIN_VALUE), true);
        this.testFloatToVarcharCoercions(Float.valueOf(Float.MAX_VALUE), true);
        this.testFloatToVarcharCoercions(Float.valueOf(Float.POSITIVE_INFINITY), true);
        this.testFloatToVarcharCoercions(Float.valueOf(Float.parseFloat("123456789.12345678")), true);
        this.testFloatToVarcharCoercions(Float.valueOf(Float.NEGATIVE_INFINITY), false);
        this.testFloatToVarcharCoercions(Float.valueOf(Float.MIN_VALUE), false);
        this.testFloatToVarcharCoercions(Float.valueOf(Float.MAX_VALUE), false);
        this.testFloatToVarcharCoercions(Float.valueOf(Float.POSITIVE_INFINITY), false);
        this.testFloatToVarcharCoercions(Float.valueOf(Float.parseFloat("123456789.12345678")), false);
    }

    private void testFloatToVarcharCoercions(Float floatValue, boolean treatNaNAsNull) {
        TestFloatToVarcharCoercions.assertCoercions((Type)RealType.REAL, floatValue, (Type)VarcharType.createUnboundedVarcharType(), Slices.utf8Slice((String)floatValue.toString()), treatNaNAsNull ? HiveStorageFormat.ORC : HiveStorageFormat.PARQUET);
    }

    @Test
    public void testFloatToSmallerVarcharCoercions() {
        this.testFloatToSmallerVarcharCoercions(Float.valueOf(Float.NEGATIVE_INFINITY), true);
        this.testFloatToSmallerVarcharCoercions(Float.valueOf(Float.MIN_VALUE), true);
        this.testFloatToSmallerVarcharCoercions(Float.valueOf(Float.MAX_VALUE), true);
        this.testFloatToSmallerVarcharCoercions(Float.valueOf(Float.POSITIVE_INFINITY), true);
        this.testFloatToSmallerVarcharCoercions(Float.valueOf(Float.parseFloat("123456789.12345678")), true);
        this.testFloatToSmallerVarcharCoercions(Float.valueOf(Float.NEGATIVE_INFINITY), false);
        this.testFloatToSmallerVarcharCoercions(Float.valueOf(Float.MIN_VALUE), false);
        this.testFloatToSmallerVarcharCoercions(Float.valueOf(Float.MAX_VALUE), false);
        this.testFloatToSmallerVarcharCoercions(Float.valueOf(Float.POSITIVE_INFINITY), false);
        this.testFloatToSmallerVarcharCoercions(Float.valueOf(Float.parseFloat("123456789.12345678")), false);
    }

    private void testFloatToSmallerVarcharCoercions(Float floatValue, boolean treatNaNAsNull) {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TestFloatToVarcharCoercions.assertCoercions((Type)RealType.REAL, floatValue, (Type)VarcharType.createVarcharType((int)1), floatValue.toString(), treatNaNAsNull ? HiveStorageFormat.ORC : HiveStorageFormat.PARQUET)).isInstanceOf(TrinoException.class)).hasMessageContaining("Varchar representation of %s exceeds varchar(1) bounds", new Object[]{floatValue});
    }

    @Test
    public void testNaNToVarcharCoercions() {
        TestFloatToVarcharCoercions.assertCoercions((Type)RealType.REAL, Float.valueOf(Float.NaN), (Type)VarcharType.createUnboundedVarcharType(), null, HiveStorageFormat.ORC);
        TestFloatToVarcharCoercions.assertCoercions((Type)RealType.REAL, Float.valueOf(Float.NaN), (Type)VarcharType.createUnboundedVarcharType(), Slices.utf8Slice((String)"NaN"), HiveStorageFormat.PARQUET);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TestFloatToVarcharCoercions.assertCoercions((Type)RealType.REAL, Float.valueOf(Float.NaN), (Type)VarcharType.createVarcharType((int)1), "NaN", HiveStorageFormat.PARQUET)).isInstanceOf(TrinoException.class)).hasMessageContaining("Varchar representation of NaN exceeds varchar(1) bounds");
    }

    public static void assertCoercions(Type fromType, Float valueToBeCoerced, Type toType, Object expectedValue, HiveStorageFormat storageFormat) {
        Block coercedValue = ((TypeCoercer)CoercionUtils.createCoercer((TypeManager)InternalTypeManager.TESTING_TYPE_MANAGER, (HiveType)HiveTypeTranslator.toHiveType((Type)fromType), (HiveType)HiveTypeTranslator.toHiveType((Type)toType), (CoercionUtils.CoercionContext)new CoercionUtils.CoercionContext(HiveTimestampPrecision.DEFAULT_PRECISION, storageFormat)).orElseThrow()).apply(Utils.nativeValueToBlock((Type)fromType, (Object)Float.floatToIntBits(valueToBeCoerced.floatValue())));
        Assertions.assertThat((Object)Utils.blockToNativeValue((Type)toType, (Block)coercedValue)).isEqualTo(expectedValue);
    }
}

