/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.coercions;

import io.trino.metastore.HiveType;
import io.trino.plugin.hive.HiveStorageFormat;
import io.trino.plugin.hive.HiveTimestampPrecision;
import io.trino.plugin.hive.coercions.CoercionUtils;
import io.trino.plugin.hive.coercions.TypeCoercer;
import io.trino.plugin.hive.util.HiveTypeTranslator;
import io.trino.spi.block.Block;
import io.trino.spi.predicate.Utils;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeManager;
import io.trino.type.InternalTypeManager;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestIntegerNumberToDoubleCoercer {
    @Test
    public void testTinyintToDoubleCoercion() {
        TestIntegerNumberToDoubleCoercer.assertDoubleCoercion((Type)TinyintType.TINYINT, 0L, 0.0);
        TestIntegerNumberToDoubleCoercer.assertDoubleCoercion((Type)TinyintType.TINYINT, 12L, 12.0);
        TestIntegerNumberToDoubleCoercer.assertDoubleCoercion((Type)TinyintType.TINYINT, -12L, -12.0);
        TestIntegerNumberToDoubleCoercer.assertDoubleCoercion((Type)TinyintType.TINYINT, 127L, 127.0);
        TestIntegerNumberToDoubleCoercer.assertDoubleCoercion((Type)TinyintType.TINYINT, -128L, -128.0);
    }

    @Test
    public void testSmallintToDoubleCoercion() {
        TestIntegerNumberToDoubleCoercer.assertDoubleCoercion((Type)SmallintType.SMALLINT, 0L, 0.0);
        TestIntegerNumberToDoubleCoercer.assertDoubleCoercion((Type)SmallintType.SMALLINT, 128L, 128.0);
        TestIntegerNumberToDoubleCoercer.assertDoubleCoercion((Type)SmallintType.SMALLINT, -128L, -128.0);
        TestIntegerNumberToDoubleCoercer.assertDoubleCoercion((Type)SmallintType.SMALLINT, 32767L, 32767.0);
        TestIntegerNumberToDoubleCoercer.assertDoubleCoercion((Type)SmallintType.SMALLINT, -32768L, -32768.0);
    }

    @Test
    public void testIntToDoubleCoercion() {
        TestIntegerNumberToDoubleCoercer.assertDoubleCoercion((Type)IntegerType.INTEGER, 0L, 0.0);
        TestIntegerNumberToDoubleCoercer.assertDoubleCoercion((Type)IntegerType.INTEGER, 128L, 128.0);
        TestIntegerNumberToDoubleCoercer.assertDoubleCoercion((Type)IntegerType.INTEGER, -128L, -128.0);
        TestIntegerNumberToDoubleCoercer.assertDoubleCoercion((Type)IntegerType.INTEGER, Integer.MAX_VALUE, 2.147483647E9);
        TestIntegerNumberToDoubleCoercer.assertDoubleCoercion((Type)IntegerType.INTEGER, Integer.MIN_VALUE, -2.147483648E9);
    }

    @Test
    public void testBigintToDoubleCoercion() {
        TestIntegerNumberToDoubleCoercer.assertDoubleCoercion((Type)BigintType.BIGINT, 0L, 0.0);
        TestIntegerNumberToDoubleCoercer.assertDoubleCoercion((Type)BigintType.BIGINT, 128L, 128.0);
        TestIntegerNumberToDoubleCoercer.assertDoubleCoercion((Type)BigintType.BIGINT, -128L, -128.0);
        TestIntegerNumberToDoubleCoercer.assertDoubleCoercion((Type)BigintType.BIGINT, Integer.MAX_VALUE, 2.147483647E9);
        TestIntegerNumberToDoubleCoercer.assertDoubleCoercion((Type)BigintType.BIGINT, Integer.MIN_VALUE, -2.147483648E9);
        TestIntegerNumberToDoubleCoercer.assertDoubleCoercion((Type)BigintType.BIGINT, 0xFFFFFFFFFFFFFL, 4.503599627370495E15);
        TestIntegerNumberToDoubleCoercer.assertDoubleCoercion((Type)BigintType.BIGINT, -4503599627370496L, -4.503599627370496E15);
        TestIntegerNumberToDoubleCoercer.assertDoubleCoercionFailure((Type)BigintType.BIGINT, 0x10000000000000L);
        TestIntegerNumberToDoubleCoercer.assertDoubleCoercionFailure((Type)BigintType.BIGINT, -4503599627370497L);
        TestIntegerNumberToDoubleCoercer.assertDoubleCoercionFailure((Type)BigintType.BIGINT, Long.MAX_VALUE);
        TestIntegerNumberToDoubleCoercer.assertDoubleCoercionFailure((Type)BigintType.BIGINT, Long.MIN_VALUE);
    }

    private static void assertDoubleCoercion(Type fromType, Object valueToBeCoerced, Double expectedValue) {
        Block coercedValue = TestIntegerNumberToDoubleCoercer.createIntegerToDoubleCoercer(fromType, valueToBeCoerced);
        Assertions.assertThat((Object)Utils.blockToNativeValue((Type)DoubleType.DOUBLE, (Block)coercedValue)).isEqualTo((Object)expectedValue);
    }

    private static void assertDoubleCoercionFailure(Type fromType, Object valueToBeCoerced) {
        Assertions.assertThatThrownBy(() -> TestIntegerNumberToDoubleCoercer.createIntegerToDoubleCoercer(fromType, valueToBeCoerced)).hasMessageContaining("Cannot read value '%s' as DOUBLE".formatted(valueToBeCoerced));
    }

    private static Block createIntegerToDoubleCoercer(Type fromType, Object valueToBeCoerced) {
        return ((TypeCoercer)CoercionUtils.createCoercer((TypeManager)InternalTypeManager.TESTING_TYPE_MANAGER, (HiveType)HiveTypeTranslator.toHiveType((Type)fromType), (HiveType)HiveTypeTranslator.toHiveType((Type)DoubleType.DOUBLE), (CoercionUtils.CoercionContext)new CoercionUtils.CoercionContext(HiveTimestampPrecision.DEFAULT_PRECISION, HiveStorageFormat.PARQUET)).orElseThrow()).apply(Utils.nativeValueToBlock((Type)fromType, (Object)valueToBeCoerced));
    }
}

