/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.coercions;

import io.airlift.slice.Slices;
import io.trino.metastore.HiveType;
import io.trino.plugin.hive.HiveStorageFormat;
import io.trino.plugin.hive.HiveTimestampPrecision;
import io.trino.plugin.hive.coercions.CoercionUtils;
import io.trino.plugin.hive.coercions.TypeCoercer;
import io.trino.plugin.hive.util.HiveTypeTranslator;
import io.trino.spi.TrinoException;
import io.trino.spi.block.Block;
import io.trino.spi.predicate.Utils;
import io.trino.spi.type.DateType;
import io.trino.spi.type.LongTimestamp;
import io.trino.spi.type.SqlTimestamp;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeManager;
import io.trino.spi.type.VarcharType;
import io.trino.type.InternalTypeManager;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.temporal.ChronoField;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestTimestampCoercer {
    @Test
    public void testTimestampToDate() {
        TestTimestampCoercer.assertTimestampToDateCoercion("1900-01-01T00:00:00.000", "1900-01-01");
        TestTimestampCoercer.assertTimestampToDateCoercion("1958-01-01T13:18:03.123", "1958-01-01");
        TestTimestampCoercer.assertTimestampToDateCoercion("2019-03-18T10:01:17.987", "2019-03-18");
        TestTimestampCoercer.assertTimestampToDateCoercion("2021-12-31T23:59:59.000", "2021-12-31");
        TestTimestampCoercer.assertTimestampToDateCoercion("2021-12-31T23:59:59.999", "2021-12-31");
        TestTimestampCoercer.assertTimestampToDateCoercion("2021-12-31T23:59:59.999999", "2021-12-31");
        TestTimestampCoercer.assertTimestampToDateCoercion("2021-12-31T23:59:59.999999999", "2021-12-31");
        TestTimestampCoercer.assertTimestampToDateCoercion("2018-10-28T01:33:17.456", "2018-10-28");
        TestTimestampCoercer.assertTimestampToDateCoercion("1970-01-01T00:00:00.000", "1970-01-01");
        TestTimestampCoercer.assertTimestampToDateCoercion("1970-01-01T00:13:42.000", "1970-01-01");
        TestTimestampCoercer.assertTimestampToDateCoercion("2018-04-01T02:13:55.123", "2018-04-01");
        TestTimestampCoercer.assertTimestampToDateCoercion("2018-03-25T03:17:17.000", "2018-03-25");
        TestTimestampCoercer.assertTimestampToDateCoercion("1986-01-01T00:13:07.000", "1986-01-01");
        TestTimestampCoercer.assertTimestampToDateCoercion("1969-12-31T23:59:59.123456", "1969-12-31");
    }

    @Test
    public void testHistoricalLongTimestampToDate() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TestTimestampCoercer.assertTimestampToDateCoercion("1899-12-31T23:59:59.999999999", "1899-12-31")).isInstanceOf(TrinoException.class)).hasMessageContaining("Coercion on historical dates is not supported");
    }

    @Test
    public void testTimestampToVarchar() {
        TestTimestampCoercer.testTimestampToVarchar("1900-01-01T00:00:00.000", "1900-01-01 00:00:00");
        TestTimestampCoercer.testTimestampToVarchar("1958-01-01T13:18:03.123", "1958-01-01 13:18:03.123");
        TestTimestampCoercer.testTimestampToVarchar("2019-03-18T10:01:17.987", "2019-03-18 10:01:17.987");
        TestTimestampCoercer.testTimestampToVarchar("2018-10-28T01:33:17.456", "2018-10-28 01:33:17.456");
        TestTimestampCoercer.testTimestampToVarchar("2018-10-28T03:33:33.333", "2018-10-28 03:33:33.333");
        TestTimestampCoercer.testTimestampToVarchar("1970-01-01T00:00:00.000", "1970-01-01 00:00:00");
        TestTimestampCoercer.testTimestampToVarchar("1970-01-01T00:13:42.000", "1970-01-01 00:13:42");
        TestTimestampCoercer.testTimestampToVarchar("2018-04-01T02:13:55.123", "2018-04-01 02:13:55.123");
        TestTimestampCoercer.testTimestampToVarchar("2018-03-25T03:17:17.000", "2018-03-25 03:17:17");
        TestTimestampCoercer.testTimestampToVarchar("1986-01-01T00:13:07.000", "1986-01-01 00:13:07");
        TestTimestampCoercer.testTimestampToVarchar("1969-12-31T23:59:59.123456", "1969-12-31 23:59:59.123456");
    }

    private static void testTimestampToVarchar(String timestampValue, String hiveTimestampValue) {
        LocalDateTime localDateTime = LocalDateTime.parse(timestampValue);
        SqlTimestamp timestamp = SqlTimestamp.fromSeconds((int)TimestampType.TIMESTAMP_PICOS.getPrecision(), (long)localDateTime.toEpochSecond(ZoneOffset.UTC), (long)localDateTime.get(ChronoField.NANO_OF_SECOND));
        TestTimestampCoercer.assertLongTimestampToVarcharCoercions(TimestampType.TIMESTAMP_PICOS, new LongTimestamp(timestamp.getEpochMicros(), timestamp.getPicosOfMicros()), VarcharType.createUnboundedVarcharType(), hiveTimestampValue);
    }

    @Test
    public void testVarcharToShortTimestamp() {
        TestTimestampCoercer.testVarcharToShortTimestamp("1900-01-01T00:00:00.000", "1900-01-01 00:00:00");
        TestTimestampCoercer.testVarcharToShortTimestamp("1958-01-01T13:18:03.123", "1958-01-01 13:18:03.123");
        TestTimestampCoercer.testVarcharToShortTimestamp("2019-03-18T10:01:17.987", "2019-03-18 10:01:17.987");
        TestTimestampCoercer.testVarcharToShortTimestamp("2018-10-28T01:33:17.456", "2018-10-28 01:33:17.456");
        TestTimestampCoercer.testVarcharToShortTimestamp("2018-10-28T03:33:33.333", "2018-10-28 03:33:33.333");
        TestTimestampCoercer.testVarcharToShortTimestamp("1970-01-01T00:00:00.000", "1970-01-01 00:00:00");
        TestTimestampCoercer.testVarcharToShortTimestamp("1970-01-01T00:13:42.000", "1970-01-01 00:13:42");
        TestTimestampCoercer.testVarcharToShortTimestamp("2018-04-01T02:13:55.123", "2018-04-01 02:13:55.123");
        TestTimestampCoercer.testVarcharToShortTimestamp("2018-03-25T03:17:17.000", "2018-03-25 03:17:17");
        TestTimestampCoercer.testVarcharToShortTimestamp("1986-01-01T00:13:07.000", "1986-01-01 00:13:07");
        TestTimestampCoercer.testVarcharToShortTimestamp("1969-12-31T23:59:59.123456", "1969-12-31 23:59:59.123456");
    }

    private static void testVarcharToShortTimestamp(String timestampValue, String hiveTimestampValue) {
        LocalDateTime localDateTime = LocalDateTime.parse(timestampValue);
        SqlTimestamp timestamp = SqlTimestamp.fromSeconds((int)TimestampType.TIMESTAMP_MICROS.getPrecision(), (long)localDateTime.toEpochSecond(ZoneOffset.UTC), (long)localDateTime.get(ChronoField.NANO_OF_SECOND));
        TestTimestampCoercer.assertVarcharToShortTimestampCoercions((Type)VarcharType.createUnboundedVarcharType(), Slices.utf8Slice((String)hiveTimestampValue), (Type)TimestampType.TIMESTAMP_MICROS, timestamp.getEpochMicros());
    }

    @Test
    public void testVarcharToLongTimestamp() {
        TestTimestampCoercer.testVarcharToLongTimestamp("1900-01-01T00:00:00.000", "1900-01-01 00:00:00");
        TestTimestampCoercer.testVarcharToLongTimestamp("1958-01-01T13:18:03.123", "1958-01-01 13:18:03.123");
        TestTimestampCoercer.testVarcharToLongTimestamp("2019-03-18T10:01:17.987", "2019-03-18 10:01:17.987");
        TestTimestampCoercer.testVarcharToLongTimestamp("2018-10-28T01:33:17.456", "2018-10-28 01:33:17.456");
        TestTimestampCoercer.testVarcharToLongTimestamp("2018-10-28T03:33:33.333", "2018-10-28 03:33:33.333");
        TestTimestampCoercer.testVarcharToLongTimestamp("1970-01-01T00:00:00.000", "1970-01-01 00:00:00");
        TestTimestampCoercer.testVarcharToLongTimestamp("1970-01-01T00:13:42.000", "1970-01-01 00:13:42");
        TestTimestampCoercer.testVarcharToLongTimestamp("2018-04-01T02:13:55.123", "2018-04-01 02:13:55.123");
        TestTimestampCoercer.testVarcharToLongTimestamp("2018-03-25T03:17:17.000", "2018-03-25 03:17:17");
        TestTimestampCoercer.testVarcharToLongTimestamp("1986-01-01T00:13:07.000", "1986-01-01 00:13:07");
        TestTimestampCoercer.testVarcharToLongTimestamp("1969-12-31T23:59:59.123456", "1969-12-31 23:59:59.123456");
    }

    private static void testVarcharToLongTimestamp(String timestampValue, String hiveTimestampValue) {
        LocalDateTime localDateTime = LocalDateTime.parse(timestampValue);
        SqlTimestamp timestamp = SqlTimestamp.fromSeconds((int)TimestampType.TIMESTAMP_PICOS.getPrecision(), (long)localDateTime.toEpochSecond(ZoneOffset.UTC), (long)localDateTime.get(ChronoField.NANO_OF_SECOND));
        TestTimestampCoercer.assertVarcharToLongTimestampCoercions((Type)VarcharType.createUnboundedVarcharType(), Slices.utf8Slice((String)hiveTimestampValue), (Type)TimestampType.TIMESTAMP_PICOS, new LongTimestamp(timestamp.getEpochMicros(), timestamp.getPicosOfMicros()));
    }

    @Test
    public void testTimestampToSmallerVarchar() {
        LocalDateTime localDateTime = LocalDateTime.parse("2023-04-11T05:16:12.345678876");
        SqlTimestamp timestamp = SqlTimestamp.fromSeconds((int)TimestampType.TIMESTAMP_PICOS.getPrecision(), (long)localDateTime.toEpochSecond(ZoneOffset.UTC), (long)localDateTime.get(ChronoField.NANO_OF_SECOND));
        LongTimestamp longTimestamp = new LongTimestamp(timestamp.getEpochMicros(), timestamp.getPicosOfMicros());
        TestTimestampCoercer.assertLongTimestampToVarcharCoercions(TimestampType.TIMESTAMP_PICOS, longTimestamp, VarcharType.createVarcharType((int)1), "2");
        TestTimestampCoercer.assertLongTimestampToVarcharCoercions(TimestampType.TIMESTAMP_PICOS, longTimestamp, VarcharType.createVarcharType((int)2), "20");
        TestTimestampCoercer.assertLongTimestampToVarcharCoercions(TimestampType.TIMESTAMP_PICOS, longTimestamp, VarcharType.createVarcharType((int)3), "202");
        TestTimestampCoercer.assertLongTimestampToVarcharCoercions(TimestampType.TIMESTAMP_PICOS, longTimestamp, VarcharType.createVarcharType((int)4), "2023");
        TestTimestampCoercer.assertLongTimestampToVarcharCoercions(TimestampType.TIMESTAMP_PICOS, longTimestamp, VarcharType.createVarcharType((int)5), "2023-");
        TestTimestampCoercer.assertLongTimestampToVarcharCoercions(TimestampType.TIMESTAMP_PICOS, longTimestamp, VarcharType.createVarcharType((int)6), "2023-0");
        TestTimestampCoercer.assertLongTimestampToVarcharCoercions(TimestampType.TIMESTAMP_PICOS, longTimestamp, VarcharType.createVarcharType((int)7), "2023-04");
        TestTimestampCoercer.assertLongTimestampToVarcharCoercions(TimestampType.TIMESTAMP_PICOS, longTimestamp, VarcharType.createVarcharType((int)8), "2023-04-");
        TestTimestampCoercer.assertLongTimestampToVarcharCoercions(TimestampType.TIMESTAMP_PICOS, longTimestamp, VarcharType.createVarcharType((int)9), "2023-04-1");
        TestTimestampCoercer.assertLongTimestampToVarcharCoercions(TimestampType.TIMESTAMP_PICOS, longTimestamp, VarcharType.createVarcharType((int)10), "2023-04-11");
        TestTimestampCoercer.assertLongTimestampToVarcharCoercions(TimestampType.TIMESTAMP_PICOS, longTimestamp, VarcharType.createVarcharType((int)11), "2023-04-11 ");
        TestTimestampCoercer.assertLongTimestampToVarcharCoercions(TimestampType.TIMESTAMP_PICOS, longTimestamp, VarcharType.createVarcharType((int)12), "2023-04-11 0");
        TestTimestampCoercer.assertLongTimestampToVarcharCoercions(TimestampType.TIMESTAMP_PICOS, longTimestamp, VarcharType.createVarcharType((int)13), "2023-04-11 05");
        TestTimestampCoercer.assertLongTimestampToVarcharCoercions(TimestampType.TIMESTAMP_PICOS, longTimestamp, VarcharType.createVarcharType((int)14), "2023-04-11 05:");
        TestTimestampCoercer.assertLongTimestampToVarcharCoercions(TimestampType.TIMESTAMP_PICOS, longTimestamp, VarcharType.createVarcharType((int)15), "2023-04-11 05:1");
        TestTimestampCoercer.assertLongTimestampToVarcharCoercions(TimestampType.TIMESTAMP_PICOS, longTimestamp, VarcharType.createVarcharType((int)16), "2023-04-11 05:16");
        TestTimestampCoercer.assertLongTimestampToVarcharCoercions(TimestampType.TIMESTAMP_PICOS, longTimestamp, VarcharType.createVarcharType((int)17), "2023-04-11 05:16:");
        TestTimestampCoercer.assertLongTimestampToVarcharCoercions(TimestampType.TIMESTAMP_PICOS, longTimestamp, VarcharType.createVarcharType((int)18), "2023-04-11 05:16:1");
        TestTimestampCoercer.assertLongTimestampToVarcharCoercions(TimestampType.TIMESTAMP_PICOS, longTimestamp, VarcharType.createVarcharType((int)19), "2023-04-11 05:16:12");
        TestTimestampCoercer.assertLongTimestampToVarcharCoercions(TimestampType.TIMESTAMP_PICOS, longTimestamp, VarcharType.createVarcharType((int)20), "2023-04-11 05:16:12.");
        TestTimestampCoercer.assertLongTimestampToVarcharCoercions(TimestampType.TIMESTAMP_PICOS, longTimestamp, VarcharType.createVarcharType((int)21), "2023-04-11 05:16:12.3");
        TestTimestampCoercer.assertLongTimestampToVarcharCoercions(TimestampType.TIMESTAMP_PICOS, longTimestamp, VarcharType.createVarcharType((int)22), "2023-04-11 05:16:12.34");
        TestTimestampCoercer.assertLongTimestampToVarcharCoercions(TimestampType.TIMESTAMP_PICOS, longTimestamp, VarcharType.createVarcharType((int)23), "2023-04-11 05:16:12.345");
        TestTimestampCoercer.assertLongTimestampToVarcharCoercions(TimestampType.TIMESTAMP_PICOS, longTimestamp, VarcharType.createVarcharType((int)24), "2023-04-11 05:16:12.3456");
        TestTimestampCoercer.assertLongTimestampToVarcharCoercions(TimestampType.TIMESTAMP_PICOS, longTimestamp, VarcharType.createVarcharType((int)25), "2023-04-11 05:16:12.34567");
        TestTimestampCoercer.assertLongTimestampToVarcharCoercions(TimestampType.TIMESTAMP_PICOS, longTimestamp, VarcharType.createVarcharType((int)26), "2023-04-11 05:16:12.345678");
        TestTimestampCoercer.assertLongTimestampToVarcharCoercions(TimestampType.TIMESTAMP_PICOS, longTimestamp, VarcharType.createVarcharType((int)27), "2023-04-11 05:16:12.3456788");
        TestTimestampCoercer.assertLongTimestampToVarcharCoercions(TimestampType.TIMESTAMP_PICOS, longTimestamp, VarcharType.createVarcharType((int)28), "2023-04-11 05:16:12.34567887");
        TestTimestampCoercer.assertLongTimestampToVarcharCoercions(TimestampType.TIMESTAMP_PICOS, longTimestamp, VarcharType.createVarcharType((int)29), "2023-04-11 05:16:12.345678876");
    }

    @Test
    public void testHistoricalLongTimestampToVarchar() {
        LocalDateTime localDateTime = LocalDateTime.parse("1899-12-31T23:59:59.999999999");
        SqlTimestamp timestamp = SqlTimestamp.fromSeconds((int)TimestampType.TIMESTAMP_PICOS.getPrecision(), (long)localDateTime.toEpochSecond(ZoneOffset.UTC), (long)localDateTime.get(ChronoField.NANO_OF_SECOND));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TestTimestampCoercer.assertLongTimestampToVarcharCoercions(TimestampType.TIMESTAMP_PICOS, new LongTimestamp(timestamp.getEpochMicros(), timestamp.getPicosOfMicros()), VarcharType.createUnboundedVarcharType(), "1899-12-31 23:59:59.999999999")).isInstanceOf(TrinoException.class)).hasMessageContaining("Coercion on historical dates is not supported");
    }

    @Test
    public void testInvalidVarcharToShortTimestamp() {
        TestTimestampCoercer.testInvalidVarcharToShortTimestamp("Invalid timestamp");
        TestTimestampCoercer.testInvalidVarcharToShortTimestamp("2022");
        TestTimestampCoercer.testInvalidVarcharToShortTimestamp("2001-04-01T00:13:42.000");
        TestTimestampCoercer.testInvalidVarcharToShortTimestamp("2001-14-01 00:13:42.000");
        TestTimestampCoercer.testInvalidVarcharToShortTimestamp("2001-01-32 00:13:42.000");
        TestTimestampCoercer.testInvalidVarcharToShortTimestamp("2001-04-01 23:59:60.000");
        TestTimestampCoercer.testInvalidVarcharToShortTimestamp("2001-04-01 23:60:01.000");
        TestTimestampCoercer.testInvalidVarcharToShortTimestamp("2001-04-01 27:01:01.000");
    }

    private static void testInvalidVarcharToShortTimestamp(String invalidValue) {
        TestTimestampCoercer.assertVarcharToShortTimestampCoercions((Type)VarcharType.createUnboundedVarcharType(), Slices.utf8Slice((String)invalidValue), (Type)TimestampType.TIMESTAMP_MICROS, null);
    }

    @Test
    public void testInvalidVarcharLongTimestamp() {
        TestTimestampCoercer.testInvalidVarcharLongTimestamp("Invalid timestamp");
        TestTimestampCoercer.testInvalidVarcharLongTimestamp("2022");
        TestTimestampCoercer.testInvalidVarcharLongTimestamp("2001-04-01T00:13:42.000");
        TestTimestampCoercer.testInvalidVarcharLongTimestamp("2001-14-01 00:13:42.000");
        TestTimestampCoercer.testInvalidVarcharLongTimestamp("2001-01-32 00:13:42.000");
        TestTimestampCoercer.testInvalidVarcharLongTimestamp("2001-04-01 23:59:60.000");
        TestTimestampCoercer.testInvalidVarcharLongTimestamp("2001-04-01 23:60:01.000");
        TestTimestampCoercer.testInvalidVarcharLongTimestamp("2001-04-01 27:01:01.000");
    }

    private static void testInvalidVarcharLongTimestamp(String invalidValue) {
        TestTimestampCoercer.assertVarcharToLongTimestampCoercions((Type)VarcharType.createUnboundedVarcharType(), Slices.utf8Slice((String)invalidValue), (Type)TimestampType.TIMESTAMP_MICROS, null);
    }

    @Test
    public void testHistoricalVarcharToShortTimestamp() {
        LocalDateTime localDateTime = LocalDateTime.parse("1899-12-31T23:59:59.999999");
        SqlTimestamp timestamp = SqlTimestamp.fromSeconds((int)TimestampType.TIMESTAMP_MICROS.getPrecision(), (long)localDateTime.toEpochSecond(ZoneOffset.UTC), (long)localDateTime.get(ChronoField.NANO_OF_SECOND));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TestTimestampCoercer.assertVarcharToShortTimestampCoercions((Type)VarcharType.createUnboundedVarcharType(), Slices.utf8Slice((String)"1899-12-31 23:59:59.999999"), (Type)TimestampType.TIMESTAMP_MICROS, timestamp.getEpochMicros())).isInstanceOf(TrinoException.class)).hasMessageContaining("Coercion on historical dates is not supported");
    }

    @Test
    public void testHistoricalVarcharToLongTimestamp() {
        LocalDateTime localDateTime = LocalDateTime.parse("1899-12-31T23:59:59.999999");
        SqlTimestamp timestamp = SqlTimestamp.fromSeconds((int)TimestampType.TIMESTAMP_PICOS.getPrecision(), (long)localDateTime.toEpochSecond(ZoneOffset.UTC), (long)localDateTime.get(ChronoField.NANO_OF_SECOND));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TestTimestampCoercer.assertVarcharToShortTimestampCoercions((Type)VarcharType.createUnboundedVarcharType(), Slices.utf8Slice((String)"1899-12-31 23:59:59.999999"), (Type)TimestampType.TIMESTAMP_PICOS, timestamp.getEpochMicros())).isInstanceOf(TrinoException.class)).hasMessageContaining("Coercion on historical dates is not supported");
    }

    public static void assertLongTimestampToVarcharCoercions(TimestampType fromType, LongTimestamp valueToBeCoerced, VarcharType toType, String expectedValue) {
        TestTimestampCoercer.assertCoercions((Type)fromType, valueToBeCoerced, (Type)toType, Slices.utf8Slice((String)expectedValue), HiveTimestampPrecision.NANOSECONDS);
    }

    public static void assertVarcharToShortTimestampCoercions(Type fromType, Object valueToBeCoerced, Type toType, Object expectedValue) {
        TestTimestampCoercer.assertCoercions(fromType, valueToBeCoerced, toType, expectedValue, HiveTimestampPrecision.MICROSECONDS);
    }

    public static void assertVarcharToLongTimestampCoercions(Type fromType, Object valueToBeCoerced, Type toType, Object expectedValue) {
        TestTimestampCoercer.assertCoercions(fromType, valueToBeCoerced, toType, expectedValue, HiveTimestampPrecision.NANOSECONDS);
    }

    public static void assertCoercions(Type fromType, Object valueToBeCoerced, Type toType, Object expectedValue, HiveTimestampPrecision timestampPrecision) {
        Block coercedValue = ((TypeCoercer)CoercionUtils.createCoercer((TypeManager)InternalTypeManager.TESTING_TYPE_MANAGER, (HiveType)HiveTypeTranslator.toHiveType((Type)fromType), (HiveType)HiveTypeTranslator.toHiveType((Type)toType), (CoercionUtils.CoercionContext)new CoercionUtils.CoercionContext(timestampPrecision, HiveStorageFormat.PARQUET)).orElseThrow()).apply(Utils.nativeValueToBlock((Type)fromType, (Object)valueToBeCoerced));
        Assertions.assertThat((Object)Utils.blockToNativeValue((Type)toType, (Block)coercedValue)).isEqualTo(expectedValue);
    }

    private static void assertTimestampToDateCoercion(String timestampAsString, String expectedDate) {
        LocalDateTime localDateTime = LocalDateTime.parse(timestampAsString);
        SqlTimestamp timestamp = SqlTimestamp.fromSeconds((int)TimestampType.TIMESTAMP_PICOS.getPrecision(), (long)localDateTime.toEpochSecond(ZoneOffset.UTC), (long)localDateTime.get(ChronoField.NANO_OF_SECOND));
        TestTimestampCoercer.assertCoercions((Type)TimestampType.TIMESTAMP_PICOS, new LongTimestamp(timestamp.getEpochMicros(), timestamp.getPicosOfMicros()), (Type)DateType.DATE, LocalDate.parse(expectedDate).toEpochDay(), HiveTimestampPrecision.NANOSECONDS);
    }
}

