/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.coercions;

import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.metastore.HiveType;
import io.trino.plugin.hive.HiveStorageFormat;
import io.trino.plugin.hive.HiveTimestampPrecision;
import io.trino.plugin.hive.coercions.CoercionUtils;
import io.trino.plugin.hive.coercions.TypeCoercer;
import io.trino.plugin.hive.util.HiveTypeTranslator;
import io.trino.spi.block.Block;
import io.trino.spi.predicate.Utils;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeManager;
import io.trino.spi.type.VarbinaryType;
import io.trino.spi.type.VarcharType;
import io.trino.type.InternalTypeManager;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestVarbinaryToVarcharCoercer {
    private static final byte CONTINUATION_BYTE = -65;
    private static final byte START_4_BYTE = -9;
    private static final byte X_CHAR = 88;

    @Test
    public void testVarbinaryToVarcharCoercion() {
        TestVarbinaryToVarcharCoercer.assertVarbinaryToVarcharCoercionForParquet(Slices.utf8Slice((String)"abc"), (Type)VarbinaryType.VARBINARY, "abc", (Type)VarcharType.VARCHAR);
        TestVarbinaryToVarcharCoercer.assertVarbinaryToVarcharCoercionForParquet(Slices.utf8Slice((String)"abc"), (Type)VarbinaryType.VARBINARY, "ab", (Type)VarcharType.createVarcharType((int)2));
        TestVarbinaryToVarcharCoercer.assertVarbinaryToVarcharCoercionForParquet(Slices.wrappedBuffer((byte[])new byte[]{88, -65}), (Type)VarbinaryType.VARBINARY, "X\ufffd", (Type)VarcharType.VARCHAR);
        TestVarbinaryToVarcharCoercer.assertVarbinaryToVarcharCoercionForParquet(Slices.wrappedBuffer((byte[])new byte[]{88, -9, -65, -65, -65}), (Type)VarbinaryType.VARBINARY, "X\ufffd\ufffd\ufffd\ufffd", (Type)VarcharType.VARCHAR);
        TestVarbinaryToVarcharCoercer.assertVarbinaryToVarcharCoercionForParquet(Slices.wrappedBuffer((byte[])new byte[]{88, -9, -65, -65, -65, 88}), (Type)VarbinaryType.VARBINARY, "X\ufffd\ufffd\ufffd\ufffdX", (Type)VarcharType.VARCHAR);
        TestVarbinaryToVarcharCoercer.assertVarbinaryToVarcharCoercionForParquet(Slices.wrappedBuffer((byte[])new byte[]{88, -19, -96, -128}), (Type)VarbinaryType.VARBINARY, "X\ufffd", (Type)VarcharType.VARCHAR);
        TestVarbinaryToVarcharCoercer.assertVarbinaryToVarcharCoercionForParquet(Slices.wrappedBuffer((byte[])new byte[]{88, -19, -65, -65}), (Type)VarbinaryType.VARBINARY, "X\ufffd", (Type)VarcharType.VARCHAR);
    }

    @Test
    public void testVarbinaryToVarcharCoercionForOrc() {
        TestVarbinaryToVarcharCoercer.assertVarbinaryToVarcharCoercionForOrc(Slices.utf8Slice((String)"abc"), (Type)VarbinaryType.VARBINARY, "61 62 63", (Type)VarcharType.VARCHAR);
        TestVarbinaryToVarcharCoercer.assertVarbinaryToVarcharCoercionForOrc(Slices.utf8Slice((String)"abc"), (Type)VarbinaryType.VARBINARY, "61", (Type)VarcharType.createVarcharType((int)2));
        TestVarbinaryToVarcharCoercer.assertVarbinaryToVarcharCoercionForOrc(Slices.wrappedBuffer((byte[])new byte[]{88, -65}), (Type)VarbinaryType.VARBINARY, "58 bf", (Type)VarcharType.VARCHAR);
        TestVarbinaryToVarcharCoercer.assertVarbinaryToVarcharCoercionForOrc(Slices.wrappedBuffer((byte[])new byte[]{88, -9, -65, -65, -65}), (Type)VarbinaryType.VARBINARY, "58 f7 bf bf bf", (Type)VarcharType.VARCHAR);
        TestVarbinaryToVarcharCoercer.assertVarbinaryToVarcharCoercionForOrc(Slices.wrappedBuffer((byte[])new byte[]{88, -9, -65, -65, -65, 88}), (Type)VarbinaryType.VARBINARY, "58 f7 bf bf bf 58", (Type)VarcharType.VARCHAR);
        TestVarbinaryToVarcharCoercer.assertVarbinaryToVarcharCoercionForOrc(Slices.wrappedBuffer((byte[])new byte[]{88, -19, -96, -128}), (Type)VarbinaryType.VARBINARY, "58 ed a0 80", (Type)VarcharType.VARCHAR);
        TestVarbinaryToVarcharCoercer.assertVarbinaryToVarcharCoercionForOrc(Slices.wrappedBuffer((byte[])new byte[]{88, -19, -65, -65}), (Type)VarbinaryType.VARBINARY, "58 ed bf bf", (Type)VarcharType.VARCHAR);
    }

    private static void assertVarbinaryToVarcharCoercionForOrc(Slice actualValue, Type fromType, String expectedValue, Type toType) {
        TestVarbinaryToVarcharCoercer.assertVarbinaryToVarcharCoercion(actualValue, fromType, Slices.utf8Slice((String)expectedValue), toType, HiveStorageFormat.ORC);
    }

    private static void assertVarbinaryToVarcharCoercionForParquet(Slice actualValue, Type fromType, String expectedValue, Type toType) {
        TestVarbinaryToVarcharCoercer.assertVarbinaryToVarcharCoercion(actualValue, fromType, Slices.utf8Slice((String)expectedValue), toType, HiveStorageFormat.PARQUET);
    }

    private static void assertVarbinaryToVarcharCoercion(Slice actualValue, Type fromType, Slice expectedValue, Type toType, HiveStorageFormat storageFormat) {
        Block coercedBlock = ((TypeCoercer)CoercionUtils.createCoercer((TypeManager)InternalTypeManager.TESTING_TYPE_MANAGER, (HiveType)HiveTypeTranslator.toHiveType((Type)fromType), (HiveType)HiveTypeTranslator.toHiveType((Type)toType), (CoercionUtils.CoercionContext)new CoercionUtils.CoercionContext(HiveTimestampPrecision.DEFAULT_PRECISION, storageFormat)).orElseThrow()).apply(Utils.nativeValueToBlock((Type)fromType, (Object)actualValue));
        Assertions.assertThat((Object)Utils.blockToNativeValue((Type)toType, (Block)coercedBlock)).isEqualTo((Object)expectedValue);
    }
}

