/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.coercions;

import io.airlift.slice.Slices;
import io.trino.metastore.HiveType;
import io.trino.plugin.hive.HiveStorageFormat;
import io.trino.plugin.hive.HiveTimestampPrecision;
import io.trino.plugin.hive.coercions.CoercionUtils;
import io.trino.plugin.hive.coercions.TypeCoercer;
import io.trino.plugin.hive.util.HiveTypeTranslator;
import io.trino.spi.block.Block;
import io.trino.spi.predicate.Utils;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeManager;
import io.trino.spi.type.VarcharType;
import io.trino.type.InternalTypeManager;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestVarcharToDoubleCoercer {
    @Test
    public void testDoubleToVarcharCoercions() {
        TestVarcharToDoubleCoercer.assertVarcharToDoubleCoercion("-1.7976931348623157e+310", Double.NEGATIVE_INFINITY);
        TestVarcharToDoubleCoercer.assertVarcharToDoubleCoercion("-Infinity", Double.NEGATIVE_INFINITY);
        TestVarcharToDoubleCoercer.assertVarcharToDoubleCoercion("1.12e+3", Double.parseDouble("1120.0"));
        TestVarcharToDoubleCoercer.assertVarcharToDoubleCoercion("123456789.12345678", Double.parseDouble("123456789.12345678"));
        TestVarcharToDoubleCoercer.assertVarcharToDoubleCoercion("123", Double.parseDouble("123"));
        TestVarcharToDoubleCoercer.assertVarcharToDoubleCoercion("Infinity", Double.POSITIVE_INFINITY);
        TestVarcharToDoubleCoercer.assertVarcharToDoubleCoercion("+Infinity", Double.POSITIVE_INFINITY);
        TestVarcharToDoubleCoercer.assertVarcharToDoubleCoercion("1.7976931348623157e+310", Double.POSITIVE_INFINITY);
        TestVarcharToDoubleCoercer.assertVarcharToDoubleCoercion("Hello", null);
    }

    @Test
    public void testNaNToVarcharCoercions() {
        TestVarcharToDoubleCoercer.assertVarcharToDoubleCoercion("NaN", HiveStorageFormat.ORC, null);
        TestVarcharToDoubleCoercer.assertVarcharToDoubleCoercion("NaN", HiveStorageFormat.PARQUET, Double.NaN);
    }

    private static void assertVarcharToDoubleCoercion(String actualValue, Double expectedValue) {
        TestVarcharToDoubleCoercer.assertVarcharToDoubleCoercion(actualValue, HiveStorageFormat.PARQUET, expectedValue);
    }

    private static void assertVarcharToDoubleCoercion(String actualValue, HiveStorageFormat storageFormat, Double expectedValue) {
        Block coercedBlock = ((TypeCoercer)CoercionUtils.createCoercer((TypeManager)InternalTypeManager.TESTING_TYPE_MANAGER, (HiveType)HiveTypeTranslator.toHiveType((Type)VarcharType.createUnboundedVarcharType()), (HiveType)HiveTypeTranslator.toHiveType((Type)DoubleType.DOUBLE), (CoercionUtils.CoercionContext)new CoercionUtils.CoercionContext(HiveTimestampPrecision.DEFAULT_PRECISION, storageFormat)).orElseThrow()).apply(Utils.nativeValueToBlock((Type)VarcharType.createUnboundedVarcharType(), (Object)Slices.utf8Slice((String)actualValue)));
        Assertions.assertThat((Object)Utils.blockToNativeValue((Type)DoubleType.DOUBLE, (Block)coercedBlock)).isEqualTo((Object)expectedValue);
    }
}

