/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.coercions;

import io.airlift.slice.Slices;
import io.trino.metastore.HiveType;
import io.trino.plugin.hive.HiveStorageFormat;
import io.trino.plugin.hive.HiveTimestampPrecision;
import io.trino.plugin.hive.coercions.CoercionUtils;
import io.trino.plugin.hive.coercions.TypeCoercer;
import io.trino.plugin.hive.util.HiveTypeTranslator;
import io.trino.spi.block.Block;
import io.trino.spi.predicate.Utils;
import io.trino.spi.type.RealType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeManager;
import io.trino.spi.type.VarcharType;
import io.trino.type.InternalTypeManager;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestVarcharToFloatCoercer {
    @Test
    public void testVarcharToFloatCoercions() {
        TestVarcharToFloatCoercer.assertVarcharToFloatCoercion("1.12e+3", Float.valueOf(Float.parseFloat("1120.0")));
        TestVarcharToFloatCoercer.assertVarcharToFloatCoercion("123456789.12345678", Float.valueOf(Float.parseFloat("123456789.12345678")));
        TestVarcharToFloatCoercer.assertVarcharToFloatCoercion("123", Float.valueOf(Float.parseFloat("123")));
        TestVarcharToFloatCoercer.assertVarcharToFloatCoercion("1.17549435E-38f", Float.valueOf(Float.MIN_NORMAL));
        TestVarcharToFloatCoercer.assertVarcharToFloatCoercion("3.4028235e+38f", Float.valueOf(Float.MAX_VALUE));
        TestVarcharToFloatCoercer.assertVarcharToFloatCoercion("-3.4028235e+38f", Float.valueOf(-3.4028235E38f));
        TestVarcharToFloatCoercer.assertVarcharToFloatCoercion("4.4028235e+39f", Float.valueOf(Float.POSITIVE_INFINITY));
        TestVarcharToFloatCoercer.assertVarcharToFloatCoercion("-3.4028235e+39f", Float.valueOf(Float.NEGATIVE_INFINITY));
        TestVarcharToFloatCoercer.assertVarcharToFloatCoercion("1.4e-45f", Float.valueOf(Float.MIN_VALUE));
        TestVarcharToFloatCoercer.assertVarcharToFloatCoercion("1.3e-46f", Float.valueOf(0.0f));
        TestVarcharToFloatCoercer.assertVarcharToFloatCoercion("-1.3e-46f", Float.valueOf(-0.0f));
        TestVarcharToFloatCoercer.assertVarcharToFloatCoercion("-Infinity", Float.valueOf(Float.NEGATIVE_INFINITY));
        TestVarcharToFloatCoercer.assertVarcharToFloatCoercion("Infinity", Float.valueOf(Float.POSITIVE_INFINITY));
        TestVarcharToFloatCoercer.assertVarcharToFloatCoercion("+Infinity", Float.valueOf(Float.POSITIVE_INFINITY));
        TestVarcharToFloatCoercer.assertVarcharToFloatCoercion("1.12e+3d", Float.valueOf(Float.parseFloat("1120.0")));
        TestVarcharToFloatCoercer.assertVarcharToFloatCoercion(Double.toString(Double.MAX_VALUE), Float.valueOf(Float.POSITIVE_INFINITY));
        TestVarcharToFloatCoercer.assertVarcharToFloatCoercion(Double.toString(Double.MIN_VALUE), Float.valueOf(0.0f));
        TestVarcharToFloatCoercer.assertVarcharToFloatCoercion("1.13e", null);
        TestVarcharToFloatCoercer.assertVarcharToFloatCoercion("Hello", null);
    }

    @Test
    public void testVarcharToFloatNaNCoercions() {
        TestVarcharToFloatCoercer.assertVarcharToFloatCoercion("NaN", HiveStorageFormat.ORC, null);
        TestVarcharToFloatCoercer.assertVarcharToFloatCoercion("NaN", HiveStorageFormat.PARQUET, Float.valueOf(Float.NaN));
    }

    private static void assertVarcharToFloatCoercion(String actualValue, Float expectedValue) {
        TestVarcharToFloatCoercer.assertVarcharToFloatCoercion(actualValue, HiveStorageFormat.PARQUET, expectedValue);
    }

    private static void assertVarcharToFloatCoercion(String actualValue, HiveStorageFormat storageFormat, Float expectedValue) {
        Block coercedBlock = ((TypeCoercer)CoercionUtils.createCoercer((TypeManager)InternalTypeManager.TESTING_TYPE_MANAGER, (HiveType)HiveTypeTranslator.toHiveType((Type)VarcharType.createUnboundedVarcharType()), (HiveType)HiveTypeTranslator.toHiveType((Type)RealType.REAL), (CoercionUtils.CoercionContext)new CoercionUtils.CoercionContext(HiveTimestampPrecision.DEFAULT_PRECISION, storageFormat)).orElseThrow()).apply(Utils.nativeValueToBlock((Type)VarcharType.createUnboundedVarcharType(), (Object)Slices.utf8Slice((String)actualValue)));
        Float coercedValue = coercedBlock.isNull(0) ? null : Float.valueOf(RealType.REAL.getFloat(coercedBlock, 0));
        Assertions.assertThat(coercedValue).isEqualTo(expectedValue);
    }
}

