/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.containers;

import com.google.common.collect.ImmutableMap;
import io.trino.plugin.hive.containers.HiveHadoop;
import io.trino.plugin.hive.containers.HiveMinioDataLake;
import io.trino.testing.containers.TestContainers;
import java.net.URI;
import java.util.Map;

public class Hive3MinioDataLake
extends HiveMinioDataLake {
    private final HiveHadoop hiveHadoop;

    public Hive3MinioDataLake(String bucketName) {
        this(bucketName, HiveHadoop.HIVE3_IMAGE);
    }

    public Hive3MinioDataLake(String bucketName, String hiveHadoopImage) {
        this(bucketName, (Map<String, String>)ImmutableMap.of((Object)"/etc/hadoop/conf/core-site.xml", (Object)TestContainers.getPathFromClassPathResource((String)"hive_minio_datalake/hive-core-site.xml")), hiveHadoopImage);
    }

    public Hive3MinioDataLake(String bucketName, Map<String, String> hiveHadoopFilesToMount, String hiveHadoopImage) {
        super(bucketName);
        HiveHadoop.Builder hiveHadoopBuilder = (HiveHadoop.Builder)((HiveHadoop.Builder)((HiveHadoop.Builder)HiveHadoop.builder().withImage(hiveHadoopImage)).withNetwork(this.network)).withFilesToMount(hiveHadoopFilesToMount);
        this.hiveHadoop = (HiveHadoop)((Object)this.closer.register((AutoCloseable)((Object)hiveHadoopBuilder.build())));
    }

    @Override
    public void start() {
        super.start();
        this.hiveHadoop.start();
        this.state = HiveMinioDataLake.State.STARTED;
    }

    @Override
    public String runOnHive(String sql) {
        return this.hiveHadoop.runOnHive(sql);
    }

    @Override
    public HiveHadoop getHiveHadoop() {
        return this.hiveHadoop;
    }

    @Override
    public URI getHiveMetastoreEndpoint() {
        return this.hiveHadoop.getHiveMetastoreEndpoint();
    }
}

