/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.containers;

import com.google.common.collect.ImmutableSet;
import com.google.common.net.HostAndPort;
import io.airlift.log.Logger;
import io.trino.plugin.hive.containers.Hive4Metastore;
import io.trino.testing.containers.BaseTestContainer;
import java.net.URI;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.testcontainers.containers.Network;

public class Hive4HiveServer
extends BaseTestContainer {
    public static final int HIVE_SERVER_PORT = 10000;
    private static final Logger log = Logger.get(Hive4HiveServer.class);
    private static final String HOST_NAME = "hiveserver2";

    public static Builder builder() {
        return new Builder();
    }

    private Hive4HiveServer(String image, String hostName, Set<Integer> ports, Map<String, String> filesToMount, Map<String, String> envVars, Optional<Network> network, int startupRetryLimit) {
        super(image, hostName, ports, filesToMount, envVars, network, startupRetryLimit);
    }

    public void start() {
        super.start();
        log.info("Hive container started with addresses for hive server: %s", new Object[]{this.getHiveServerEndpoint()});
    }

    public String runOnHive(String query) {
        return this.executeInContainerFailOnError(new String[]{"beeline", "-u", "jdbc:hive2://localhost:%s/default".formatted(10000), "-n", "hive", "-e", query});
    }

    public URI getHiveServerEndpoint() {
        HostAndPort address = this.getMappedHostAndPortForExposedPort(10000);
        return URI.create(address.getHost() + ":" + address.getPort());
    }

    public static class Builder
    extends BaseTestContainer.Builder<Builder, Hive4HiveServer> {
        private Builder() {
            this.image = Hive4Metastore.HIVE4_IMAGE;
            this.hostName = Hive4HiveServer.HOST_NAME;
            this.exposePorts = ImmutableSet.of((Object)10000);
        }

        public Hive4HiveServer build() {
            return new Hive4HiveServer(this.image, this.hostName, this.exposePorts, this.filesToMount, this.envVars, this.network, this.startupRetryLimit);
        }
    }
}

