/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.containers;

import com.google.common.collect.ImmutableSet;
import com.google.common.net.HostAndPort;
import io.airlift.log.Logger;
import io.trino.plugin.hive.containers.HiveHadoop;
import io.trino.testing.TestingProperties;
import io.trino.testing.containers.BaseTestContainer;
import java.net.URI;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.testcontainers.containers.Network;

public class Hive4Metastore
extends BaseTestContainer {
    public static final String HIVE4_IMAGE = "ghcr.io/trinodb/testing/hive4.0-hive:" + TestingProperties.getDockerImagesVersion();
    public static final int HIVE_METASTORE_PORT = 9083;
    private static final Logger log = Logger.get(HiveHadoop.class);
    private static final String HOST_NAME = "metastore";

    public static Builder builder() {
        return new Builder();
    }

    private Hive4Metastore(String image, String hostName, Set<Integer> ports, Map<String, String> filesToMount, Map<String, String> envVars, Optional<Network> network, int startupRetryLimit) {
        super(image, hostName, ports, filesToMount, envVars, network, startupRetryLimit);
    }

    public void start() {
        super.start();
        log.info("Hive container started with addresses for metastore: %s", new Object[]{this.getHiveMetastoreEndpoint()});
    }

    public URI getHiveMetastoreEndpoint() {
        HostAndPort address = this.getMappedHostAndPortForExposedPort(9083);
        return URI.create("thrift://" + address.getHost() + ":" + address.getPort());
    }

    public URI getInternalHiveMetastoreEndpoint() {
        return URI.create("thrift://metastore:9083");
    }

    public static class Builder
    extends BaseTestContainer.Builder<Builder, Hive4Metastore> {
        private Builder() {
            this.image = HIVE4_IMAGE;
            this.hostName = Hive4Metastore.HOST_NAME;
            this.exposePorts = ImmutableSet.of((Object)9083);
        }

        public Hive4Metastore build() {
            return new Hive4Metastore(this.image, this.hostName, this.exposePorts, this.filesToMount, this.envVars, this.network, this.startupRetryLimit);
        }
    }
}

