/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.containers;

import com.google.common.collect.ImmutableMap;
import io.trino.plugin.hive.containers.Hive4HiveServer;
import io.trino.plugin.hive.containers.Hive4Metastore;
import io.trino.plugin.hive.containers.HiveHadoop;
import io.trino.plugin.hive.containers.HiveMinioDataLake;
import io.trino.testing.containers.TestContainers;
import java.net.URI;
import java.util.Map;
import java.util.Set;

public class Hive4MinioDataLake
extends HiveMinioDataLake {
    private final Hive4HiveServer hiveServer;
    private final Hive4Metastore hiveMetastore;

    public Hive4MinioDataLake(String bucketName) {
        super(bucketName);
        String hiveImage = Hive4Metastore.HIVE4_IMAGE;
        ImmutableMap hiveFilesToMount = ImmutableMap.of((Object)"/opt/hive/conf/hive-site.xml", (Object)TestContainers.getPathFromClassPathResource((String)"hive_minio_datalake/hive4-hive-site.xml"));
        Hive4Metastore.Builder metastorebuilder = (Hive4Metastore.Builder)((Hive4Metastore.Builder)((Hive4Metastore.Builder)((Hive4Metastore.Builder)((Hive4Metastore.Builder)Hive4Metastore.builder().withImage(hiveImage)).withEnvVars(Map.of("SERVICE_NAME", "metastore"))).withNetwork(this.network)).withExposePorts(Set.of(Integer.valueOf(9083)))).withFilesToMount((Map)hiveFilesToMount);
        this.hiveMetastore = (Hive4Metastore)((Object)this.closer.register((AutoCloseable)((Object)metastorebuilder.build())));
        Hive4HiveServer.Builder hiveHadoopBuilder = (Hive4HiveServer.Builder)((Hive4HiveServer.Builder)((Hive4HiveServer.Builder)((Hive4HiveServer.Builder)((Hive4HiveServer.Builder)Hive4HiveServer.builder().withImage(hiveImage)).withEnvVars(Map.of("SERVICE_NAME", "hiveserver2", "HIVE_SERVER2_THRIFT_PORT", String.valueOf(10000), "SERVICE_OPTS", "-Xmx1G -Dhive.metastore.uris=%s".formatted(this.hiveMetastore.getInternalHiveMetastoreEndpoint()), "IS_RESUME", "true", "AWS_ACCESS_KEY_ID", "accesskey", "AWS_SECRET_KEY", "secretkey"))).withNetwork(this.network)).withExposePorts(Set.of(Integer.valueOf(10000)))).withFilesToMount((Map)hiveFilesToMount);
        this.hiveServer = (Hive4HiveServer)((Object)this.closer.register((AutoCloseable)((Object)hiveHadoopBuilder.build())));
    }

    @Override
    public void start() {
        super.start();
        this.hiveMetastore.start();
        this.hiveServer.start();
        this.state = HiveMinioDataLake.State.STARTED;
    }

    @Override
    public String runOnHive(String sql) {
        return this.hiveServer.runOnHive(sql);
    }

    @Override
    public HiveHadoop getHiveHadoop() {
        throw new UnsupportedOperationException();
    }

    @Override
    public URI getHiveMetastoreEndpoint() {
        return this.hiveMetastore.getHiveMetastoreEndpoint();
    }
}

