/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.containers;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import io.trino.plugin.base.util.AutoCloseableCloser;
import io.trino.plugin.hive.containers.HiveHadoop;
import io.trino.testing.containers.Minio;
import io.trino.testing.minio.MinioClient;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.testcontainers.containers.Network;

public abstract class HiveMinioDataLake
implements AutoCloseable {
    private static final String MINIO_DEFAULT_REGION = "us-east-1";
    private final String bucketName;
    private final Minio minio;
    private MinioClient minioClient;
    protected final AutoCloseableCloser closer = AutoCloseableCloser.create();
    protected final Network network;
    protected State state = State.INITIAL;

    public HiveMinioDataLake(String bucketName) {
        this.bucketName = Objects.requireNonNull(bucketName, "bucketName is null");
        this.network = (Network)this.closer.register((AutoCloseable)Network.newNetwork());
        this.minio = (Minio)this.closer.register((AutoCloseable)((Minio.Builder)((Minio.Builder)Minio.builder().withNetwork(this.network)).withEnvVars((Map)ImmutableMap.builder().put((Object)"MINIO_ACCESS_KEY", (Object)"accesskey").put((Object)"MINIO_SECRET_KEY", (Object)"secretkey").put((Object)"MINIO_REGION", (Object)MINIO_DEFAULT_REGION).buildOrThrow())).build());
    }

    public void start() {
        Preconditions.checkState((this.state == State.INITIAL ? 1 : 0) != 0, (String)"Already started: %s", (Object)((Object)this.state));
        this.state = State.STARTING;
        this.minio.start();
        this.minioClient = (MinioClient)this.closer.register((AutoCloseable)this.minio.createMinioClient());
        this.minio.createBucket(this.bucketName);
    }

    public void stop() throws Exception {
        this.closer.close();
        this.state = State.STOPPED;
    }

    public Network getNetwork() {
        return this.network;
    }

    public MinioClient getMinioClient() {
        Preconditions.checkState((this.state == State.STARTED ? 1 : 0) != 0, (String)"Can't provide client when MinIO state is: %s", (Object)((Object)this.state));
        return this.minioClient;
    }

    public void copyResources(String resourcePath, String target) {
        this.minio.copyResources(resourcePath, this.bucketName, target);
    }

    public void writeFile(byte[] contents, String target) {
        this.minio.writeFile(contents, this.bucketName, target);
    }

    public List<String> listFiles(String targetDirectory) {
        return this.getMinioClient().listObjects(this.getBucketName(), targetDirectory);
    }

    public Minio getMinio() {
        return this.minio;
    }

    public abstract String runOnHive(String var1);

    public abstract HiveHadoop getHiveHadoop();

    public abstract URI getHiveMetastoreEndpoint();

    public String getBucketName() {
        return this.bucketName;
    }

    @Override
    public void close() throws Exception {
        this.stop();
    }

    protected static enum State {
        INITIAL,
        STARTING,
        STARTED,
        STOPPED;

    }
}

