/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.fs;

import com.google.common.collect.ImmutableList;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.trino.filesystem.Location;
import io.trino.metastore.HiveMetastore;
import io.trino.metastore.HiveMetastoreFactory;
import io.trino.metastore.PrincipalPrivileges;
import io.trino.metastore.Table;
import io.trino.plugin.hive.HiveQueryRunner;
import io.trino.plugin.hive.TestingHiveUtils;
import io.trino.plugin.hive.fs.CachingDirectoryLister;
import io.trino.spi.connector.SchemaTableName;
import io.trino.testing.AbstractTestQueryFramework;
import io.trino.testing.DistributedQueryRunner;
import io.trino.testing.MaterializedRow;
import io.trino.testing.QueryRunner;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public abstract class BaseCachingDirectoryListerTest
extends AbstractTestQueryFramework {
    private CachingDirectoryLister directoryLister;
    private HiveMetastore metastore;

    protected QueryRunner createQueryRunner(Map<String, String> properties) throws Exception {
        DistributedQueryRunner queryRunner = HiveQueryRunner.builder().setHiveProperties(properties).build();
        this.directoryLister = TestingHiveUtils.getConnectorService((QueryRunner)queryRunner, CachingDirectoryLister.class);
        this.metastore = TestingHiveUtils.getConnectorService((QueryRunner)queryRunner, HiveMetastoreFactory.class).createMetastore(Optional.empty());
        return queryRunner;
    }

    @Test
    public void testCacheInvalidationIsAppliedSpecificallyOnTheNonPartitionedTableBeingChanged() {
        this.assertUpdate("CREATE TABLE partial_cache_invalidation_table1 (col1 int) WITH (format = 'ORC')");
        this.assertUpdate("INSERT INTO partial_cache_invalidation_table1 VALUES (1), (2), (3)", 3L);
        this.assertQuery("SELECT sum(col1) FROM partial_cache_invalidation_table1", "VALUES (6)");
        String cachedTable1Location = this.getTableLocation("tpch", "partial_cache_invalidation_table1");
        Assertions.assertThat((boolean)this.isCached(cachedTable1Location, SchemaTableName.schemaTableName((String)"tpch", (String)"partial_cache_invalidation_table1"))).isTrue();
        this.assertUpdate("CREATE TABLE partial_cache_invalidation_table2 (col1 int) WITH (format = 'ORC')");
        this.assertUpdate("INSERT INTO partial_cache_invalidation_table2 VALUES (11), (12)", 2L);
        this.assertQuery("SELECT sum(col1) FROM partial_cache_invalidation_table2", "VALUES (23)");
        String cachedTable2Location = this.getTableLocation("tpch", "partial_cache_invalidation_table2");
        Assertions.assertThat((boolean)this.isCached(cachedTable2Location, SchemaTableName.schemaTableName((String)"tpch", (String)"partial_cache_invalidation_table2"))).isTrue();
        this.assertUpdate("INSERT INTO partial_cache_invalidation_table1 VALUES (4), (5)", 2L);
        Assertions.assertThat((boolean)this.isCached(cachedTable1Location, SchemaTableName.schemaTableName((String)"tpch", (String)"partial_cache_invalidation_table1"))).isFalse();
        Assertions.assertThat((boolean)this.isCached(cachedTable2Location, SchemaTableName.schemaTableName((String)"tpch", (String)"partial_cache_invalidation_table2"))).isTrue();
        this.assertQuery("SELECT sum(col1) FROM partial_cache_invalidation_table1", "VALUES (15)");
        this.assertQuery("SELECT sum(col1) FROM partial_cache_invalidation_table2", "VALUES (23)");
        this.assertUpdate("DROP TABLE partial_cache_invalidation_table1");
        this.assertUpdate("DROP TABLE partial_cache_invalidation_table2");
    }

    @Test
    public void testCacheInvalidationIsAppliedOnTheEntireCacheOnPartitionedTableDrop() {
        this.assertUpdate("CREATE TABLE full_cache_invalidation_non_partitioned_table (col1 int) WITH (format = 'ORC')");
        this.assertUpdate("INSERT INTO full_cache_invalidation_non_partitioned_table VALUES (1), (2), (3)", 3L);
        this.assertQuery("SELECT sum(col1) FROM full_cache_invalidation_non_partitioned_table", "VALUES (6)");
        String nonPartitionedTableLocation = this.getTableLocation("tpch", "full_cache_invalidation_non_partitioned_table");
        Assertions.assertThat((boolean)this.isCached(nonPartitionedTableLocation, SchemaTableName.schemaTableName((String)"tpch", (String)"full_cache_invalidation_non_partitioned_table"))).isTrue();
        this.assertUpdate("CREATE TABLE full_cache_invalidation_partitioned_table (col1 int, col2 varchar) WITH (format = 'ORC', partitioned_by = ARRAY['col2'])");
        this.assertUpdate("INSERT INTO full_cache_invalidation_partitioned_table VALUES (1, 'group1'), (2, 'group1'), (3, 'group2'), (4, 'group2')", 4L);
        this.assertQuery("SELECT col2, sum(col1) FROM full_cache_invalidation_partitioned_table GROUP BY col2", "VALUES ('group1', 3), ('group2', 7)");
        String partitionedTableGroup1PartitionLocation = this.getPartitionLocation("tpch", "full_cache_invalidation_partitioned_table", (List<String>)ImmutableList.of((Object)"group1"));
        String partitionedTableGroup2PartitionLocation = this.getPartitionLocation("tpch", "full_cache_invalidation_partitioned_table", (List<String>)ImmutableList.of((Object)"group2"));
        Assertions.assertThat((boolean)this.isCached(partitionedTableGroup1PartitionLocation, SchemaTableName.schemaTableName((String)"tpch", (String)"full_cache_invalidation_partitioned_table"))).isTrue();
        Assertions.assertThat((boolean)this.isCached(partitionedTableGroup2PartitionLocation, SchemaTableName.schemaTableName((String)"tpch", (String)"full_cache_invalidation_partitioned_table"))).isTrue();
        this.assertUpdate("INSERT INTO full_cache_invalidation_non_partitioned_table VALUES (4), (5)", 2L);
        Assertions.assertThat((boolean)this.isCached(nonPartitionedTableLocation, SchemaTableName.schemaTableName((String)"tpch", (String)"full_cache_invalidation_non_partitioned_table"))).isFalse();
        Assertions.assertThat((boolean)this.isCached(partitionedTableGroup1PartitionLocation, SchemaTableName.schemaTableName((String)"tpch", (String)"full_cache_invalidation_partitioned_table"))).isTrue();
        Assertions.assertThat((boolean)this.isCached(partitionedTableGroup2PartitionLocation, SchemaTableName.schemaTableName((String)"tpch", (String)"full_cache_invalidation_partitioned_table"))).isTrue();
        this.assertUpdate("DROP TABLE full_cache_invalidation_partitioned_table");
        Assertions.assertThat((boolean)this.isCached(nonPartitionedTableLocation, SchemaTableName.schemaTableName((String)"tpch", (String)"full_cache_invalidation_non_partitioned_table"))).isFalse();
        Assertions.assertThat((boolean)this.isCached(partitionedTableGroup1PartitionLocation, SchemaTableName.schemaTableName((String)"tpch", (String)"full_cache_invalidation_partitioned_table"))).isFalse();
        Assertions.assertThat((boolean)this.isCached(partitionedTableGroup2PartitionLocation, SchemaTableName.schemaTableName((String)"tpch", (String)"full_cache_invalidation_partitioned_table"))).isFalse();
        this.assertQuery("SELECT sum(col1) FROM full_cache_invalidation_non_partitioned_table", "VALUES (15)");
        this.assertUpdate("DROP TABLE full_cache_invalidation_non_partitioned_table");
    }

    @Test
    public void testCacheInvalidationIsAppliedSpecificallyOnPartitionDropped() {
        this.assertUpdate("CREATE TABLE partition_path_cache_invalidation_non_partitioned_table (col1 int) WITH (format = 'ORC')");
        this.assertUpdate("INSERT INTO partition_path_cache_invalidation_non_partitioned_table VALUES (1), (2), (3)", 3L);
        this.assertQuery("SELECT sum(col1) FROM partition_path_cache_invalidation_non_partitioned_table", "VALUES (6)");
        String nonPartitionedTableLocation = this.getTableLocation("tpch", "partition_path_cache_invalidation_non_partitioned_table");
        Assertions.assertThat((boolean)this.isCached(nonPartitionedTableLocation, SchemaTableName.schemaTableName((String)"tpch", (String)"partition_path_cache_invalidation_non_partitioned_table"))).isTrue();
        this.assertUpdate("CREATE TABLE partition_path_cache_invalidation_partitioned_table (col1 int, col2 varchar) WITH (format = 'ORC', partitioned_by = ARRAY['col2'])");
        this.assertUpdate("INSERT INTO partition_path_cache_invalidation_partitioned_table VALUES (1, 'group1'), (2, 'group1'), (3, 'group2'), (4, 'group2')", 4L);
        this.assertQuery("SELECT col2, sum(col1) FROM partition_path_cache_invalidation_partitioned_table GROUP BY col2", "VALUES ('group1', 3), ('group2', 7)");
        String partitionedTableGroup1PartitionLocation = this.getPartitionLocation("tpch", "partition_path_cache_invalidation_partitioned_table", (List<String>)ImmutableList.of((Object)"group1"));
        String partitionedTableGroup2PartitionLocation = this.getPartitionLocation("tpch", "partition_path_cache_invalidation_partitioned_table", (List<String>)ImmutableList.of((Object)"group2"));
        Assertions.assertThat((boolean)this.isCached(partitionedTableGroup1PartitionLocation, SchemaTableName.schemaTableName((String)"tpch", (String)"partition_path_cache_invalidation_partitioned_table"))).isTrue();
        Assertions.assertThat((boolean)this.isCached(partitionedTableGroup2PartitionLocation, SchemaTableName.schemaTableName((String)"tpch", (String)"partition_path_cache_invalidation_partitioned_table"))).isTrue();
        this.assertUpdate("DELETE FROM partition_path_cache_invalidation_partitioned_table WHERE col2='group1'");
        Assertions.assertThat((boolean)this.isCached(nonPartitionedTableLocation, SchemaTableName.schemaTableName((String)"tpch", (String)"partition_path_cache_invalidation_non_partitioned_table"))).isTrue();
        Assertions.assertThat((boolean)this.isCached(partitionedTableGroup1PartitionLocation, SchemaTableName.schemaTableName((String)"tpch", (String)"partition_path_cache_invalidation_partitioned_table"))).isFalse();
        Assertions.assertThat((boolean)this.isCached(partitionedTableGroup2PartitionLocation, SchemaTableName.schemaTableName((String)"tpch", (String)"partition_path_cache_invalidation_partitioned_table"))).isTrue();
        this.assertQuery("SELECT sum(col1) FROM partition_path_cache_invalidation_non_partitioned_table", "VALUES (6)");
        this.assertQuery("SELECT col2, sum(col1) FROM partition_path_cache_invalidation_partitioned_table GROUP BY col2", "VALUES ('group2', 7)");
        this.assertUpdate("DROP TABLE partition_path_cache_invalidation_non_partitioned_table");
        this.assertUpdate("DROP TABLE partition_path_cache_invalidation_partitioned_table");
    }

    @Test
    public void testInsertIntoNonPartitionedTable() {
        this.assertUpdate("CREATE TABLE insert_into_non_partitioned_table (col1 int) WITH (format = 'ORC')");
        this.assertUpdate("INSERT INTO insert_into_non_partitioned_table VALUES (1), (2), (3)", 3L);
        this.assertQuery("SELECT sum(col1) FROM insert_into_non_partitioned_table", "VALUES (6)");
        Assertions.assertThat((boolean)this.isCached(this.getTableLocation("tpch", "insert_into_non_partitioned_table"), SchemaTableName.schemaTableName((String)"tpch", (String)"insert_into_non_partitioned_table"))).isTrue();
        this.assertUpdate("INSERT INTO insert_into_non_partitioned_table VALUES (4), (5)", 2L);
        Assertions.assertThat((boolean)this.isCached(this.getTableLocation("tpch", "insert_into_non_partitioned_table"), SchemaTableName.schemaTableName((String)"tpch", (String)"insert_into_non_partitioned_table"))).isFalse();
        this.assertQuery("SELECT sum(col1) FROM insert_into_non_partitioned_table", "VALUES (15)");
        this.assertUpdate("DROP TABLE insert_into_non_partitioned_table");
    }

    @Test
    public void testInsertIntoPartitionedTable() {
        this.assertUpdate("CREATE TABLE insert_into_partitioned_table (col1 int, col2 varchar) WITH (format = 'ORC', partitioned_by = ARRAY['col2'])");
        this.assertUpdate("INSERT INTO insert_into_partitioned_table VALUES (1, 'group1'), (2, 'group1'), (3, 'group2'), (4, 'group2')", 4L);
        this.assertQuery("SELECT col2, sum(col1) FROM insert_into_partitioned_table GROUP BY col2", "VALUES ('group1', 3), ('group2', 7)");
        String tableGroup1PartitionLocation = this.getPartitionLocation("tpch", "insert_into_partitioned_table", (List<String>)ImmutableList.of((Object)"group1"));
        String tableGroup2PartitionLocation = this.getPartitionLocation("tpch", "insert_into_partitioned_table", (List<String>)ImmutableList.of((Object)"group2"));
        Assertions.assertThat((boolean)this.isCached(tableGroup1PartitionLocation, SchemaTableName.schemaTableName((String)"tpch", (String)"insert_into_partitioned_table"))).isTrue();
        Assertions.assertThat((boolean)this.isCached(tableGroup2PartitionLocation, SchemaTableName.schemaTableName((String)"tpch", (String)"insert_into_partitioned_table"))).isTrue();
        this.assertUpdate("INSERT INTO insert_into_partitioned_table  VALUES (5, 'group2'), (6, 'group3')", 2L);
        Assertions.assertThat((boolean)this.isCached(tableGroup1PartitionLocation, SchemaTableName.schemaTableName((String)"tpch", (String)"insert_into_partitioned_table"))).isTrue();
        Assertions.assertThat((boolean)this.isCached(tableGroup2PartitionLocation, SchemaTableName.schemaTableName((String)"tpch", (String)"insert_into_partitioned_table"))).isFalse();
        this.assertQuery("SELECT col2, sum(col1) FROM insert_into_partitioned_table GROUP BY col2", "VALUES ('group1', 3), ('group2', 12), ('group3', 6)");
        this.assertUpdate("DROP TABLE insert_into_partitioned_table");
    }

    @Test
    public void testDropPartition() {
        this.assertUpdate("CREATE TABLE delete_from_partitioned_table (col1 int, col2 varchar) WITH (format = 'ORC', partitioned_by = ARRAY['col2'])");
        this.assertUpdate("INSERT INTO delete_from_partitioned_table VALUES (1, 'group1'), (2, 'group1'), (3, 'group2'), (4, 'group2'), (5, 'group3')", 5L);
        this.assertQuery("SELECT col2, sum(col1) FROM delete_from_partitioned_table GROUP BY col2", "VALUES ('group1', 3), ('group2', 7), ('group3', 5)");
        String tableGroup1PartitionLocation = this.getPartitionLocation("tpch", "delete_from_partitioned_table", (List<String>)ImmutableList.of((Object)"group1"));
        String tableGroup2PartitionLocation = this.getPartitionLocation("tpch", "delete_from_partitioned_table", (List<String>)ImmutableList.of((Object)"group2"));
        String tableGroup3PartitionLocation = this.getPartitionLocation("tpch", "delete_from_partitioned_table", (List<String>)ImmutableList.of((Object)"group3"));
        Assertions.assertThat((boolean)this.isCached(tableGroup1PartitionLocation, SchemaTableName.schemaTableName((String)"tpch", (String)"delete_from_partitioned_table"))).isTrue();
        Assertions.assertThat((boolean)this.isCached(tableGroup2PartitionLocation, SchemaTableName.schemaTableName((String)"tpch", (String)"delete_from_partitioned_table"))).isTrue();
        this.assertUpdate("DELETE FROM delete_from_partitioned_table WHERE col2 = 'group1' OR col2 = 'group2'");
        Assertions.assertThat((boolean)this.isCached(tableGroup1PartitionLocation, SchemaTableName.schemaTableName((String)"tpch", (String)"delete_from_partitioned_table"))).isFalse();
        Assertions.assertThat((boolean)this.isCached(tableGroup2PartitionLocation, SchemaTableName.schemaTableName((String)"tpch", (String)"delete_from_partitioned_table"))).isFalse();
        Assertions.assertThat((boolean)this.isCached(tableGroup3PartitionLocation, SchemaTableName.schemaTableName((String)"tpch", (String)"delete_from_partitioned_table"))).isTrue();
        this.assertQuery("SELECT col2, sum(col1) FROM delete_from_partitioned_table GROUP BY col2", "VALUES ('group3', 5)");
        this.assertUpdate("DROP TABLE delete_from_partitioned_table");
    }

    @Test
    public void testDropMultiLevelPartition() {
        this.assertUpdate("CREATE TABLE delete_from_partitioned_table (clicks bigint, day date, country varchar) WITH (format = 'ORC', partitioned_by = ARRAY['day', 'country'])");
        this.assertUpdate("INSERT INTO delete_from_partitioned_table VALUES (1000, DATE '2022-02-01', 'US'), (2000, DATE '2022-02-01', 'US'), (4000, DATE '2022-02-02', 'US'), (1500, DATE '2022-02-01', 'AT'), (2500, DATE '2022-02-02', 'AT')", 5L);
        this.assertQuery("SELECT day, country, sum(clicks) FROM delete_from_partitioned_table GROUP BY day, country", "VALUES (DATE '2022-02-01', 'US', 3000), (DATE '2022-02-02', 'US', 4000), (DATE '2022-02-01', 'AT', 1500), (DATE '2022-02-02', 'AT', 2500)");
        String table20220201UsPartitionLocation = this.getPartitionLocation("tpch", "delete_from_partitioned_table", (List<String>)ImmutableList.of((Object)"2022-02-01", (Object)"US"));
        String table20220202UsPartitionLocation = this.getPartitionLocation("tpch", "delete_from_partitioned_table", (List<String>)ImmutableList.of((Object)"2022-02-02", (Object)"US"));
        String table20220201AtPartitionLocation = this.getPartitionLocation("tpch", "delete_from_partitioned_table", (List<String>)ImmutableList.of((Object)"2022-02-01", (Object)"AT"));
        String table20220202AtPartitionLocation = this.getPartitionLocation("tpch", "delete_from_partitioned_table", (List<String>)ImmutableList.of((Object)"2022-02-02", (Object)"AT"));
        Assertions.assertThat((boolean)this.isCached(table20220201UsPartitionLocation, SchemaTableName.schemaTableName((String)"tpch", (String)"delete_from_partitioned_table"))).isTrue();
        Assertions.assertThat((boolean)this.isCached(table20220202UsPartitionLocation, SchemaTableName.schemaTableName((String)"tpch", (String)"delete_from_partitioned_table"))).isTrue();
        Assertions.assertThat((boolean)this.isCached(table20220201AtPartitionLocation, SchemaTableName.schemaTableName((String)"tpch", (String)"delete_from_partitioned_table"))).isTrue();
        Assertions.assertThat((boolean)this.isCached(table20220202AtPartitionLocation, SchemaTableName.schemaTableName((String)"tpch", (String)"delete_from_partitioned_table"))).isTrue();
        this.assertUpdate("DELETE FROM delete_from_partitioned_table WHERE day = DATE '2022-02-01'");
        Assertions.assertThat((boolean)this.isCached(table20220201UsPartitionLocation, SchemaTableName.schemaTableName((String)"tpch", (String)"delete_from_partitioned_table"))).isFalse();
        Assertions.assertThat((boolean)this.isCached(table20220202UsPartitionLocation, SchemaTableName.schemaTableName((String)"tpch", (String)"delete_from_partitioned_table"))).isTrue();
        Assertions.assertThat((boolean)this.isCached(table20220201AtPartitionLocation, SchemaTableName.schemaTableName((String)"tpch", (String)"delete_from_partitioned_table"))).isFalse();
        Assertions.assertThat((boolean)this.isCached(table20220202AtPartitionLocation, SchemaTableName.schemaTableName((String)"tpch", (String)"delete_from_partitioned_table"))).isTrue();
        this.assertUpdate("DELETE FROM delete_from_partitioned_table WHERE country = 'US'");
        Assertions.assertThat((boolean)this.isCached(table20220202UsPartitionLocation, SchemaTableName.schemaTableName((String)"tpch", (String)"delete_from_partitioned_table"))).isFalse();
        Assertions.assertThat((boolean)this.isCached(table20220202AtPartitionLocation, SchemaTableName.schemaTableName((String)"tpch", (String)"delete_from_partitioned_table"))).isTrue();
        this.assertQuery("SELECT day, country, sum(clicks) FROM delete_from_partitioned_table GROUP BY day, country", "VALUES (DATE '2022-02-02', 'AT', 2500)");
        this.assertUpdate("DROP TABLE delete_from_partitioned_table");
    }

    @Test
    public void testUnregisterRegisterPartition() {
        this.assertUpdate("CREATE TABLE register_unregister_partition_table (col1 int, col2 varchar) WITH (format = 'ORC', partitioned_by = ARRAY['col2'])");
        this.assertUpdate("INSERT INTO register_unregister_partition_table VALUES (1, 'group1'), (2, 'group1'), (3, 'group2'), (4, 'group2')", 4L);
        this.assertQuery("SELECT col2, sum(col1) FROM register_unregister_partition_table GROUP BY col2", "VALUES ('group1', 3), ('group2', 7)");
        String tableGroup1PartitionLocation = this.getPartitionLocation("tpch", "register_unregister_partition_table", (List<String>)ImmutableList.of((Object)"group1"));
        String tableGroup2PartitionLocation = this.getPartitionLocation("tpch", "register_unregister_partition_table", (List<String>)ImmutableList.of((Object)"group2"));
        Assertions.assertThat((boolean)this.isCached(tableGroup1PartitionLocation, SchemaTableName.schemaTableName((String)"tpch", (String)"register_unregister_partition_table"))).isTrue();
        Assertions.assertThat((boolean)this.isCached(tableGroup2PartitionLocation, SchemaTableName.schemaTableName((String)"tpch", (String)"register_unregister_partition_table"))).isTrue();
        List paths = this.getQueryRunner().execute(this.getSession(), "SELECT \"$path\" FROM register_unregister_partition_table WHERE col2 = 'group1' LIMIT 1").toTestTypes().getMaterializedRows();
        String group1PartitionPath = Location.of((String)((String)((MaterializedRow)paths.get(0)).getField(0))).parentDirectory().toString();
        this.assertUpdate(String.format("CALL system.unregister_partition('%s', '%s', ARRAY['col2'], ARRAY['group1'])", "tpch", "register_unregister_partition_table"));
        Assertions.assertThat((boolean)this.isCached(tableGroup1PartitionLocation, SchemaTableName.schemaTableName((String)"tpch", (String)"register_unregister_partition_table"))).isFalse();
        Assertions.assertThat((boolean)this.isCached(tableGroup2PartitionLocation, SchemaTableName.schemaTableName((String)"tpch", (String)"register_unregister_partition_table"))).isTrue();
        this.assertQuery("SELECT col2, sum(col1) FROM register_unregister_partition_table GROUP BY col2", "VALUES ('group2', 7)");
        Assertions.assertThat((boolean)this.isCached(tableGroup2PartitionLocation, SchemaTableName.schemaTableName((String)"tpch", (String)"register_unregister_partition_table"))).isTrue();
        this.assertUpdate(String.format("CALL system.register_partition('%s', '%s', ARRAY['col2'], ARRAY['group1'], '%s')", "tpch", "register_unregister_partition_table", group1PartitionPath));
        Assertions.assertThat((boolean)this.isCached(tableGroup1PartitionLocation, SchemaTableName.schemaTableName((String)"tpch", (String)"register_unregister_partition_table"))).isFalse();
        Assertions.assertThat((boolean)this.isCached(tableGroup2PartitionLocation, SchemaTableName.schemaTableName((String)"tpch", (String)"register_unregister_partition_table"))).isTrue();
        this.assertQuery("SELECT col2, sum(col1) FROM register_unregister_partition_table GROUP BY col2", "VALUES ('group1', 3), ('group2', 7)");
        this.assertUpdate("DROP TABLE register_unregister_partition_table");
    }

    @Test
    public void testRenameTable() {
        this.assertUpdate("CREATE TABLE table_to_be_renamed (col1 int) WITH (format = 'ORC')");
        this.assertUpdate("INSERT INTO table_to_be_renamed VALUES (1), (2), (3)", 3L);
        this.assertQuery("SELECT sum(col1) FROM table_to_be_renamed", "VALUES (6)");
        String tableLocation = this.getTableLocation("tpch", "table_to_be_renamed");
        Assertions.assertThat((boolean)this.isCached(tableLocation, SchemaTableName.schemaTableName((String)"tpch", (String)"table_to_be_renamed"))).isTrue();
        this.assertUpdate("ALTER TABLE table_to_be_renamed RENAME TO table_renamed");
        Assertions.assertThat((boolean)this.isCached(tableLocation, SchemaTableName.schemaTableName((String)"tpch", (String)"table_to_be_renamed"))).isFalse();
        this.assertUpdate("DROP TABLE table_renamed");
    }

    @Test
    public void testDropTable() {
        this.assertUpdate("CREATE TABLE table_to_be_dropped (col1 int) WITH (format = 'ORC')");
        this.assertUpdate("INSERT INTO table_to_be_dropped VALUES (1), (2), (3)", 3L);
        this.assertQuery("SELECT sum(col1) FROM table_to_be_dropped", "VALUES (6)");
        String tableLocation = this.getTableLocation("tpch", "table_to_be_dropped");
        Assertions.assertThat((boolean)this.isCached(tableLocation, SchemaTableName.schemaTableName((String)"tpch", (String)"table_to_be_dropped"))).isTrue();
        this.assertUpdate("DROP TABLE table_to_be_dropped");
        Assertions.assertThat((boolean)this.isCached(tableLocation, SchemaTableName.schemaTableName((String)"tpch", (String)"table_to_be_dropped"))).isFalse();
    }

    @Test
    public void testDropPartitionedTable() {
        this.assertUpdate("CREATE TABLE drop_partitioned_table (col1 int, col2 varchar) WITH (format = 'ORC', partitioned_by = ARRAY['col2'])");
        this.assertUpdate("INSERT INTO drop_partitioned_table VALUES (1, 'group1'), (2, 'group1'), (3, 'group2'), (4, 'group2'), (5, 'group3')", 5L);
        this.assertQuery("SELECT col2, sum(col1) FROM drop_partitioned_table GROUP BY col2", "VALUES ('group1', 3), ('group2', 7), ('group3', 5)");
        String tableGroup1PartitionLocation = this.getPartitionLocation("tpch", "drop_partitioned_table", (List<String>)ImmutableList.of((Object)"group1"));
        String tableGroup2PartitionLocation = this.getPartitionLocation("tpch", "drop_partitioned_table", (List<String>)ImmutableList.of((Object)"group2"));
        String tableGroup3PartitionLocation = this.getPartitionLocation("tpch", "drop_partitioned_table", (List<String>)ImmutableList.of((Object)"group3"));
        Assertions.assertThat((boolean)this.isCached(tableGroup1PartitionLocation, SchemaTableName.schemaTableName((String)"tpch", (String)"drop_partitioned_table"))).isTrue();
        Assertions.assertThat((boolean)this.isCached(tableGroup2PartitionLocation, SchemaTableName.schemaTableName((String)"tpch", (String)"drop_partitioned_table"))).isTrue();
        Assertions.assertThat((boolean)this.isCached(tableGroup3PartitionLocation, SchemaTableName.schemaTableName((String)"tpch", (String)"drop_partitioned_table"))).isTrue();
        this.assertUpdate("CREATE TABLE other_table (col1 int) WITH (format = 'ORC')");
        this.assertUpdate("INSERT INTO other_table VALUES (1), (2), (3)", 3L);
        this.assertQuery("SELECT sum(col1) FROM other_table", "VALUES (6)");
        String otherTableLocation = this.getTableLocation("tpch", "other_table");
        Assertions.assertThat((boolean)this.isCached(otherTableLocation, SchemaTableName.schemaTableName((String)"tpch", (String)"other_table"))).isTrue();
        this.assertUpdate("DROP TABLE drop_partitioned_table");
        Assertions.assertThat((boolean)this.isCached(tableGroup1PartitionLocation, SchemaTableName.schemaTableName((String)"tpch", (String)"drop_partitioned_table"))).isFalse();
        Assertions.assertThat((boolean)this.isCached(tableGroup2PartitionLocation, SchemaTableName.schemaTableName((String)"tpch", (String)"drop_partitioned_table"))).isFalse();
        Assertions.assertThat((boolean)this.isCached(tableGroup3PartitionLocation, SchemaTableName.schemaTableName((String)"tpch", (String)"drop_partitioned_table"))).isFalse();
        Assertions.assertThat((boolean)this.isCached(otherTableLocation, SchemaTableName.schemaTableName((String)"tpch", (String)"other_table"))).isTrue();
        this.assertQuery("SELECT sum(col1) FROM other_table", "VALUES (6)");
        this.assertUpdate("DROP TABLE other_table");
    }

    @Test
    public void testTableExclusion() {
        CachingDirectoryLister lister = new CachingDirectoryLister(new Duration(5.0, TimeUnit.MINUTES), DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE), (List)ImmutableList.of((Object)"db.*", (Object)"test.*"), (List)ImmutableList.of((Object)"db.excluded", (Object)"test.excluded"), fileEntry -> true);
        Assertions.assertThat((boolean)this.isCacheEnabled(lister, "db", "table1")).isTrue();
        Assertions.assertThat((boolean)this.isCacheEnabled(lister, "test", "table2")).isTrue();
        Assertions.assertThat((boolean)this.isCacheEnabled(lister, "db", "excluded")).isFalse();
        Assertions.assertThat((boolean)this.isCacheEnabled(lister, "test", "excluded")).isFalse();
        Assertions.assertThat((boolean)this.isCacheEnabled(lister, "other", "table")).isFalse();
    }

    @Test
    public void testWildcardExclusion() {
        CachingDirectoryLister lister = new CachingDirectoryLister(new Duration(5.0, TimeUnit.MINUTES), DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE), (List)ImmutableList.of((Object)"db.*"), (List)ImmutableList.of((Object)"db.*"), fileEntry -> true);
        Assertions.assertThat((boolean)this.isCacheEnabled(lister, "db", "table1")).isFalse();
        Assertions.assertThat((boolean)this.isCacheEnabled(lister, "db", "production")).isFalse();
        Assertions.assertThat((boolean)this.isCacheEnabled(lister, "db", "temp_table")).isFalse();
        Assertions.assertThat((boolean)this.isCacheEnabled(lister, "other", "table")).isFalse();
    }

    @Test
    public void testForExcludingOneTableFromSchema() {
        CachingDirectoryLister lister = new CachingDirectoryLister(new Duration(5.0, TimeUnit.MINUTES), DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE), (List)ImmutableList.of((Object)"db.*"), (List)ImmutableList.of((Object)"db.a"), fileEntry -> true);
        Assertions.assertThat((boolean)this.isCacheEnabled(lister, "db", "table1")).isTrue();
        Assertions.assertThat((boolean)this.isCacheEnabled(lister, "db", "production")).isTrue();
        Assertions.assertThat((boolean)this.isCacheEnabled(lister, "db", "temp_table")).isTrue();
        Assertions.assertThat((boolean)this.isCacheEnabled(lister, "db", "a")).isFalse();
        Assertions.assertThat((boolean)this.isCacheEnabled(lister, "other", "table")).isFalse();
    }

    private boolean isCacheEnabled(CachingDirectoryLister lister, String schema, String table) {
        return lister.isCacheEnabledFor(new SchemaTableName(schema, table));
    }

    protected Optional<Table> getTable(String schemaName, String tableName) {
        return this.metastore.getTable(schemaName, tableName);
    }

    protected void createTable(Table table, PrincipalPrivileges principalPrivileges) {
        this.metastore.createTable(table, principalPrivileges);
    }

    protected void dropTable(String schemaName, String tableName, boolean deleteData) {
        this.metastore.dropTable(schemaName, tableName, deleteData);
    }

    protected String getTableLocation(String schemaName, String tableName) {
        return this.getTable(schemaName, tableName).map(table -> table.getStorage().getLocation()).orElseThrow(() -> new NoSuchElementException(String.format("The table %s.%s could not be found", schemaName, tableName)));
    }

    protected String getPartitionLocation(String schemaName, String tableName, List<String> partitionValues) {
        Table table = this.getTable(schemaName, tableName).orElseThrow(() -> new NoSuchElementException(String.format("The table %s.%s could not be found", schemaName, tableName)));
        return this.metastore.getPartition(table, partitionValues).map(partition -> partition.getStorage().getLocation()).orElseThrow(() -> new NoSuchElementException(String.format("The partition %s from the table %s.%s could not be found", partitionValues, schemaName, tableName)));
    }

    protected boolean isCached(String path, SchemaTableName schemaTableName) {
        return this.directoryLister.isCached(Location.of((String)path), schemaTableName);
    }
}

