/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.fs;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.metastore.PrincipalPrivileges;
import io.trino.metastore.Table;
import io.trino.plugin.hive.fs.BaseCachingDirectoryListerTest;
import io.trino.plugin.hive.metastore.MetastoreUtil;
import io.trino.spi.connector.SchemaTableName;
import io.trino.testing.QueryRunner;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@Execution(value=ExecutionMode.SAME_THREAD)
public class TestCachingDirectoryListerRecursiveFilesOnly
extends BaseCachingDirectoryListerTest {
    protected QueryRunner createQueryRunner() throws Exception {
        return this.createQueryRunner((Map<String, String>)ImmutableMap.builder().put((Object)"hive.allow-register-partition-procedure", (Object)"true").put((Object)"hive.recursive-directories", (Object)"true").put((Object)"hive.file-status-cache-expire-time", (Object)"5m").put((Object)"hive.file-status-cache.max-retained-size", (Object)"1MB").put((Object)"hive.file-status-cache-tables", (Object)"tpch.*").buildOrThrow());
    }

    @Test
    public void testRecursiveDirectories() {
        this.assertUpdate("CREATE TABLE recursive_directories (clicks bigint, day date, country varchar) WITH (format = 'ORC', partitioned_by = ARRAY['day', 'country'])");
        this.assertUpdate("INSERT INTO recursive_directories VALUES (1000, DATE '2022-02-01', 'US'), (2000, DATE '2022-02-01', 'US'), (4000, DATE '2022-02-02', 'US'), (1500, DATE '2022-02-01', 'AT'), (2500, DATE '2022-02-02', 'AT')", 5L);
        Table partitionedTable = this.getTable("tpch", "recursive_directories").orElseThrow(() -> new NoSuchElementException(String.format("Failed to read table %s.%s", "tpch", "recursive_directories")));
        this.dropTable("tpch", "recursive_directories", false);
        Table testTable = Table.builder((Table)partitionedTable).setPartitionColumns((List)ImmutableList.of()).build();
        this.createTable(testTable, testTable.getOwner().map(MetastoreUtil::buildInitialPrivilegeSet).orElse(PrincipalPrivileges.NO_PRIVILEGES));
        this.assertQuery("SELECT sum(clicks) FROM recursive_directories", "VALUES (11000)");
        String tableLocation = this.getTableLocation("tpch", "recursive_directories");
        Assertions.assertThat((boolean)this.isCached(tableLocation, SchemaTableName.schemaTableName((String)"tpch", (String)"recursive_directories"))).isTrue();
        this.assertUpdate("INSERT INTO recursive_directories VALUES (1000)", 1L);
        Assertions.assertThat((boolean)this.isCached(tableLocation, SchemaTableName.schemaTableName((String)"tpch", (String)"recursive_directories"))).isFalse();
        this.assertQuery("SELECT sum(clicks) FROM recursive_directories", "VALUES (12000)");
        this.assertUpdate("DROP TABLE recursive_directories");
        Assertions.assertThat((boolean)this.isCached(tableLocation, SchemaTableName.schemaTableName((String)"tpch", (String)"recursive_directories"))).isFalse();
    }
}

