/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.fs;

import io.trino.filesystem.Location;
import io.trino.plugin.hive.fs.HiveFileIterator;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestHiveFileIterator {
    @Test
    public void testRelativeHiddenPathDetection() {
        Assertions.assertThat((boolean)HiveFileIterator.isHiddenOrWithinHiddenParentDirectory((Location)Location.of((String)"file:///root-path/.hidden/child"), (Location)Location.of((String)"file:///root-path"))).isTrue();
        Assertions.assertThat((boolean)HiveFileIterator.isHiddenOrWithinHiddenParentDirectory((Location)Location.of((String)"file:///root-path/_hidden.txt"), (Location)Location.of((String)"file:///root-path"))).isTrue();
        Assertions.assertThat((boolean)HiveFileIterator.isHiddenOrWithinHiddenParentDirectory((Location)Location.of((String)"file:///root-path/.hidden/child"), (Location)Location.of((String)"file:///root-path/"))).isTrue();
        Assertions.assertThat((boolean)HiveFileIterator.isHiddenOrWithinHiddenParentDirectory((Location)Location.of((String)"file:///root-path/_hidden.txt"), (Location)Location.of((String)"file:///root-path/"))).isTrue();
        Assertions.assertThat((boolean)HiveFileIterator.isHiddenOrWithinHiddenParentDirectory((Location)Location.of((String)"file:///root/.hidden/listing-root/file.txt"), (Location)Location.of((String)"file:///root/.hidden/listing-root"))).isFalse();
        Assertions.assertThat((boolean)HiveFileIterator.isHiddenOrWithinHiddenParentDirectory((Location)Location.of((String)"file:///root/hidden-ending_/file.txt"), (Location)Location.of((String)"file:///root/hidden-ending_"))).isFalse();
        Assertions.assertThat((boolean)HiveFileIterator.isHiddenOrWithinHiddenParentDirectory((Location)Location.of((String)"file:///root/With spaces and | pipes/.hidden/file.txt"), (Location)Location.of((String)"file:///root/With spaces and | pipes/.hidden"))).isFalse();
    }

    @Test
    public void testHiddenFileNameDetection() {
        Assertions.assertThat((boolean)HiveFileIterator.isHiddenFileOrDirectory((Location)Location.of((String)"file:///parent/.hidden/ignore-parent-directories.txt"))).isFalse();
        Assertions.assertThat((boolean)HiveFileIterator.isHiddenFileOrDirectory((Location)Location.of((String)"file:///parent/visible/_hidden-file.txt"))).isTrue();
    }

    @Test
    public void testHiddenDetectionEdgeCases() {
        Assertions.assertThat((boolean)HiveFileIterator.containsHiddenPathPartAfterIndex((String)"/.leading-slash-hidden/file.txt", (int)0)).isTrue();
        Assertions.assertThat((boolean)HiveFileIterator.containsHiddenPathPartAfterIndex((String)"/.leading-slash-hidden-directory/", (int)0)).isTrue();
        Assertions.assertThat((boolean)HiveFileIterator.containsHiddenPathPartAfterIndex((String)"_root-hidden/file.txt", (int)0)).isTrue();
        Assertions.assertThat((boolean)HiveFileIterator.containsHiddenPathPartAfterIndex((String)"_root-hidden/directory/", (int)0)).isTrue();
        Assertions.assertThat((boolean)HiveFileIterator.containsHiddenPathPartAfterIndex((String)"root//multi-slash/", (int)0)).isFalse();
        Assertions.assertThat((boolean)HiveFileIterator.containsHiddenPathPartAfterIndex((String)"root/child/.slash-hidden/file.txt", (int)0)).isTrue();
        Assertions.assertThat((boolean)HiveFileIterator.containsHiddenPathPartAfterIndex((String)"root/child/.slash-hidden/parent/file.txt", (int)0)).isTrue();
    }
}

