/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.fs;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.units.DataSize;
import io.trino.filesystem.Location;
import io.trino.filesystem.TrinoFileSystem;
import io.trino.metastore.Column;
import io.trino.metastore.HiveBucketProperty;
import io.trino.metastore.HiveType;
import io.trino.metastore.Partition;
import io.trino.metastore.SortingColumn;
import io.trino.metastore.Storage;
import io.trino.metastore.StorageFormat;
import io.trino.metastore.Table;
import io.trino.plugin.hive.fs.DirectoryLister;
import io.trino.plugin.hive.fs.DirectoryListingFilter;
import io.trino.plugin.hive.fs.RemoteIterator;
import io.trino.plugin.hive.fs.TransactionScopeCachingDirectoryLister;
import io.trino.plugin.hive.fs.TransactionScopeCachingDirectoryListerFactory;
import io.trino.plugin.hive.fs.TrinoFileStatus;
import io.trino.spi.connector.SchemaTableName;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.concurrent.atomic.AtomicInteger;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@Execution(value=ExecutionMode.SAME_THREAD)
public class TestTransactionScopeCachingDirectoryLister {
    private static final Column TABLE_COLUMN = new Column("column", HiveType.HIVE_INT, Optional.of("comment"), Map.of());
    private static final Storage TABLE_STORAGE = new Storage(StorageFormat.create((String)"serde", (String)"input", (String)"output"), Optional.of("location"), Optional.of(new HiveBucketProperty((List)ImmutableList.of((Object)"column"), 10, (List)ImmutableList.of((Object)new SortingColumn("column", SortingColumn.Order.ASCENDING)))), true, (Map)ImmutableMap.of((Object)"param", (Object)"value2"));
    private static final Table TABLE = new Table("database", "table", Optional.of("owner"), "table_type", TABLE_STORAGE, (List)ImmutableList.of((Object)TABLE_COLUMN), (List)ImmutableList.of((Object)TABLE_COLUMN), (Map)ImmutableMap.of((Object)"param", (Object)"value3"), Optional.of("original_text"), Optional.of("expanded_text"), OptionalLong.empty());

    @Test
    public void testConcurrentDirectoryListing() throws IOException {
        TrinoFileStatus firstFile = new TrinoFileStatus((List)ImmutableList.of(), "file:/x/x", false, 1L, 1L);
        TrinoFileStatus secondFile = new TrinoFileStatus((List)ImmutableList.of(), "file:/x/y", false, 1L, 1L);
        TrinoFileStatus thirdFile = new TrinoFileStatus((List)ImmutableList.of(), "file:/y/z", false, 1L, 1L);
        Location path1 = Location.of((String)"file:/x");
        Location path2 = Location.of((String)"file:/y");
        CountingDirectoryLister countingLister = new CountingDirectoryLister((Map<Location, List<TrinoFileStatus>>)ImmutableMap.of((Object)path1, (Object)ImmutableList.of((Object)firstFile, (Object)secondFile), (Object)path2, (Object)ImmutableList.of((Object)thirdFile)));
        TransactionScopeCachingDirectoryLister cachingLister = (TransactionScopeCachingDirectoryLister)new TransactionScopeCachingDirectoryListerFactory(DataSize.ofBytes((long)500L), Optional.of(1)).get((DirectoryLister)countingLister);
        this.assertFiles((RemoteIterator<TrinoFileStatus>)new DirectoryListingFilter(path2, cachingLister.listFilesRecursively(null, TABLE, path2), true), (List<TrinoFileStatus>)ImmutableList.of((Object)thirdFile));
        Assertions.assertThat((int)countingLister.getListCount()).isEqualTo(1);
        Assertions.assertThat((boolean)cachingLister.isCached(path2, TABLE.getSchemaTableName())).isTrue();
        this.assertFiles((RemoteIterator<TrinoFileStatus>)new DirectoryListingFilter(path2, cachingLister.listFilesRecursively(null, TABLE, path2), true), (List<TrinoFileStatus>)ImmutableList.of((Object)thirdFile));
        Assertions.assertThat((int)countingLister.getListCount()).isEqualTo(1);
        DirectoryListingFilter path1FilesA = new DirectoryListingFilter(path1, cachingLister.listFilesRecursively(null, TABLE, path1), true);
        DirectoryListingFilter path1FilesB = new DirectoryListingFilter(path1, cachingLister.listFilesRecursively(null, TABLE, path1), true);
        Assertions.assertThat((int)countingLister.getListCount()).isEqualTo(2);
        Assertions.assertThat((Comparable)((TrinoFileStatus)path1FilesA.next())).isEqualTo((Object)firstFile);
        Assertions.assertThat((Comparable)((TrinoFileStatus)path1FilesB.next())).isEqualTo((Object)firstFile);
        Assertions.assertThat((Comparable)((TrinoFileStatus)path1FilesB.next())).isEqualTo((Object)secondFile);
        Assertions.assertThat((Comparable)((TrinoFileStatus)path1FilesA.next())).isEqualTo((Object)secondFile);
        Assertions.assertThat((boolean)path1FilesA.hasNext()).isFalse();
        Assertions.assertThat((boolean)path1FilesB.hasNext()).isFalse();
        Assertions.assertThat((int)countingLister.getListCount()).isEqualTo(2);
        Assertions.assertThat((boolean)cachingLister.isCached(path2, TABLE.getSchemaTableName())).isFalse();
        this.assertFiles((RemoteIterator<TrinoFileStatus>)new DirectoryListingFilter(path2, cachingLister.listFilesRecursively(null, TABLE, path2), true), (List<TrinoFileStatus>)ImmutableList.of((Object)thirdFile));
        Assertions.assertThat((int)countingLister.getListCount()).isEqualTo(3);
    }

    @Test
    public void testConcurrentDirectoryListingException() throws IOException {
        TrinoFileStatus file = new TrinoFileStatus((List)ImmutableList.of(), "file:/x/x", false, 1L, 1L);
        Location path = Location.of((String)"file:/x");
        CountingDirectoryLister countingLister = new CountingDirectoryLister((Map<Location, List<TrinoFileStatus>>)ImmutableMap.of((Object)path, (Object)ImmutableList.of((Object)file)));
        DirectoryLister cachingLister = new TransactionScopeCachingDirectoryListerFactory(DataSize.ofBytes((long)600L), Optional.of(1)).get((DirectoryLister)countingLister);
        countingLister.setThrowException(true);
        RemoteIterator filesA = cachingLister.listFilesRecursively(null, TABLE, path);
        RemoteIterator filesB = cachingLister.listFilesRecursively(null, TABLE, path);
        Assertions.assertThat((int)countingLister.getListCount()).isEqualTo(1);
        Assertions.assertThatThrownBy(() -> ((RemoteIterator)filesA).hasNext()).isInstanceOf(IOException.class);
        countingLister.setThrowException(false);
        this.assertFiles((RemoteIterator<TrinoFileStatus>)new DirectoryListingFilter(path, cachingLister.listFilesRecursively(null, TABLE, path), true), (List<TrinoFileStatus>)ImmutableList.of((Object)file));
        Assertions.assertThat((int)countingLister.getListCount()).isEqualTo(2);
        Assertions.assertThatThrownBy(() -> ((RemoteIterator)filesB).hasNext()).isInstanceOf(IOException.class);
    }

    private void assertFiles(RemoteIterator<TrinoFileStatus> iterator, List<TrinoFileStatus> expectedFiles) throws IOException {
        ImmutableList.Builder actualFiles = ImmutableList.builder();
        while (iterator.hasNext()) {
            actualFiles.add((Object)((TrinoFileStatus)iterator.next()));
        }
        Assertions.assertThat((List)actualFiles.build()).isEqualTo(expectedFiles);
    }

    static RemoteIterator<TrinoFileStatus> throwingRemoteIterator(final List<TrinoFileStatus> files, final boolean throwException) {
        return new RemoteIterator<TrinoFileStatus>(){
            private final Iterator<TrinoFileStatus> iterator;
            {
                this.iterator = ImmutableList.copyOf((Collection)files).iterator();
            }

            public boolean hasNext() throws IOException {
                if (throwException) {
                    throw new IOException();
                }
                return this.iterator.hasNext();
            }

            public TrinoFileStatus next() {
                return this.iterator.next();
            }
        };
    }

    private static class CountingDirectoryLister
    implements DirectoryLister {
        private final Map<Location, List<TrinoFileStatus>> fileStatuses;
        private final AtomicInteger listCount = new AtomicInteger();
        private volatile boolean throwException;

        public CountingDirectoryLister(Map<Location, List<TrinoFileStatus>> fileStatuses) {
            this.fileStatuses = Objects.requireNonNull(fileStatuses, "fileStatuses is null");
        }

        public RemoteIterator<TrinoFileStatus> listFilesRecursively(TrinoFileSystem fs, Table table, Location location) {
            this.listCount.incrementAndGet();
            return TestTransactionScopeCachingDirectoryLister.throwingRemoteIterator(Objects.requireNonNull(this.fileStatuses.get(location)), this.throwException);
        }

        public void setThrowException(boolean throwException) {
            this.throwException = throwException;
        }

        public int getListCount() {
            return this.listCount.get();
        }

        public void invalidate(Location location, SchemaTableName schemaTableName) {
        }

        public void invalidate(Partition partition) {
        }

        public void invalidate(Table table) {
        }

        public void invalidateAll() {
        }
    }
}

