/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.metastore;

import io.trino.metastore.Column;
import io.trino.metastore.Database;
import io.trino.metastore.HiveMetastore;
import io.trino.metastore.HiveType;
import io.trino.metastore.PrincipalPrivileges;
import io.trino.metastore.SchemaAlreadyExistsException;
import io.trino.metastore.Table;
import io.trino.metastore.TableAlreadyExistsException;
import io.trino.plugin.hive.HiveStorageFormat;
import io.trino.plugin.hive.TableType;
import io.trino.spi.connector.TableNotFoundException;
import io.trino.testing.TestingNames;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Execution(value=ExecutionMode.SAME_THREAD)
public abstract class AbstractTestHiveMetastore {
    protected abstract HiveMetastore getMetastore();

    @Test
    void testCreateDatabase() {
        String databaseName = "test_database_" + ThreadLocalRandom.current().nextLong(Long.MAX_VALUE);
        Database.Builder database = Database.builder().setDatabaseName(databaseName).setParameters(Map.of("trino_query_id", "query_id")).setOwnerName(Optional.empty()).setOwnerType(Optional.empty());
        this.getMetastore().createDatabase(database.build());
        this.getMetastore().createDatabase(database.build());
        database.setParameters(Map.of("trino_query_id", "another_query_id"));
        Assertions.assertThatThrownBy(() -> this.getMetastore().createDatabase(database.build())).isInstanceOf(SchemaAlreadyExistsException.class);
        this.getMetastore().dropDatabase(databaseName, false);
    }

    @Test
    void testCreateTable() {
        String databaseName = "test_database_" + ThreadLocalRandom.current().nextLong(Long.MAX_VALUE);
        Database.Builder database = Database.builder().setDatabaseName(databaseName).setOwnerName(Optional.empty()).setOwnerType(Optional.empty());
        this.getMetastore().createDatabase(database.build());
        String tableName = "test_table";
        Table.Builder table = Table.builder().setDatabaseName(databaseName).setTableName(tableName).setParameters(Map.of("trino_query_id", "query_id")).setTableType(TableType.EXTERNAL_TABLE.name()).setDataColumns(List.of(new Column("test_column", HiveType.HIVE_STRING, Optional.empty(), Map.of()))).setOwner(Optional.empty());
        table.getStorageBuilder().setLocation(Optional.of("/tmp/location")).setStorageFormat(HiveStorageFormat.PARQUET.toStorageFormat());
        this.getMetastore().createTable(table.build(), PrincipalPrivileges.NO_PRIVILEGES);
        this.getMetastore().createTable(table.build(), PrincipalPrivileges.NO_PRIVILEGES);
        table.setParameters(Map.of("trino_query_id", "another_query_id"));
        Assertions.assertThatThrownBy(() -> this.getMetastore().createTable(table.build(), PrincipalPrivileges.NO_PRIVILEGES)).isInstanceOf(TableAlreadyExistsException.class);
        this.getMetastore().dropTable(databaseName, tableName, false);
        this.getMetastore().dropDatabase(databaseName, false);
    }

    @Test
    public void testDropNotExistingTable() {
        String databaseName = "test_database_" + TestingNames.randomNameSuffix();
        Database.Builder database = Database.builder().setDatabaseName(databaseName).setOwnerName(Optional.empty()).setOwnerType(Optional.empty());
        this.getMetastore().createDatabase(database.build());
        Assertions.assertThatThrownBy(() -> this.getMetastore().dropTable(databaseName, "not_existing", false)).isInstanceOf(TableNotFoundException.class);
        this.getMetastore().dropDatabase(databaseName, false);
    }
}

