/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.metastore;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.slice.Slices;
import io.trino.metastore.HiveBasicStatistics;
import io.trino.metastore.HiveType;
import io.trino.plugin.hive.HiveColumnHandle;
import io.trino.plugin.hive.metastore.MetastoreUtil;
import io.trino.spi.predicate.Domain;
import io.trino.spi.predicate.Range;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.predicate.ValueSet;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalLong;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.OptionalAssert;
import org.junit.jupiter.api.Test;

public class TestMetastoreUtil {
    @Test
    public void testComputePartitionKeyFilter() {
        HiveColumnHandle dsColumn = TestMetastoreUtil.partitionColumn("ds");
        HiveColumnHandle typeColumn = TestMetastoreUtil.partitionColumn("type");
        ImmutableList partitionKeys = ImmutableList.of((Object)dsColumn, (Object)typeColumn);
        Domain dsDomain = Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"2018-05-06")), (Range[])new Range[0]), (boolean)false);
        Domain typeDomain = Domain.create((ValueSet)ValueSet.of((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"fruit"), (Object[])new Object[0]), (boolean)false);
        TupleDomain tupleDomain = TupleDomain.withColumnDomains((Map)ImmutableMap.builder().put((Object)HiveColumnHandle.bucketColumnHandle(), (Object)Domain.create((ValueSet)ValueSet.of((Type)IntegerType.INTEGER, (Object)123L, (Object[])new Object[0]), (boolean)false)).put((Object)dsColumn, (Object)dsDomain).put((Object)typeColumn, (Object)typeDomain).buildOrThrow());
        TupleDomain filter = MetastoreUtil.computePartitionKeyFilter((List)partitionKeys, (TupleDomain)tupleDomain);
        ((OptionalAssert)Assertions.assertThat((Optional)filter.getDomains()).as("output contains only the partition keys", new Object[0])).contains((Object)ImmutableMap.builder().put((Object)"ds", (Object)dsDomain).put((Object)"type", (Object)typeDomain).buildOrThrow());
    }

    @Test
    public void testBasicStatisticsRoundTrip() {
        TestMetastoreUtil.testBasicStatisticsRoundTrip(new HiveBasicStatistics(OptionalLong.empty(), OptionalLong.empty(), OptionalLong.empty(), OptionalLong.empty()));
        TestMetastoreUtil.testBasicStatisticsRoundTrip(new HiveBasicStatistics(OptionalLong.of(1L), OptionalLong.empty(), OptionalLong.of(2L), OptionalLong.empty()));
        TestMetastoreUtil.testBasicStatisticsRoundTrip(new HiveBasicStatistics(OptionalLong.of(1L), OptionalLong.of(2L), OptionalLong.of(3L), OptionalLong.of(4L)));
    }

    private static void testBasicStatisticsRoundTrip(HiveBasicStatistics expected) {
        Assertions.assertThat((Object)MetastoreUtil.getHiveBasicStatistics((Map)MetastoreUtil.updateStatisticsParameters((Map)ImmutableMap.of(), (HiveBasicStatistics)expected))).isEqualTo((Object)expected);
    }

    @Test
    public void testSparkFallbackGetBasicStatistics() {
        Map<String, String> tableParameters = Map.of("spark.sql.statistics.numFiles", "1", "spark.sql.statistics.numRows", "2", "spark.sql.statistics.rawDataSize", "3", "spark.sql.statistics.totalSize", "4");
        HiveBasicStatistics actual = MetastoreUtil.getBasicStatisticsWithSparkFallback(tableParameters);
        Assertions.assertThat((Object)actual).isEqualTo((Object)new HiveBasicStatistics(OptionalLong.of(1L), OptionalLong.of(2L), OptionalLong.of(3L), OptionalLong.of(4L)));
        actual = MetastoreUtil.getHiveBasicStatistics(tableParameters);
        Assertions.assertThat((Object)actual).isEqualTo((Object)new HiveBasicStatistics(OptionalLong.empty(), OptionalLong.empty(), OptionalLong.empty(), OptionalLong.empty()));
        tableParameters = Map.of("numFiles", "0", "numRows", "0", "rawDataSize", "0", "totalSize", "0", "spark.sql.statistics.numFiles", "1", "spark.sql.statistics.numRows", "2", "spark.sql.statistics.rawDataSize", "3", "spark.sql.statistics.totalSize", "4");
        actual = MetastoreUtil.getBasicStatisticsWithSparkFallback(tableParameters);
        Assertions.assertThat((Object)actual).isEqualTo((Object)new HiveBasicStatistics(OptionalLong.of(1L), OptionalLong.of(2L), OptionalLong.of(3L), OptionalLong.of(4L)));
        actual = MetastoreUtil.getHiveBasicStatistics(tableParameters);
        Assertions.assertThat((Object)actual).isEqualTo((Object)new HiveBasicStatistics(OptionalLong.of(0L), OptionalLong.of(0L), OptionalLong.of(0L), OptionalLong.of(0L)));
        tableParameters = Map.of("numFiles", "10", "numRows", "20", "rawDataSize", "30", "totalSize", "40", "spark.sql.statistics.numFiles", "1", "spark.sql.statistics.numRows", "2", "spark.sql.statistics.rawDataSize", "3", "spark.sql.statistics.totalSize", "4");
        actual = MetastoreUtil.getBasicStatisticsWithSparkFallback(tableParameters);
        Assertions.assertThat((Object)actual).isEqualTo((Object)new HiveBasicStatistics(OptionalLong.of(10L), OptionalLong.of(20L), OptionalLong.of(30L), OptionalLong.of(40L)));
    }

    private static HiveColumnHandle partitionColumn(String name) {
        return new HiveColumnHandle(name, 0, HiveType.HIVE_STRING, (Type)VarcharType.VARCHAR, Optional.empty(), HiveColumnHandle.ColumnType.PARTITION_KEY, Optional.empty());
    }
}

