/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.metastore;

import io.trino.metastore.BooleanStatistics;
import io.trino.metastore.DateStatistics;
import io.trino.metastore.DecimalStatistics;
import io.trino.metastore.DoubleStatistics;
import io.trino.metastore.HiveColumnStatistics;
import io.trino.metastore.HiveType;
import io.trino.metastore.IntegerStatistics;
import io.trino.plugin.hive.metastore.SparkMetastoreUtil;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalLong;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestSparkMetastoreUtil {
    @Test
    public void testSparkLongStatsToColumnStatistics() {
        Map<String, String> columnStatistics = Map.of("spark.sql.statistics.colStats.c_long.min", "1", "spark.sql.statistics.colStats.c_long.distinctCount", "4", "spark.sql.statistics.colStats.c_long.maxLen", "4", "spark.sql.statistics.colStats.c_long.avgLen", "4", "spark.sql.statistics.colStats.c_long.nullCount", "0", "spark.sql.statistics.colStats.c_long.version", "2", "spark.sql.statistics.colStats.c_long.max", "4");
        HiveColumnStatistics actualNotExists = SparkMetastoreUtil.fromMetastoreColumnStatistics((String)"c_long_not_exists", (HiveType)HiveType.HIVE_LONG, columnStatistics);
        Assertions.assertThat((Object)actualNotExists).isEqualTo((Object)HiveColumnStatistics.builder().setIntegerStatistics(new IntegerStatistics(OptionalLong.empty(), OptionalLong.empty())).build());
        HiveColumnStatistics actual = SparkMetastoreUtil.fromMetastoreColumnStatistics((String)"c_long", (HiveType)HiveType.HIVE_LONG, columnStatistics);
        Assertions.assertThat((Object)actual).isEqualTo((Object)HiveColumnStatistics.builder().setIntegerStatistics(new IntegerStatistics(OptionalLong.of(1L), OptionalLong.of(4L))).setNullsCount(0L).setDistinctValuesWithNullCount(4L).build());
    }

    @Test
    public void testSparkDoubleStatsToColumnStatistics() {
        Map<String, String> columnStatistics = Map.of("spark.sql.statistics.colStats.c_double.min", "0.3", "spark.sql.statistics.colStats.c_double.distinctCount", "10", "spark.sql.statistics.colStats.c_double.maxLen", "4", "spark.sql.statistics.colStats.c_double.avgLen", "4", "spark.sql.statistics.colStats.c_double.nullCount", "1", "spark.sql.statistics.colStats.c_double.version", "2", "spark.sql.statistics.colStats.c_double.max", "3.3");
        HiveColumnStatistics actualNotExists = SparkMetastoreUtil.fromMetastoreColumnStatistics((String)"c_double_not_exists", (HiveType)HiveType.HIVE_DOUBLE, columnStatistics);
        Assertions.assertThat((Object)actualNotExists).isEqualTo((Object)HiveColumnStatistics.builder().setDoubleStatistics(new DoubleStatistics(OptionalDouble.empty(), OptionalDouble.empty())).build());
        HiveColumnStatistics actual = SparkMetastoreUtil.fromMetastoreColumnStatistics((String)"c_double", (HiveType)HiveType.HIVE_DOUBLE, columnStatistics);
        Assertions.assertThat((Object)actual).isEqualTo((Object)HiveColumnStatistics.builder().setDoubleStatistics(new DoubleStatistics(OptionalDouble.of(0.3), OptionalDouble.of(3.3))).setNullsCount(1L).setDistinctValuesWithNullCount(10L).build());
    }

    @Test
    public void testSparkDecimalStatsToColumnStatistics() {
        Map<String, String> columnStatistics = Map.of("spark.sql.statistics.colStats.c_decimal.min", "0.3", "spark.sql.statistics.colStats.c_decimal.distinctCount", "10", "spark.sql.statistics.colStats.c_decimal.maxLen", "4", "spark.sql.statistics.colStats.c_decimal.avgLen", "4", "spark.sql.statistics.colStats.c_decimal.nullCount", "1", "spark.sql.statistics.colStats.c_decimal.version", "2", "spark.sql.statistics.colStats.c_decimal.max", "3.3");
        HiveType decimalType = HiveType.valueOf((String)"decimal");
        HiveColumnStatistics actualNotExists = SparkMetastoreUtil.fromMetastoreColumnStatistics((String)"c_decimal_not_exists", (HiveType)decimalType, columnStatistics);
        Assertions.assertThat((Object)actualNotExists).isEqualTo((Object)HiveColumnStatistics.builder().setDecimalStatistics(new DecimalStatistics(Optional.empty(), Optional.empty())).build());
        HiveColumnStatistics actual = SparkMetastoreUtil.fromMetastoreColumnStatistics((String)"c_decimal", (HiveType)decimalType, columnStatistics);
        Assertions.assertThat((Object)actual).isEqualTo((Object)HiveColumnStatistics.builder().setDecimalStatistics(new DecimalStatistics(Optional.of(new BigDecimal("0.3")), Optional.of(new BigDecimal("3.3")))).setNullsCount(1L).setDistinctValuesWithNullCount(10L).build());
    }

    @Test
    public void testSparkBooleanStatsToColumnStatistics() {
        Map<String, String> columnStatistics = Map.of("spark.sql.statistics.colStats.c_bool.min", "false", "spark.sql.statistics.colStats.c_bool.distinctCount", "2", "spark.sql.statistics.colStats.c_bool.maxLen", "1", "spark.sql.statistics.colStats.c_bool.avgLen", "1", "spark.sql.statistics.colStats.c_bool.nullCount", "1", "spark.sql.statistics.colStats.c_bool.version", "2", "spark.sql.statistics.colStats.c_bool.max", "true");
        HiveColumnStatistics actualNotExists = SparkMetastoreUtil.fromMetastoreColumnStatistics((String)"c_bool_not_exists", (HiveType)HiveType.HIVE_BOOLEAN, columnStatistics);
        Assertions.assertThat((Object)actualNotExists).isEqualTo((Object)HiveColumnStatistics.builder().setBooleanStatistics(new BooleanStatistics(OptionalLong.empty(), OptionalLong.empty())).build());
        HiveColumnStatistics actual = SparkMetastoreUtil.fromMetastoreColumnStatistics((String)"c_bool", (HiveType)HiveType.HIVE_BOOLEAN, columnStatistics);
        Assertions.assertThat((Object)actual).isEqualTo((Object)HiveColumnStatistics.builder().setBooleanStatistics(new BooleanStatistics(OptionalLong.empty(), OptionalLong.empty())).setNullsCount(1L).build());
    }

    @Test
    public void testSparkDateStatsToColumnStatistics() {
        Map<String, String> columnStatistics = Map.of("spark.sql.statistics.colStats.c_date.min", "2000-01-01", "spark.sql.statistics.colStats.c_date.distinctCount", "10", "spark.sql.statistics.colStats.c_date.maxLen", "4", "spark.sql.statistics.colStats.c_date.avgLen", "4", "spark.sql.statistics.colStats.c_date.nullCount", "3", "spark.sql.statistics.colStats.c_date.version", "2", "spark.sql.statistics.colStats.c_date.max", "2030-12-31");
        HiveColumnStatistics actualNotExists = SparkMetastoreUtil.fromMetastoreColumnStatistics((String)"c_date_not_exists", (HiveType)HiveType.HIVE_DATE, columnStatistics);
        Assertions.assertThat((Object)actualNotExists).isEqualTo((Object)HiveColumnStatistics.builder().setDateStatistics(new DateStatistics(Optional.empty(), Optional.empty())).build());
        HiveColumnStatistics actual = SparkMetastoreUtil.fromMetastoreColumnStatistics((String)"c_date", (HiveType)HiveType.HIVE_DATE, columnStatistics);
        Assertions.assertThat((Object)actual).isEqualTo((Object)HiveColumnStatistics.builder().setDateStatistics(new DateStatistics(Optional.of(LocalDate.of(2000, 1, 1)), Optional.of(LocalDate.of(2030, 12, 31)))).setNullsCount(3L).setDistinctValuesWithNullCount(10L).build());
    }

    @Test
    public void testSparkStringStatsToColumnStatistics() {
        Map<String, String> columnStatistics = Map.of("spark.sql.statistics.colStats.c_char.distinctCount", "3", "spark.sql.statistics.colStats.c_char.avgLen", "10", "spark.sql.statistics.colStats.char_col.maxLen", "10", "spark.sql.statistics.colStats.c_char.nullCount", "7", "spark.sql.statistics.colStats.c_char.version", "2");
        HiveColumnStatistics actualNotExists = SparkMetastoreUtil.fromMetastoreColumnStatistics((String)"c_char_not_exists", (HiveType)HiveType.HIVE_STRING, columnStatistics);
        Assertions.assertThat((Object)actualNotExists).isEqualTo((Object)HiveColumnStatistics.builder().build());
        HiveColumnStatistics actual = SparkMetastoreUtil.fromMetastoreColumnStatistics((String)"c_char", (HiveType)HiveType.HIVE_STRING, columnStatistics);
        Assertions.assertThat((Object)actual).isEqualTo((Object)HiveColumnStatistics.builder().setNullsCount(7L).setDistinctValuesWithNullCount(3L).setAverageColumnLength(10.0).build());
    }

    @Test
    public void testSparkBinaryStatsToColumnStatistics() {
        Map<String, String> columnStatistics = Map.of("spark.sql.statistics.colStats.c_bin.distinctCount", "7", "spark.sql.statistics.colStats.c_bin.avgLen", "10", "spark.sql.statistics.colStats.c_bin.maxLen", "10", "spark.sql.statistics.colStats.c_bin.nullCount", "3", "spark.sql.statistics.colStats.c_bin.version", "2");
        HiveColumnStatistics actualNotExists = SparkMetastoreUtil.fromMetastoreColumnStatistics((String)"c_bin_not_exists", (HiveType)HiveType.HIVE_BINARY, columnStatistics);
        Assertions.assertThat((Object)actualNotExists).isEqualTo((Object)HiveColumnStatistics.builder().build());
        HiveColumnStatistics actual = SparkMetastoreUtil.fromMetastoreColumnStatistics((String)"c_bin", (HiveType)HiveType.HIVE_BINARY, columnStatistics);
        Assertions.assertThat((Object)actual).isEqualTo((Object)HiveColumnStatistics.builder().setNullsCount(3L).setAverageColumnLength(10.0).setMaxValueSizeInBytes(10L).build());
    }
}

