/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.metastore.cache;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import io.airlift.concurrent.Threads;
import io.airlift.slice.Slices;
import io.airlift.units.Duration;
import io.trino.hive.thrift.metastore.ColumnStatisticsData;
import io.trino.hive.thrift.metastore.ColumnStatisticsObj;
import io.trino.hive.thrift.metastore.LockState;
import io.trino.hive.thrift.metastore.LongColumnStatsData;
import io.trino.metastore.AcidTransactionOwner;
import io.trino.metastore.Database;
import io.trino.metastore.HiveBasicStatistics;
import io.trino.metastore.HiveColumnStatistics;
import io.trino.metastore.HiveMetastore;
import io.trino.metastore.HivePrincipal;
import io.trino.metastore.HiveType;
import io.trino.metastore.Partition;
import io.trino.metastore.PartitionStatistics;
import io.trino.metastore.StatisticsUpdateMode;
import io.trino.metastore.Table;
import io.trino.metastore.TableInfo;
import io.trino.metastore.cache.CachingHiveMetastore;
import io.trino.plugin.base.util.AutoCloseableCloser;
import io.trino.plugin.hive.HiveColumnHandle;
import io.trino.plugin.hive.TestingThriftHiveMetastoreBuilder;
import io.trino.plugin.hive.metastore.MetastoreUtil;
import io.trino.plugin.hive.metastore.thrift.BridgingHiveMetastore;
import io.trino.plugin.hive.metastore.thrift.MockThriftMetastoreClient;
import io.trino.plugin.hive.metastore.thrift.ThriftHiveMetastore;
import io.trino.plugin.hive.metastore.thrift.ThriftMetastore;
import io.trino.plugin.hive.metastore.thrift.ThriftMetastoreClient;
import io.trino.plugin.hive.metastore.thrift.ThriftMetastoreStats;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.predicate.Domain;
import io.trino.spi.predicate.Range;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.predicate.ValueSet;
import io.trino.spi.security.PrincipalType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.apache.thrift.TException;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.MapAssert;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.RepeatedTest;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Execution(value=ExecutionMode.SAME_THREAD)
public class TestCachingHiveMetastore {
    private static final HiveBasicStatistics TEST_BASIC_STATS = new HiveBasicStatistics(OptionalLong.empty(), OptionalLong.of(2398040535435L), OptionalLong.empty(), OptionalLong.empty());
    private static final Map<String, HiveColumnStatistics> TEST_COLUMN_STATS = ImmutableMap.of((Object)"column", (Object)HiveColumnStatistics.createIntegerColumnStatistics((OptionalLong)OptionalLong.empty(), (OptionalLong)OptionalLong.empty(), (OptionalLong)OptionalLong.empty(), (OptionalLong)OptionalLong.empty()));
    private static final PartitionStatistics TEST_STATS = PartitionStatistics.builder().setBasicStatistics(TEST_BASIC_STATS).setColumnStatistics(TEST_COLUMN_STATS).build();
    private static final SchemaTableName TEST_SCHEMA_TABLE = new SchemaTableName("testdb", "testtbl");
    private static final TableInfo TEST_TABLE_INFO = new TableInfo(TEST_SCHEMA_TABLE, TableInfo.ExtendedRelationType.TABLE);
    private static final Duration CACHE_TTL = new Duration(5.0, TimeUnit.MINUTES);
    private AutoCloseableCloser closer;
    private MockThriftMetastoreClient mockClient;
    private ThriftMetastore thriftHiveMetastore;
    private ListeningExecutorService executor;
    private CachingHiveMetastore metastore;
    private CachingHiveMetastore statsOnlyCacheMetastore;
    private ThriftMetastoreStats stats;

    @BeforeEach
    public void setUp() {
        this.closer = AutoCloseableCloser.create();
        this.mockClient = new MockThriftMetastoreClient();
        this.thriftHiveMetastore = this.createThriftHiveMetastore();
        this.executor = MoreExecutors.listeningDecorator((ExecutorService)Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)(this.getClass().getSimpleName() + "-%s"))));
        this.metastore = TestCachingHiveMetastore.createCachingHiveMetastore((HiveMetastore)new BridgingHiveMetastore(this.thriftHiveMetastore), CACHE_TTL, true, true, (Executor)this.executor);
        this.statsOnlyCacheMetastore = TestCachingHiveMetastore.createCachingHiveMetastore((HiveMetastore)new BridgingHiveMetastore(this.thriftHiveMetastore), Duration.ZERO, true, true, (Executor)this.executor);
        this.stats = ((ThriftHiveMetastore)this.thriftHiveMetastore).getStats();
    }

    @AfterAll
    public void tearDown() throws Exception {
        this.executor.shutdownNow();
        this.executor = null;
        this.metastore = null;
        this.closer.close();
        this.closer = null;
    }

    private ThriftMetastore createThriftHiveMetastore() {
        return this.createThriftHiveMetastore(this.mockClient);
    }

    private ThriftMetastore createThriftHiveMetastore(ThriftMetastoreClient client) {
        return TestingThriftHiveMetastoreBuilder.testingThriftHiveMetastoreBuilder().metastoreClient(client).build(arg_0 -> ((AutoCloseableCloser)this.closer).register(arg_0));
    }

    @Test
    public void testCachingWithOnlyPartitionsCacheEnabled() {
        this.assertThatCachingWithDisabledPartitionCache().whenExecuting(CachingHiveMetastore::getAllDatabases).usesCache();
        this.assertThatCachingWithDisabledPartitionCache().whenExecuting(testedMetastore -> testedMetastore.getTables("testdb")).usesCache();
        this.assertThatCachingWithDisabledPartitionCache().whenExecuting(testedMetastore -> testedMetastore.getTable("testdb", "testtbl")).usesCache();
        this.assertThatCachingWithDisabledPartitionCache().whenExecuting(testedMetastore -> testedMetastore.getPartitionNamesByFilter("testdb", "testtbl", MockThriftMetastoreClient.PARTITION_COLUMN_NAMES, TupleDomain.all())).doesNotUseCache();
        this.assertThatCachingWithDisabledPartitionCache().whenExecuting(testedMetastore -> {
            Optional table = testedMetastore.getTable("testdb", "testtbl");
            testedMetastore.getPartition((Table)table.orElseThrow(), MockThriftMetastoreClient.TEST_PARTITION_VALUES1);
        }).omitsCacheForNumberOfOperations(1);
        this.assertThatCachingWithDisabledPartitionCache().whenExecuting(testedMetastore -> {
            Optional table = testedMetastore.getTable("testdb", "testtbl");
            testedMetastore.getPartitionsByNames((Table)table.orElseThrow(), MockThriftMetastoreClient.TEST_PARTITION_VALUES1);
        }).omitsCacheForNumberOfOperations(1);
    }

    @Test
    public void testGetAllDatabases() {
        Assertions.assertThat((int)this.mockClient.getAccessCount()).isEqualTo(0);
        Assertions.assertThat((List)this.metastore.getAllDatabases()).isEqualTo((Object)ImmutableList.of((Object)"testdb"));
        Assertions.assertThat((int)this.mockClient.getAccessCount()).isEqualTo(1);
        Assertions.assertThat((List)this.metastore.getAllDatabases()).isEqualTo((Object)ImmutableList.of((Object)"testdb"));
        Assertions.assertThat((int)this.mockClient.getAccessCount()).isEqualTo(1);
        Assertions.assertThat((long)this.metastore.getDatabaseNamesStats().getRequestCount()).isEqualTo(2L);
        Assertions.assertThat((Double)this.metastore.getDatabaseNamesStats().getHitRate()).isEqualTo(0.5);
        this.metastore.flushCache();
        Assertions.assertThat((List)this.metastore.getAllDatabases()).isEqualTo((Object)ImmutableList.of((Object)"testdb"));
        Assertions.assertThat((int)this.mockClient.getAccessCount()).isEqualTo(2);
        Assertions.assertThat((long)this.metastore.getDatabaseNamesStats().getRequestCount()).isEqualTo(3L);
        Assertions.assertThat((Double)this.metastore.getDatabaseNamesStats().getHitRate()).isEqualTo(0.3333333333333333);
    }

    @Test
    public void testGetAllTable() {
        Assertions.assertThat((int)this.mockClient.getAccessCount()).isEqualTo(0);
        Assertions.assertThat((List)this.metastore.getTables("testdb")).isEqualTo((Object)ImmutableList.of((Object)TEST_TABLE_INFO));
        Assertions.assertThat((int)this.mockClient.getAccessCount()).isEqualTo(1);
        Assertions.assertThat((List)this.metastore.getTables("testdb")).isEqualTo((Object)ImmutableList.of((Object)TEST_TABLE_INFO));
        Assertions.assertThat((int)this.mockClient.getAccessCount()).isEqualTo(1);
        Assertions.assertThat((long)this.metastore.getTableNamesStats().getRequestCount()).isEqualTo(2L);
        Assertions.assertThat((Double)this.metastore.getTableNamesStats().getHitRate()).isEqualTo(0.5);
        this.metastore.flushCache();
        Assertions.assertThat((List)this.metastore.getTables("testdb")).isEqualTo((Object)ImmutableList.of((Object)TEST_TABLE_INFO));
        Assertions.assertThat((int)this.mockClient.getAccessCount()).isEqualTo(2);
        Assertions.assertThat((long)this.metastore.getTableNamesStats().getRequestCount()).isEqualTo(3L);
        Assertions.assertThat((Double)this.metastore.getTableNamesStats().getHitRate()).isEqualTo(0.3333333333333333);
    }

    @Test
    public void testInvalidDbGetAllTAbles() {
        Assertions.assertThat((List)this.metastore.getTables("baddb")).isEmpty();
    }

    @Test
    public void testGetTable() {
        Assertions.assertThat((int)this.mockClient.getAccessCount()).isEqualTo(0);
        Assertions.assertThat((Optional)this.metastore.getTable("testdb", "testtbl")).isNotNull();
        Assertions.assertThat((int)this.mockClient.getAccessCount()).isEqualTo(1);
        Assertions.assertThat((Optional)this.metastore.getTable("testdb", "testtbl")).isNotNull();
        Assertions.assertThat((int)this.mockClient.getAccessCount()).isEqualTo(1);
        Assertions.assertThat((long)this.metastore.getTableStats().getRequestCount()).isEqualTo(2L);
        Assertions.assertThat((Double)this.metastore.getTableStats().getHitRate()).isEqualTo(0.5);
        this.metastore.flushCache();
        Assertions.assertThat((Optional)this.metastore.getTable("testdb", "testtbl")).isNotNull();
        Assertions.assertThat((int)this.mockClient.getAccessCount()).isEqualTo(2);
        Assertions.assertThat((long)this.metastore.getTableStats().getRequestCount()).isEqualTo(3L);
        Assertions.assertThat((Double)this.metastore.getTableStats().getHitRate()).isEqualTo(0.3333333333333333);
    }

    @Test
    public void testSetTableAuthorization() {
        Assertions.assertThat((int)this.mockClient.getAccessCount()).isEqualTo(0);
        Assertions.assertThat((Optional)this.metastore.getTable("testdb", "testtbl")).isNotNull();
        Assertions.assertThat((Optional)this.metastore.getDatabase("testdb")).isNotNull();
        Assertions.assertThat((int)this.mockClient.getAccessCount()).isEqualTo(2);
        this.metastore.setTableOwner("testdb", "testtbl", new HivePrincipal(PrincipalType.USER, "ignore"));
        Assertions.assertThat((int)this.mockClient.getAccessCount()).isEqualTo(3);
        Assertions.assertThat((Optional)this.metastore.getTable("testdb", "testtbl")).isNotNull();
        Assertions.assertThat((int)this.mockClient.getAccessCount()).isEqualTo(4);
        Assertions.assertThat((Optional)this.metastore.getDatabase("testdb")).isNotNull();
        Assertions.assertThat((int)this.mockClient.getAccessCount()).isEqualTo(4);
    }

    @Test
    public void testInvalidDbGetTable() {
        Assertions.assertThat((Optional)this.metastore.getTable("baddb", "testtbl")).isEmpty();
        Assertions.assertThat((long)this.stats.getGetTable().getThriftExceptions().getTotalCount()).isEqualTo(0L);
        Assertions.assertThat((long)this.stats.getGetTable().getTotalFailures().getTotalCount()).isEqualTo(0L);
    }

    @Test
    public void testGetPartitionNames() {
        ImmutableList expectedPartitions = ImmutableList.of((Object)"key=testpartition1", (Object)"key=testpartition2", (Object)"key=testpartition3");
        Assertions.assertThat((int)this.mockClient.getAccessCount()).isEqualTo(0);
        Assertions.assertThat((List)((List)this.metastore.getPartitionNamesByFilter("testdb", "testtbl", MockThriftMetastoreClient.PARTITION_COLUMN_NAMES, TupleDomain.all()).orElseThrow())).isEqualTo((Object)expectedPartitions);
        Assertions.assertThat((int)this.mockClient.getAccessCount()).isEqualTo(1);
        Assertions.assertThat((List)((List)this.metastore.getPartitionNamesByFilter("testdb", "testtbl", MockThriftMetastoreClient.PARTITION_COLUMN_NAMES, TupleDomain.all()).orElseThrow())).isEqualTo((Object)expectedPartitions);
        Assertions.assertThat((int)this.mockClient.getAccessCount()).isEqualTo(1);
        this.metastore.flushCache();
        Assertions.assertThat((List)((List)this.metastore.getPartitionNamesByFilter("testdb", "testtbl", MockThriftMetastoreClient.PARTITION_COLUMN_NAMES, TupleDomain.all()).orElseThrow())).isEqualTo((Object)expectedPartitions);
        Assertions.assertThat((int)this.mockClient.getAccessCount()).isEqualTo(2);
    }

    @Test
    public void testGetPartitionThenGetPartitions() {
        Table table = (Table)this.metastore.getTable("testdb", "testtbl").orElseThrow();
        Optional firstRead = this.metastore.getPartition(table, List.of("testpartition1"));
        Assertions.assertThat((Optional)firstRead).isPresent();
        Assertions.assertThat((List)((Partition)firstRead.get()).getValues()).isEqualTo(List.of("testpartition1"));
        Map byName = this.metastore.getPartitionsByNames(table, List.of("key=testpartition1"));
        Assertions.assertThat((Map)byName).containsOnlyKeys((Object[])new String[]{"key=testpartition1"});
        Optional secondRead = (Optional)byName.get("key=testpartition1");
        Assertions.assertThat((Optional)secondRead).isPresent();
        Assertions.assertThat((List)((Partition)secondRead.get()).getValues()).isEqualTo(List.of("testpartition1"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RepeatedTest(value=20)
    @Timeout(value=60L)
    public void testGetPartitionThenGetPartitionsRacingWithInvalidation() throws Exception {
        Table table = (Table)this.metastore.getTable("testdb", "testtbl").orElseThrow();
        Optional firstRead = this.metastore.getPartition(table, List.of("testpartition1"));
        Assertions.assertThat((Optional)firstRead).isPresent();
        Assertions.assertThat((List)((Partition)firstRead.get()).getValues()).isEqualTo(List.of("testpartition1"));
        ExecutorService executor = Executors.newFixedThreadPool(2);
        try {
            CyclicBarrier barrier = new CyclicBarrier(2);
            Future<Object> invalidation = executor.submit(() -> {
                barrier.await(10L, TimeUnit.SECONDS);
                this.metastore.flushCache();
                return null;
            });
            Future<Map> read = executor.submit(() -> {
                barrier.await(10L, TimeUnit.SECONDS);
                return this.metastore.getPartitionsByNames(table, List.of("key=testpartition1"));
            });
            Map byName = read.get();
            Assertions.assertThat((Map)byName).containsOnlyKeys((Object[])new String[]{"key=testpartition1"});
            Optional secondRead = (Optional)byName.get("key=testpartition1");
            Assertions.assertThat((Optional)secondRead).isPresent();
            Assertions.assertThat((List)((Partition)secondRead.get()).getValues()).isEqualTo(List.of("testpartition1"));
            invalidation.get();
        }
        finally {
            executor.shutdownNow();
        }
    }

    @Test
    public void testInvalidGetPartitionNamesByFilterAll() {
        Assertions.assertThat((Optional)this.metastore.getPartitionNamesByFilter("baddb", "testtbl", MockThriftMetastoreClient.PARTITION_COLUMN_NAMES, TupleDomain.all())).isEmpty();
    }

    @Test
    public void testGetPartitionNamesByParts() {
        ImmutableList expectedPartitions = ImmutableList.of((Object)"key=testpartition1", (Object)"key=testpartition2", (Object)"key=testpartition3");
        Assertions.assertThat((int)this.mockClient.getAccessCount()).isEqualTo(0);
        Assertions.assertThat((List)((List)this.metastore.getPartitionNamesByFilter("testdb", "testtbl", MockThriftMetastoreClient.PARTITION_COLUMN_NAMES, TupleDomain.all()).orElseThrow())).isEqualTo((Object)expectedPartitions);
        Assertions.assertThat((int)this.mockClient.getAccessCount()).isEqualTo(1);
        Assertions.assertThat((List)((List)this.metastore.getPartitionNamesByFilter("testdb", "testtbl", MockThriftMetastoreClient.PARTITION_COLUMN_NAMES, TupleDomain.all()).orElseThrow())).isEqualTo((Object)expectedPartitions);
        Assertions.assertThat((int)this.mockClient.getAccessCount()).isEqualTo(1);
        Assertions.assertThat((long)this.metastore.getPartitionFilterStats().getRequestCount()).isEqualTo(2L);
        Assertions.assertThat((Double)this.metastore.getPartitionFilterStats().getHitRate()).isEqualTo(0.5);
        this.metastore.flushCache();
        Assertions.assertThat((List)((List)this.metastore.getPartitionNamesByFilter("testdb", "testtbl", MockThriftMetastoreClient.PARTITION_COLUMN_NAMES, TupleDomain.all()).orElseThrow())).isEqualTo((Object)expectedPartitions);
        Assertions.assertThat((int)this.mockClient.getAccessCount()).isEqualTo(2);
        Assertions.assertThat((long)this.metastore.getPartitionFilterStats().getRequestCount()).isEqualTo(3L);
        Assertions.assertThat((Double)this.metastore.getPartitionFilterStats().getHitRate()).isEqualTo(0.3333333333333333);
        ImmutableList partitionColumnNames = ImmutableList.of((Object)"date_key", (Object)"key");
        HiveColumnHandle dateKeyColumn = HiveColumnHandle.createBaseColumn((String)((String)partitionColumnNames.get(0)), (int)0, (HiveType)HiveType.HIVE_STRING, (Type)VarcharType.VARCHAR, (HiveColumnHandle.ColumnType)HiveColumnHandle.ColumnType.PARTITION_KEY, Optional.empty());
        HiveColumnHandle keyColumn = HiveColumnHandle.createBaseColumn((String)((String)partitionColumnNames.get(1)), (int)1, (HiveType)HiveType.HIVE_STRING, (Type)VarcharType.VARCHAR, (HiveColumnHandle.ColumnType)HiveColumnHandle.ColumnType.PARTITION_KEY, Optional.empty());
        ImmutableList partitionColumns = ImmutableList.of((Object)dateKeyColumn, (Object)keyColumn);
        TupleDomain withNoFilter = MetastoreUtil.computePartitionKeyFilter((List)partitionColumns, (TupleDomain)TupleDomain.all());
        TupleDomain withSingleValueFilter = MetastoreUtil.computePartitionKeyFilter((List)partitionColumns, (TupleDomain)TupleDomain.withColumnDomains((Map)ImmutableMap.builder().put((Object)dateKeyColumn, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.greaterThan((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"2020-10-01")), (Range[])new Range[0]), (boolean)false)).put((Object)keyColumn, (Object)Domain.create((ValueSet)ValueSet.of((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"val"), (Object[])new Object[0]), (boolean)false)).buildOrThrow()));
        TupleDomain withNoSingleValueFilter = MetastoreUtil.computePartitionKeyFilter((List)partitionColumns, (TupleDomain)TupleDomain.withColumnDomains((Map)ImmutableMap.builder().put((Object)dateKeyColumn, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.greaterThan((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"2020-10-01")), (Range[])new Range[0]), (boolean)false)).put((Object)keyColumn, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.range((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"val1"), (boolean)true, (Object)Slices.utf8Slice((String)"val2"), (boolean)true), (Range[])new Range[0]), (boolean)false)).buildOrThrow()));
        Assertions.assertThat((double)this.stats.getGetPartitionNamesByParts().getTime().getAllTime().getCount()).isEqualTo(0.0);
        this.metastore.getPartitionNamesByFilter("testdb", "testtbl", (List)partitionColumnNames, withNoFilter);
        Assertions.assertThat((double)this.stats.getGetPartitionNamesByParts().getTime().getAllTime().getCount()).isEqualTo(0.0);
        this.metastore.getPartitionNamesByFilter("testdb", "testtbl", (List)partitionColumnNames, withSingleValueFilter);
        Assertions.assertThat((double)this.stats.getGetPartitionNamesByParts().getTime().getAllTime().getCount()).isEqualTo(1.0);
        this.metastore.getPartitionNamesByFilter("testdb", "testtbl", (List)partitionColumnNames, withNoSingleValueFilter);
        Assertions.assertThat((double)this.stats.getGetPartitionNamesByParts().getTime().getAllTime().getCount()).isEqualTo(2.0);
    }

    @Test
    public void testInvalidGetPartitionNamesByParts() {
        Assertions.assertThat((Optional)this.metastore.getPartitionNamesByFilter("baddb", "testtbl", MockThriftMetastoreClient.PARTITION_COLUMN_NAMES, TupleDomain.all())).isEmpty();
    }

    @Test
    public void testGetPartitionsByNames() {
        Assertions.assertThat((int)this.mockClient.getAccessCount()).isEqualTo(0);
        Table table = (Table)this.metastore.getTable("testdb", "testtbl").orElseThrow();
        Assertions.assertThat((int)this.mockClient.getAccessCount()).isEqualTo(1);
        Assertions.assertThat((Map)this.metastore.getPartitionsByNames(table, (List)ImmutableList.of((Object)"key=testpartition1"))).hasSize(1);
        Assertions.assertThat((int)this.mockClient.getAccessCount()).isEqualTo(2);
        Assertions.assertThat((Map)this.metastore.getPartitionsByNames(table, (List)ImmutableList.of((Object)"key=testpartition1", (Object)"key=testpartition2"))).hasSize(2);
        Assertions.assertThat((int)this.mockClient.getAccessCount()).isEqualTo(3);
        Assertions.assertThat((Map)this.metastore.getPartitionsByNames(table, (List)ImmutableList.of((Object)"key=testpartition1"))).hasSize(1);
        Assertions.assertThat((Map)this.metastore.getPartitionsByNames(table, (List)ImmutableList.of((Object)"key=testpartition2"))).hasSize(1);
        Assertions.assertThat((Map)this.metastore.getPartitionsByNames(table, (List)ImmutableList.of((Object)"key=testpartition1", (Object)"key=testpartition2"))).hasSize(2);
        Assertions.assertThat((int)this.mockClient.getAccessCount()).isEqualTo(3);
        this.metastore.flushCache();
        Assertions.assertThat((Map)this.metastore.getPartitionsByNames(table, (List)ImmutableList.of((Object)"key=testpartition1", (Object)"key=testpartition2"))).hasSize(2);
        Assertions.assertThat((int)this.mockClient.getAccessCount()).isEqualTo(4);
    }

    @Test
    public void testListRoles() {
        Assertions.assertThat((int)this.mockClient.getAccessCount()).isEqualTo(0);
        Assertions.assertThat((Collection)this.metastore.listRoles()).containsExactlyElementsOf(MockThriftMetastoreClient.TEST_ROLES);
        Assertions.assertThat((int)this.mockClient.getAccessCount()).isEqualTo(1);
        Assertions.assertThat((Collection)this.metastore.listRoles()).containsExactlyElementsOf(MockThriftMetastoreClient.TEST_ROLES);
        Assertions.assertThat((int)this.mockClient.getAccessCount()).isEqualTo(1);
        Assertions.assertThat((long)this.metastore.getRolesStats().getRequestCount()).isEqualTo(2L);
        Assertions.assertThat((Double)this.metastore.getRolesStats().getHitRate()).isEqualTo(0.5);
        this.metastore.flushCache();
        Assertions.assertThat((Collection)this.metastore.listRoles()).containsExactlyElementsOf(MockThriftMetastoreClient.TEST_ROLES);
        Assertions.assertThat((int)this.mockClient.getAccessCount()).isEqualTo(2);
        this.metastore.createRole("role", "grantor");
        Assertions.assertThat((Collection)this.metastore.listRoles()).containsExactlyElementsOf(MockThriftMetastoreClient.TEST_ROLES);
        Assertions.assertThat((int)this.mockClient.getAccessCount()).isEqualTo(3);
        this.metastore.dropRole("testrole");
        Assertions.assertThat((Collection)this.metastore.listRoles()).containsExactlyElementsOf(MockThriftMetastoreClient.TEST_ROLES);
        Assertions.assertThat((int)this.mockClient.getAccessCount()).isEqualTo(4);
        Assertions.assertThat((long)this.metastore.getRolesStats().getRequestCount()).isEqualTo(5L);
        Assertions.assertThat((Double)this.metastore.getRolesStats().getHitRate()).isEqualTo(0.2);
    }

    @Test
    public void testGetTableStatistics() {
        Assertions.assertThat((int)this.mockClient.getAccessCount()).isEqualTo(0);
        Assertions.assertThat((Optional)this.metastore.getTable("testdb", "testtbl")).isPresent();
        Assertions.assertThat((int)this.mockClient.getAccessCount()).isEqualTo(1);
        Assertions.assertThat((Map)this.metastore.getTableColumnStatistics("testdb", "testtbl", TEST_COLUMN_STATS.keySet())).isEqualTo(TEST_COLUMN_STATS);
        Assertions.assertThat((int)this.mockClient.getAccessCount()).isEqualTo(2);
        Assertions.assertThat((Map)this.metastore.getTableColumnStatistics("testdb", "testtbl", TEST_COLUMN_STATS.keySet())).isEqualTo(TEST_COLUMN_STATS);
        Assertions.assertThat((int)this.mockClient.getAccessCount()).isEqualTo(2);
        Assertions.assertThat((long)this.metastore.getTableColumnStatisticsStats().getRequestCount()).isEqualTo(2L);
        Assertions.assertThat((Double)this.metastore.getTableColumnStatisticsStats().getHitRate()).isEqualTo(0.5);
        Assertions.assertThat((long)this.metastore.getTableStats().getRequestCount()).isEqualTo(1L);
        Assertions.assertThat((Double)this.metastore.getTableStats().getHitRate()).isEqualTo(0.0);
        Assertions.assertThatThrownBy(() -> this.metastore.getTableColumnStatistics("testdb", "testtbl", (Set)ImmutableSet.of())).isInstanceOf(IllegalArgumentException.class);
        Assertions.assertThat((long)this.metastore.getTableColumnStatisticsStats().getRequestCount()).isEqualTo(2L);
        Assertions.assertThat((Double)this.metastore.getTableColumnStatisticsStats().getHitRate()).isEqualTo(0.5);
        this.mockClient.mockColumnStats("testdb", "testtbl", (Map<String, ColumnStatisticsData>)ImmutableMap.of((Object)"col1", (Object)ColumnStatisticsData.longStats((LongColumnStatsData)new LongColumnStatsData().setNumNulls(1L)), (Object)"col2", (Object)ColumnStatisticsData.longStats((LongColumnStatsData)new LongColumnStatsData().setNumNulls(2L)), (Object)"col3", (Object)ColumnStatisticsData.longStats((LongColumnStatsData)new LongColumnStatsData().setNumNulls(3L))));
        Assertions.assertThat((Map)this.metastore.getTableColumnStatistics("testdb", "testtbl", (Set)ImmutableSet.of((Object)"col1"))).containsEntry((Object)"col1", (Object)TestCachingHiveMetastore.intColumnStats(1));
        Assertions.assertThat((Map)this.metastore.getTableColumnStatistics("testdb", "testtbl", (Set)ImmutableSet.of((Object)"col2"))).containsEntry((Object)"col2", (Object)TestCachingHiveMetastore.intColumnStats(2));
        ((MapAssert)Assertions.assertThat((Map)this.metastore.getTableColumnStatistics("testdb", "testtbl", (Set)ImmutableSet.of((Object)"col2", (Object)"col3"))).containsEntry((Object)"col2", (Object)TestCachingHiveMetastore.intColumnStats(2))).containsEntry((Object)"col3", (Object)TestCachingHiveMetastore.intColumnStats(3));
        this.metastore.getTableColumnStatistics("testdb", "testtbl", (Set)ImmutableSet.of((Object)"column"));
        Assertions.assertThat((int)this.mockClient.getAccessCount()).isEqualTo(5);
        ColumnStatisticsData newStats = new ColumnStatisticsData();
        newStats.setLongStats(new LongColumnStatsData(327843L, 4324L));
        this.mockClient.mockColumnStats("testdb", "testtbl", (Map<String, ColumnStatisticsData>)ImmutableMap.of((Object)"column", (Object)newStats));
        this.metastore.invalidateTable("testdb", "testtbl");
        Assertions.assertThat((Map)this.metastore.getTableColumnStatistics("testdb", "testtbl", (Set)ImmutableSet.of((Object)"column"))).isEqualTo((Object)ImmutableMap.of((Object)"column", (Object)HiveColumnStatistics.createIntegerColumnStatistics((OptionalLong)OptionalLong.empty(), (OptionalLong)OptionalLong.empty(), (OptionalLong)OptionalLong.of(newStats.getLongStats().getNumNulls()), (OptionalLong)OptionalLong.of(newStats.getLongStats().getNumDVs()))));
        Assertions.assertThat((int)this.mockClient.getAccessCount()).isEqualTo(6);
    }

    @Test
    public void testGetTableStatisticsWithEmptyColumnStats() {
        Assertions.assertThat((int)this.mockClient.getAccessCount()).isEqualTo(0);
        Assertions.assertThat((Optional)this.metastore.getTable("testdb", "testtbl")).isPresent();
        Assertions.assertThat((int)this.mockClient.getAccessCount()).isEqualTo(1);
        this.mockClient.mockColumnStats("testdb", "testtbl", (Map<String, ColumnStatisticsData>)ImmutableMap.of());
        Assertions.assertThat((Map)this.metastore.getTableColumnStatistics("testdb", "testtbl", (Set)ImmutableSet.of((Object)"column"))).isEmpty();
        Assertions.assertThat((int)this.mockClient.getAccessCount()).isEqualTo(2);
        Assertions.assertThat((Map)this.metastore.getTableColumnStatistics("testdb", "testtbl", (Set)ImmutableSet.of((Object)"column"))).isEmpty();
        Assertions.assertThat((int)this.mockClient.getAccessCount()).isEqualTo(2);
    }

    @Test
    public void testTableStatisticsWithEmptyColumnStatsWithNoCacheMissing() {
        CachingHiveMetastore metastore = TestCachingHiveMetastore.createCachingHiveMetastore((HiveMetastore)new BridgingHiveMetastore(this.thriftHiveMetastore), CACHE_TTL, false, true, (Executor)this.executor);
        Assertions.assertThat((int)this.mockClient.getAccessCount()).isEqualTo(0);
        Assertions.assertThat((Optional)metastore.getTable("testdb", "testtbl")).isPresent();
        Assertions.assertThat((int)this.mockClient.getAccessCount()).isEqualTo(1);
        this.mockClient.mockColumnStats("testdb", "testtbl", (Map<String, ColumnStatisticsData>)ImmutableMap.of());
        Assertions.assertThat((Map)metastore.getTableColumnStatistics("testdb", "testtbl", (Set)ImmutableSet.of((Object)"column"))).isEmpty();
        Assertions.assertThat((int)this.mockClient.getAccessCount()).isEqualTo(2);
        Assertions.assertThat((Map)metastore.getTableColumnStatistics("testdb", "testtbl", (Set)ImmutableSet.of((Object)"column"))).isEmpty();
        Assertions.assertThat((int)this.mockClient.getAccessCount()).isEqualTo(3);
    }

    @Test
    public void testGetTableStatisticsWithoutMetadataCache() {
        Assertions.assertThat((int)this.mockClient.getAccessCount()).isEqualTo(0);
        Assertions.assertThat((Optional)this.statsOnlyCacheMetastore.getTable("testdb", "testtbl")).isPresent();
        Assertions.assertThat((int)this.mockClient.getAccessCount()).isEqualTo(1);
        Assertions.assertThat((Map)this.statsOnlyCacheMetastore.getTableColumnStatistics("testdb", "testtbl", (Set)ImmutableSet.of((Object)"column"))).isEqualTo(TEST_COLUMN_STATS);
        Assertions.assertThat((int)this.mockClient.getAccessCount()).isEqualTo(2);
        Assertions.assertThat((Map)this.statsOnlyCacheMetastore.getTableColumnStatistics("testdb", "testtbl", (Set)ImmutableSet.of((Object)"column"))).isEqualTo(TEST_COLUMN_STATS);
        Assertions.assertThat((int)this.mockClient.getAccessCount()).isEqualTo(2);
        Assertions.assertThat((long)this.statsOnlyCacheMetastore.getTableColumnStatisticsStats().getRequestCount()).isEqualTo(2L);
        Assertions.assertThat((Double)this.statsOnlyCacheMetastore.getTableColumnStatisticsStats().getHitRate()).isEqualTo(0.5);
        Assertions.assertThat((long)this.statsOnlyCacheMetastore.getTableStats().getRequestCount()).isEqualTo(0L);
        Assertions.assertThat((Double)this.statsOnlyCacheMetastore.getTableStats().getHitRate()).isEqualTo(1.0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInvalidateWithLoadInProgress() throws Exception {
        final CountDownLatch loadInProgress = new CountDownLatch(1);
        final CountDownLatch invalidateDone = new CountDownLatch(1);
        MockThriftMetastoreClient mockClient = new MockThriftMetastoreClient(this){

            @Override
            public List<ColumnStatisticsObj> getTableColumnStatistics(String databaseName, String tableName, List<String> columnNames) throws TException {
                loadInProgress.countDown();
                List<ColumnStatisticsObj> result = super.getTableColumnStatistics(databaseName, tableName, columnNames);
                try {
                    invalidateDone.await(10L, TimeUnit.SECONDS);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                return result;
            }
        };
        CachingHiveMetastore metastore = TestCachingHiveMetastore.createCachingHiveMetastore((HiveMetastore)new BridgingHiveMetastore(this.createThriftHiveMetastore(mockClient)), CACHE_TTL, true, true, (Executor)this.executor);
        Assertions.assertThat((Optional)metastore.getTable("testdb", "testtbl")).isPresent();
        ExecutorService executorService = Executors.newFixedThreadPool(1, Threads.daemonThreadsNamed((String)"invalidation-%d"));
        try {
            Future<?> invalidateFuture = executorService.submit(() -> {
                try {
                    loadInProgress.await(10L, TimeUnit.SECONDS);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                metastore.flushCache();
                invalidateDone.countDown();
            });
            Assertions.assertThat((Map)metastore.getTableColumnStatistics("testdb", "testtbl", TEST_COLUMN_STATS.keySet())).isEqualTo(TEST_COLUMN_STATS);
            Assertions.assertThat((int)mockClient.getAccessCount()).isEqualTo(2);
            Assertions.assertThat((Map)metastore.getTableColumnStatistics("testdb", "testtbl", TEST_COLUMN_STATS.keySet())).isEqualTo(TEST_COLUMN_STATS);
            Assertions.assertThat((int)mockClient.getAccessCount()).isEqualTo(3);
            invalidateFuture.get(1L, TimeUnit.SECONDS);
        }
        finally {
            executorService.shutdownNow();
        }
    }

    @Test
    public void testGetPartitionStatistics() {
        Assertions.assertThat((int)this.mockClient.getAccessCount()).isEqualTo(0);
        Table table = (Table)this.metastore.getTable("testdb", "testtbl").orElseThrow();
        Assertions.assertThat((int)this.mockClient.getAccessCount()).isEqualTo(1);
        Partition partition = (Partition)this.metastore.getPartition(table, MockThriftMetastoreClient.TEST_PARTITION_VALUES1).orElseThrow();
        String partitionName = MetastoreUtil.makePartitionName((Table)table, (Partition)partition);
        Partition partition2 = (Partition)this.metastore.getPartition(table, MockThriftMetastoreClient.TEST_PARTITION_VALUES2).orElseThrow();
        String partition2Name = MetastoreUtil.makePartitionName((Table)table, (Partition)partition2);
        Partition partition3 = (Partition)this.metastore.getPartition(table, MockThriftMetastoreClient.TEST_PARTITION_VALUES3).orElseThrow();
        String partition3Name = MetastoreUtil.makePartitionName((Table)table, (Partition)partition3);
        Assertions.assertThat((int)this.mockClient.getAccessCount()).isEqualTo(4);
        Assertions.assertThat((Map)this.metastore.getPartitionColumnStatistics("testdb", "testtbl", (Set)ImmutableSet.of((Object)"key=testpartition1"), (Set)ImmutableSet.of((Object)"column"))).isEqualTo((Object)ImmutableMap.of((Object)"key=testpartition1", TEST_COLUMN_STATS));
        Assertions.assertThat((int)this.mockClient.getAccessCount()).isEqualTo(5);
        Assertions.assertThat((long)this.metastore.getPartitionStatisticsStats().getRequestCount()).isEqualTo(1L);
        Assertions.assertThat((Map)this.metastore.getPartitionColumnStatistics("testdb", "testtbl", (Set)ImmutableSet.of((Object)"key=testpartition1"), (Set)ImmutableSet.of((Object)"column"))).isEqualTo((Object)ImmutableMap.of((Object)"key=testpartition1", TEST_COLUMN_STATS));
        Assertions.assertThat((int)this.mockClient.getAccessCount()).isEqualTo(5);
        Assertions.assertThat((long)this.metastore.getPartitionStatisticsStats().getRequestCount()).isEqualTo(2L);
        Assertions.assertThat((Double)this.metastore.getPartitionStatisticsStats().getHitRate()).isEqualTo(0.5);
        Assertions.assertThat((long)this.metastore.getTableStats().getRequestCount()).isEqualTo(1L);
        Assertions.assertThat((Double)this.metastore.getTableStats().getHitRate()).isEqualTo(0.0);
        Assertions.assertThat((long)this.metastore.getPartitionStats().getRequestCount()).isEqualTo(3L);
        Assertions.assertThat((Double)this.metastore.getPartitionStats().getHitRate()).isEqualTo(0.0);
        Assertions.assertThatThrownBy(() -> this.metastore.getPartitionColumnStatistics("testdb", "testtbl", (Set)ImmutableSet.of((Object)"key=testpartition1"), (Set)ImmutableSet.of())).isInstanceOf(IllegalArgumentException.class);
        Assertions.assertThat((long)this.metastore.getPartitionStatisticsStats().getRequestCount()).isEqualTo(2L);
        Assertions.assertThat((Double)this.metastore.getPartitionStatisticsStats().getHitRate()).isEqualTo(0.5);
        this.mockClient.mockPartitionColumnStats("testdb", "testtbl", "key=testpartition1", (Map<String, ColumnStatisticsData>)ImmutableMap.of((Object)"col1", (Object)ColumnStatisticsData.longStats((LongColumnStatsData)new LongColumnStatsData().setNumNulls(1L)), (Object)"col2", (Object)ColumnStatisticsData.longStats((LongColumnStatsData)new LongColumnStatsData().setNumNulls(2L)), (Object)"col3", (Object)ColumnStatisticsData.longStats((LongColumnStatsData)new LongColumnStatsData().setNumNulls(3L))));
        Map tableCol1PartitionStatistics = this.metastore.getPartitionColumnStatistics("testdb", "testtbl", (Set)ImmutableSet.of((Object)partitionName), (Set)ImmutableSet.of((Object)"col1"));
        Assertions.assertThat((Map)tableCol1PartitionStatistics).containsOnlyKeys((Object[])new String[]{partitionName});
        Assertions.assertThat((Map)((Map)tableCol1PartitionStatistics.get(partitionName))).containsEntry((Object)"col1", (Object)TestCachingHiveMetastore.intColumnStats(1));
        Map tableCol2PartitionStatistics = this.metastore.getPartitionColumnStatistics("testdb", "testtbl", (Set)ImmutableSet.of((Object)partitionName), (Set)ImmutableSet.of((Object)"col2"));
        Assertions.assertThat((Map)tableCol2PartitionStatistics).containsOnlyKeys((Object[])new String[]{partitionName});
        Assertions.assertThat((Map)((Map)tableCol2PartitionStatistics.get(partitionName))).containsEntry((Object)"col2", (Object)TestCachingHiveMetastore.intColumnStats(2));
        Map tableCol23PartitionStatistics = this.metastore.getPartitionColumnStatistics("testdb", "testtbl", (Set)ImmutableSet.of((Object)partitionName), (Set)ImmutableSet.of((Object)"col2", (Object)"col3"));
        Assertions.assertThat((Map)tableCol23PartitionStatistics).containsOnlyKeys((Object[])new String[]{partitionName});
        ((MapAssert)Assertions.assertThat((Map)((Map)tableCol23PartitionStatistics.get(partitionName))).containsEntry((Object)"col2", (Object)TestCachingHiveMetastore.intColumnStats(2))).containsEntry((Object)"col3", (Object)TestCachingHiveMetastore.intColumnStats(3));
        this.mockClient.mockPartitionColumnStats("testdb", "testtbl", "key=testpartition2", (Map<String, ColumnStatisticsData>)ImmutableMap.of((Object)"col1", (Object)ColumnStatisticsData.longStats((LongColumnStatsData)new LongColumnStatsData().setNumNulls(21L)), (Object)"col2", (Object)ColumnStatisticsData.longStats((LongColumnStatsData)new LongColumnStatsData().setNumNulls(22L)), (Object)"col3", (Object)ColumnStatisticsData.longStats((LongColumnStatsData)new LongColumnStatsData().setNumNulls(23L))));
        this.mockClient.mockPartitionColumnStats("testdb", "testtbl", "key=testpartition3", (Map<String, ColumnStatisticsData>)ImmutableMap.of((Object)"col1", (Object)ColumnStatisticsData.longStats((LongColumnStatsData)new LongColumnStatsData().setNumNulls(31L)), (Object)"col2", (Object)ColumnStatisticsData.longStats((LongColumnStatsData)new LongColumnStatsData().setNumNulls(32L)), (Object)"col3", (Object)ColumnStatisticsData.longStats((LongColumnStatsData)new LongColumnStatsData().setNumNulls(33L))));
        Map tableCol2Partition2Statistics = this.metastore.getPartitionColumnStatistics("testdb", "testtbl", (Set)ImmutableSet.of((Object)partition2Name), (Set)ImmutableSet.of((Object)"col2"));
        Assertions.assertThat((Map)tableCol2Partition2Statistics).containsOnlyKeys((Object[])new String[]{partition2Name});
        Assertions.assertThat((Map)((Map)tableCol2Partition2Statistics.get(partition2Name))).containsEntry((Object)"col2", (Object)TestCachingHiveMetastore.intColumnStats(22));
        Map tableCol23Partition123Statistics = this.metastore.getPartitionColumnStatistics("testdb", "testtbl", (Set)ImmutableSet.of((Object)partitionName, (Object)partition2Name, (Object)partition3Name), (Set)ImmutableSet.of((Object)"col2", (Object)"col3"));
        Assertions.assertThat((Map)tableCol23Partition123Statistics).containsOnlyKeys((Object[])new String[]{partitionName, partition2Name, partition3Name});
        ((MapAssert)Assertions.assertThat((Map)((Map)tableCol23Partition123Statistics.get(partitionName))).containsEntry((Object)"col2", (Object)TestCachingHiveMetastore.intColumnStats(2))).containsEntry((Object)"col3", (Object)TestCachingHiveMetastore.intColumnStats(3));
        ((MapAssert)Assertions.assertThat((Map)((Map)tableCol23Partition123Statistics.get(partition2Name))).containsEntry((Object)"col2", (Object)TestCachingHiveMetastore.intColumnStats(22))).containsEntry((Object)"col3", (Object)TestCachingHiveMetastore.intColumnStats(23));
        ((MapAssert)Assertions.assertThat((Map)((Map)tableCol23Partition123Statistics.get(partition3Name))).containsEntry((Object)"col2", (Object)TestCachingHiveMetastore.intColumnStats(32))).containsEntry((Object)"col3", (Object)TestCachingHiveMetastore.intColumnStats(33));
    }

    @Test
    public void testGetPartitionStatisticsWithEmptyColumnStats() {
        Assertions.assertThat((int)this.mockClient.getAccessCount()).isEqualTo(0);
        Table table = (Table)this.metastore.getTable("testdb", "testtbl").orElseThrow();
        Assertions.assertThat((int)this.mockClient.getAccessCount()).isEqualTo(1);
        Assertions.assertThat((Optional)this.metastore.getPartition(table, MockThriftMetastoreClient.TEST_PARTITION_VALUES2)).isPresent();
        Assertions.assertThat((int)this.mockClient.getAccessCount()).isEqualTo(2);
        PartitionStatistics expectedStats = PartitionStatistics.builder().setBasicStatistics(TEST_BASIC_STATS).setColumnStatistics((Map)ImmutableMap.of()).build();
        Assertions.assertThat((Map)this.metastore.getPartitionColumnStatistics("testdb", "testtbl", (Set)ImmutableSet.of((Object)"key=testpartition2"), (Set)ImmutableSet.of((Object)"column"))).isEqualTo((Object)ImmutableMap.of((Object)"key=testpartition2", (Object)expectedStats.columnStatistics()));
        Assertions.assertThat((int)this.mockClient.getAccessCount()).isEqualTo(3);
        Assertions.assertThat((Map)this.metastore.getPartitionColumnStatistics("testdb", "testtbl", (Set)ImmutableSet.of((Object)"key=testpartition2"), (Set)ImmutableSet.of((Object)"column"))).isEqualTo((Object)ImmutableMap.of((Object)"key=testpartition2", (Object)expectedStats.columnStatistics()));
        Assertions.assertThat((int)this.mockClient.getAccessCount()).isEqualTo(3);
    }

    @Test
    public void testGetPartitionStatisticsWithEmptyColumnStatsWithNoCacheMissing() {
        CachingHiveMetastore metastore = TestCachingHiveMetastore.createCachingHiveMetastore((HiveMetastore)new BridgingHiveMetastore(this.thriftHiveMetastore), CACHE_TTL, false, true, (Executor)this.executor);
        Assertions.assertThat((int)this.mockClient.getAccessCount()).isEqualTo(0);
        Table table = (Table)metastore.getTable("testdb", "testtbl").orElseThrow();
        Assertions.assertThat((int)this.mockClient.getAccessCount()).isEqualTo(1);
        Assertions.assertThat((Optional)metastore.getPartition(table, MockThriftMetastoreClient.TEST_PARTITION_VALUES2)).isPresent();
        Assertions.assertThat((int)this.mockClient.getAccessCount()).isEqualTo(2);
        PartitionStatistics expectedStats = PartitionStatistics.builder().setBasicStatistics(TEST_BASIC_STATS).setColumnStatistics((Map)ImmutableMap.of()).build();
        Assertions.assertThat((Map)metastore.getPartitionColumnStatistics("testdb", "testtbl", (Set)ImmutableSet.of((Object)"key=testpartition2"), (Set)ImmutableSet.of((Object)"column"))).isEqualTo((Object)ImmutableMap.of((Object)"key=testpartition2", (Object)expectedStats.columnStatistics()));
        Assertions.assertThat((int)this.mockClient.getAccessCount()).isEqualTo(3);
        Assertions.assertThat((Map)metastore.getPartitionColumnStatistics("testdb", "testtbl", (Set)ImmutableSet.of((Object)"key=testpartition2"), (Set)ImmutableSet.of((Object)"column"))).isEqualTo((Object)ImmutableMap.of((Object)"key=testpartition2", (Object)expectedStats.columnStatistics()));
        Assertions.assertThat((int)this.mockClient.getAccessCount()).isEqualTo(4);
    }

    @Test
    public void testGetPartitionStatisticsWithoutMetadataCache() {
        Assertions.assertThat((int)this.mockClient.getAccessCount()).isEqualTo(0);
        Table table = (Table)this.statsOnlyCacheMetastore.getTable("testdb", "testtbl").orElseThrow();
        Assertions.assertThat((int)this.mockClient.getAccessCount()).isEqualTo(1);
        Assertions.assertThat((Optional)this.statsOnlyCacheMetastore.getPartition(table, MockThriftMetastoreClient.TEST_PARTITION_VALUES1)).isPresent();
        Assertions.assertThat((int)this.mockClient.getAccessCount()).isEqualTo(2);
        Assertions.assertThat((Map)this.statsOnlyCacheMetastore.getPartitionColumnStatistics("testdb", "testtbl", (Set)ImmutableSet.of((Object)"key=testpartition1"), (Set)ImmutableSet.of((Object)"column"))).isEqualTo((Object)ImmutableMap.of((Object)"key=testpartition1", TEST_COLUMN_STATS));
        Assertions.assertThat((int)this.mockClient.getAccessCount()).isEqualTo(3);
        Assertions.assertThat((Map)this.statsOnlyCacheMetastore.getPartitionColumnStatistics("testdb", "testtbl", (Set)ImmutableSet.of((Object)"key=testpartition1"), (Set)ImmutableSet.of((Object)"column"))).isEqualTo((Object)ImmutableMap.of((Object)"key=testpartition1", TEST_COLUMN_STATS));
        Assertions.assertThat((int)this.mockClient.getAccessCount()).isEqualTo(3);
        Assertions.assertThat((long)this.statsOnlyCacheMetastore.getPartitionStatisticsStats().getRequestCount()).isEqualTo(2L);
        Assertions.assertThat((Double)this.statsOnlyCacheMetastore.getPartitionStatisticsStats().getHitRate()).isEqualTo(0.5);
        Assertions.assertThat((long)this.statsOnlyCacheMetastore.getTableStats().getRequestCount()).isEqualTo(0L);
        Assertions.assertThat((Double)this.statsOnlyCacheMetastore.getTableStats().getHitRate()).isEqualTo(1.0);
        Assertions.assertThat((long)this.statsOnlyCacheMetastore.getPartitionStats().getRequestCount()).isEqualTo(0L);
        Assertions.assertThat((Double)this.statsOnlyCacheMetastore.getPartitionStats().getHitRate()).isEqualTo(1.0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInvalidatePartitionStatsWithLoadInProgress() throws Exception {
        final CountDownLatch loadInProgress = new CountDownLatch(1);
        final CountDownLatch invalidateDone = new CountDownLatch(1);
        MockThriftMetastoreClient mockClient = new MockThriftMetastoreClient(this){

            @Override
            public Map<String, List<ColumnStatisticsObj>> getPartitionColumnStatistics(String databaseName, String tableName, List<String> partitionNames, List<String> columnNames) throws TException {
                loadInProgress.countDown();
                Map<String, List<ColumnStatisticsObj>> result = super.getPartitionColumnStatistics(databaseName, tableName, partitionNames, columnNames);
                try {
                    invalidateDone.await(10L, TimeUnit.SECONDS);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                return result;
            }
        };
        CachingHiveMetastore metastore = TestCachingHiveMetastore.createCachingHiveMetastore((HiveMetastore)new BridgingHiveMetastore(this.createThriftHiveMetastore(mockClient)), CACHE_TTL, true, true, (Executor)this.executor);
        Table table = (Table)metastore.getTable("testdb", "testtbl").orElseThrow();
        Assertions.assertThat((Optional)metastore.getPartition(table, MockThriftMetastoreClient.TEST_PARTITION_VALUES1)).isPresent();
        ExecutorService executorService = Executors.newFixedThreadPool(1, Threads.daemonThreadsNamed((String)"invalidation-%d"));
        try {
            Future<?> invalidateFuture = executorService.submit(() -> {
                try {
                    loadInProgress.await(10L, TimeUnit.SECONDS);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                metastore.flushCache();
                invalidateDone.countDown();
            });
            Assertions.assertThat((Map)metastore.getPartitionColumnStatistics("testdb", "testtbl", (Set)ImmutableSet.of((Object)"key=testpartition1"), (Set)ImmutableSet.of((Object)"column"))).isEqualTo((Object)ImmutableMap.of((Object)"key=testpartition1", TEST_COLUMN_STATS));
            Assertions.assertThat((int)mockClient.getAccessCount()).isEqualTo(3);
            Assertions.assertThat((Map)metastore.getPartitionColumnStatistics("testdb", "testtbl", (Set)ImmutableSet.of((Object)"key=testpartition1"), (Set)ImmutableSet.of((Object)"column"))).isEqualTo((Object)ImmutableMap.of((Object)"key=testpartition1", TEST_COLUMN_STATS));
            Assertions.assertThat((int)mockClient.getAccessCount()).isEqualTo(4);
            invalidateFuture.get(1L, TimeUnit.SECONDS);
        }
        finally {
            executorService.shutdownNow();
        }
    }

    @Test
    public void testUpdatePartitionStatistics() {
        Assertions.assertThat((int)this.mockClient.getAccessCount()).isEqualTo(0);
        Table table = (Table)this.metastore.getTable("testdb", "testtbl").orElseThrow();
        Assertions.assertThat((int)this.mockClient.getAccessCount()).isEqualTo(1);
        this.metastore.updatePartitionStatistics(table, StatisticsUpdateMode.MERGE_INCREMENTAL, Map.of("key=testpartition1", TEST_STATS));
        Assertions.assertThat((int)this.mockClient.getAccessCount()).isEqualTo(5);
    }

    @Test
    public void testInvalidGetPartitionsByNames() {
        Table table = (Table)this.metastore.getTable("testdb", "testtbl").orElseThrow();
        Map partitionsByNames = this.metastore.getPartitionsByNames(table, (List)ImmutableList.of((Object)"key=badpartition1"));
        Assertions.assertThat((Map)partitionsByNames).hasSize(1);
        Optional onlyElement = (Optional)Iterables.getOnlyElement(partitionsByNames.values());
        Assertions.assertThat((Optional)onlyElement).isEmpty();
    }

    @Test
    public void testNoCacheExceptions() {
        this.mockClient.setThrowException(true);
        try {
            this.metastore.getAllDatabases();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        Assertions.assertThat((int)this.mockClient.getAccessCount()).isEqualTo(1);
        try {
            this.metastore.getAllDatabases();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        Assertions.assertThat((int)this.mockClient.getAccessCount()).isEqualTo(2);
    }

    @Test
    public void testNoCacheMissing() {
        CachingHiveMetastore metastore = TestCachingHiveMetastore.createCachingHiveMetastore((HiveMetastore)new BridgingHiveMetastore(this.thriftHiveMetastore), CACHE_TTL, false, true, (Executor)this.executor);
        this.mockClient.setReturnTable(false);
        Assertions.assertThat((int)this.mockClient.getAccessCount()).isEqualTo(0);
        Assertions.assertThat((Optional)metastore.getTable("testdb", "testtbl")).isEmpty();
        Assertions.assertThat((int)this.mockClient.getAccessCount()).isEqualTo(1);
        Assertions.assertThat((Optional)metastore.getTable("testdb", "testtbl")).isEmpty();
        Assertions.assertThat((int)this.mockClient.getAccessCount()).isEqualTo(2);
        this.mockClient.setReturnTable(true);
        Assertions.assertThat((Optional)metastore.getTable("testdb", "testtbl")).isPresent();
        Assertions.assertThat((int)this.mockClient.getAccessCount()).isEqualTo(3);
        this.mockClient.setReturnTable(true);
        Assertions.assertThat((Optional)metastore.getTable("testdb", "testtbl")).isPresent();
        Assertions.assertThat((int)this.mockClient.getAccessCount()).isEqualTo(3);
        this.mockClient.setReturnTable(false);
        Assertions.assertThat((Optional)metastore.getTable("testdb", "testtbl")).isPresent();
        Assertions.assertThat((int)this.mockClient.getAccessCount()).isEqualTo(3);
        metastore.invalidateTable("testdb", "testtbl");
        Assertions.assertThat((Optional)metastore.getTable("testdb", "testtbl")).isEmpty();
        Assertions.assertThat((int)this.mockClient.getAccessCount()).isEqualTo(4);
    }

    @Test
    public void testCachingHiveMetastoreCreationViaMemoize() {
        this.metastore = CachingHiveMetastore.createPerTransactionCache((HiveMetastore)new BridgingHiveMetastore(this.createThriftHiveMetastore()), (long)1000L);
        Assertions.assertThat((int)this.mockClient.getAccessCount()).isEqualTo(0);
        Assertions.assertThat((List)this.metastore.getAllDatabases()).isEqualTo((Object)ImmutableList.of((Object)"testdb"));
        Assertions.assertThat((int)this.mockClient.getAccessCount()).isEqualTo(1);
        Assertions.assertThat((List)this.metastore.getAllDatabases()).isEqualTo((Object)ImmutableList.of((Object)"testdb"));
        Assertions.assertThat((int)this.mockClient.getAccessCount()).isEqualTo(1);
        Assertions.assertThat((long)this.metastore.getDatabaseNamesStats().getRequestCount()).isEqualTo(0L);
    }

    @Test
    public void testDropTable() {
        Assertions.assertThat((int)this.mockClient.getAccessCount()).isEqualTo(0);
        Table table = (Table)this.metastore.getTable("testdb", "testtbl").orElseThrow();
        Assertions.assertThat((int)this.mockClient.getAccessCount()).isEqualTo(1);
        Assertions.assertThat((Optional)this.metastore.getTable("testdb", "testtbl")).isNotNull();
        Assertions.assertThat((int)this.mockClient.getAccessCount()).isEqualTo(1);
        Assertions.assertThat((Optional)this.metastore.getPartition(table, MockThriftMetastoreClient.TEST_PARTITION_VALUES1)).isNotNull();
        Assertions.assertThat((int)this.mockClient.getAccessCount()).isEqualTo(2);
        Assertions.assertThat((Optional)this.metastore.getPartition(table, MockThriftMetastoreClient.TEST_PARTITION_VALUES1)).isNotNull();
        Assertions.assertThat((int)this.mockClient.getAccessCount()).isEqualTo(2);
        this.metastore.dropTable("testdb", "testtbl", false);
        Assertions.assertThat((Optional)this.metastore.getTable("testdb", "testtbl")).isNotNull();
        Assertions.assertThat((int)this.mockClient.getAccessCount()).isEqualTo(4);
        Assertions.assertThat((Optional)this.metastore.getPartition(table, MockThriftMetastoreClient.TEST_PARTITION_VALUES1)).isNotNull();
        Assertions.assertThat((int)this.mockClient.getAccessCount()).isEqualTo(5);
    }

    @Test
    public void testAllDatabases() {
        Assertions.assertThat((int)this.mockClient.getAccessCount()).isEqualTo(0);
        Assertions.assertThat((List)this.metastore.getAllDatabases()).containsExactly((Object[])new String[]{"testdb"});
        Assertions.assertThat((int)this.mockClient.getAccessCount()).isEqualTo(1);
        Assertions.assertThat((List)this.metastore.getAllDatabases()).containsExactly((Object[])new String[]{"testdb"});
        Assertions.assertThat((int)this.mockClient.getAccessCount()).isEqualTo(1);
        this.metastore.dropDatabase("testdb", false);
        Assertions.assertThat((List)this.metastore.getAllDatabases()).containsExactly((Object[])new String[]{"testdb"});
        Assertions.assertThat((int)this.mockClient.getAccessCount()).isEqualTo(2);
        Assertions.assertThat((List)this.metastore.getAllDatabases()).containsExactly((Object[])new String[]{"testdb"});
        Assertions.assertThat((int)this.mockClient.getAccessCount()).isEqualTo(2);
        this.metastore.createDatabase(Database.builder().setDatabaseName("testdb").setOwnerName(Optional.empty()).setOwnerType(Optional.empty()).build());
        Assertions.assertThat((List)this.metastore.getAllDatabases()).containsExactly((Object[])new String[]{"testdb"});
        Assertions.assertThat((int)this.mockClient.getAccessCount()).isEqualTo(3);
        Assertions.assertThat((List)this.metastore.getAllDatabases()).containsExactly((Object[])new String[]{"testdb"});
        Assertions.assertThat((int)this.mockClient.getAccessCount()).isEqualTo(3);
    }

    @Test
    public void testAcquireSharedReadLockIfMetastoreDownDuringCheckLock() {
        long lockId = new Random().nextLong();
        this.mockClient.setTestLockState(LockState.WAITING);
        this.mockClient.setTestLockId(lockId);
        this.mockClient.setThrowException(true);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(this::acquireSharedReadLock).isInstanceOf(TrinoException.class)).hasMessage("Fail to connect to metastore. LockId = %s".formatted(lockId));
        Assertions.assertThat((int)this.mockClient.getAccessCount()).isEqualTo(11);
    }

    private void acquireSharedReadLock() {
        this.metastore.acquireSharedReadLock(new AcidTransactionOwner("test"), "queryId", 5L, Collections.singletonList(new SchemaTableName("test", "test")), Collections.emptyList());
    }

    private static HiveColumnStatistics intColumnStats(int nullsCount) {
        return HiveColumnStatistics.createIntegerColumnStatistics((OptionalLong)OptionalLong.empty(), (OptionalLong)OptionalLong.empty(), (OptionalLong)OptionalLong.of(nullsCount), (OptionalLong)OptionalLong.empty());
    }

    private PartitionCachingAssertions assertThatCachingWithDisabledPartitionCache() {
        return new PartitionCachingAssertions(this, (Executor)this.executor);
    }

    private static CachingHiveMetastore createCachingHiveMetastore(HiveMetastore hiveMetastore, Duration cacheTtl, boolean cacheMissing, boolean partitionCacheEnabled, Executor executor) {
        return CachingHiveMetastore.createCachingHiveMetastore((HiveMetastore)hiveMetastore, (Duration)cacheTtl, (Duration)CACHE_TTL, Optional.of(new Duration(1.0, TimeUnit.MINUTES)), (Executor)executor, (long)1000L, (CachingHiveMetastore.StatsRecording)CachingHiveMetastore.StatsRecording.ENABLED, (boolean)partitionCacheEnabled, (Set)(cacheMissing ? ImmutableSet.copyOf((Object[])CachingHiveMetastore.ObjectType.values()) : ImmutableSet.of()));
    }

    class PartitionCachingAssertions {
        private final CachingHiveMetastore cachingHiveMetastore;
        private final MockThriftMetastoreClient thriftClient;
        private Consumer<CachingHiveMetastore> metastoreInteractions = hiveMetastore -> {};

        private PartitionCachingAssertions(TestCachingHiveMetastore this$0, Executor refreshExecutor) {
            this.thriftClient = new MockThriftMetastoreClient();
            this.cachingHiveMetastore = TestCachingHiveMetastore.createCachingHiveMetastore((HiveMetastore)new BridgingHiveMetastore(this$0.createThriftHiveMetastore(this.thriftClient)), CACHE_TTL, true, false, refreshExecutor);
        }

        PartitionCachingAssertions whenExecuting(Consumer<CachingHiveMetastore> interactions) {
            this.metastoreInteractions = interactions;
            return this;
        }

        void usesCache() {
            for (int i = 0; i < 5; ++i) {
                this.metastoreInteractions.accept(this.cachingHiveMetastore);
                ((AbstractIntegerAssert)Assertions.assertThat((int)this.thriftClient.getAccessCount()).describedAs("Metastore is expected to use cache, but it does not.", new Object[0])).isEqualTo(1);
            }
        }

        void doesNotUseCache() {
            for (int i = 1; i < 5; ++i) {
                this.metastoreInteractions.accept(this.cachingHiveMetastore);
                ((AbstractIntegerAssert)Assertions.assertThat((int)this.thriftClient.getAccessCount()).describedAs("Metastore is expected to not use cache, but it does.", new Object[0])).isEqualTo(i);
            }
        }

        void omitsCacheForNumberOfOperations(int expectedCacheOmittingOperations) {
            this.metastoreInteractions.accept(this.cachingHiveMetastore);
            int startingAccessCount = this.thriftClient.getAccessCount();
            for (int i = 1; i < 5; ++i) {
                this.metastoreInteractions.accept(this.cachingHiveMetastore);
                int currentAccessCount = this.thriftClient.getAccessCount();
                int timesCacheHasBeenOmitted = (currentAccessCount - startingAccessCount) / i;
                ((AbstractIntegerAssert)Assertions.assertThat((int)timesCacheHasBeenOmitted).describedAs(String.format("Metastore is expected to not use cache %s times, but it does not use it %s times.", expectedCacheOmittingOperations, timesCacheHasBeenOmitted), new Object[0])).isEqualTo(expectedCacheOmittingOperations);
            }
        }
    }
}

