/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.metastore.file;

import com.google.common.collect.ImmutableMap;
import io.airlift.json.JsonCodec;
import io.trino.metastore.BooleanStatistics;
import io.trino.metastore.DateStatistics;
import io.trino.metastore.DecimalStatistics;
import io.trino.metastore.DoubleStatistics;
import io.trino.metastore.HiveBasicStatistics;
import io.trino.metastore.HiveColumnStatistics;
import io.trino.metastore.IntegerStatistics;
import io.trino.plugin.hive.metastore.file.ColumnStatistics;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalLong;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class TestColumnStatistics {
    private static final JsonCodec<Map<String, ColumnStatistics>> MAP_COLUMN_STATISTICS_CODEC = JsonCodec.mapJsonCodec(String.class, ColumnStatistics.class);
    private static final HiveBasicStatistics ROWS_100 = new HiveBasicStatistics(OptionalLong.empty(), OptionalLong.of(100L), OptionalLong.empty(), OptionalLong.empty());
    private static final String ALL_KINDS_JSON = "{\n    \"empty\": {},\n    \"integer\": {\n        \"integerStatistics\": {\n            \"min\": 1,\n            \"max\": 11\n        },\n        \"maxValueSizeInBytes\": 1,\n        \"averageColumnLength\": 1.2359550561797752,\n        \"nullsCount\": 11,\n        \"distinctValuesCount\": 111\n    },\n    \"double\": {\n        \"doubleStatistics\": {\n            \"min\": 2.0,\n            \"max\": 12.0\n        },\n        \"maxValueSizeInBytes\": 2,\n        \"averageColumnLength\": 2.8205128205128207,\n        \"nullsCount\": 22,\n        \"distinctValuesCount\": 222\n    },\n    \"decimal\": {\n        \"decimalStatistics\": {\n            \"min\": 3.0,\n            \"max\": 13.0\n        },\n        \"maxValueSizeInBytes\": 3,\n        \"averageColumnLength\": 4.925373134328358,\n        \"nullsCount\": 33,\n        \"distinctValuesCount\": 333\n    },\n    \"date\": {\n        \"dateStatistics\": {\n            \"min\": \"0004-04-04\",\n            \"max\": \"0014-04-04\"\n        },\n        \"maxValueSizeInBytes\": 4,\n        \"averageColumnLength\": 7.857142857142857,\n        \"nullsCount\": 44,\n        \"distinctValuesCount\": 444\n    },\n    \"boolean\": {\n        \"booleanStatistics\": {\n            \"trueCount\": 5,\n            \"falseCount\": 5\n        },\n        \"maxValueSizeInBytes\": 5,\n        \"averageColumnLength\": 12.222222222222221,\n        \"nullsCount\": 55,\n        \"distinctValuesCount\": 555\n    },\n    \"basic\": {\n        \"maxValueSizeInBytes\": 6,\n        \"averageColumnLength\": 19.41176470588235,\n        \"nullsCount\": 66,\n        \"distinctValuesCount\": 666\n    }\n}\n";
    private static final String ALL_KINDS_JSON_BEFORE_AVG_SIZE = "{\n    \"empty\": {},\n    \"integer\": {\n        \"integerStatistics\": {\n            \"min\": 1,\n            \"max\": 11\n        },\n        \"maxValueSizeInBytes\": 1,\n        \"totalSizeInBytes\": 110,\n        \"nullsCount\": 11,\n        \"distinctValuesCount\": 111\n    },\n    \"double\": {\n        \"doubleStatistics\": {\n            \"min\": 2.0,\n            \"max\": 12.0\n        },\n        \"maxValueSizeInBytes\": 2,\n        \"totalSizeInBytes\": 220,\n        \"nullsCount\": 22,\n        \"distinctValuesCount\": 222\n    },\n    \"decimal\": {\n        \"decimalStatistics\": {\n            \"min\": 3.0,\n            \"max\": 13.0\n        },\n        \"maxValueSizeInBytes\": 3,\n        \"totalSizeInBytes\": 330,\n        \"nullsCount\": 33,\n        \"distinctValuesCount\": 333\n    },\n    \"date\": {\n        \"dateStatistics\": {\n            \"min\": \"0004-04-04\",\n            \"max\": \"0014-04-04\"\n        },\n        \"maxValueSizeInBytes\": 4,\n        \"totalSizeInBytes\": 440,\n        \"nullsCount\": 44,\n        \"distinctValuesCount\": 444\n    },\n    \"boolean\": {\n        \"booleanStatistics\": {\n            \"trueCount\": 5,\n            \"falseCount\": 5\n        },\n        \"maxValueSizeInBytes\": 5,\n        \"totalSizeInBytes\": 550,\n        \"nullsCount\": 55,\n        \"distinctValuesCount\": 555\n    },\n    \"basic\": {\n        \"maxValueSizeInBytes\": 6,\n        \"totalSizeInBytes\": 660,\n        \"nullsCount\": 66,\n        \"distinctValuesCount\": 666\n    }\n}\n";
    private static final Map<String, ColumnStatistics> ALL_KINDS = ImmutableMap.builder().put((Object)"empty", (Object)new ColumnStatistics(Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), OptionalLong.empty(), OptionalDouble.empty(), OptionalLong.empty(), OptionalLong.empty(), OptionalLong.empty())).put((Object)"integer", (Object)new ColumnStatistics(Optional.of(new ColumnStatistics.IntegerStatistics(OptionalLong.of(1L), OptionalLong.of(11L))), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), OptionalLong.of(1L), OptionalDouble.of(1.2359550561797752), OptionalLong.empty(), OptionalLong.of(11L), OptionalLong.of(111L))).put((Object)"double", (Object)new ColumnStatistics(Optional.empty(), Optional.of(new ColumnStatistics.DoubleStatistics(OptionalDouble.of(2.0), OptionalDouble.of(12.0))), Optional.empty(), Optional.empty(), Optional.empty(), OptionalLong.of(2L), OptionalDouble.of(2.8205128205128207), OptionalLong.empty(), OptionalLong.of(22L), OptionalLong.of(222L))).put((Object)"decimal", (Object)new ColumnStatistics(Optional.empty(), Optional.empty(), Optional.of(new ColumnStatistics.DecimalStatistics(Optional.of(new BigDecimal("3.0")), Optional.of(new BigDecimal("13.0")))), Optional.empty(), Optional.empty(), OptionalLong.of(3L), OptionalDouble.of(4.925373134328358), OptionalLong.empty(), OptionalLong.of(33L), OptionalLong.of(333L))).put((Object)"date", (Object)new ColumnStatistics(Optional.empty(), Optional.empty(), Optional.empty(), Optional.of(new ColumnStatistics.DateStatistics(Optional.of(LocalDate.of(4, 4, 4)), Optional.of(LocalDate.of(14, 4, 4)))), Optional.empty(), OptionalLong.of(4L), OptionalDouble.of(7.857142857142857), OptionalLong.empty(), OptionalLong.of(44L), OptionalLong.of(444L))).put((Object)"boolean", (Object)new ColumnStatistics(Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.of(new ColumnStatistics.BooleanStatistics(OptionalLong.of(5L), OptionalLong.of(5L))), OptionalLong.of(5L), OptionalDouble.of(12.222222222222221), OptionalLong.empty(), OptionalLong.of(55L), OptionalLong.of(555L))).put((Object)"basic", (Object)new ColumnStatistics(Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), OptionalLong.of(6L), OptionalDouble.of(19.41176470588235), OptionalLong.empty(), OptionalLong.of(66L), OptionalLong.of(666L))).buildOrThrow();
    private static final Map<String, HiveColumnStatistics> HIVE_ALL_KINDS = ImmutableMap.builder().put((Object)"empty", (Object)new HiveColumnStatistics(Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), OptionalLong.empty(), OptionalDouble.empty(), OptionalLong.empty(), OptionalLong.empty())).put((Object)"integer", (Object)new HiveColumnStatistics(Optional.of(new IntegerStatistics(OptionalLong.of(1L), OptionalLong.of(11L))), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), OptionalLong.of(1L), OptionalDouble.of(1.2359550561797752), OptionalLong.of(11L), OptionalLong.of(111L))).put((Object)"double", (Object)new HiveColumnStatistics(Optional.empty(), Optional.of(new DoubleStatistics(OptionalDouble.of(2.0), OptionalDouble.of(12.0))), Optional.empty(), Optional.empty(), Optional.empty(), OptionalLong.of(2L), OptionalDouble.of(2.8205128205128207), OptionalLong.of(22L), OptionalLong.of(222L))).put((Object)"decimal", (Object)new HiveColumnStatistics(Optional.empty(), Optional.empty(), Optional.of(new DecimalStatistics(Optional.of(new BigDecimal("3.0")), Optional.of(new BigDecimal("13.0")))), Optional.empty(), Optional.empty(), OptionalLong.of(3L), OptionalDouble.of(4.925373134328358), OptionalLong.of(33L), OptionalLong.of(333L))).put((Object)"date", (Object)new HiveColumnStatistics(Optional.empty(), Optional.empty(), Optional.empty(), Optional.of(new DateStatistics(Optional.of(LocalDate.of(4, 4, 4)), Optional.of(LocalDate.of(14, 4, 4)))), Optional.empty(), OptionalLong.of(4L), OptionalDouble.of(7.857142857142857), OptionalLong.of(44L), OptionalLong.of(444L))).put((Object)"boolean", (Object)new HiveColumnStatistics(Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.of(new BooleanStatistics(OptionalLong.of(5L), OptionalLong.of(5L))), OptionalLong.of(5L), OptionalDouble.of(12.222222222222221), OptionalLong.of(55L), OptionalLong.of(555L))).put((Object)"basic", (Object)new HiveColumnStatistics(Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), OptionalLong.of(6L), OptionalDouble.of(19.41176470588235), OptionalLong.of(66L), OptionalLong.of(666L))).buildOrThrow();

    TestColumnStatistics() {
    }

    @Test
    void testRoundTrip() {
        Assertions.assertThat((Map)((Map)MAP_COLUMN_STATISTICS_CODEC.fromJson(MAP_COLUMN_STATISTICS_CODEC.toJson(ALL_KINDS)))).isEqualTo(ALL_KINDS);
    }

    @Test
    void testDeserialize() {
        Assertions.assertThat((Map)((Map)MAP_COLUMN_STATISTICS_CODEC.fromJson(ALL_KINDS_JSON))).isEqualTo(ALL_KINDS);
    }

    @Test
    void testDeserializeBeforeAvgSize() {
        Map oldStats = (Map)MAP_COLUMN_STATISTICS_CODEC.fromJson(ALL_KINDS_JSON_BEFORE_AVG_SIZE);
        Assertions.assertThat((OptionalLong)((ColumnStatistics)oldStats.get("integer")).totalSizeInBytes()).isPresent();
        Assertions.assertThat((OptionalDouble)((ColumnStatistics)oldStats.get("integer")).averageColumnLength()).isEmpty();
        Assertions.assertThat(TestColumnStatistics.toHive(oldStats, ROWS_100)).isEqualTo(HIVE_ALL_KINDS);
    }

    @Test
    void testRoundHive() {
        Map fromHive = (Map)HIVE_ALL_KINDS.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, e -> ColumnStatistics.fromHiveColumnStatistics((HiveColumnStatistics)((HiveColumnStatistics)e.getValue()))));
        Assertions.assertThat((Map)fromHive).isEqualTo(ALL_KINDS);
        Assertions.assertThat(TestColumnStatistics.toHive(fromHive, HiveBasicStatistics.createEmptyStatistics())).isEqualTo(HIVE_ALL_KINDS);
        Assertions.assertThat(TestColumnStatistics.toHive(fromHive, HiveBasicStatistics.createZeroStatistics())).isEqualTo(HIVE_ALL_KINDS);
        Assertions.assertThat(TestColumnStatistics.toHive(fromHive, ROWS_100)).isEqualTo(HIVE_ALL_KINDS);
    }

    private static Map<String, HiveColumnStatistics> toHive(Map<String, ColumnStatistics> fromHive, HiveBasicStatistics emptyStatistics) {
        return (Map)fromHive.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> ((ColumnStatistics)entry.getValue()).toHiveColumnStatistics(emptyStatistics)));
    }
}

