/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.metastore.file;

import com.google.common.collect.ImmutableMap;
import com.google.common.io.MoreFiles;
import com.google.common.io.RecursiveDeleteOption;
import io.trino.filesystem.TrinoFileSystemFactory;
import io.trino.filesystem.local.LocalFileSystemFactory;
import io.trino.metastore.Column;
import io.trino.metastore.Database;
import io.trino.metastore.HiveMetastore;
import io.trino.metastore.HiveType;
import io.trino.metastore.PrincipalPrivileges;
import io.trino.metastore.StorageFormat;
import io.trino.metastore.Table;
import io.trino.plugin.hive.NodeVersion;
import io.trino.plugin.hive.TableType;
import io.trino.plugin.hive.metastore.AbstractTestHiveMetastore;
import io.trino.plugin.hive.metastore.file.FileHiveMetastore;
import io.trino.plugin.hive.metastore.file.FileHiveMetastoreConfig;
import io.trino.testing.TestingNames;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Test;

final class TestFileHiveMetastore
extends AbstractTestHiveMetastore {
    private final Path tempDir = Files.createTempDirectory("test", new FileAttribute[0]);
    private final HiveMetastore metastore;

    TestFileHiveMetastore() throws IOException {
        LocalFileSystemFactory fileSystemFactory = new LocalFileSystemFactory(this.tempDir);
        this.metastore = new FileHiveMetastore(new NodeVersion("testversion"), (TrinoFileSystemFactory)fileSystemFactory, false, new FileHiveMetastoreConfig().setCatalogDirectory("local:///").setMetastoreUser("test").setDisableLocationChecks(true));
    }

    @AfterAll
    void tearDown() throws IOException {
        MoreFiles.deleteRecursively((Path)this.tempDir, (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE});
    }

    @Override
    protected HiveMetastore getMetastore() {
        return this.metastore;
    }

    @Test
    public void testPreserveHudiInputFormat() {
        String databaseName = "test_database_" + TestingNames.randomNameSuffix();
        Database.Builder database = Database.builder().setDatabaseName(databaseName).setParameters(Map.of("trino_query_id", "query_id")).setOwnerName(Optional.empty()).setOwnerType(Optional.empty());
        this.getMetastore().createDatabase(database.build());
        StorageFormat storageFormat = StorageFormat.create((String)"org.apache.hadoop.hive.ql.io.parquet.serde.ParquetHiveSerDe", (String)"org.apache.hudi.hadoop.HoodieParquetInputFormat", (String)"org.apache.hadoop.hive.ql.io.parquet.MapredParquetOutputFormat");
        String tableName = "some_table_name" + TestingNames.randomNameSuffix();
        Table table = Table.builder().setDatabaseName(databaseName).setTableName(tableName).setTableType(TableType.EXTERNAL_TABLE.name()).setOwner(Optional.of("public")).addDataColumn(new Column("foo", HiveType.HIVE_INT, Optional.empty(), Map.of())).setParameters((Map)ImmutableMap.of((Object)"serialization.format", (Object)"1", (Object)"EXTERNAL", (Object)"TRUE")).withStorage(storageBuilder -> storageBuilder.setStorageFormat(storageFormat).setLocation("file:///dev/null")).build();
        this.metastore.createTable(table, PrincipalPrivileges.NO_PRIVILEGES);
        Table saved = (Table)this.metastore.getTable(databaseName, tableName).orElseThrow();
        Assertions.assertThat((Object)saved.getStorage()).isEqualTo((Object)table.getStorage());
        this.metastore.dropTable(databaseName, tableName, false);
        this.getMetastore().dropDatabase(databaseName, false);
    }
}

