/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.metastore.glue;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.slice.Slices;
import io.trino.spi.predicate.Domain;
import io.trino.spi.predicate.Range;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.predicate.ValueSet;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PartitionFilterBuilder {
    public static final int DECIMAL_TYPE_PRECISION = 10;
    public static final int DECIMAL_TYPE_SCALE = 5;
    public static final DecimalType DECIMAL_TYPE = DecimalType.createDecimalType((int)10, (int)5);
    private final Map<String, Domain> domains = new HashMap<String, Domain>();

    public PartitionFilterBuilder addStringValues(String columnName, String ... values) {
        List blockValues = (List)Arrays.stream(values).map(Slices::utf8Slice).collect(ImmutableList.toImmutableList());
        Domain domain = Domain.multipleValues((Type)VarcharType.VARCHAR, (List)blockValues);
        this.domains.merge(columnName, domain, Domain::union);
        return this;
    }

    public PartitionFilterBuilder addBigintValues(String columnName, Long ... values) {
        Domain domain = Domain.multipleValues((Type)BigintType.BIGINT, Arrays.asList(values));
        this.domains.merge(columnName, domain, Domain::union);
        return this;
    }

    public PartitionFilterBuilder addIntegerValues(String columnName, Long ... values) {
        Domain domain = Domain.multipleValues((Type)IntegerType.INTEGER, Arrays.asList(values));
        this.domains.merge(columnName, domain, Domain::union);
        return this;
    }

    public PartitionFilterBuilder addDecimalValues(String columnName, String ... values) {
        Preconditions.checkArgument((values.length > 0 ? 1 : 0) != 0);
        List encodedValues = (List)Arrays.stream(values).map(PartitionFilterBuilder::decimalOf).collect(ImmutableList.toImmutableList());
        Domain domain = Domain.multipleValues((Type)DECIMAL_TYPE, (List)encodedValues);
        this.domains.merge(columnName, domain, Domain::union);
        return this;
    }

    public PartitionFilterBuilder addRanges(String columnName, Range range, Range ... ranges) {
        ValueSet values = ValueSet.ofRanges((Range)range, (Range[])ranges);
        Domain domain = Domain.create((ValueSet)values, (boolean)false);
        this.domains.merge(columnName, domain, Domain::union);
        return this;
    }

    public PartitionFilterBuilder addDomain(String columnName, Domain domain) {
        this.domains.merge(columnName, domain, Domain::union);
        return this;
    }

    public TupleDomain<String> build() {
        return TupleDomain.withColumnDomains((Map)ImmutableMap.copyOf(this.domains));
    }

    public static Long decimalOf(String value) {
        BigDecimal bigDecimalValue = new BigDecimal(value).setScale(5, RoundingMode.UP);
        return bigDecimalValue.unscaledValue().longValue();
    }
}

