/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.metastore.glue;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.slice.Slices;
import io.trino.metastore.Database;
import io.trino.metastore.HiveBucketProperty;
import io.trino.metastore.HiveType;
import io.trino.metastore.Partition;
import io.trino.metastore.Storage;
import io.trino.metastore.StorageFormat;
import io.trino.plugin.hive.TableType;
import io.trino.plugin.hive.metastore.glue.GlueConverter;
import io.trino.spi.function.LanguageFunction;
import io.trino.spi.security.PrincipalType;
import java.util.Collection;
import java.util.HexFormat;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import software.amazon.awssdk.services.glue.model.Column;
import software.amazon.awssdk.services.glue.model.DatabaseInput;
import software.amazon.awssdk.services.glue.model.PartitionInput;
import software.amazon.awssdk.services.glue.model.SerDeInfo;
import software.amazon.awssdk.services.glue.model.StorageDescriptor;
import software.amazon.awssdk.services.glue.model.Table;
import software.amazon.awssdk.services.glue.model.TableInput;
import software.amazon.awssdk.services.glue.model.UserDefinedFunction;
import software.amazon.awssdk.services.glue.model.UserDefinedFunctionInput;

class TestGlueConverter {
    private final Database trinoDatabase = Database.builder().setDatabaseName("test-database").setComment(Optional.of("database desc")).setLocation(Optional.of("/database")).setParameters((Map)ImmutableMap.of()).setOwnerName(Optional.of("PUBLIC")).setOwnerType(Optional.of(PrincipalType.ROLE)).build();
    private final io.trino.metastore.Table trinoTable = io.trino.metastore.Table.builder().setDatabaseName(this.trinoDatabase.getDatabaseName()).setTableName("test-table").setOwner(Optional.of("owner")).setParameters((Map)ImmutableMap.of()).setTableType(TableType.EXTERNAL_TABLE.name()).setDataColumns((List)ImmutableList.of((Object)new io.trino.metastore.Column("table-data", HiveType.HIVE_STRING, Optional.of("table data column comment"), Map.of()))).setPartitionColumns((List)ImmutableList.of((Object)new io.trino.metastore.Column("table-partition", HiveType.HIVE_STRING, Optional.of("table partition column comment"), Map.of()))).setViewOriginalText(Optional.of("originalText")).setViewExpandedText(Optional.of("expandedText")).withStorage(storage -> storage.setStorageFormat(StorageFormat.create((String)"TableSerdeLib", (String)"TableInputFormat", (String)"TableOutputFormat")).setLocation("/test-table").setBucketProperty(Optional.empty()).setSerdeParameters((Map)ImmutableMap.of())).build();
    private final Partition trinoPartition = Partition.builder().setDatabaseName(this.trinoDatabase.getDatabaseName()).setTableName(this.trinoTable.getTableName()).setValues((List)ImmutableList.of((Object)"val1")).setColumns((List)ImmutableList.of((Object)new io.trino.metastore.Column("partition-data", HiveType.HIVE_STRING, Optional.of("partition data column comment"), Map.of()))).setParameters((Map)ImmutableMap.of()).withStorage(storage -> storage.setStorageFormat(StorageFormat.create((String)"PartitionSerdeLib", (String)"PartitionInputFormat", (String)"PartitionOutputFormat")).setLocation("/test-table/partition").setBucketProperty(Optional.empty()).setSerdeParameters((Map)ImmutableMap.of())).build();
    private final software.amazon.awssdk.services.glue.model.Database glueDatabase = (software.amazon.awssdk.services.glue.model.Database)software.amazon.awssdk.services.glue.model.Database.builder().name("test-database").description("database desc").locationUri("/database").parameters((Map)ImmutableMap.of((Object)"key", (Object)"database-value")).build();
    private final Table glueMaterializedView = (Table)Table.builder().databaseName(this.glueDatabase.name()).name("test-materialized-view").owner("owner").parameters((Map)ImmutableMap.builder().put((Object)"presto_view", (Object)"true").put((Object)"comment", (Object)"Presto Materialized View").buildOrThrow()).tableType(TableType.VIRTUAL_VIEW.name()).viewOriginalText("/* %s: base64encodedquery */".formatted("Presto Materialized View")).viewExpandedText("Presto Materialized View").build();
    private final Table glueView = (Table)Table.builder().databaseName(this.glueDatabase.name()).name("test-regular-view").owner("owner").parameters((Map)ImmutableMap.builder().put((Object)"presto_view", (Object)"true").put((Object)"comment", (Object)"Presto View").buildOrThrow()).tableType(TableType.VIRTUAL_VIEW.name()).viewOriginalText("/* %s: base64encodedquery */".formatted("Presto View")).viewExpandedText("Presto View").build();
    private final Table glueTable = (Table)Table.builder().databaseName(this.glueDatabase.name()).name("test-table").owner("owner").parameters((Map)ImmutableMap.of()).partitionKeys(new Column[]{(Column)Column.builder().name("table-partition").type("string").comment("table partition column comment").build()}).storageDescriptor((StorageDescriptor)StorageDescriptor.builder().bucketColumns((Collection)ImmutableList.of((Object)"test-bucket-col")).columns(new Column[]{(Column)Column.builder().name("table-data").type("string").comment("table data column comment").build()}).parameters((Map)ImmutableMap.of()).serdeInfo((SerDeInfo)SerDeInfo.builder().serializationLibrary("SerdeLib").parameters((Map)ImmutableMap.of()).build()).inputFormat("InputFormat").outputFormat("OutputFormat").location("/test-table").numberOfBuckets(Integer.valueOf(1)).build()).tableType(TableType.EXTERNAL_TABLE.name()).viewOriginalText("originalText").viewExpandedText("expandedText").build();
    private final software.amazon.awssdk.services.glue.model.Partition gluePartition = (software.amazon.awssdk.services.glue.model.Partition)software.amazon.awssdk.services.glue.model.Partition.builder().databaseName(this.glueDatabase.name()).tableName(this.glueTable.name()).values((Collection)ImmutableList.of((Object)"val1")).parameters((Map)ImmutableMap.of()).storageDescriptor((StorageDescriptor)StorageDescriptor.builder().bucketColumns((Collection)ImmutableList.of((Object)"partition-bucket-col")).columns(new Column[]{(Column)Column.builder().name("partition-data").type("string").comment("partition data column comment").build()}).parameters((Map)ImmutableMap.of()).serdeInfo((SerDeInfo)SerDeInfo.builder().serializationLibrary("SerdeLib").parameters((Map)ImmutableMap.of()).build()).inputFormat("InputFormat").outputFormat("OutputFormat").location("/test-table").numberOfBuckets(Integer.valueOf(1)).build()).build();

    TestGlueConverter() {
    }

    @Test
    void testToGlueDatabaseInput() {
        DatabaseInput databaseInput = GlueConverter.toGlueDatabaseInput((Database)this.trinoDatabase);
        Assertions.assertThat((String)databaseInput.name()).isEqualTo(this.trinoDatabase.getDatabaseName());
        Assertions.assertThat((String)databaseInput.description()).isEqualTo((String)this.trinoDatabase.getComment().orElse(null));
        Assertions.assertThat((String)databaseInput.locationUri()).isEqualTo((String)this.trinoDatabase.getLocation().orElse(null));
        Assertions.assertThat((Map)databaseInput.parameters()).isEqualTo((Object)this.trinoDatabase.getParameters());
    }

    @Test
    void testToGlueTableInput() {
        TableInput tableInput = GlueConverter.toGlueTableInput((io.trino.metastore.Table)this.trinoTable);
        Assertions.assertThat((String)tableInput.name()).isEqualTo(this.trinoTable.getTableName());
        Assertions.assertThat((String)tableInput.owner()).isEqualTo((String)this.trinoTable.getOwner().orElse(null));
        Assertions.assertThat((String)tableInput.tableType()).isEqualTo(this.trinoTable.getTableType());
        Assertions.assertThat((Map)tableInput.parameters()).isEqualTo((Object)this.trinoTable.getParameters());
        TestGlueConverter.assertColumnList(tableInput.storageDescriptor().columns(), this.trinoTable.getDataColumns());
        TestGlueConverter.assertColumnList(tableInput.partitionKeys(), this.trinoTable.getPartitionColumns());
        TestGlueConverter.assertStorage(tableInput.storageDescriptor(), this.trinoTable.getStorage());
        Assertions.assertThat((String)tableInput.viewExpandedText()).isEqualTo((String)this.trinoTable.getViewExpandedText().orElse(null));
        Assertions.assertThat((String)tableInput.viewOriginalText()).isEqualTo((String)this.trinoTable.getViewOriginalText().orElse(null));
    }

    @Test
    void testToGluePartitionInput() {
        PartitionInput partitionInput = GlueConverter.toGluePartitionInput((Partition)this.trinoPartition);
        Assertions.assertThat((Map)partitionInput.parameters()).isEqualTo((Object)this.trinoPartition.getParameters());
        TestGlueConverter.assertStorage(partitionInput.storageDescriptor(), this.trinoPartition.getStorage());
        Assertions.assertThat((List)partitionInput.values()).isEqualTo((Object)this.trinoPartition.getValues());
    }

    @Test
    void testToGlueFunctionInput() {
        String sql = HexFormat.of().formatHex(Slices.random((int)2000, (Random)new Random(0L)).getBytes());
        LanguageFunction expected = new LanguageFunction("(integer,bigint,varchar)", sql, List.of(), Optional.of("owner"));
        UserDefinedFunctionInput input = GlueConverter.toGlueFunctionInput((String)"test_name", (LanguageFunction)expected);
        Assertions.assertThat((String)input.ownerName()).isEqualTo((String)expected.owner().orElseThrow());
        UserDefinedFunction function = (UserDefinedFunction)UserDefinedFunction.builder().ownerName(input.ownerName()).resourceUris((Collection)input.resourceUris()).build();
        LanguageFunction actual = GlueConverter.fromGlueFunction((UserDefinedFunction)function);
        Assertions.assertThat((List)input.resourceUris()).hasSize(3);
        Assertions.assertThat((Object)actual).isEqualTo((Object)expected);
        function = (UserDefinedFunction)function.toBuilder().ownerName("other").build();
        actual = GlueConverter.fromGlueFunction((UserDefinedFunction)function);
        Assertions.assertThat((Optional)actual.owner()).isEqualTo(Optional.of("other"));
    }

    @Test
    void testConvertDatabase() {
        Database trinoDatabase = GlueConverter.fromGlueDatabase((software.amazon.awssdk.services.glue.model.Database)this.glueDatabase);
        Assertions.assertThat((String)trinoDatabase.getDatabaseName()).isEqualTo(this.glueDatabase.name());
        Assertions.assertThat((Optional)trinoDatabase.getLocation()).hasValue((Object)this.glueDatabase.locationUri());
        Assertions.assertThat((Optional)trinoDatabase.getComment()).hasValue((Object)this.glueDatabase.description());
        Assertions.assertThat((Map)trinoDatabase.getParameters()).isEqualTo((Object)this.glueDatabase.parameters());
        Assertions.assertThat((Optional)trinoDatabase.getOwnerName()).isEqualTo(Optional.of("PUBLIC"));
        Assertions.assertThat((Optional)trinoDatabase.getOwnerType()).isEqualTo(Optional.of(PrincipalType.ROLE));
    }

    @Test
    void testConvertTable() {
        io.trino.metastore.Table trinoTable = GlueConverter.fromGlueTable((Table)this.glueTable, (String)this.glueDatabase.name());
        Assertions.assertThat((String)trinoTable.getTableName()).isEqualTo(this.glueTable.name());
        Assertions.assertThat((String)trinoTable.getDatabaseName()).isEqualTo(this.glueDatabase.name());
        Assertions.assertThat((String)trinoTable.getTableType()).isEqualTo(GlueConverter.getTableTypeNullable((Table)this.glueTable));
        Assertions.assertThat((String)trinoTable.getOwner().orElse(null)).isEqualTo(this.glueTable.owner());
        Assertions.assertThat((Map)trinoTable.getParameters()).isEqualTo((Object)this.glueTable.parameters());
        TestGlueConverter.assertColumnList(this.glueTable.storageDescriptor().columns(), trinoTable.getDataColumns());
        TestGlueConverter.assertColumnList(this.glueTable.partitionKeys(), trinoTable.getPartitionColumns());
        TestGlueConverter.assertStorage(this.glueTable.storageDescriptor(), trinoTable.getStorage());
        Assertions.assertThat((Optional)trinoTable.getViewOriginalText()).hasValue((Object)this.glueTable.viewOriginalText());
        Assertions.assertThat((Optional)trinoTable.getViewExpandedText()).hasValue((Object)this.glueTable.viewExpandedText());
    }

    @Test
    void testConvertTableWithOpenCSVSerDe() {
        Table glueTable = (Table)this.glueTable.toBuilder().storageDescriptor((StorageDescriptor)this.glueTable.storageDescriptor().toBuilder().columns((Collection)ImmutableList.of((Object)((Column)Column.builder().name("int_column").type("int").comment("int column").build()))).inputFormat("org.apache.hadoop.hive.ql.io.parquet.MapredParquetInputFormat").outputFormat("org.apache.hadoop.hive.ql.io.parquet.MapredParquetOutputFormat").serdeInfo((SerDeInfo)SerDeInfo.builder().serializationLibrary("org.apache.hadoop.hive.serde2.OpenCSVSerde").parameters((Map)ImmutableMap.of()).build()).build()).build();
        io.trino.metastore.Table trinoTable = GlueConverter.fromGlueTable((Table)glueTable, (String)glueTable.databaseName());
        Assertions.assertThat((String)trinoTable.getTableName()).isEqualTo(glueTable.name());
        Assertions.assertThat((String)trinoTable.getDatabaseName()).isEqualTo(this.glueDatabase.name());
        Assertions.assertThat((String)trinoTable.getTableType()).isEqualTo(GlueConverter.getTableTypeNullable((Table)glueTable));
        Assertions.assertThat((String)trinoTable.getOwner().orElse(null)).isEqualTo(glueTable.owner());
        Assertions.assertThat((Map)trinoTable.getParameters()).isEqualTo((Object)glueTable.parameters());
        Assertions.assertThat((List)trinoTable.getDataColumns()).hasSize(1);
        Assertions.assertThat((Object)((io.trino.metastore.Column)trinoTable.getDataColumns().getFirst()).getType()).isEqualTo((Object)HiveType.HIVE_STRING);
        TestGlueConverter.assertColumnList(glueTable.partitionKeys(), trinoTable.getPartitionColumns());
        TestGlueConverter.assertStorage(glueTable.storageDescriptor(), trinoTable.getStorage());
        Assertions.assertThat((Optional)trinoTable.getViewOriginalText()).hasValue((Object)glueTable.viewOriginalText());
        Assertions.assertThat((Optional)trinoTable.getViewExpandedText()).hasValue((Object)glueTable.viewExpandedText());
    }

    @Test
    void testConvertTableWithoutTableType() {
        Table table = (Table)this.glueTable.toBuilder().tableType(null).build();
        io.trino.metastore.Table trinoTable = GlueConverter.fromGlueTable((Table)table, (String)table.databaseName());
        Assertions.assertThat((String)trinoTable.getTableType()).isEqualTo(TableType.EXTERNAL_TABLE.name());
    }

    @Test
    void testConvertTableNullPartitions() {
        Table table = (Table)this.glueTable.toBuilder().partitionKeys((Collection)ImmutableList.of()).build();
        io.trino.metastore.Table trinoTable = GlueConverter.fromGlueTable((Table)table, (String)table.databaseName());
        Assertions.assertThat((List)trinoTable.getPartitionColumns()).isEmpty();
    }

    @Test
    void testConvertTableUppercaseColumnType() {
        Table table = (Table)this.glueTable.toBuilder().partitionKeys(new Column[]{(Column)Column.builder().name("table-partition").type("String").comment("table partition column comment").build()}).build();
        Assertions.assertThat((Object)((io.trino.metastore.Column)GlueConverter.fromGlueTable((Table)table, (String)table.databaseName()).getPartitionColumns().getFirst()).getType()).isEqualTo((Object)HiveType.HIVE_STRING);
    }

    @Test
    void testConvertPartition() {
        Partition trinoPartition = GlueConverter.fromGluePartition((String)this.gluePartition.databaseName(), (String)this.gluePartition.tableName(), (software.amazon.awssdk.services.glue.model.Partition)this.gluePartition);
        Assertions.assertThat((String)trinoPartition.getDatabaseName()).isEqualTo(this.gluePartition.databaseName());
        Assertions.assertThat((String)trinoPartition.getTableName()).isEqualTo(this.gluePartition.tableName());
        TestGlueConverter.assertColumnList(this.gluePartition.storageDescriptor().columns(), trinoPartition.getColumns());
        Assertions.assertThat((List)trinoPartition.getValues()).isEqualTo((Object)this.gluePartition.values());
        TestGlueConverter.assertStorage(this.gluePartition.storageDescriptor(), trinoPartition.getStorage());
        Assertions.assertThat((Map)trinoPartition.getParameters()).isEqualTo((Object)this.gluePartition.parameters());
    }

    @Test
    void testDatabaseNullParameters() {
        software.amazon.awssdk.services.glue.model.Database database = (software.amazon.awssdk.services.glue.model.Database)this.glueDatabase.toBuilder().parameters(null).build();
        Assertions.assertThat((Map)GlueConverter.fromGlueDatabase((software.amazon.awssdk.services.glue.model.Database)database).getParameters()).isNotNull();
    }

    @Test
    void testTableNullParameters() {
        Table table = (Table)this.glueTable.toBuilder().parameters(null).storageDescriptor((StorageDescriptor)this.glueTable.storageDescriptor().toBuilder().serdeInfo((SerDeInfo)this.glueTable.storageDescriptor().serdeInfo().toBuilder().parameters(null).build()).build()).build();
        io.trino.metastore.Table trinoTable = GlueConverter.fromGlueTable((Table)table, (String)this.glueTable.databaseName());
        Assertions.assertThat((Map)trinoTable.getParameters()).isNotNull();
        Assertions.assertThat((Map)trinoTable.getStorage().getSerdeParameters()).isNotNull();
    }

    @Test
    void testIcebergTableNullStorageDescriptor() {
        Table table = (Table)this.glueTable.toBuilder().parameters((Map)ImmutableMap.of((Object)"table_type", (Object)"iceberg")).storageDescriptor((StorageDescriptor)null).build();
        io.trino.metastore.Table trinoTable = GlueConverter.fromGlueTable((Table)table, (String)table.databaseName());
        Assertions.assertThat((List)trinoTable.getDataColumns()).hasSize(1);
    }

    @Test
    void testIcebergTableNonNullStorageDescriptor() {
        Table table = (Table)this.glueTable.toBuilder().parameters((Map)ImmutableMap.of((Object)"table_type", (Object)"iceberg")).build();
        Assertions.assertThat((Object)table.storageDescriptor()).isNotNull();
        io.trino.metastore.Table trinoTable = GlueConverter.fromGlueTable((Table)table, (String)table.databaseName());
        Assertions.assertThat((List)trinoTable.getDataColumns()).hasSize(1);
    }

    @Test
    void testDeltaTableNullStorageDescriptor() {
        Table table = (Table)this.glueTable.toBuilder().parameters((Map)ImmutableMap.of((Object)"spark.sql.sources.provider", (Object)"delta")).storageDescriptor((StorageDescriptor)null).build();
        io.trino.metastore.Table trinoTable = GlueConverter.fromGlueTable((Table)table, (String)table.databaseName());
        Assertions.assertThat((List)trinoTable.getDataColumns()).hasSize(1);
    }

    @Test
    void testDeltaTableNonNullStorageDescriptor() {
        Table table = (Table)this.glueTable.toBuilder().parameters((Map)ImmutableMap.of((Object)"spark.sql.sources.provider", (Object)"delta")).build();
        Assertions.assertThat((Object)table.storageDescriptor()).isNotNull();
        io.trino.metastore.Table trinoTable = GlueConverter.fromGlueTable((Table)table, (String)table.databaseName());
        Assertions.assertThat((List)trinoTable.getDataColumns()).hasSize(1);
    }

    @Test
    public void testIcebergMaterializedViewNullStorageDescriptor() {
        Assertions.assertThat((Object)this.glueMaterializedView.storageDescriptor()).isNull();
        io.trino.metastore.Table trinoTable = GlueConverter.fromGlueTable((Table)this.glueMaterializedView, (String)this.glueMaterializedView.databaseName());
        Assertions.assertThat((List)trinoTable.getDataColumns()).hasSize(1);
    }

    @Test
    public void testIcebergTrinoViewNullStorageDescriptor() {
        Assertions.assertThat((Object)this.glueView.storageDescriptor()).isNull();
        io.trino.metastore.Table trinoTable = GlueConverter.fromGlueTable((Table)this.glueView, (String)this.glueView.databaseName());
        Assertions.assertThat((List)trinoTable.getDataColumns()).hasSize(1);
    }

    @Test
    void testPartitionNullParameters() {
        software.amazon.awssdk.services.glue.model.Partition partition = (software.amazon.awssdk.services.glue.model.Partition)this.gluePartition.toBuilder().parameters(null).build();
        Assertions.assertThat((Map)GlueConverter.fromGluePartition((String)partition.databaseName(), (String)partition.tableName(), (software.amazon.awssdk.services.glue.model.Partition)partition).getParameters()).isNotNull();
    }

    private static void assertColumnList(List<Column> glueColumns, List<io.trino.metastore.Column> trinoColumns) {
        if (trinoColumns == null) {
            Assertions.assertThat(glueColumns).isNull();
        }
        Assertions.assertThat(glueColumns).isNotNull();
        Assertions.assertThat(glueColumns).hasSize(trinoColumns.size());
        for (int i = 0; i < trinoColumns.size(); ++i) {
            TestGlueConverter.assertColumn(glueColumns.get(i), trinoColumns.get(i));
        }
    }

    private static void assertColumn(Column glueColumn, io.trino.metastore.Column trinoColumn) {
        Assertions.assertThat((String)glueColumn.name()).isEqualTo(trinoColumn.getName());
        Assertions.assertThat((String)glueColumn.type()).isEqualTo(trinoColumn.getType().getHiveTypeName().toString());
        Assertions.assertThat((String)glueColumn.comment()).isEqualTo((String)trinoColumn.getComment().orElse(null));
    }

    private static void assertStorage(StorageDescriptor glueStorage, Storage trinoStorage) {
        Assertions.assertThat((String)glueStorage.location()).isEqualTo(trinoStorage.getLocation());
        Assertions.assertThat((String)glueStorage.serdeInfo().serializationLibrary()).isEqualTo(trinoStorage.getStorageFormat().getSerde());
        Assertions.assertThat((String)glueStorage.inputFormat()).isEqualTo(trinoStorage.getStorageFormat().getInputFormat());
        Assertions.assertThat((String)glueStorage.outputFormat()).isEqualTo(trinoStorage.getStorageFormat().getOutputFormat());
        if (trinoStorage.getBucketProperty().isPresent()) {
            HiveBucketProperty bucketProperty = (HiveBucketProperty)trinoStorage.getBucketProperty().get();
            Assertions.assertThat((List)glueStorage.bucketColumns()).isEqualTo((Object)bucketProperty.bucketedBy());
            Assertions.assertThat((int)glueStorage.numberOfBuckets()).isEqualTo(bucketProperty.bucketCount());
        }
    }
}

