/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.metastore.glue;

import com.google.common.collect.Iterables;
import io.trino.plugin.hive.HiveQueryRunner;
import io.trino.testing.AbstractTestQueryFramework;
import io.trino.testing.DistributedQueryRunner;
import io.trino.testing.QueryRunner;
import io.trino.testing.TestingNames;
import io.trino.testing.TestingSession;
import io.trino.testing.sql.TestTable;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Test;
import software.amazon.awssdk.services.glue.GlueClient;
import software.amazon.awssdk.services.glue.model.TableVersion;

final class TestGlueHiveMetastoreSkipArchive
extends AbstractTestQueryFramework {
    private final String testSchema = "test_schema_" + TestingNames.randomNameSuffix();
    private final GlueClient glueClient = GlueClient.create();

    TestGlueHiveMetastoreSkipArchive() {
    }

    protected QueryRunner createQueryRunner() throws Exception {
        DistributedQueryRunner queryRunner = ((HiveQueryRunner.Builder)((Object)((HiveQueryRunner.Builder)((Object)((HiveQueryRunner.Builder)((Object)((HiveQueryRunner.Builder)((Object)HiveQueryRunner.builder(TestingSession.testSessionBuilder().setCatalog("hive").setSchema(this.testSchema).build()).addHiveProperty("hive.metastore", "glue").addHiveProperty("hive.metastore.glue.default-warehouse-dir", "local:///glue"))).addHiveProperty("hive.security", "allow-all"))).addHiveProperty("hive.metastore.glue.skip-archive", "true"))).setCreateTpchSchemas(false))).build();
        queryRunner.execute("CREATE SCHEMA " + this.testSchema);
        return queryRunner;
    }

    @AfterAll
    void cleanUpSchema() {
        this.getQueryRunner().execute("DROP SCHEMA " + this.testSchema + " CASCADE");
    }

    @Test
    void testSkipArchive() {
        try (TestTable table = this.newTrinoTable("test_skip_archive", "(col int)");){
            List<TableVersion> tableVersionsBeforeInsert = this.getTableVersions(this.testSchema, table.getName());
            Assertions.assertThat(tableVersionsBeforeInsert).hasSize(1);
            String versionIdBeforeInsert = ((TableVersion)Iterables.getOnlyElement(tableVersionsBeforeInsert)).versionId();
            this.assertUpdate("INSERT INTO " + table.getName() + " VALUES 1", 1L);
            List<TableVersion> tableVersionsAfterInsert = this.getTableVersions(this.testSchema, table.getName());
            Assertions.assertThat(tableVersionsAfterInsert).hasSize(1);
            String versionIdAfterInsert = ((TableVersion)Iterables.getOnlyElement(tableVersionsAfterInsert)).versionId();
            Assertions.assertThat((String)versionIdBeforeInsert).isNotEqualTo((Object)versionIdAfterInsert);
        }
    }

    private List<TableVersion> getTableVersions(String databaseName, String tableName) {
        return this.glueClient.getTableVersions(builder -> builder.databaseName(databaseName).tableName(tableName)).tableVersions();
    }
}

