/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.metastore.glue;

import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.Uninterruptibles;
import io.airlift.units.Duration;
import io.trino.metastore.Column;
import io.trino.metastore.Database;
import io.trino.metastore.HiveColumnStatistics;
import io.trino.metastore.HiveType;
import io.trino.metastore.Partition;
import io.trino.metastore.StorageFormat;
import io.trino.metastore.Table;
import io.trino.metastore.TableInfo;
import io.trino.plugin.hive.HiveErrorCode;
import io.trino.plugin.hive.metastore.glue.GlueCache;
import io.trino.plugin.hive.metastore.glue.InMemoryGlueCache;
import io.trino.plugin.hive.metastore.glue.PartitionName;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.TrinoException;
import io.trino.spi.catalog.CatalogName;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.function.LanguageFunction;
import io.trino.spi.security.PrincipalType;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalLong;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class TestInMemoryGlueCache {
    TestInMemoryGlueCache() {
    }

    private static GlueCache createGlueCache() {
        return new InMemoryGlueCache(new CatalogName("testing"), new Duration(1.0, TimeUnit.DAYS), new Duration(1.0, TimeUnit.DAYS), Optional.of(new Duration(12.0, TimeUnit.HOURS)), 1, Long.MAX_VALUE);
    }

    @Test
    void testGetDatabaseNames() {
        GlueCache glueCache = TestInMemoryGlueCache.createGlueCache();
        Assertions.assertThat((List)glueCache.getDatabaseNames(consumer -> ImmutableList.of((Object)"db1", (Object)"db2"))).containsExactly((Object[])new String[]{"db1", "db2"});
        Assertions.assertThat((List)glueCache.getDatabaseNames(consumer -> ImmutableList.of((Object)"fail"))).containsExactly((Object[])new String[]{"db1", "db2"});
        Assertions.assertThat((List)glueCache.getDatabaseNames(consumer -> {
            throw new RuntimeException();
        })).containsExactly((Object[])new String[]{"db1", "db2"});
        glueCache.invalidateDatabaseNames();
        Assertions.assertThat((List)glueCache.getDatabaseNames(consumer -> ImmutableList.of((Object)"db5", (Object)"db6"))).containsExactly((Object[])new String[]{"db5", "db6"});
        glueCache.invalidateDatabaseNames();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> glueCache.getDatabaseNames(consumer -> {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, "test");
        })).isInstanceOf(TrinoException.class)).hasMessage("test");
        Assertions.assertThat((List)glueCache.getDatabaseNames(consumer -> ImmutableList.of((Object)"after exception"))).containsExactly((Object[])new String[]{"after exception"});
    }

    @Test
    void testGetDatabaseNamesWithCacheDatabase() throws InterruptedException {
        GlueCache glueCache = TestInMemoryGlueCache.createGlueCache();
        Assertions.assertThat((List)glueCache.getDatabaseNames(cacheDatabase -> {
            cacheDatabase.accept(TestInMemoryGlueCache.testDatabase("db1", "initial"));
            cacheDatabase.accept(TestInMemoryGlueCache.testDatabase("db2", "initial"));
            return ImmutableList.of((Object)"db1", (Object)"db2");
        })).containsExactly((Object[])new String[]{"db1", "db2"});
        Assertions.assertThat((Optional)glueCache.getDatabase("db1", () -> {
            throw new RuntimeException();
        })).contains((Object)TestInMemoryGlueCache.testDatabase("db1", "initial"));
        Assertions.assertThat((Optional)glueCache.getDatabase("db2", () -> {
            throw new RuntimeException();
        })).contains((Object)TestInMemoryGlueCache.testDatabase("db2", "initial"));
        glueCache.invalidateDatabaseNames();
        Assertions.assertThat((Optional)glueCache.getDatabase("db1", () -> {
            throw new RuntimeException();
        })).contains((Object)TestInMemoryGlueCache.testDatabase("db1", "initial"));
        Assertions.assertThat((Optional)glueCache.getDatabase("db2", () -> {
            throw new RuntimeException();
        })).contains((Object)TestInMemoryGlueCache.testDatabase("db2", "initial"));
        Assertions.assertThat((List)glueCache.getDatabaseNames(cacheDatabase -> {
            cacheDatabase.accept(TestInMemoryGlueCache.testDatabase("db2", "updated"));
            cacheDatabase.accept(TestInMemoryGlueCache.testDatabase("db3", "initial"));
            cacheDatabase.accept(TestInMemoryGlueCache.testDatabase("db4", "initial"));
            return ImmutableList.of((Object)"db2", (Object)"db3");
        })).containsExactly((Object[])new String[]{"db2", "db3"});
        Assertions.assertThat((Optional)glueCache.getDatabase("db1", () -> {
            throw new RuntimeException();
        })).contains((Object)TestInMemoryGlueCache.testDatabase("db1", "initial"));
        Assertions.assertThat((Optional)glueCache.getDatabase("db2", () -> {
            throw new RuntimeException();
        })).contains((Object)TestInMemoryGlueCache.testDatabase("db2", "updated"));
        Assertions.assertThat((Optional)glueCache.getDatabase("db3", () -> {
            throw new RuntimeException();
        })).contains((Object)TestInMemoryGlueCache.testDatabase("db3", "initial"));
        Assertions.assertThat((Optional)glueCache.getDatabase("db4", () -> {
            throw new RuntimeException();
        })).contains((Object)TestInMemoryGlueCache.testDatabase("db4", "initial"));
        glueCache.invalidateDatabase("unknown");
        Assertions.assertThat((List)glueCache.getDatabaseNames(cacheDatabase -> {
            throw new RuntimeException();
        })).containsExactly((Object[])new String[]{"db2", "db3"});
        glueCache.invalidateDatabaseNames();
        Assertions.assertThat((Optional)glueCache.getDatabase("db1", () -> {
            throw new RuntimeException();
        })).contains((Object)TestInMemoryGlueCache.testDatabase("db1", "initial"));
        Assertions.assertThat((Optional)glueCache.getDatabase("db2", () -> {
            throw new RuntimeException();
        })).contains((Object)TestInMemoryGlueCache.testDatabase("db2", "updated"));
        Assertions.assertThat((Optional)glueCache.getDatabase("db3", () -> {
            throw new RuntimeException();
        })).contains((Object)TestInMemoryGlueCache.testDatabase("db3", "initial"));
        Assertions.assertThat((Optional)glueCache.getDatabase("db4", () -> {
            throw new RuntimeException();
        })).contains((Object)TestInMemoryGlueCache.testDatabase("db4", "initial"));
        CountDownLatch inBulkLoad = new CountDownLatch(1);
        CountDownLatch invalidated = new CountDownLatch(1);
        Thread thread = Thread.startVirtualThread(() -> Assertions.assertThat((List)glueCache.getDatabaseNames(cacheDatabase -> {
            cacheDatabase.accept(TestInMemoryGlueCache.testDatabase("db1", "bulk"));
            cacheDatabase.accept(TestInMemoryGlueCache.testDatabase("db2", "bulk"));
            inBulkLoad.countDown();
            Uninterruptibles.awaitUninterruptibly((CountDownLatch)invalidated);
            cacheDatabase.accept(TestInMemoryGlueCache.testDatabase("db3", "bulk"));
            cacheDatabase.accept(TestInMemoryGlueCache.testDatabase("db4", "bulk"));
            return ImmutableList.of((Object)"db1", (Object)"db2", (Object)"db3", (Object)"db4");
        })).containsExactly((Object[])new String[]{"db1", "db2", "db3", "db4"}));
        Uninterruptibles.awaitUninterruptibly((CountDownLatch)inBulkLoad);
        glueCache.invalidateDatabase("unknown");
        invalidated.countDown();
        thread.join();
        Assertions.assertThat((Optional)glueCache.getDatabase("db1", () -> {
            throw new RuntimeException();
        })).contains((Object)TestInMemoryGlueCache.testDatabase("db1", "bulk"));
        Assertions.assertThat((Optional)glueCache.getDatabase("db2", () -> {
            throw new RuntimeException();
        })).contains((Object)TestInMemoryGlueCache.testDatabase("db2", "bulk"));
        Assertions.assertThat((Optional)glueCache.getDatabase("db3", () -> {
            throw new RuntimeException();
        })).contains((Object)TestInMemoryGlueCache.testDatabase("db3", "initial"));
        Assertions.assertThat((Optional)glueCache.getDatabase("db4", () -> {
            throw new RuntimeException();
        })).contains((Object)TestInMemoryGlueCache.testDatabase("db4", "initial"));
    }

    @Test
    void testGetDatabase() {
        GlueCache glueCache = TestInMemoryGlueCache.createGlueCache();
        Assertions.assertThat((Optional)glueCache.getDatabase("db1", () -> Optional.of(TestInMemoryGlueCache.testDatabase("db1")))).contains((Object)TestInMemoryGlueCache.testDatabase("db1"));
        Assertions.assertThat((Optional)glueCache.getDatabase("db1", () -> Optional.of(TestInMemoryGlueCache.testDatabase("fail")))).contains((Object)TestInMemoryGlueCache.testDatabase("db1"));
        Assertions.assertThat((Optional)glueCache.getDatabase("db1", () -> {
            throw new RuntimeException();
        })).contains((Object)TestInMemoryGlueCache.testDatabase("db1"));
        glueCache.invalidateDatabase("db1");
        Assertions.assertThat((Optional)glueCache.getDatabase("db1", () -> Optional.of(TestInMemoryGlueCache.testDatabase("db1", "alternate")))).contains((Object)TestInMemoryGlueCache.testDatabase("db1", "alternate"));
        glueCache.invalidateDatabase("db1");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> glueCache.getDatabase("db1", () -> {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, "test");
        })).isInstanceOf(TrinoException.class)).hasMessage("test");
        Assertions.assertThat((Optional)glueCache.getDatabase("db1", () -> Optional.of(TestInMemoryGlueCache.testDatabase("after exception")))).contains((Object)TestInMemoryGlueCache.testDatabase("after exception"));
    }

    @Test
    void testGetTables() {
        GlueCache glueCache = TestInMemoryGlueCache.createGlueCache();
        Assertions.assertThat((List)glueCache.getTables("db1", cacheTable -> ImmutableList.of((Object)TestInMemoryGlueCache.testTableInfo("db1", "table1"), (Object)TestInMemoryGlueCache.testTableInfo("db1", "table2")))).containsExactlyInAnyOrder((Object[])new TableInfo[]{TestInMemoryGlueCache.testTableInfo("db1", "table1"), TestInMemoryGlueCache.testTableInfo("db1", "table2")});
        Assertions.assertThat((List)glueCache.getTables("db1", cacheTable -> ImmutableList.of((Object)TestInMemoryGlueCache.testTableInfo("db1", "fail")))).containsExactlyInAnyOrder((Object[])new TableInfo[]{TestInMemoryGlueCache.testTableInfo("db1", "table1"), TestInMemoryGlueCache.testTableInfo("db1", "table2")});
        Assertions.assertThat((List)glueCache.getTables("db1", cacheTable -> {
            throw new RuntimeException();
        })).containsExactlyInAnyOrder((Object[])new TableInfo[]{TestInMemoryGlueCache.testTableInfo("db1", "table1"), TestInMemoryGlueCache.testTableInfo("db1", "table2")});
        glueCache.invalidateTables("db1");
        Assertions.assertThat((List)glueCache.getTables("db1", cacheTable -> ImmutableList.of((Object)TestInMemoryGlueCache.testTableInfo("db1", "table3"), (Object)TestInMemoryGlueCache.testTableInfo("db1", "table4")))).containsExactlyInAnyOrder((Object[])new TableInfo[]{TestInMemoryGlueCache.testTableInfo("db1", "table3"), TestInMemoryGlueCache.testTableInfo("db1", "table4")});
        glueCache.invalidateTables("db1");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> glueCache.getTables("db1", cacheTable -> {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, "test");
        })).isInstanceOf(TrinoException.class)).hasMessage("test");
        Assertions.assertThat((List)glueCache.getTables("db1", cacheTable -> ImmutableList.of((Object)TestInMemoryGlueCache.testTableInfo("db1", "after exception")))).containsExactlyInAnyOrder((Object[])new TableInfo[]{TestInMemoryGlueCache.testTableInfo("db1", "after exception")});
    }

    @Test
    void testGetTablesWithCacheDatabase() throws InterruptedException {
        GlueCache glueCache = TestInMemoryGlueCache.createGlueCache();
        Assertions.assertThat((List)glueCache.getTables("db1", cacheTable -> {
            cacheTable.accept(TestInMemoryGlueCache.testTable("db1", "table1", "initial"));
            cacheTable.accept(TestInMemoryGlueCache.testTable("db1", "table2", "initial"));
            return ImmutableList.of((Object)TestInMemoryGlueCache.testTableInfo("db1", "table1"), (Object)TestInMemoryGlueCache.testTableInfo("db1", "table2"));
        })).containsExactlyInAnyOrder((Object[])new TableInfo[]{TestInMemoryGlueCache.testTableInfo("db1", "table1"), TestInMemoryGlueCache.testTableInfo("db1", "table2")});
        Assertions.assertThat((Optional)glueCache.getTable("db1", "table1", () -> {
            throw new RuntimeException();
        })).contains((Object)TestInMemoryGlueCache.testTable("db1", "table1", "initial"));
        Assertions.assertThat((Optional)glueCache.getTable("db1", "table2", () -> {
            throw new RuntimeException();
        })).contains((Object)TestInMemoryGlueCache.testTable("db1", "table2", "initial"));
        glueCache.invalidateTables("db1");
        Assertions.assertThat((Optional)glueCache.getTable("db1", "table1", () -> {
            throw new RuntimeException();
        })).contains((Object)TestInMemoryGlueCache.testTable("db1", "table1", "initial"));
        Assertions.assertThat((Optional)glueCache.getTable("db1", "table2", () -> {
            throw new RuntimeException();
        })).contains((Object)TestInMemoryGlueCache.testTable("db1", "table2", "initial"));
        Assertions.assertThat((List)glueCache.getTables("db1", cacheTable -> {
            cacheTable.accept(TestInMemoryGlueCache.testTable("db1", "table2", "updated"));
            cacheTable.accept(TestInMemoryGlueCache.testTable("db1", "table3", "initial"));
            cacheTable.accept(TestInMemoryGlueCache.testTable("db1", "table4", "initial"));
            return ImmutableList.of((Object)TestInMemoryGlueCache.testTableInfo("db1", "table2"), (Object)TestInMemoryGlueCache.testTableInfo("db1", "table3"));
        })).containsExactlyInAnyOrder((Object[])new TableInfo[]{TestInMemoryGlueCache.testTableInfo("db1", "table2"), TestInMemoryGlueCache.testTableInfo("db1", "table3")});
        Assertions.assertThat((Optional)glueCache.getTable("db1", "table1", () -> {
            throw new RuntimeException();
        })).contains((Object)TestInMemoryGlueCache.testTable("db1", "table1", "initial"));
        Assertions.assertThat((Optional)glueCache.getTable("db1", "table2", () -> {
            throw new RuntimeException();
        })).contains((Object)TestInMemoryGlueCache.testTable("db1", "table2", "updated"));
        Assertions.assertThat((Optional)glueCache.getTable("db1", "table3", () -> {
            throw new RuntimeException();
        })).contains((Object)TestInMemoryGlueCache.testTable("db1", "table3", "initial"));
        Assertions.assertThat((Optional)glueCache.getTable("db1", "table4", () -> {
            throw new RuntimeException();
        })).contains((Object)TestInMemoryGlueCache.testTable("db1", "table4", "initial"));
        glueCache.invalidateTable("db1", "unknown", true);
        Assertions.assertThat((List)glueCache.getTables("db1", cacheTable -> {
            throw new RuntimeException();
        })).containsExactlyInAnyOrder((Object[])new TableInfo[]{TestInMemoryGlueCache.testTableInfo("db1", "table2"), TestInMemoryGlueCache.testTableInfo("db1", "table3")});
        glueCache.invalidateTables("db1");
        Assertions.assertThat((Optional)glueCache.getTable("db1", "table1", () -> {
            throw new RuntimeException();
        })).contains((Object)TestInMemoryGlueCache.testTable("db1", "table1", "initial"));
        Assertions.assertThat((Optional)glueCache.getTable("db1", "table2", () -> {
            throw new RuntimeException();
        })).contains((Object)TestInMemoryGlueCache.testTable("db1", "table2", "updated"));
        Assertions.assertThat((Optional)glueCache.getTable("db1", "table3", () -> {
            throw new RuntimeException();
        })).contains((Object)TestInMemoryGlueCache.testTable("db1", "table3", "initial"));
        CountDownLatch inBulkLoad = new CountDownLatch(1);
        CountDownLatch invalidated = new CountDownLatch(1);
        Thread thread = Thread.startVirtualThread(() -> Assertions.assertThat((List)glueCache.getTables("db1", cacheTable -> {
            cacheTable.accept(TestInMemoryGlueCache.testTable("db1", "table1", "bulk"));
            cacheTable.accept(TestInMemoryGlueCache.testTable("db1", "table2", "bulk"));
            inBulkLoad.countDown();
            Uninterruptibles.awaitUninterruptibly((CountDownLatch)invalidated);
            cacheTable.accept(TestInMemoryGlueCache.testTable("db1", "table3", "bulk"));
            cacheTable.accept(TestInMemoryGlueCache.testTable("db1", "table4", "bulk"));
            return ImmutableList.of((Object)TestInMemoryGlueCache.testTableInfo("db1", "table1"), (Object)TestInMemoryGlueCache.testTableInfo("db1", "table2"), (Object)TestInMemoryGlueCache.testTableInfo("db1", "table3"), (Object)TestInMemoryGlueCache.testTableInfo("db1", "table4"));
        })).containsExactlyInAnyOrder((Object[])new TableInfo[]{TestInMemoryGlueCache.testTableInfo("db1", "table1"), TestInMemoryGlueCache.testTableInfo("db1", "table2"), TestInMemoryGlueCache.testTableInfo("db1", "table3"), TestInMemoryGlueCache.testTableInfo("db1", "table4")}));
        Uninterruptibles.awaitUninterruptibly((CountDownLatch)inBulkLoad);
        glueCache.invalidateTable("db1", "unknown", true);
        invalidated.countDown();
        thread.join();
        Assertions.assertThat((Optional)glueCache.getTable("db1", "table1", () -> {
            throw new RuntimeException();
        })).contains((Object)TestInMemoryGlueCache.testTable("db1", "table1", "bulk"));
        Assertions.assertThat((Optional)glueCache.getTable("db1", "table2", () -> {
            throw new RuntimeException();
        })).contains((Object)TestInMemoryGlueCache.testTable("db1", "table2", "bulk"));
        Assertions.assertThat((Optional)glueCache.getTable("db1", "table3", () -> {
            throw new RuntimeException();
        })).contains((Object)TestInMemoryGlueCache.testTable("db1", "table3", "initial"));
        Assertions.assertThat((Optional)glueCache.getTable("db1", "table4", () -> {
            throw new RuntimeException();
        })).contains((Object)TestInMemoryGlueCache.testTable("db1", "table4", "initial"));
    }

    @Test
    void testGetTable() {
        GlueCache glueCache = TestInMemoryGlueCache.createGlueCache();
        Assertions.assertThat((Optional)glueCache.getTable("db1", "table1", () -> Optional.of(TestInMemoryGlueCache.testTable("db1", "table1")))).contains((Object)TestInMemoryGlueCache.testTable("db1", "table1"));
        Assertions.assertThat((Optional)glueCache.getTable("db1", "table1", () -> Optional.of(TestInMemoryGlueCache.testTable("db1", "fail")))).contains((Object)TestInMemoryGlueCache.testTable("db1", "table1"));
        Assertions.assertThat((Optional)glueCache.getTable("db1", "table1", () -> {
            throw new RuntimeException();
        })).contains((Object)TestInMemoryGlueCache.testTable("db1", "table1"));
        glueCache.invalidateTable("db1", "table1", true);
        Assertions.assertThat((Optional)glueCache.getTable("db1", "table1", () -> Optional.of(TestInMemoryGlueCache.testTable("db1", "what")))).contains((Object)TestInMemoryGlueCache.testTable("db1", "what"));
        glueCache.invalidateTable("db1", "table1", true);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> glueCache.getTable("db1", "table1", () -> {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, "test");
        })).isInstanceOf(TrinoException.class)).hasMessage("test");
        Assertions.assertThat((Optional)glueCache.getTable("db1", "table1", () -> Optional.of(TestInMemoryGlueCache.testTable("db1", "after exception")))).contains((Object)TestInMemoryGlueCache.testTable("db1", "after exception"));
    }

    @Test
    void testGetTableColumnStatistics() {
        GlueCache glueCache = TestInMemoryGlueCache.createGlueCache();
        Assertions.assertThat((Map)glueCache.getTableColumnStatistics("db", "table", Set.of("col1", "col2"), missingColumns -> {
            Assertions.assertThat((Collection)missingColumns).containsExactlyInAnyOrder((Object[])new String[]{"col1", "col2"});
            return Map.of();
        })).isEmpty();
        Assertions.assertThat((Map)glueCache.getTableColumnStatistics("db", "table", Set.of("col1", "col2"), missingColumns -> {
            throw new RuntimeException();
        })).isEmpty();
        glueCache.invalidateTableColumnStatistics("db", "table");
        Assertions.assertThat((Map)glueCache.getTableColumnStatistics("db", "table", Set.of("col1", "col2"), missingColumns -> {
            Assertions.assertThat((Collection)missingColumns).containsExactlyInAnyOrder((Object[])new String[]{"col1", "col2"});
            return Map.of("col1", TestInMemoryGlueCache.testStats(1), "col2", TestInMemoryGlueCache.testStats(2));
        })).isEqualTo(Map.of("col1", TestInMemoryGlueCache.testStats(1), "col2", TestInMemoryGlueCache.testStats(2)));
        Assertions.assertThat((Map)glueCache.getTableColumnStatistics("db", "table", Set.of("col1", "col2"), missingColumns -> {
            throw new RuntimeException();
        })).containsExactlyInAnyOrderEntriesOf(Map.of("col1", TestInMemoryGlueCache.testStats(1), "col2", TestInMemoryGlueCache.testStats(2)));
        Assertions.assertThat((Map)glueCache.getTableColumnStatistics("db", "table", Set.of("col1", "col2", "col3", "col4"), missingColumns -> {
            Assertions.assertThat((Collection)missingColumns).containsExactlyInAnyOrder((Object[])new String[]{"col3", "col4"});
            return Map.of("col3", TestInMemoryGlueCache.testStats(3), "col4", TestInMemoryGlueCache.testStats(4));
        })).isEqualTo(Map.of("col1", TestInMemoryGlueCache.testStats(1), "col2", TestInMemoryGlueCache.testStats(2), "col3", TestInMemoryGlueCache.testStats(3), "col4", TestInMemoryGlueCache.testStats(4)));
        Assertions.assertThat((Map)glueCache.getTableColumnStatistics("db", "table", Set.of("col1", "col2", "col3", "col4"), missingColumns -> {
            throw new RuntimeException();
        })).isEqualTo(Map.of("col1", TestInMemoryGlueCache.testStats(1), "col2", TestInMemoryGlueCache.testStats(2), "col3", TestInMemoryGlueCache.testStats(3), "col4", TestInMemoryGlueCache.testStats(4)));
        glueCache.invalidateTable("db", "table", false);
        Assertions.assertThat((Map)glueCache.getTableColumnStatistics("db", "table", Set.of("col1", "col2"), missingColumns -> {
            Assertions.assertThat((Collection)missingColumns).containsExactlyInAnyOrder((Object[])new String[]{"col1", "col2"});
            return Map.of("col1", TestInMemoryGlueCache.testStats(11), "col2", TestInMemoryGlueCache.testStats(22));
        })).isEqualTo(Map.of("col1", TestInMemoryGlueCache.testStats(11), "col2", TestInMemoryGlueCache.testStats(22)));
        glueCache.invalidateDatabase("db");
        Assertions.assertThat((Map)glueCache.getTableColumnStatistics("db", "table", Set.of("col1", "col2"), missingColumns -> {
            Assertions.assertThat((Collection)missingColumns).containsExactlyInAnyOrder((Object[])new String[]{"col1", "col2"});
            return Map.of("col1", TestInMemoryGlueCache.testStats(111), "col2", TestInMemoryGlueCache.testStats(222));
        })).isEqualTo(Map.of("col1", TestInMemoryGlueCache.testStats(111), "col2", TestInMemoryGlueCache.testStats(222)));
    }

    @Test
    void testGetPartitionNames() {
        GlueCache glueCache = TestInMemoryGlueCache.createGlueCache();
        Assertions.assertThat((Collection)glueCache.getPartitionNames("db1", "table1", "", consumer -> Set.of(TestInMemoryGlueCache.testPartitionName("part1"), TestInMemoryGlueCache.testPartitionName("part2")))).containsExactlyInAnyOrder((Object[])new PartitionName[]{TestInMemoryGlueCache.testPartitionName("part1"), TestInMemoryGlueCache.testPartitionName("part2")});
        Assertions.assertThat((Collection)glueCache.getPartitionNames("db1", "table1", "", consumer -> Set.of(TestInMemoryGlueCache.testPartitionName("fail")))).containsExactlyInAnyOrder((Object[])new PartitionName[]{TestInMemoryGlueCache.testPartitionName("part1"), TestInMemoryGlueCache.testPartitionName("part2")});
        Assertions.assertThat((Collection)glueCache.getPartitionNames("db1", "table1", "", consumer -> {
            throw new RuntimeException();
        })).containsExactlyInAnyOrder((Object[])new PartitionName[]{TestInMemoryGlueCache.testPartitionName("part1"), TestInMemoryGlueCache.testPartitionName("part2")});
        Assertions.assertThat((Collection)glueCache.getPartitionNames("db1", "table1", "expression", consumer -> Set.of(TestInMemoryGlueCache.testPartitionName("a"), TestInMemoryGlueCache.testPartitionName("b")))).containsExactlyInAnyOrder((Object[])new PartitionName[]{TestInMemoryGlueCache.testPartitionName("a"), TestInMemoryGlueCache.testPartitionName("b")});
        Assertions.assertThat((Collection)glueCache.getPartitionNames("db1", "table1", "expression", consumer -> {
            throw new RuntimeException();
        })).containsExactlyInAnyOrder((Object[])new PartitionName[]{TestInMemoryGlueCache.testPartitionName("a"), TestInMemoryGlueCache.testPartitionName("b")});
        glueCache.invalidateTable("db1", "table1", true);
        Assertions.assertThat((Collection)glueCache.getPartitionNames("db1", "table1", "", consumer -> Set.of(TestInMemoryGlueCache.testPartitionName("part3"), TestInMemoryGlueCache.testPartitionName("part4")))).containsExactlyInAnyOrder((Object[])new PartitionName[]{TestInMemoryGlueCache.testPartitionName("part3"), TestInMemoryGlueCache.testPartitionName("part4")});
        Assertions.assertThat((Collection)glueCache.getPartitionNames("db1", "table1", "expression", consumer -> Set.of(TestInMemoryGlueCache.testPartitionName("c"), TestInMemoryGlueCache.testPartitionName("d")))).containsExactlyInAnyOrder((Object[])new PartitionName[]{TestInMemoryGlueCache.testPartitionName("c"), TestInMemoryGlueCache.testPartitionName("d")});
        glueCache.invalidateTable("db1", "table1", true);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> glueCache.getPartitionNames("db1", "table1", "", consumer -> {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, "test");
        })).isInstanceOf(TrinoException.class)).hasMessage("test");
        Assertions.assertThat((Collection)glueCache.getPartitionNames("db1", "table1", "", consumer -> Set.of(TestInMemoryGlueCache.testPartitionName("after exception")))).containsExactlyInAnyOrder((Object[])new PartitionName[]{TestInMemoryGlueCache.testPartitionName("after exception")});
        Assertions.assertThat((Collection)glueCache.getPartitionNames("db1", "table1", "flush", consumer -> Set.of(TestInMemoryGlueCache.testPartitionName("flush1"), TestInMemoryGlueCache.testPartitionName("flush2")))).containsExactlyInAnyOrder((Object[])new PartitionName[]{TestInMemoryGlueCache.testPartitionName("flush1"), TestInMemoryGlueCache.testPartitionName("flush2")});
        glueCache.invalidateTable("db1", "table1", false);
        Assertions.assertThat((Collection)glueCache.getPartitionNames("db1", "table1", "flush", consumer -> {
            throw new RuntimeException();
        })).containsExactlyInAnyOrder((Object[])new PartitionName[]{TestInMemoryGlueCache.testPartitionName("flush1"), TestInMemoryGlueCache.testPartitionName("flush2")});
        glueCache.invalidateTable("db1", "table1", true);
        Assertions.assertThat((Collection)glueCache.getPartitionNames("db1", "table1", "flush", consumer -> Set.of(TestInMemoryGlueCache.testPartitionName("flush3"), TestInMemoryGlueCache.testPartitionName("flush4")))).containsExactlyInAnyOrder((Object[])new PartitionName[]{TestInMemoryGlueCache.testPartitionName("flush3"), TestInMemoryGlueCache.testPartitionName("flush4")});
        glueCache.invalidateDatabase("db1");
        Assertions.assertThat((Collection)glueCache.getPartitionNames("db1", "table1", "flush", consumer -> Set.of(TestInMemoryGlueCache.testPartitionName("flush5"), TestInMemoryGlueCache.testPartitionName("flush6")))).containsExactlyInAnyOrder((Object[])new PartitionName[]{TestInMemoryGlueCache.testPartitionName("flush5"), TestInMemoryGlueCache.testPartitionName("flush6")});
    }

    @Test
    void testGetPartitionNamesWithCacheTable() throws InterruptedException {
        GlueCache glueCache = TestInMemoryGlueCache.createGlueCache();
        Assertions.assertThat((Collection)glueCache.getPartitionNames("db1", "table1", "", cachePartition -> {
            cachePartition.accept(TestInMemoryGlueCache.testPartition("part1", "initial"));
            cachePartition.accept(TestInMemoryGlueCache.testPartition("part2", "initial"));
            return Set.of(TestInMemoryGlueCache.testPartitionName("part1"), TestInMemoryGlueCache.testPartitionName("part2"));
        })).containsExactlyInAnyOrder((Object[])new PartitionName[]{TestInMemoryGlueCache.testPartitionName("part1"), TestInMemoryGlueCache.testPartitionName("part2")});
        Assertions.assertThat((Optional)glueCache.getPartition("db1", "table1", TestInMemoryGlueCache.testPartitionName("part1"), () -> {
            throw new RuntimeException();
        })).contains((Object)TestInMemoryGlueCache.testPartition("part1", "initial"));
        Assertions.assertThat((Optional)glueCache.getPartition("db1", "table1", TestInMemoryGlueCache.testPartitionName("part2"), () -> {
            throw new RuntimeException();
        })).contains((Object)TestInMemoryGlueCache.testPartition("part2", "initial"));
        Assertions.assertThat((Collection)glueCache.getPartitionNames("db1", "table1", "", cachePartition -> {
            throw new RuntimeException();
        })).containsExactlyInAnyOrder((Object[])new PartitionName[]{TestInMemoryGlueCache.testPartitionName("part1"), TestInMemoryGlueCache.testPartitionName("part2")});
        glueCache.invalidateTable("db1", "table1", true);
        Assertions.assertThat((Optional)glueCache.getPartition("db1", "table1", TestInMemoryGlueCache.testPartitionName("part1"), () -> Optional.of(TestInMemoryGlueCache.testPartition("part1", "new")))).contains((Object)TestInMemoryGlueCache.testPartition("part1", "new"));
        Assertions.assertThat((Optional)glueCache.getPartition("db1", "table1", TestInMemoryGlueCache.testPartitionName("part2"), () -> Optional.of(TestInMemoryGlueCache.testPartition("part2", "new")))).contains((Object)TestInMemoryGlueCache.testPartition("part2", "new"));
        Assertions.assertThat((Collection)glueCache.getPartitionNames("db1", "table1", "", cachePartition -> {
            cachePartition.accept(TestInMemoryGlueCache.testPartition("part2", "updated"));
            cachePartition.accept(TestInMemoryGlueCache.testPartition("part3", "initial"));
            cachePartition.accept(TestInMemoryGlueCache.testPartition("part4", "initial"));
            return Set.of(TestInMemoryGlueCache.testPartitionName("part2"), TestInMemoryGlueCache.testPartitionName("part3"));
        })).containsExactlyInAnyOrder((Object[])new PartitionName[]{TestInMemoryGlueCache.testPartitionName("part2"), TestInMemoryGlueCache.testPartitionName("part3")});
        Assertions.assertThat((Optional)glueCache.getPartition("db1", "table1", TestInMemoryGlueCache.testPartitionName("part1"), () -> {
            throw new RuntimeException();
        })).contains((Object)TestInMemoryGlueCache.testPartition("part1", "new"));
        Assertions.assertThat((Optional)glueCache.getPartition("db1", "table1", TestInMemoryGlueCache.testPartitionName("part2"), () -> {
            throw new RuntimeException();
        })).contains((Object)TestInMemoryGlueCache.testPartition("part2", "updated"));
        Assertions.assertThat((Optional)glueCache.getPartition("db1", "table1", TestInMemoryGlueCache.testPartitionName("part3"), () -> {
            throw new RuntimeException();
        })).contains((Object)TestInMemoryGlueCache.testPartition("part3", "initial"));
        Assertions.assertThat((Optional)glueCache.getPartition("db1", "table1", TestInMemoryGlueCache.testPartitionName("part4"), () -> {
            throw new RuntimeException();
        })).contains((Object)TestInMemoryGlueCache.testPartition("part4", "initial"));
        glueCache.invalidatePartition("db1", "table1", TestInMemoryGlueCache.testPartitionName("unknown"));
        Assertions.assertThat((Collection)glueCache.getPartitionNames("db1", "table1", "", cachePartition -> {
            throw new RuntimeException();
        })).containsExactlyInAnyOrder((Object[])new PartitionName[]{TestInMemoryGlueCache.testPartitionName("part2"), TestInMemoryGlueCache.testPartitionName("part3")});
        glueCache.invalidateTable("db1", "table1", true);
        Assertions.assertThat((Optional)glueCache.getPartition("db1", "table1", TestInMemoryGlueCache.testPartitionName("part1"), () -> Optional.of(TestInMemoryGlueCache.testPartition("part1", "initial")))).contains((Object)TestInMemoryGlueCache.testPartition("part1", "initial"));
        Assertions.assertThat((Optional)glueCache.getPartition("db1", "table1", TestInMemoryGlueCache.testPartitionName("part2"), () -> Optional.of(TestInMemoryGlueCache.testPartition("part2", "initial")))).contains((Object)TestInMemoryGlueCache.testPartition("part2", "initial"));
        Assertions.assertThat((Optional)glueCache.getPartition("db1", "table1", TestInMemoryGlueCache.testPartitionName("part3"), () -> Optional.of(TestInMemoryGlueCache.testPartition("part3", "initial")))).contains((Object)TestInMemoryGlueCache.testPartition("part3", "initial"));
        Assertions.assertThat((Optional)glueCache.getPartition("db1", "table1", TestInMemoryGlueCache.testPartitionName("part4"), () -> Optional.of(TestInMemoryGlueCache.testPartition("part4", "initial")))).contains((Object)TestInMemoryGlueCache.testPartition("part4", "initial"));
        CountDownLatch inBulkLoad = new CountDownLatch(1);
        CountDownLatch invalidated = new CountDownLatch(1);
        Thread thread = Thread.startVirtualThread(() -> Assertions.assertThat((Collection)glueCache.getPartitionNames("db1", "table1", "", cachePartition -> {
            cachePartition.accept(TestInMemoryGlueCache.testPartition("part1", "bulk"));
            cachePartition.accept(TestInMemoryGlueCache.testPartition("part2", "bulk"));
            inBulkLoad.countDown();
            Uninterruptibles.awaitUninterruptibly((CountDownLatch)invalidated);
            cachePartition.accept(TestInMemoryGlueCache.testPartition("part3", "bulk"));
            cachePartition.accept(TestInMemoryGlueCache.testPartition("part4", "bulk"));
            return Set.of(TestInMemoryGlueCache.testPartitionName("part1"), TestInMemoryGlueCache.testPartitionName("part2"), TestInMemoryGlueCache.testPartitionName("part3"), TestInMemoryGlueCache.testPartitionName("part4"));
        })).containsExactlyInAnyOrder((Object[])new PartitionName[]{TestInMemoryGlueCache.testPartitionName("part1"), TestInMemoryGlueCache.testPartitionName("part2"), TestInMemoryGlueCache.testPartitionName("part3"), TestInMemoryGlueCache.testPartitionName("part4")}));
        Uninterruptibles.awaitUninterruptibly((CountDownLatch)inBulkLoad);
        glueCache.invalidatePartition("db1", "table1", TestInMemoryGlueCache.testPartitionName("unknown"));
        invalidated.countDown();
        thread.join();
        Assertions.assertThat((Optional)glueCache.getPartition("db1", "table1", TestInMemoryGlueCache.testPartitionName("part1"), () -> {
            throw new RuntimeException();
        })).contains((Object)TestInMemoryGlueCache.testPartition("part1", "bulk"));
        Assertions.assertThat((Optional)glueCache.getPartition("db1", "table1", TestInMemoryGlueCache.testPartitionName("part2"), () -> {
            throw new RuntimeException();
        })).contains((Object)TestInMemoryGlueCache.testPartition("part2", "bulk"));
        Assertions.assertThat((Optional)glueCache.getPartition("db1", "table1", TestInMemoryGlueCache.testPartitionName("part3"), () -> {
            throw new RuntimeException();
        })).contains((Object)TestInMemoryGlueCache.testPartition("part3", "initial"));
        Assertions.assertThat((Optional)glueCache.getPartition("db1", "table1", TestInMemoryGlueCache.testPartitionName("part4"), () -> {
            throw new RuntimeException();
        })).contains((Object)TestInMemoryGlueCache.testPartition("part4", "initial"));
    }

    @Test
    void testGetPartition() {
        GlueCache glueCache = TestInMemoryGlueCache.createGlueCache();
        Assertions.assertThat((Optional)glueCache.getPartition("db1", "table1", TestInMemoryGlueCache.testPartitionName("part1"), Optional::empty)).isEmpty();
        Assertions.assertThat((Optional)glueCache.getPartition("db1", "table1", TestInMemoryGlueCache.testPartitionName("part1"), () -> Optional.of(TestInMemoryGlueCache.testPartition("part1", "fail")))).isEmpty();
        Assertions.assertThat((Optional)glueCache.getPartition("db1", "table1", TestInMemoryGlueCache.testPartitionName("part1"), () -> {
            throw new RuntimeException();
        })).isEmpty();
        glueCache.invalidatePartition("db1", "table1", TestInMemoryGlueCache.testPartitionName("part1"));
        Assertions.assertThat((Optional)glueCache.getPartition("db1", "table1", TestInMemoryGlueCache.testPartitionName("part1"), () -> Optional.of(TestInMemoryGlueCache.testPartition("part1", "initial")))).contains((Object)TestInMemoryGlueCache.testPartition("part1", "initial"));
        Assertions.assertThat((Optional)glueCache.getPartition("db1", "table1", TestInMemoryGlueCache.testPartitionName("part1"), () -> Optional.of(TestInMemoryGlueCache.testPartition("part1", "fail")))).contains((Object)TestInMemoryGlueCache.testPartition("part1", "initial"));
        Assertions.assertThat((Optional)glueCache.getPartition("db1", "table1", TestInMemoryGlueCache.testPartitionName("part1"), () -> {
            throw new RuntimeException();
        })).contains((Object)TestInMemoryGlueCache.testPartition("part1", "initial"));
        glueCache.invalidatePartition("db1", "table1", TestInMemoryGlueCache.testPartitionName("part1"));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> glueCache.getPartition("db1", "table1", TestInMemoryGlueCache.testPartitionName("part1"), () -> {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, "test");
        })).isInstanceOf(TrinoException.class)).hasMessage("test");
        Assertions.assertThat((Optional)glueCache.getPartition("db1", "table1", TestInMemoryGlueCache.testPartitionName("part1"), () -> Optional.of(TestInMemoryGlueCache.testPartition("part1", "after exception")))).contains((Object)TestInMemoryGlueCache.testPartition("part1", "after exception"));
        glueCache.invalidateTable("db1", "table1", false);
        Assertions.assertThat((Optional)glueCache.getPartition("db1", "table1", TestInMemoryGlueCache.testPartitionName("part1"), () -> {
            throw new RuntimeException();
        })).contains((Object)TestInMemoryGlueCache.testPartition("part1", "after exception"));
        glueCache.invalidateTable("db1", "table1", true);
        Assertions.assertThat((Optional)glueCache.getPartition("db1", "table1", TestInMemoryGlueCache.testPartitionName("part1"), () -> Optional.of(TestInMemoryGlueCache.testPartition("part1", "table invalidation")))).contains((Object)TestInMemoryGlueCache.testPartition("part1", "table invalidation"));
        glueCache.invalidateDatabase("db1");
        Assertions.assertThat((Optional)glueCache.getPartition("db1", "table1", TestInMemoryGlueCache.testPartitionName("part1"), () -> Optional.of(TestInMemoryGlueCache.testPartition("part1", "database invalidation")))).contains((Object)TestInMemoryGlueCache.testPartition("part1", "database invalidation"));
    }

    @Test
    void testBatchGetPartitions() throws InterruptedException {
        GlueCache glueCache = TestInMemoryGlueCache.createGlueCache();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> glueCache.batchGetPartitions("db1", "table1", Set.of(TestInMemoryGlueCache.testPartitionName("part1"), TestInMemoryGlueCache.testPartitionName("part2")), (cachePartition, missingPartitions) -> {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, "test");
        })).isInstanceOf(TrinoException.class)).hasMessage("test");
        Assertions.assertThat((Collection)glueCache.batchGetPartitions("db1", "table1", Set.of(TestInMemoryGlueCache.testPartitionName("part1"), TestInMemoryGlueCache.testPartitionName("part2")), (cachePartition, missingPartitions) -> {
            Assertions.assertThat((Collection)missingPartitions).containsExactlyInAnyOrder((Object[])new PartitionName[]{TestInMemoryGlueCache.testPartitionName("part1"), TestInMemoryGlueCache.testPartitionName("part2")});
            cachePartition.accept(TestInMemoryGlueCache.testPartition("part1", "initial"));
            cachePartition.accept(TestInMemoryGlueCache.testPartition("part2", "initial"));
            return Set.of(TestInMemoryGlueCache.testPartition("part1", "initial"), TestInMemoryGlueCache.testPartition("part2", "initial"));
        })).containsExactlyInAnyOrder((Object[])new Partition[]{TestInMemoryGlueCache.testPartition("part1", "initial"), TestInMemoryGlueCache.testPartition("part2", "initial")});
        Assertions.assertThat((Optional)glueCache.getPartition("db1", "table1", TestInMemoryGlueCache.testPartitionName("part1"), () -> {
            throw new RuntimeException();
        })).contains((Object)TestInMemoryGlueCache.testPartition("part1", "initial"));
        Assertions.assertThat((Optional)glueCache.getPartition("db1", "table1", TestInMemoryGlueCache.testPartitionName("part2"), () -> {
            throw new RuntimeException();
        })).contains((Object)TestInMemoryGlueCache.testPartition("part2", "initial"));
        Assertions.assertThat((Collection)glueCache.batchGetPartitions("db1", "table1", Set.of(TestInMemoryGlueCache.testPartitionName("part1"), TestInMemoryGlueCache.testPartitionName("part2")), (cachePartition, missingPartitions) -> {
            throw new RuntimeException();
        })).containsExactlyInAnyOrder((Object[])new Partition[]{TestInMemoryGlueCache.testPartition("part1", "initial"), TestInMemoryGlueCache.testPartition("part2", "initial")});
        glueCache.invalidateTable("db1", "table1", false);
        Assertions.assertThat((Optional)glueCache.getPartition("db1", "table1", TestInMemoryGlueCache.testPartitionName("part1"), () -> {
            throw new RuntimeException();
        })).contains((Object)TestInMemoryGlueCache.testPartition("part1", "initial"));
        Assertions.assertThat((Optional)glueCache.getPartition("db1", "table1", TestInMemoryGlueCache.testPartitionName("part2"), () -> {
            throw new RuntimeException();
        })).contains((Object)TestInMemoryGlueCache.testPartition("part2", "initial"));
        Assertions.assertThat((Collection)glueCache.batchGetPartitions("db1", "table1", Set.of(TestInMemoryGlueCache.testPartitionName("part1"), TestInMemoryGlueCache.testPartitionName("part2"), TestInMemoryGlueCache.testPartitionName("part3"), TestInMemoryGlueCache.testPartitionName("part4")), (cachePartition, missingPartitions) -> {
            Assertions.assertThat((Collection)missingPartitions).containsExactlyInAnyOrder((Object[])new PartitionName[]{TestInMemoryGlueCache.testPartitionName("part3"), TestInMemoryGlueCache.testPartitionName("part4")});
            cachePartition.accept(TestInMemoryGlueCache.testPartition("part3", "initial"));
            cachePartition.accept(TestInMemoryGlueCache.testPartition("part4", "initial"));
            return Set.of(TestInMemoryGlueCache.testPartition("part3", "initial"), TestInMemoryGlueCache.testPartition("part4", "initial"));
        })).containsExactlyInAnyOrder((Object[])new Partition[]{TestInMemoryGlueCache.testPartition("part1", "initial"), TestInMemoryGlueCache.testPartition("part2", "initial"), TestInMemoryGlueCache.testPartition("part3", "initial"), TestInMemoryGlueCache.testPartition("part4", "initial")});
        Assertions.assertThat((Optional)glueCache.getPartition("db1", "table1", TestInMemoryGlueCache.testPartitionName("part1"), () -> {
            throw new RuntimeException();
        })).contains((Object)TestInMemoryGlueCache.testPartition("part1", "initial"));
        Assertions.assertThat((Optional)glueCache.getPartition("db1", "table1", TestInMemoryGlueCache.testPartitionName("part2"), () -> {
            throw new RuntimeException();
        })).contains((Object)TestInMemoryGlueCache.testPartition("part2", "initial"));
        Assertions.assertThat((Optional)glueCache.getPartition("db1", "table1", TestInMemoryGlueCache.testPartitionName("part3"), () -> {
            throw new RuntimeException();
        })).contains((Object)TestInMemoryGlueCache.testPartition("part3", "initial"));
        Assertions.assertThat((Optional)glueCache.getPartition("db1", "table1", TestInMemoryGlueCache.testPartitionName("part4"), () -> {
            throw new RuntimeException();
        })).contains((Object)TestInMemoryGlueCache.testPartition("part4", "initial"));
        glueCache.invalidateTable("db1", "table1", true);
        CountDownLatch inBulkLoad = new CountDownLatch(1);
        CountDownLatch invalidated = new CountDownLatch(1);
        Thread thread = Thread.startVirtualThread(() -> Assertions.assertThat((Collection)glueCache.batchGetPartitions("db1", "table1", Set.of(TestInMemoryGlueCache.testPartitionName("part1"), TestInMemoryGlueCache.testPartitionName("part2"), TestInMemoryGlueCache.testPartitionName("part3"), TestInMemoryGlueCache.testPartitionName("part4")), (cachePartition, missingPartitions) -> {
            Assertions.assertThat((Collection)missingPartitions).containsExactlyInAnyOrder((Object[])new PartitionName[]{TestInMemoryGlueCache.testPartitionName("part1"), TestInMemoryGlueCache.testPartitionName("part2"), TestInMemoryGlueCache.testPartitionName("part3"), TestInMemoryGlueCache.testPartitionName("part4")});
            cachePartition.accept(TestInMemoryGlueCache.testPartition("part1", "bulk"));
            cachePartition.accept(TestInMemoryGlueCache.testPartition("part2", "bulk"));
            inBulkLoad.countDown();
            Uninterruptibles.awaitUninterruptibly((CountDownLatch)invalidated);
            cachePartition.accept(TestInMemoryGlueCache.testPartition("part3", "bulk"));
            cachePartition.accept(TestInMemoryGlueCache.testPartition("part4", "bulk"));
            return Set.of(TestInMemoryGlueCache.testPartition("part1", "bulk"), TestInMemoryGlueCache.testPartition("part2", "bulk"), TestInMemoryGlueCache.testPartition("part3", "bulk"), TestInMemoryGlueCache.testPartition("part4", "bulk"));
        })).containsExactlyInAnyOrder((Object[])new Partition[]{TestInMemoryGlueCache.testPartition("part1", "bulk"), TestInMemoryGlueCache.testPartition("part2", "bulk"), TestInMemoryGlueCache.testPartition("part3", "bulk"), TestInMemoryGlueCache.testPartition("part4", "bulk")}));
        Uninterruptibles.awaitUninterruptibly((CountDownLatch)inBulkLoad);
        glueCache.invalidatePartition("db1", "table1", TestInMemoryGlueCache.testPartitionName("unknown"));
        invalidated.countDown();
        thread.join();
        Assertions.assertThat((Optional)glueCache.getPartition("db1", "table1", TestInMemoryGlueCache.testPartitionName("part1"), () -> {
            throw new RuntimeException();
        })).contains((Object)TestInMemoryGlueCache.testPartition("part1", "bulk"));
        Assertions.assertThat((Optional)glueCache.getPartition("db1", "table1", TestInMemoryGlueCache.testPartitionName("part2"), () -> {
            throw new RuntimeException();
        })).contains((Object)TestInMemoryGlueCache.testPartition("part2", "bulk"));
        Assertions.assertThat((Optional)glueCache.getPartition("db1", "table1", TestInMemoryGlueCache.testPartitionName("part3"), () -> Optional.of(TestInMemoryGlueCache.testPartition("part3", "after bulk")))).contains((Object)TestInMemoryGlueCache.testPartition("part3", "after bulk"));
        Assertions.assertThat((Optional)glueCache.getPartition("db1", "table1", TestInMemoryGlueCache.testPartitionName("part4"), () -> Optional.of(TestInMemoryGlueCache.testPartition("part4", "after bulk")))).contains((Object)TestInMemoryGlueCache.testPartition("part4", "after bulk"));
    }

    @Test
    void testGetPartitionColumnStatistics() {
        GlueCache glueCache = TestInMemoryGlueCache.createGlueCache();
        Assertions.assertThat((Map)glueCache.getPartitionColumnStatistics("db", "table", TestInMemoryGlueCache.testPartitionName("part1"), Set.of("col1", "col2"), missingColumns -> {
            Assertions.assertThat((Collection)missingColumns).containsExactlyInAnyOrder((Object[])new String[]{"col1", "col2"});
            return Map.of();
        })).isEmpty();
        Assertions.assertThat((Map)glueCache.getPartitionColumnStatistics("db", "table", TestInMemoryGlueCache.testPartitionName("part1"), Set.of("col1", "col2"), missingColumns -> {
            throw new RuntimeException();
        })).isEmpty();
        glueCache.invalidatePartition("db", "table", TestInMemoryGlueCache.testPartitionName("part1"));
        Assertions.assertThat((Map)glueCache.getPartitionColumnStatistics("db", "table", TestInMemoryGlueCache.testPartitionName("part1"), Set.of("col1", "col2"), missingColumns -> {
            Assertions.assertThat((Collection)missingColumns).containsExactlyInAnyOrder((Object[])new String[]{"col1", "col2"});
            return Map.of("col1", TestInMemoryGlueCache.testStats(1), "col2", TestInMemoryGlueCache.testStats(2));
        })).containsExactlyInAnyOrderEntriesOf(Map.of("col1", TestInMemoryGlueCache.testStats(1), "col2", TestInMemoryGlueCache.testStats(2)));
        Assertions.assertThat((Map)glueCache.getPartitionColumnStatistics("db", "table", TestInMemoryGlueCache.testPartitionName("part1"), Set.of("col1", "col2"), missingColumns -> {
            throw new RuntimeException();
        })).containsExactlyInAnyOrderEntriesOf(Map.of("col1", TestInMemoryGlueCache.testStats(1), "col2", TestInMemoryGlueCache.testStats(2)));
        Assertions.assertThat((Map)glueCache.getPartitionColumnStatistics("db", "table", TestInMemoryGlueCache.testPartitionName("part1"), Set.of("col1", "col2", "col3", "col4"), missingColumns -> {
            Assertions.assertThat((Collection)missingColumns).containsExactlyInAnyOrder((Object[])new String[]{"col3", "col4"});
            return Map.of("col3", TestInMemoryGlueCache.testStats(3), "col4", TestInMemoryGlueCache.testStats(4));
        })).containsExactlyInAnyOrderEntriesOf(Map.of("col1", TestInMemoryGlueCache.testStats(1), "col2", TestInMemoryGlueCache.testStats(2), "col3", TestInMemoryGlueCache.testStats(3), "col4", TestInMemoryGlueCache.testStats(4)));
        Assertions.assertThat((Map)glueCache.getPartitionColumnStatistics("db", "table", TestInMemoryGlueCache.testPartitionName("part1"), Set.of("col1", "col2", "col3", "col4"), missingColumns -> {
            throw new RuntimeException();
        })).containsExactlyInAnyOrderEntriesOf(Map.of("col1", TestInMemoryGlueCache.testStats(1), "col2", TestInMemoryGlueCache.testStats(2), "col3", TestInMemoryGlueCache.testStats(3), "col4", TestInMemoryGlueCache.testStats(4)));
        glueCache.invalidatePartition("db", "table", TestInMemoryGlueCache.testPartitionName("part1"));
        Assertions.assertThat((Map)glueCache.getPartitionColumnStatistics("db", "table", TestInMemoryGlueCache.testPartitionName("part1"), Set.of("col1", "col2"), missingColumns -> {
            Assertions.assertThat((Collection)missingColumns).containsExactlyInAnyOrder((Object[])new String[]{"col1", "col2"});
            return Map.of("col1", TestInMemoryGlueCache.testStats(11), "col2", TestInMemoryGlueCache.testStats(22));
        })).isEqualTo(Map.of("col1", TestInMemoryGlueCache.testStats(11), "col2", TestInMemoryGlueCache.testStats(22)));
        glueCache.invalidateTable("db", "table", false);
        Assertions.assertThat((Map)glueCache.getPartitionColumnStatistics("db", "table", TestInMemoryGlueCache.testPartitionName("part1"), Set.of("col1", "col2"), missingColumns -> {
            throw new RuntimeException();
        })).isEqualTo(Map.of("col1", TestInMemoryGlueCache.testStats(11), "col2", TestInMemoryGlueCache.testStats(22)));
        glueCache.invalidateTable("db", "table", true);
        Assertions.assertThat((Map)glueCache.getPartitionColumnStatistics("db", "table", TestInMemoryGlueCache.testPartitionName("part1"), Set.of("col1", "col2"), missingColumns -> {
            Assertions.assertThat((Collection)missingColumns).containsExactlyInAnyOrder((Object[])new String[]{"col1", "col2"});
            return Map.of("col1", TestInMemoryGlueCache.testStats(111), "col2", TestInMemoryGlueCache.testStats(222));
        })).isEqualTo(Map.of("col1", TestInMemoryGlueCache.testStats(111), "col2", TestInMemoryGlueCache.testStats(222)));
        glueCache.invalidateDatabase("db");
        Assertions.assertThat((Map)glueCache.getPartitionColumnStatistics("db", "table", TestInMemoryGlueCache.testPartitionName("part1"), Set.of("col1", "col2"), missingColumns -> {
            Assertions.assertThat((Collection)missingColumns).containsExactlyInAnyOrder((Object[])new String[]{"col1", "col2"});
            return Map.of("col1", TestInMemoryGlueCache.testStats(1111), "col2", TestInMemoryGlueCache.testStats(2222));
        })).isEqualTo(Map.of("col1", TestInMemoryGlueCache.testStats(1111), "col2", TestInMemoryGlueCache.testStats(2222)));
    }

    @Test
    void testGetAllFunctions() {
        GlueCache glueCache = TestInMemoryGlueCache.createGlueCache();
        Assertions.assertThat((Collection)glueCache.getAllFunctions("db1", () -> Set.of(TestInMemoryGlueCache.testFunction("x"), TestInMemoryGlueCache.testFunction("y")))).containsExactlyInAnyOrder((Object[])new LanguageFunction[]{TestInMemoryGlueCache.testFunction("x"), TestInMemoryGlueCache.testFunction("y")});
        Assertions.assertThat((Collection)glueCache.getAllFunctions("db1", () -> Set.of(TestInMemoryGlueCache.testFunction("fail")))).containsExactlyInAnyOrder((Object[])new LanguageFunction[]{TestInMemoryGlueCache.testFunction("x"), TestInMemoryGlueCache.testFunction("y")});
        Assertions.assertThat((Collection)glueCache.getAllFunctions("db1", () -> {
            throw new RuntimeException();
        })).containsExactlyInAnyOrder((Object[])new LanguageFunction[]{TestInMemoryGlueCache.testFunction("x"), TestInMemoryGlueCache.testFunction("y")});
        glueCache.invalidateFunction("db1", "unknown");
        Assertions.assertThat((Collection)glueCache.getAllFunctions("db1", () -> Set.of(TestInMemoryGlueCache.testFunction("a"), TestInMemoryGlueCache.testFunction("b")))).containsExactlyInAnyOrder((Object[])new LanguageFunction[]{TestInMemoryGlueCache.testFunction("a"), TestInMemoryGlueCache.testFunction("b")});
        glueCache.invalidateDatabase("db1");
        Assertions.assertThat((Collection)glueCache.getAllFunctions("db1", () -> Set.of(TestInMemoryGlueCache.testFunction("c"), TestInMemoryGlueCache.testFunction("d")))).containsExactlyInAnyOrder((Object[])new LanguageFunction[]{TestInMemoryGlueCache.testFunction("c"), TestInMemoryGlueCache.testFunction("d")});
        glueCache.invalidateFunction("db1", "unknown");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> glueCache.getAllFunctions("db1", () -> {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, "test");
        })).isInstanceOf(TrinoException.class)).hasMessage("test");
        Assertions.assertThat((Collection)glueCache.getAllFunctions("db1", () -> Set.of(TestInMemoryGlueCache.testFunction("after exception")))).containsExactlyInAnyOrder((Object[])new LanguageFunction[]{TestInMemoryGlueCache.testFunction("after exception")});
    }

    @Test
    void testGetFunction() {
        GlueCache glueCache = TestInMemoryGlueCache.createGlueCache();
        Assertions.assertThat((Collection)glueCache.getFunction("db1", "func1", () -> List.of(TestInMemoryGlueCache.testFunction("a"), TestInMemoryGlueCache.testFunction("b")))).containsExactlyInAnyOrder((Object[])new LanguageFunction[]{TestInMemoryGlueCache.testFunction("a"), TestInMemoryGlueCache.testFunction("b")});
        Assertions.assertThat((Collection)glueCache.getFunction("db1", "func1", () -> List.of(TestInMemoryGlueCache.testFunction("fail")))).containsExactlyInAnyOrder((Object[])new LanguageFunction[]{TestInMemoryGlueCache.testFunction("a"), TestInMemoryGlueCache.testFunction("b")});
        Assertions.assertThat((Collection)glueCache.getFunction("db1", "func1", () -> {
            throw new RuntimeException();
        })).containsExactlyInAnyOrder((Object[])new LanguageFunction[]{TestInMemoryGlueCache.testFunction("a"), TestInMemoryGlueCache.testFunction("b")});
        glueCache.invalidateFunction("db1", "func1");
        Assertions.assertThat((Collection)glueCache.getFunction("db1", "func1", () -> List.of(TestInMemoryGlueCache.testFunction("c"), TestInMemoryGlueCache.testFunction("d")))).containsExactlyInAnyOrder((Object[])new LanguageFunction[]{TestInMemoryGlueCache.testFunction("c"), TestInMemoryGlueCache.testFunction("d")});
        glueCache.invalidateDatabase("db1");
        Assertions.assertThat((Collection)glueCache.getFunction("db1", "func1", () -> List.of(TestInMemoryGlueCache.testFunction("e"), TestInMemoryGlueCache.testFunction("f")))).containsExactlyInAnyOrder((Object[])new LanguageFunction[]{TestInMemoryGlueCache.testFunction("e"), TestInMemoryGlueCache.testFunction("f")});
    }

    private static Database testDatabase(String name) {
        return TestInMemoryGlueCache.testDatabase(name, "no-owner");
    }

    private static Database testDatabase(String name, String owner) {
        return Database.builder().setDatabaseName(name).setOwnerName(Optional.of(owner)).setOwnerType(Optional.of(PrincipalType.USER)).build();
    }

    private static TableInfo testTableInfo(String schemaName, String tableName) {
        return new TableInfo(new SchemaTableName(schemaName, tableName), TableInfo.ExtendedRelationType.TABLE);
    }

    private static Table testTable(String schemaName, String tableName) {
        return TestInMemoryGlueCache.testTable(schemaName, tableName, "no-owner");
    }

    private static Table testTable(String schemaName, String tableName, String owner) {
        return Table.builder().setDatabaseName(schemaName).setTableName(tableName).setOwner(Optional.of(owner)).setTableType("table").withStorage(storage -> storage.setStorageFormat(StorageFormat.NULL_STORAGE_FORMAT)).build();
    }

    private static PartitionName testPartitionName(String name) {
        return new PartitionName(List.of(name, name));
    }

    private static Partition testPartition(String partitionName, String version) {
        return TestInMemoryGlueCache.testPartition("db1", "table1", partitionName, version);
    }

    private static Partition testPartition(String schemaName, String tableName, String partitionName, String version) {
        return Partition.builder().setDatabaseName(schemaName).setTableName(tableName).setValues(List.of(partitionName, partitionName)).withStorage(storage -> storage.setStorageFormat(StorageFormat.NULL_STORAGE_FORMAT)).setColumns(List.of(new Column(version, HiveType.HIVE_STRING, Optional.empty(), Map.of()))).build();
    }

    private static HiveColumnStatistics testStats(int columnNumber) {
        return HiveColumnStatistics.createBinaryColumnStatistics((OptionalLong)OptionalLong.of(columnNumber + 1), (OptionalDouble)OptionalDouble.of(columnNumber + 2), (OptionalLong)OptionalLong.of(columnNumber + 3));
    }

    private static LanguageFunction testFunction(String signatureToken) {
        return new LanguageFunction(signatureToken, "", List.of(), Optional.empty());
    }
}

