/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.metastore.glue;

import com.google.common.base.Verify;
import com.google.common.collect.ImmutableSet;
import io.trino.filesystem.TrinoFileSystemFactory;
import io.trino.plugin.hive.HiveTestUtils;
import io.trino.plugin.hive.metastore.glue.GlueCache;
import io.trino.plugin.hive.metastore.glue.GlueHiveMetastore;
import io.trino.plugin.hive.metastore.glue.GlueHiveMetastoreConfig;
import io.trino.plugin.hive.metastore.glue.GlueMetastoreModule;
import io.trino.plugin.hive.metastore.glue.GlueMetastoreStats;
import io.trino.spi.catalog.CatalogName;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.EnumSet;
import java.util.Set;
import java.util.function.Consumer;
import software.amazon.awssdk.services.glue.GlueClient;

public final class TestingGlueHiveMetastore {
    private TestingGlueHiveMetastore() {
    }

    public static GlueHiveMetastore createTestingGlueHiveMetastore(Path defaultWarehouseDir, Consumer<AutoCloseable> registerResource) {
        if (!Files.exists(defaultWarehouseDir, new LinkOption[0])) {
            try {
                Files.createDirectories(defaultWarehouseDir, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new RuntimeException("Could not create directory: %s".formatted(defaultWarehouseDir), e);
            }
        }
        Verify.verify((boolean)Files.isDirectory(defaultWarehouseDir, new LinkOption[0]), (String)"%s is not a directory", (Object)defaultWarehouseDir);
        return TestingGlueHiveMetastore.createTestingGlueHiveMetastore(defaultWarehouseDir.toUri(), registerResource);
    }

    public static GlueHiveMetastore createTestingGlueHiveMetastore(URI warehouseUri, Consumer<AutoCloseable> registerResource) {
        GlueHiveMetastoreConfig glueConfig = new GlueHiveMetastoreConfig().setDefaultWarehouseDir(warehouseUri.toString());
        GlueClient glueClient = GlueMetastoreModule.createGlueClient((GlueHiveMetastoreConfig)glueConfig, (Set)ImmutableSet.of());
        registerResource.accept((AutoCloseable)glueClient);
        return new GlueHiveMetastore(glueClient, GlueCache.NOOP, new GlueMetastoreStats(), (TrinoFileSystemFactory)HiveTestUtils.HDFS_FILE_SYSTEM_FACTORY, glueConfig, new CatalogName("test"), EnumSet.allOf(GlueHiveMetastore.TableKind.class));
    }
}

