/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.metastore.thrift;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import io.trino.plugin.hive.metastore.thrift.ThriftMetastoreClient;
import io.trino.plugin.hive.metastore.thrift.ThriftMetastoreClientFactory;
import java.net.URI;
import java.util.Map;
import java.util.Optional;
import org.apache.thrift.transport.TTransportException;

public class MockThriftMetastoreClientFactory
implements ThriftMetastoreClientFactory {
    private final Map<URI, Optional<ThriftMetastoreClient>> clients;

    public MockThriftMetastoreClientFactory(Map<String, Optional<ThriftMetastoreClient>> clients) {
        this.clients = (Map)clients.entrySet().stream().collect(ImmutableMap.toImmutableMap(entry -> URI.create((String)entry.getKey()), Map.Entry::getValue));
    }

    public ThriftMetastoreClient create(URI uri, Optional<String> delegationToken) throws TTransportException {
        Preconditions.checkArgument((boolean)delegationToken.isEmpty(), (Object)"delegation token is not supported");
        return (ThriftMetastoreClient)this.clients.getOrDefault(uri, Optional.empty()).orElseThrow(() -> new TTransportException(3));
    }
}

