/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.metastore.thrift;

import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.Multiset;
import io.trino.Session;
import io.trino.plugin.hive.HiveQueryRunner;
import io.trino.plugin.hive.metastore.MetastoreInvocations;
import io.trino.plugin.hive.metastore.MetastoreMethod;
import io.trino.testing.AbstractTestQueryFramework;
import io.trino.testing.QueryRunner;
import org.intellij.lang.annotations.Language;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@Execution(value=ExecutionMode.SAME_THREAD)
public class TestHiveMetastoreAccessOperations
extends AbstractTestQueryFramework {
    protected QueryRunner createQueryRunner() throws Exception {
        return HiveQueryRunner.builder().addHiveProperty("hive.dynamic-filtering.wait-timeout", "1h").build();
    }

    @Test
    public void testUse() {
        this.assertMetastoreInvocations("USE " + (String)this.getSession().getSchema().orElseThrow(), (Multiset<MetastoreMethod>)ImmutableMultiset.builder().add((Object)MetastoreMethod.GET_DATABASE).build());
    }

    @Test
    public void testCreateTable() {
        this.assertMetastoreInvocations("CREATE TABLE test_create(id VARCHAR, age INT)", (Multiset<MetastoreMethod>)ImmutableMultiset.builder().add((Object)MetastoreMethod.CREATE_TABLE).add((Object)MetastoreMethod.GET_DATABASE).add((Object)MetastoreMethod.GET_TABLE).add((Object)MetastoreMethod.UPDATE_TABLE_STATISTICS).build());
    }

    @Test
    public void testCreateTableAsSelect() {
        this.assertMetastoreInvocations("CREATE TABLE test_ctas AS SELECT 1 AS age", (Multiset<MetastoreMethod>)ImmutableMultiset.builder().add((Object)MetastoreMethod.GET_DATABASE).add((Object)MetastoreMethod.CREATE_TABLE).add((Object)MetastoreMethod.GET_TABLE).add((Object)MetastoreMethod.UPDATE_TABLE_STATISTICS).build());
    }

    @Test
    public void testSelect() {
        this.assertUpdate("CREATE TABLE test_select_from(id VARCHAR, age INT)");
        this.assertMetastoreInvocations("SELECT * FROM test_select_from", (Multiset<MetastoreMethod>)ImmutableMultiset.builder().add((Object)MetastoreMethod.GET_TABLE).build());
    }

    @Test
    public void testSelectPartitionedTable() {
        this.assertUpdate("CREATE TABLE test_select_partition WITH (partitioned_by = ARRAY['part']) AS SELECT 1 AS data, 10 AS part", 1L);
        this.assertMetastoreInvocations("SELECT * FROM test_select_partition", (Multiset<MetastoreMethod>)ImmutableMultiset.builder().add((Object)MetastoreMethod.GET_TABLE).add((Object)MetastoreMethod.GET_PARTITION_NAMES_BY_FILTER).add((Object)MetastoreMethod.GET_PARTITIONS_BY_NAMES).build());
        this.assertUpdate("INSERT INTO test_select_partition SELECT 2 AS data, 20 AS part", 1L);
        this.assertMetastoreInvocations("SELECT * FROM test_select_partition", (Multiset<MetastoreMethod>)ImmutableMultiset.builder().add((Object)MetastoreMethod.GET_TABLE).add((Object)MetastoreMethod.GET_PARTITION_NAMES_BY_FILTER).add((Object)MetastoreMethod.GET_PARTITIONS_BY_NAMES).build());
        this.assertMetastoreInvocations("SELECT * FROM test_select_partition WHERE part = 10", (Multiset<MetastoreMethod>)ImmutableMultiset.builder().add((Object)MetastoreMethod.GET_TABLE).add((Object)MetastoreMethod.GET_PARTITION_NAMES_BY_FILTER).add((Object)MetastoreMethod.GET_PARTITIONS_BY_NAMES).build());
    }

    @Test
    public void testSelectWithFilter() {
        this.assertUpdate("CREATE TABLE test_select_from_where AS SELECT 2 AS age", 1L);
        this.assertMetastoreInvocations("SELECT * FROM test_select_from_where WHERE age = 2", (Multiset<MetastoreMethod>)ImmutableMultiset.builder().add((Object)MetastoreMethod.GET_TABLE).build());
    }

    @Test
    public void testSelectFromView() {
        this.assertUpdate("CREATE TABLE test_select_view_table(id VARCHAR, age INT)");
        this.assertUpdate("CREATE VIEW test_select_view_view AS SELECT id, age FROM test_select_view_table");
        this.assertMetastoreInvocations("SELECT * FROM test_select_view_view", (Multiset<MetastoreMethod>)ImmutableMultiset.builder().addCopies((Object)MetastoreMethod.GET_TABLE, 2).build());
    }

    @Test
    public void testSelectFromViewWithFilter() {
        this.assertUpdate("CREATE TABLE test_select_view_where_table AS SELECT 2 AS age", 1L);
        this.assertUpdate("CREATE VIEW test_select_view_where_view AS SELECT age FROM test_select_view_where_table");
        this.assertMetastoreInvocations("SELECT * FROM test_select_view_where_view WHERE age = 2", (Multiset<MetastoreMethod>)ImmutableMultiset.builder().addCopies((Object)MetastoreMethod.GET_TABLE, 2).build());
    }

    @Test
    public void testJoin() {
        this.assertUpdate("CREATE TABLE test_join_t1 AS SELECT 2 AS age, 'id1' AS id", 1L);
        this.assertUpdate("CREATE TABLE test_join_t2 AS SELECT 'name1' AS name, 'id1' AS id", 1L);
        this.assertMetastoreInvocations("SELECT name, age FROM test_join_t1 JOIN test_join_t2 ON test_join_t2.id = test_join_t1.id", (Multiset<MetastoreMethod>)ImmutableMultiset.builder().addCopies((Object)MetastoreMethod.GET_TABLE, 2).addCopies((Object)MetastoreMethod.GET_TABLE_COLUMN_STATISTICS, 2).build());
    }

    @Test
    public void testSelfJoin() {
        this.assertUpdate("CREATE TABLE test_self_join_table AS SELECT 2 AS age, 0 parent, 3 AS id", 1L);
        this.assertMetastoreInvocations("SELECT child.age, parent.age FROM test_self_join_table child JOIN test_self_join_table parent ON child.parent = parent.id", (Multiset<MetastoreMethod>)ImmutableMultiset.builder().add((Object)MetastoreMethod.GET_TABLE).addCopies((Object)MetastoreMethod.GET_TABLE_COLUMN_STATISTICS, 2).build());
    }

    @Test
    public void testDynamicPartitionPruning() {
        this.assertUpdate("CREATE TABLE test_dynamic_partition_pruning_table WITH (partitioned_by=ARRAY['suppkey']) AS SELECT orderkey, partkey, suppkey FROM tpch.tiny.lineitem", 60175L);
        Session session = Session.builder((Session)this.getSession()).setCatalogSessionProperty("hive", "partition_statistics_sample_size", "10").build();
        String sql = "SELECT * FROM test_dynamic_partition_pruning_table l JOIN tpch.tiny.supplier s ON l.suppkey = s.suppkey AND s.name = 'Supplier#000000001'";
        this.assertMetastoreInvocations(Session.builder((Session)session).setSystemProperty("enable_dynamic_filtering", "false").build(), sql, (Multiset<MetastoreMethod>)ImmutableMultiset.builder().add((Object)MetastoreMethod.GET_TABLE).addCopies((Object)MetastoreMethod.GET_PARTITIONS_BY_NAMES, 5).add((Object)MetastoreMethod.GET_PARTITION_COLUMN_STATISTICS).addCopies((Object)MetastoreMethod.GET_PARTITION_NAMES_BY_FILTER, 2).build());
        this.assertQuerySucceeds("CALL system.flush_metadata_cache()");
        this.assertMetastoreInvocations(session, sql, (Multiset<MetastoreMethod>)ImmutableMultiset.builder().add((Object)MetastoreMethod.GET_TABLE).add((Object)MetastoreMethod.GET_PARTITIONS_BY_NAMES).add((Object)MetastoreMethod.GET_PARTITION_COLUMN_STATISTICS).addCopies((Object)MetastoreMethod.GET_PARTITION_NAMES_BY_FILTER, 2).build());
    }

    @Test
    public void testExplainSelect() {
        this.assertUpdate("CREATE TABLE test_explain AS SELECT 2 AS age", 1L);
        this.assertMetastoreInvocations("EXPLAIN SELECT * FROM test_explain", (Multiset<MetastoreMethod>)ImmutableMultiset.builder().add((Object)MetastoreMethod.GET_TABLE).add((Object)MetastoreMethod.GET_TABLE_COLUMN_STATISTICS).build());
    }

    @Test
    public void testDescribe() {
        this.assertUpdate("CREATE TABLE test_describe(id VARCHAR, age INT)");
        this.assertMetastoreInvocations("DESCRIBE test_describe", (Multiset<MetastoreMethod>)ImmutableMultiset.builder().add((Object)MetastoreMethod.GET_DATABASE).add((Object)MetastoreMethod.GET_TABLE).build());
    }

    @Test
    public void testShowStatsForTable() {
        this.assertUpdate("CREATE TABLE test_show_stats AS SELECT 2 AS age", 1L);
        this.assertMetastoreInvocations("SHOW STATS FOR test_show_stats", (Multiset<MetastoreMethod>)ImmutableMultiset.builder().add((Object)MetastoreMethod.GET_TABLE).add((Object)MetastoreMethod.GET_TABLE_COLUMN_STATISTICS).build());
    }

    @Test
    public void testShowStatsForTableWithFilter() {
        this.assertUpdate("CREATE TABLE test_show_stats_with_filter AS SELECT 2 AS age", 1L);
        this.assertMetastoreInvocations("SHOW STATS FOR (SELECT * FROM test_show_stats_with_filter where age >= 2)", (Multiset<MetastoreMethod>)ImmutableMultiset.builder().add((Object)MetastoreMethod.GET_TABLE).add((Object)MetastoreMethod.GET_TABLE_COLUMN_STATISTICS).build());
    }

    @Test
    public void testAnalyze() {
        this.assertUpdate("CREATE TABLE test_analyze AS SELECT 2 AS age", 1L);
        this.assertMetastoreInvocations("ANALYZE test_analyze", (Multiset<MetastoreMethod>)ImmutableMultiset.builder().add((Object)MetastoreMethod.GET_TABLE).add((Object)MetastoreMethod.UPDATE_TABLE_STATISTICS).build());
    }

    @Test
    public void testAnalyzePartitionedTable() {
        this.assertUpdate("CREATE TABLE test_analyze_partition WITH (partitioned_by = ARRAY['part']) AS SELECT 1 AS data, 10 AS part", 1L);
        this.assertMetastoreInvocations("ANALYZE test_analyze_partition", (Multiset<MetastoreMethod>)ImmutableMultiset.builder().addCopies((Object)MetastoreMethod.GET_TABLE, 1).add((Object)MetastoreMethod.GET_PARTITION_NAMES_BY_FILTER).add((Object)MetastoreMethod.GET_PARTITIONS_BY_NAMES).add((Object)MetastoreMethod.GET_PARTITION_COLUMN_STATISTICS).add((Object)MetastoreMethod.UPDATE_PARTITION_STATISTICS).build());
        this.assertUpdate("INSERT INTO test_analyze_partition SELECT 2 AS data, 20 AS part", 1L);
        this.assertMetastoreInvocations("ANALYZE test_analyze_partition", (Multiset<MetastoreMethod>)ImmutableMultiset.builder().add((Object)MetastoreMethod.GET_TABLE).add((Object)MetastoreMethod.GET_PARTITION_NAMES_BY_FILTER).add((Object)MetastoreMethod.GET_PARTITIONS_BY_NAMES).add((Object)MetastoreMethod.GET_PARTITION_COLUMN_STATISTICS).add((Object)MetastoreMethod.UPDATE_PARTITION_STATISTICS).build());
    }

    @Test
    public void testDropStats() {
        this.assertUpdate("CREATE TABLE drop_stats AS SELECT 2 AS age", 1L);
        this.assertMetastoreInvocations("CALL system.drop_stats(CURRENT_SCHEMA, 'drop_stats')", (Multiset<MetastoreMethod>)ImmutableMultiset.builder().add((Object)MetastoreMethod.GET_TABLE).add((Object)MetastoreMethod.UPDATE_TABLE_STATISTICS).build());
    }

    @Test
    public void testDropStatsPartitionedTable() {
        this.assertUpdate("CREATE TABLE drop_stats_partition WITH (partitioned_by = ARRAY['part']) AS SELECT 1 AS data, 10 AS part", 1L);
        this.assertMetastoreInvocations("CALL system.drop_stats(CURRENT_SCHEMA, 'drop_stats_partition')", (Multiset<MetastoreMethod>)ImmutableMultiset.builder().add((Object)MetastoreMethod.GET_TABLE).add((Object)MetastoreMethod.GET_PARTITION_NAMES_BY_FILTER).add((Object)MetastoreMethod.UPDATE_PARTITION_STATISTICS).build());
        this.assertUpdate("INSERT INTO drop_stats_partition SELECT 2 AS data, 20 AS part", 1L);
        this.assertMetastoreInvocations("CALL system.drop_stats(CURRENT_SCHEMA, 'drop_stats_partition')", (Multiset<MetastoreMethod>)ImmutableMultiset.builder().add((Object)MetastoreMethod.GET_TABLE).add((Object)MetastoreMethod.GET_PARTITION_NAMES_BY_FILTER).addCopies((Object)MetastoreMethod.UPDATE_PARTITION_STATISTICS, 2).build());
    }

    private void assertMetastoreInvocations(@Language(value="SQL") String query, Multiset<MetastoreMethod> expectedInvocations) {
        this.assertMetastoreInvocations(this.getSession(), query, expectedInvocations);
    }

    private void assertMetastoreInvocations(Session session, @Language(value="SQL") String query, Multiset<MetastoreMethod> expectedInvocations) {
        MetastoreInvocations.assertMetastoreInvocationsForQuery((QueryRunner)this.getDistributedQueryRunner(), session, query, expectedInvocations);
    }
}

