/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.metastore.thrift;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.Multiset;
import io.airlift.log.Logger;
import io.airlift.units.Duration;
import io.trino.Session;
import io.trino.metastore.Column;
import io.trino.metastore.Database;
import io.trino.metastore.HiveMetastore;
import io.trino.metastore.HiveMetastoreFactory;
import io.trino.metastore.HiveType;
import io.trino.metastore.PrincipalPrivileges;
import io.trino.metastore.Table;
import io.trino.plugin.hive.HiveQueryRunner;
import io.trino.plugin.hive.HiveStorageFormat;
import io.trino.plugin.hive.TableType;
import io.trino.plugin.hive.TestingHiveUtils;
import io.trino.plugin.hive.containers.HiveHadoop;
import io.trino.plugin.hive.metastore.MetastoreInvocations;
import io.trino.plugin.hive.metastore.MetastoreMethod;
import io.trino.testing.AbstractTestQueryFramework;
import io.trino.testing.DistributedQueryRunner;
import io.trino.testing.QueryRunner;
import io.trino.testing.TestingSession;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.intellij.lang.annotations.Language;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@Execution(value=ExecutionMode.SAME_THREAD)
public class TestHiveMetastoreMetadataQueriesAccessOperations
extends AbstractTestQueryFramework {
    private static final Logger log = Logger.get(TestHiveMetastoreMetadataQueriesAccessOperations.class);
    private static final int MAX_PREFIXES_COUNT = 20;
    private static final int TEST_SCHEMAS_COUNT = 21;
    private static final int TEST_TABLES_IN_SCHEMA_COUNT = 23;
    private static final int TEST_ALL_TABLES_COUNT = 483;
    private static final Session SESSION = TestingSession.testSessionBuilder().setCatalog("hive").setSchema(Optional.empty()).build();
    private HiveHadoop hiveHadoop;

    protected QueryRunner createQueryRunner() throws Exception {
        this.hiveHadoop = HiveHadoop.builder().build();
        this.hiveHadoop.start();
        DistributedQueryRunner queryRunner = ((HiveQueryRunner.Builder)((Object)((HiveQueryRunner.Builder)((Object)((HiveQueryRunner.Builder)((Object)((HiveQueryRunner.Builder)((Object)((HiveQueryRunner.Builder)((HiveQueryRunner.Builder)HiveQueryRunner.builder(SESSION).setWorkerCount(0)).addCoordinatorProperty("optimizer.experimental-max-prefetched-information-schema-prefixes", Integer.toString(20))).addHiveProperty("hive.metastore", "thrift"))).addHiveProperty("hive.metastore.uri", this.hiveHadoop.getHiveMetastoreEndpoint().toString()))).addHiveProperty("hive.hive-views.enabled", "true"))).setCreateTpchSchemas(false))).build();
        try {
            long start = System.nanoTime();
            TestHiveMetastoreMetadataQueriesAccessOperations.createTestingTables((QueryRunner)queryRunner);
            log.info("Created testing tables in %s", new Object[]{Duration.nanosSince((long)start)});
        }
        catch (RuntimeException e) {
            queryRunner.close();
            throw e;
        }
        return queryRunner;
    }

    private static void createTestingTables(QueryRunner queryRunner) {
        HiveMetastore metastore = TestingHiveUtils.getConnectorService(queryRunner, HiveMetastoreFactory.class).createMetastore(Optional.empty());
        for (int databaseId = 0; databaseId < 21; ++databaseId) {
            Object databaseName;
            if (databaseId < 20) {
                databaseName = "test_schema_" + databaseId;
                metastore.createDatabase(Database.builder().setDatabaseName((String)databaseName).setOwnerName(Optional.empty()).setOwnerType(Optional.empty()).build());
            } else {
                databaseName = "default";
            }
            for (int tableId = 0; tableId < 23; ++tableId) {
                Table.Builder table = Table.builder().setDatabaseName((String)databaseName).setTableName("test_table_" + tableId).setTableType(TableType.MANAGED_TABLE.name()).setDataColumns((List)ImmutableList.of((Object)new Column("id", HiveType.HIVE_INT, Optional.empty(), Map.of()), (Object)new Column("name", HiveType.HIVE_STRING, Optional.empty(), Map.of()))).setOwner(Optional.empty());
                table.getStorageBuilder().setStorageFormat(HiveStorageFormat.PARQUET.toStorageFormat());
                metastore.createTable(table.build(), PrincipalPrivileges.NO_PRIVILEGES);
            }
        }
    }

    @AfterAll
    void afterAll() {
        this.hiveHadoop.stop();
    }

    @Test
    public void testSelectSchemasWithoutPredicate() {
        this.assertMetastoreInvocations("SELECT * FROM information_schema.schemata", (Multiset<MetastoreMethod>)ImmutableMultiset.of((Object)((Object)MetastoreMethod.GET_ALL_DATABASES)));
        this.assertMetastoreInvocations("SELECT * FROM system.jdbc.schemas", (Multiset<MetastoreMethod>)ImmutableMultiset.of((Object)((Object)MetastoreMethod.GET_ALL_DATABASES)));
    }

    @Test
    public void testSelectSchemasWithFilterByInformationSchema() {
        this.assertMetastoreInvocations("SELECT * FROM information_schema.schemata WHERE schema_name = 'information_schema'", (Multiset<MetastoreMethod>)ImmutableMultiset.of((Object)((Object)MetastoreMethod.GET_ALL_DATABASES)));
        this.assertMetastoreInvocations("SELECT * FROM system.jdbc.schemas WHERE table_schem = 'information_schema'", (Multiset<MetastoreMethod>)ImmutableMultiset.of((Object)((Object)MetastoreMethod.GET_ALL_DATABASES)));
    }

    @Test
    public void testSelectSchemasWithLikeOverSchemaName() {
        this.assertMetastoreInvocations("SELECT * FROM information_schema.schemata WHERE schema_name LIKE 'test%'", (Multiset<MetastoreMethod>)ImmutableMultiset.of((Object)((Object)MetastoreMethod.GET_ALL_DATABASES)));
        this.assertMetastoreInvocations("SELECT * FROM system.jdbc.schemas WHERE table_schem LIKE 'test%'", (Multiset<MetastoreMethod>)ImmutableMultiset.of((Object)((Object)MetastoreMethod.GET_ALL_DATABASES)));
    }

    @Test
    public void testSelectTablesWithoutPredicate() {
        ImmutableMultiset tables = ImmutableMultiset.builder().add((Object)MetastoreMethod.GET_ALL_DATABASES).addCopies((Object)MetastoreMethod.GET_TABLES, 21).build();
        this.assertMetastoreInvocations("SELECT * FROM information_schema.tables", (Multiset<MetastoreMethod>)tables);
        this.assertMetastoreInvocations("SELECT * FROM system.jdbc.tables", (Multiset<MetastoreMethod>)tables);
    }

    @Test
    public void testSelectTablesWithFilterByInformationSchema() {
        this.assertMetastoreInvocations("SELECT * FROM information_schema.tables WHERE table_schema = 'information_schema'", (Multiset<MetastoreMethod>)ImmutableMultiset.of());
        this.assertMetastoreInvocations("SELECT * FROM system.jdbc.tables WHERE table_schem = 'information_schema'", (Multiset<MetastoreMethod>)ImmutableMultiset.of());
    }

    @Test
    public void testSelectTablesWithFilterBySchema() {
        this.assertMetastoreInvocations("SELECT * FROM information_schema.tables WHERE table_schema = 'test_schema_0'", (Multiset<MetastoreMethod>)ImmutableMultiset.builder().add((Object)MetastoreMethod.GET_TABLES).build());
        this.assertMetastoreInvocations("SELECT * FROM system.jdbc.tables WHERE table_schem = 'test_schema_0'", (Multiset<MetastoreMethod>)ImmutableMultiset.builder().add((Object)MetastoreMethod.GET_TABLES).build());
    }

    @Test
    public void testSelectTablesWithLikeOverSchema() {
        this.assertMetastoreInvocations("SELECT * FROM information_schema.tables WHERE table_schema LIKE 'test%'", (Multiset<MetastoreMethod>)ImmutableMultiset.builder().add((Object)MetastoreMethod.GET_ALL_DATABASES).addCopies((Object)MetastoreMethod.GET_TABLES, 20).build());
        this.assertMetastoreInvocations("SELECT * FROM system.jdbc.tables WHERE table_schem LIKE 'test%'", (Multiset<MetastoreMethod>)ImmutableMultiset.builder().add((Object)MetastoreMethod.GET_ALL_DATABASES).addCopies((Object)MetastoreMethod.GET_TABLES, 21).build());
    }

    @Test
    public void testSelectTablesWithFilterByTableName() {
        this.assertMetastoreInvocations("SELECT * FROM information_schema.tables WHERE table_name = 'test_table_0'", (Multiset<MetastoreMethod>)ImmutableMultiset.builder().add((Object)MetastoreMethod.GET_ALL_DATABASES).addCopies((Object)MetastoreMethod.GET_TABLES, 21).build());
        ImmutableMultiset tables = ImmutableMultiset.builder().add((Object)MetastoreMethod.GET_ALL_DATABASES).addCopies((Object)MetastoreMethod.GET_TABLES, 21).build();
        this.assertMetastoreInvocations("SELECT * FROM system.jdbc.tables WHERE table_name = 'test_table_0'", (Multiset<MetastoreMethod>)tables);
        this.assertMetastoreInvocations("SELECT * FROM system.jdbc.tables WHERE table_name LIKE 'test\\_table\\_0' ESCAPE '\\'", (Multiset<MetastoreMethod>)tables);
        this.assertMetastoreInvocations("SELECT * FROM system.jdbc.tables WHERE table_name LIKE 'test_table_0' ESCAPE '\\'", (Multiset<MetastoreMethod>)tables);
    }

    @Test
    public void testSelectTablesWithLikeOverTableName() {
        this.assertMetastoreInvocations("SELECT * FROM information_schema.tables WHERE table_name LIKE 'test%'", (Multiset<MetastoreMethod>)ImmutableMultiset.builder().add((Object)MetastoreMethod.GET_ALL_DATABASES).addCopies((Object)MetastoreMethod.GET_TABLES, 21).build());
        this.assertMetastoreInvocations("SELECT * FROM system.jdbc.tables WHERE table_name LIKE 'test%'", (Multiset<MetastoreMethod>)ImmutableMultiset.builder().add((Object)MetastoreMethod.GET_ALL_DATABASES).addCopies((Object)MetastoreMethod.GET_TABLES, 21).build());
    }

    @Test
    public void testSelectViewsWithoutPredicate() {
        this.assertMetastoreInvocations("SELECT * FROM information_schema.views", (Multiset<MetastoreMethod>)ImmutableMultiset.builder().add((Object)MetastoreMethod.GET_ALL_DATABASES).addCopies((Object)MetastoreMethod.GET_TABLES, 21).build());
        this.assertMetastoreInvocations("SELECT * FROM system.jdbc.tables WHERE table_type = 'VIEW'", (Multiset<MetastoreMethod>)ImmutableMultiset.builder().add((Object)MetastoreMethod.GET_ALL_DATABASES).addCopies((Object)MetastoreMethod.GET_TABLES, 21).build());
    }

    @Test
    public void testSelectViewsWithFilterByInformationSchema() {
        this.assertMetastoreInvocations("SELECT * FROM information_schema.views WHERE table_schema = 'information_schema'", (Multiset<MetastoreMethod>)ImmutableMultiset.of());
        this.assertMetastoreInvocations("SELECT * FROM system.jdbc.tables WHERE table_type = 'VIEW' AND table_schem = 'information_schema'", (Multiset<MetastoreMethod>)ImmutableMultiset.of());
    }

    @Test
    public void testSelectViewsWithFilterBySchema() {
        this.assertMetastoreInvocations("SELECT * FROM information_schema.views WHERE table_schema = 'test_schema_0'", (Multiset<MetastoreMethod>)ImmutableMultiset.of((Object)((Object)MetastoreMethod.GET_TABLES)));
        this.assertMetastoreInvocations("SELECT * FROM system.jdbc.tables WHERE table_type = 'VIEW' AND table_schem = 'test_schema_0'", (Multiset<MetastoreMethod>)ImmutableMultiset.builder().add((Object)MetastoreMethod.GET_TABLES).build());
    }

    @Test
    public void testSelectViewsWithLikeOverSchema() {
        this.assertMetastoreInvocations("SELECT * FROM information_schema.views WHERE table_schema LIKE 'test%'", (Multiset<MetastoreMethod>)ImmutableMultiset.builder().add((Object)MetastoreMethod.GET_ALL_DATABASES).addCopies((Object)MetastoreMethod.GET_TABLES, 20).build());
        this.assertMetastoreInvocations("SELECT * FROM system.jdbc.tables WHERE table_type = 'VIEW' AND table_schem LIKE 'test%'", (Multiset<MetastoreMethod>)ImmutableMultiset.builder().add((Object)MetastoreMethod.GET_ALL_DATABASES).addCopies((Object)MetastoreMethod.GET_TABLES, 21).build());
    }

    @Test
    public void testSelectViewsWithFilterByTableName() {
        this.assertMetastoreInvocations("SELECT * FROM information_schema.views WHERE table_name = 'test_table_0'", (Multiset<MetastoreMethod>)ImmutableMultiset.builder().add((Object)MetastoreMethod.GET_ALL_DATABASES).addCopies((Object)MetastoreMethod.GET_TABLES, 21).build());
        this.assertMetastoreInvocations("SELECT * FROM system.jdbc.tables WHERE table_type = 'VIEW' AND table_name = 'test_table_0'", (Multiset<MetastoreMethod>)ImmutableMultiset.builder().add((Object)MetastoreMethod.GET_ALL_DATABASES).addCopies((Object)MetastoreMethod.GET_TABLES, 21).build());
    }

    @Test
    public void testSelectViewsWithLikeOverTableName() {
        this.assertMetastoreInvocations("SELECT * FROM information_schema.views WHERE table_name LIKE 'test%'", (Multiset<MetastoreMethod>)ImmutableMultiset.builder().add((Object)MetastoreMethod.GET_ALL_DATABASES).addCopies((Object)MetastoreMethod.GET_TABLES, 21).build());
        this.assertMetastoreInvocations("SELECT * FROM system.jdbc.tables WHERE table_type = 'VIEW' AND table_name LIKE 'test%'", (Multiset<MetastoreMethod>)ImmutableMultiset.builder().add((Object)MetastoreMethod.GET_ALL_DATABASES).addCopies((Object)MetastoreMethod.GET_TABLES, 21).build());
    }

    @Test
    public void testSelectColumnsWithoutPredicate() {
        ImmutableMultiset tables = ImmutableMultiset.builder().add((Object)MetastoreMethod.GET_ALL_DATABASES).addCopies((Object)MetastoreMethod.GET_TABLES, 21).addCopies((Object)MetastoreMethod.GET_TABLE, 483).build();
        this.assertMetastoreInvocations("SELECT * FROM information_schema.columns", (Multiset<MetastoreMethod>)tables);
        this.assertMetastoreInvocations("SELECT * FROM system.jdbc.columns", (Multiset<MetastoreMethod>)tables);
    }

    @Test
    public void testSelectColumnsFilterByInformationSchema() {
        this.assertMetastoreInvocations("SELECT * FROM information_schema.columns WHERE table_schema = 'information_schema'", (Multiset<MetastoreMethod>)ImmutableMultiset.of());
        this.assertMetastoreInvocations("SELECT * FROM system.jdbc.columns WHERE table_schem = 'information_schema'", (Multiset<MetastoreMethod>)ImmutableMultiset.of());
    }

    @Test
    public void testSelectColumnsFilterBySchema() {
        this.assertMetastoreInvocations("SELECT * FROM information_schema.columns WHERE table_schema = 'test_schema_0'", (Multiset<MetastoreMethod>)ImmutableMultiset.builder().add((Object)MetastoreMethod.GET_TABLES).addCopies((Object)MetastoreMethod.GET_TABLE, 23).build());
        this.assertMetastoreInvocations("SELECT * FROM system.jdbc.columns WHERE table_schem = 'test_schema_0'", (Multiset<MetastoreMethod>)ImmutableMultiset.builder().add((Object)MetastoreMethod.GET_TABLES).addCopies((Object)MetastoreMethod.GET_TABLE, 23).build());
        this.assertMetastoreInvocations("SELECT * FROM system.jdbc.columns WHERE table_schem LIKE 'test\\_schema\\_0' ESCAPE '\\'", (Multiset<MetastoreMethod>)ImmutableMultiset.builder().add((Object)MetastoreMethod.GET_TABLES).addCopies((Object)MetastoreMethod.GET_TABLE, 23).build());
        this.assertMetastoreInvocations("SELECT * FROM system.jdbc.columns WHERE table_schem LIKE 'test_schema_0' ESCAPE '\\'", (Multiset<MetastoreMethod>)ImmutableMultiset.builder().add((Object)MetastoreMethod.GET_ALL_DATABASES).add((Object)MetastoreMethod.GET_TABLES).addCopies((Object)MetastoreMethod.GET_TABLE, 23).build());
    }

    @Test
    public void testSelectColumnsWithLikeOverSchema() {
        this.assertMetastoreInvocations("SELECT * FROM information_schema.columns WHERE table_schema LIKE 'test%'", (Multiset<MetastoreMethod>)ImmutableMultiset.builder().add((Object)MetastoreMethod.GET_ALL_DATABASES).addCopies((Object)MetastoreMethod.GET_TABLES, 21).addCopies((Object)MetastoreMethod.GET_TABLE, 483).build());
        this.assertMetastoreInvocations("SELECT * FROM system.jdbc.columns WHERE table_schem LIKE 'test%'", (Multiset<MetastoreMethod>)ImmutableMultiset.builder().add((Object)MetastoreMethod.GET_ALL_DATABASES).addCopies((Object)MetastoreMethod.GET_TABLES, 20).addCopies((Object)MetastoreMethod.GET_TABLE, 460).build());
    }

    @Test
    public void testSelectColumnsFilterByTableName() {
        this.assertMetastoreInvocations("SELECT * FROM information_schema.columns WHERE table_name = 'test_table_0'", (Multiset<MetastoreMethod>)ImmutableMultiset.builder().add((Object)MetastoreMethod.GET_ALL_DATABASES).addCopies((Object)MetastoreMethod.GET_TABLES, 21).addCopies((Object)MetastoreMethod.GET_TABLE, 483).build());
        this.assertMetastoreInvocations("SELECT * FROM system.jdbc.columns WHERE table_name = 'test_table_0'", (Multiset<MetastoreMethod>)ImmutableMultiset.builder().add((Object)MetastoreMethod.GET_ALL_DATABASES).addCopies((Object)MetastoreMethod.GET_TABLE, 21).build());
        this.assertMetastoreInvocations("SELECT * FROM system.jdbc.columns WHERE table_name LIKE 'test\\_table\\_0' ESCAPE '\\'", (Multiset<MetastoreMethod>)ImmutableMultiset.builder().add((Object)MetastoreMethod.GET_ALL_DATABASES).addCopies((Object)MetastoreMethod.GET_TABLE, 21).build());
        this.assertMetastoreInvocations("SELECT * FROM system.jdbc.columns WHERE table_name LIKE 'test_table_0' ESCAPE '\\'", (Multiset<MetastoreMethod>)ImmutableMultiset.builder().add((Object)MetastoreMethod.GET_ALL_DATABASES).addCopies((Object)MetastoreMethod.GET_TABLES, 21).addCopies((Object)MetastoreMethod.GET_TABLE, 21).build());
    }

    @Test
    public void testSelectColumnsWithLikeOverTableName() {
        this.assertMetastoreInvocations("SELECT * FROM information_schema.columns WHERE table_name LIKE 'test%'", (Multiset<MetastoreMethod>)ImmutableMultiset.builder().add((Object)MetastoreMethod.GET_ALL_DATABASES).addCopies((Object)MetastoreMethod.GET_TABLES, 21).addCopies((Object)MetastoreMethod.GET_TABLE, 483).build());
        this.assertMetastoreInvocations("SELECT * FROM system.jdbc.columns WHERE table_name LIKE 'test%'", (Multiset<MetastoreMethod>)ImmutableMultiset.builder().add((Object)MetastoreMethod.GET_ALL_DATABASES).addCopies((Object)MetastoreMethod.GET_TABLES, 21).addCopies((Object)MetastoreMethod.GET_TABLE, 483).build());
    }

    @Test
    public void testSelectColumnsFilterByColumn() {
        this.assertMetastoreInvocations("SELECT * FROM information_schema.columns WHERE column_name = 'name'", (Multiset<MetastoreMethod>)ImmutableMultiset.builder().add((Object)MetastoreMethod.GET_ALL_DATABASES).addCopies((Object)MetastoreMethod.GET_TABLES, 21).addCopies((Object)MetastoreMethod.GET_TABLE, 483).build());
        this.assertMetastoreInvocations("SELECT * FROM system.jdbc.columns WHERE column_name = 'name'", (Multiset<MetastoreMethod>)ImmutableMultiset.builder().add((Object)MetastoreMethod.GET_ALL_DATABASES).addCopies((Object)MetastoreMethod.GET_TABLES, 21).addCopies((Object)MetastoreMethod.GET_TABLE, 483).build());
    }

    @Test
    public void testSelectColumnsWithLikeOverColumn() {
        this.assertMetastoreInvocations("SELECT * FROM information_schema.columns WHERE column_name LIKE 'n%'", (Multiset<MetastoreMethod>)ImmutableMultiset.builder().add((Object)MetastoreMethod.GET_ALL_DATABASES).addCopies((Object)MetastoreMethod.GET_TABLES, 21).addCopies((Object)MetastoreMethod.GET_TABLE, 483).build());
        this.assertMetastoreInvocations("SELECT * FROM system.jdbc.columns WHERE column_name LIKE 'n%'", (Multiset<MetastoreMethod>)ImmutableMultiset.builder().add((Object)MetastoreMethod.GET_ALL_DATABASES).addCopies((Object)MetastoreMethod.GET_TABLES, 21).addCopies((Object)MetastoreMethod.GET_TABLE, 483).build());
    }

    @Test
    public void testSelectColumnsFilterByTableAndSchema() {
        this.assertMetastoreInvocations("SELECT * FROM information_schema.columns WHERE table_schema = 'test_schema_0' AND table_name = 'test_table_0'", (Multiset<MetastoreMethod>)ImmutableMultiset.of((Object)((Object)MetastoreMethod.GET_TABLE)));
        this.assertMetastoreInvocations("SELECT * FROM system.jdbc.columns WHERE table_schem = 'test_schema_0' AND table_name = 'test_table_0'", (Multiset<MetastoreMethod>)ImmutableMultiset.of((Object)((Object)MetastoreMethod.GET_TABLE)));
        this.assertMetastoreInvocations("SELECT * FROM system.jdbc.columns WHERE table_schem LIKE 'test\\_schema\\_0' ESCAPE '\\' AND table_name LIKE 'test\\_table\\_0' ESCAPE '\\'", (Multiset<MetastoreMethod>)ImmutableMultiset.of((Object)((Object)MetastoreMethod.GET_TABLE)));
        this.assertMetastoreInvocations("SELECT * FROM system.jdbc.columns WHERE table_schem LIKE 'test_schema_0' ESCAPE '\\' AND table_name LIKE 'test_table_0' ESCAPE '\\'", (Multiset<MetastoreMethod>)ImmutableMultiset.builder().add((Object)MetastoreMethod.GET_ALL_DATABASES).add((Object)MetastoreMethod.GET_TABLES).add((Object)MetastoreMethod.GET_TABLE).build());
    }

    private void assertMetastoreInvocations(@Language(value="SQL") String query, Multiset<MetastoreMethod> expectedInvocations) {
        MetastoreInvocations.assertMetastoreInvocationsForQuery((QueryRunner)this.getDistributedQueryRunner(), this.getQueryRunner().getDefaultSession(), query, expectedInvocations);
    }
}

