/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.metastore.thrift;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.configuration.testing.ConfigAssertions;
import io.trino.plugin.hive.metastore.thrift.StaticMetastoreConfig;
import java.net.URI;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestStaticMetastoreConfig {
    @Test
    public void testDefaults() {
        ConfigAssertions.assertRecordedDefaults((Object)((StaticMetastoreConfig)ConfigAssertions.recordDefaults(StaticMetastoreConfig.class)).setMetastoreUris(null).setMetastoreUsername(null));
    }

    @Test
    public void testExplicitPropertyMappingsSingleMetastore() {
        ImmutableMap properties = ImmutableMap.builder().put((Object)"hive.metastore.uri", (Object)"thrift://localhost:9083").put((Object)"hive.metastore.username", (Object)"trino").buildOrThrow();
        StaticMetastoreConfig expected = new StaticMetastoreConfig().setMetastoreUris((List)ImmutableList.of((Object)"thrift://localhost:9083")).setMetastoreUsername("trino");
        ConfigAssertions.assertFullMapping((Map)properties, (Object)expected);
        Assertions.assertThat((List)expected.getMetastoreUris()).isEqualTo((Object)ImmutableList.of((Object)URI.create("thrift://localhost:9083")));
        Assertions.assertThat((String)expected.getMetastoreUsername()).isEqualTo("trino");
    }

    @Test
    public void testExplicitPropertyMappingsMultipleMetastores() {
        ImmutableMap properties = ImmutableMap.builder().put((Object)"hive.metastore.uri", (Object)"thrift://localhost:9083,thrift://192.0.2.3:8932").put((Object)"hive.metastore.username", (Object)"trino").buildOrThrow();
        StaticMetastoreConfig expected = new StaticMetastoreConfig().setMetastoreUris((List)ImmutableList.of((Object)"thrift://localhost:9083", (Object)"thrift://192.0.2.3:8932")).setMetastoreUsername("trino");
        ConfigAssertions.assertFullMapping((Map)properties, (Object)expected);
        Assertions.assertThat((List)expected.getMetastoreUris()).isEqualTo((Object)ImmutableList.of((Object)URI.create("thrift://localhost:9083"), (Object)URI.create("thrift://192.0.2.3:8932")));
        Assertions.assertThat((String)expected.getMetastoreUsername()).isEqualTo("trino");
    }
}

