/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.metastore.thrift;

import com.google.common.base.Ticker;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.testing.TestingTicker;
import io.trino.hive.thrift.metastore.Table;
import io.trino.plugin.hive.metastore.thrift.FailureAwareThriftMetastoreClient;
import io.trino.plugin.hive.metastore.thrift.MockThriftMetastoreClient;
import io.trino.plugin.hive.metastore.thrift.MockThriftMetastoreClientFactory;
import io.trino.plugin.hive.metastore.thrift.StaticMetastoreConfig;
import io.trino.plugin.hive.metastore.thrift.StaticTokenAwareMetastoreClientFactory;
import io.trino.plugin.hive.metastore.thrift.ThriftMetastoreAuthenticationConfig;
import io.trino.plugin.hive.metastore.thrift.ThriftMetastoreClient;
import io.trino.plugin.hive.metastore.thrift.ThriftMetastoreClientFactory;
import io.trino.plugin.hive.metastore.thrift.TokenAwareMetastoreClientFactory;
import java.net.SocketTimeoutException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.apache.thrift.TException;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestStaticTokenAwareMetastoreClientFactory {
    private static final ThriftMetastoreClient DEFAULT_CLIENT = TestStaticTokenAwareMetastoreClientFactory.createFakeMetastoreClient();
    private static final ThriftMetastoreClient FALLBACK_CLIENT = TestStaticTokenAwareMetastoreClientFactory.createFakeMetastoreClient();
    private static final String DEFAULT_URI = "thrift://default:8080";
    private static final String FALLBACK_URI = "thrift://fallback:8090";
    private static final String FALLBACK2_URI = "thrift://fallback2:8090";
    private static final StaticMetastoreConfig CONFIG_WITH_FALLBACK = new StaticMetastoreConfig().setMetastoreUris((List)ImmutableList.of((Object)"thrift://default:8080", (Object)"thrift://fallback:8090", (Object)"thrift://fallback2:8090"));
    private static final StaticMetastoreConfig CONFIG_WITHOUT_FALLBACK = new StaticMetastoreConfig().setMetastoreUris((List)ImmutableList.of((Object)"thrift://default:8080"));
    private static final StaticMetastoreConfig CONFIG_WITH_FALLBACK_WITH_USER = new StaticMetastoreConfig().setMetastoreUris((List)ImmutableList.of((Object)"thrift://default:8080", (Object)"thrift://fallback:8090", (Object)"thrift://fallback2:8090")).setMetastoreUsername("presto");
    private static final StaticMetastoreConfig CONFIG_WITHOUT_FALLBACK_WITH_USER = new StaticMetastoreConfig().setMetastoreUris((List)ImmutableList.of((Object)"thrift://default:8080")).setMetastoreUsername("presto");
    private static final Map<String, Optional<ThriftMetastoreClient>> CLIENTS = ImmutableMap.of((Object)"thrift://default:8080", Optional.of(DEFAULT_CLIENT), (Object)"thrift://fallback:8090", Optional.of(FALLBACK_CLIENT));

    @Test
    public void testDefaultHiveMetastore() throws TException {
        TokenAwareMetastoreClientFactory clientFactory = TestStaticTokenAwareMetastoreClientFactory.createMetastoreClientFactory(CONFIG_WITH_FALLBACK, (Map<String, Optional<ThriftMetastoreClient>>)ImmutableMap.of((Object)DEFAULT_URI, Optional.of(DEFAULT_CLIENT)));
        TestStaticTokenAwareMetastoreClientFactory.assertEqualHiveClient(clientFactory.createMetastoreClient(Optional.empty()), DEFAULT_CLIENT);
    }

    @Test
    public void testFallbackHiveMetastore() throws TException {
        TokenAwareMetastoreClientFactory clientFactory = TestStaticTokenAwareMetastoreClientFactory.createMetastoreClientFactory(CONFIG_WITH_FALLBACK, (Map<String, Optional<ThriftMetastoreClient>>)ImmutableMap.of((Object)DEFAULT_URI, Optional.empty(), (Object)FALLBACK_URI, Optional.of(FALLBACK_CLIENT)));
        TestStaticTokenAwareMetastoreClientFactory.assertEqualHiveClient(clientFactory.createMetastoreClient(Optional.empty()), FALLBACK_CLIENT);
    }

    @Test
    public void testFallbackHiveMetastoreFails() {
        TokenAwareMetastoreClientFactory clientFactory = TestStaticTokenAwareMetastoreClientFactory.createMetastoreClientFactory(CONFIG_WITH_FALLBACK, (Map<String, Optional<ThriftMetastoreClient>>)ImmutableMap.of());
        TestStaticTokenAwareMetastoreClientFactory.assertCreateClientFails(clientFactory, "Failed connecting to Hive metastore: [default:8080, fallback:8090, fallback2:8090]");
    }

    @Test
    public void testMetastoreFailedWithoutFallback() {
        TokenAwareMetastoreClientFactory clientFactory = TestStaticTokenAwareMetastoreClientFactory.createMetastoreClientFactory(CONFIG_WITHOUT_FALLBACK, (Map<String, Optional<ThriftMetastoreClient>>)ImmutableMap.of((Object)DEFAULT_URI, Optional.empty()));
        TestStaticTokenAwareMetastoreClientFactory.assertCreateClientFails(clientFactory, "Failed connecting to Hive metastore: [default:8080]");
    }

    @Test
    public void testFallbackHiveMetastoreWithHiveUser() throws TException {
        TokenAwareMetastoreClientFactory clientFactory = TestStaticTokenAwareMetastoreClientFactory.createMetastoreClientFactory(CONFIG_WITH_FALLBACK_WITH_USER, (Map<String, Optional<ThriftMetastoreClient>>)ImmutableMap.of((Object)DEFAULT_URI, Optional.empty(), (Object)FALLBACK_URI, Optional.empty(), (Object)FALLBACK2_URI, Optional.of(FALLBACK_CLIENT)));
        TestStaticTokenAwareMetastoreClientFactory.assertEqualHiveClient(clientFactory.createMetastoreClient(Optional.empty()), FALLBACK_CLIENT);
    }

    @Test
    public void testMetastoreFailedWithoutFallbackWithHiveUser() {
        TokenAwareMetastoreClientFactory clientFactory = TestStaticTokenAwareMetastoreClientFactory.createMetastoreClientFactory(CONFIG_WITHOUT_FALLBACK_WITH_USER, (Map<String, Optional<ThriftMetastoreClient>>)ImmutableMap.of((Object)DEFAULT_URI, Optional.empty()));
        TestStaticTokenAwareMetastoreClientFactory.assertCreateClientFails(clientFactory, "Failed connecting to Hive metastore: [default:8080]");
    }

    @Test
    public void testFallbackHiveMetastoreOnTimeOut() throws TException {
        TokenAwareMetastoreClientFactory clientFactory = TestStaticTokenAwareMetastoreClientFactory.createMetastoreClientFactory(CONFIG_WITH_FALLBACK, CLIENTS);
        ThriftMetastoreClient metastoreClient1 = clientFactory.createMetastoreClient(Optional.empty());
        TestStaticTokenAwareMetastoreClientFactory.assertEqualHiveClient(metastoreClient1, DEFAULT_CLIENT);
        TestStaticTokenAwareMetastoreClientFactory.assertGetTableException(metastoreClient1);
        ThriftMetastoreClient metastoreClient2 = clientFactory.createMetastoreClient(Optional.empty());
        TestStaticTokenAwareMetastoreClientFactory.assertEqualHiveClient(metastoreClient2, FALLBACK_CLIENT);
        TestStaticTokenAwareMetastoreClientFactory.assertGetTableException(metastoreClient2);
    }

    @Test
    public void testFallbackHiveMetastoreOnAllTimeOut() throws TException {
        TokenAwareMetastoreClientFactory clientFactory = TestStaticTokenAwareMetastoreClientFactory.createMetastoreClientFactory(CONFIG_WITH_FALLBACK, CLIENTS);
        ThriftMetastoreClient metastoreClient1 = clientFactory.createMetastoreClient(Optional.empty());
        TestStaticTokenAwareMetastoreClientFactory.assertEqualHiveClient(metastoreClient1, DEFAULT_CLIENT);
        for (int i = 0; i < 20; ++i) {
            TestStaticTokenAwareMetastoreClientFactory.assertGetTableException(metastoreClient1);
        }
        ThriftMetastoreClient metastoreClient2 = clientFactory.createMetastoreClient(Optional.empty());
        TestStaticTokenAwareMetastoreClientFactory.assertEqualHiveClient(metastoreClient2, FALLBACK_CLIENT);
        TestStaticTokenAwareMetastoreClientFactory.assertGetTableException(metastoreClient2);
        ThriftMetastoreClient metastoreClient3 = clientFactory.createMetastoreClient(Optional.empty());
        TestStaticTokenAwareMetastoreClientFactory.assertEqualHiveClient(metastoreClient3, FALLBACK_CLIENT);
    }

    @Test
    public void testStickToFallbackAfterBackoff() throws TException {
        TestingTicker ticker = new TestingTicker();
        TokenAwareMetastoreClientFactory clientFactory = TestStaticTokenAwareMetastoreClientFactory.createMetastoreClientFactory(CONFIG_WITH_FALLBACK, CLIENTS, (Ticker)ticker);
        ticker.increment(10L, TimeUnit.NANOSECONDS);
        ThriftMetastoreClient metastoreClient1 = clientFactory.createMetastoreClient(Optional.empty());
        TestStaticTokenAwareMetastoreClientFactory.assertEqualHiveClient(metastoreClient1, DEFAULT_CLIENT);
        TestStaticTokenAwareMetastoreClientFactory.assertGetTableException(metastoreClient1);
        ticker.increment(10L, TimeUnit.NANOSECONDS);
        ThriftMetastoreClient metastoreClient2 = clientFactory.createMetastoreClient(Optional.empty());
        TestStaticTokenAwareMetastoreClientFactory.assertEqualHiveClient(metastoreClient2, FALLBACK_CLIENT);
        ticker.increment(StaticTokenAwareMetastoreClientFactory.Backoff.MAX_BACKOFF, TimeUnit.NANOSECONDS);
        ThriftMetastoreClient metastoreClient3 = clientFactory.createMetastoreClient(Optional.empty());
        TestStaticTokenAwareMetastoreClientFactory.assertEqualHiveClient(metastoreClient3, FALLBACK_CLIENT);
    }

    @Test
    public void testReturnsToDefaultClientAfterErrorOnFallback() throws TException {
        TestingTicker ticker = new TestingTicker();
        TokenAwareMetastoreClientFactory clientFactory = TestStaticTokenAwareMetastoreClientFactory.createMetastoreClientFactory(CONFIG_WITH_FALLBACK, CLIENTS, (Ticker)ticker);
        ticker.increment(10L, TimeUnit.NANOSECONDS);
        ThriftMetastoreClient metastoreClient1 = clientFactory.createMetastoreClient(Optional.empty());
        TestStaticTokenAwareMetastoreClientFactory.assertEqualHiveClient(metastoreClient1, DEFAULT_CLIENT);
        TestStaticTokenAwareMetastoreClientFactory.assertGetTableException(metastoreClient1);
        ticker.increment(10L, TimeUnit.NANOSECONDS);
        ThriftMetastoreClient metastoreClient2 = clientFactory.createMetastoreClient(Optional.empty());
        TestStaticTokenAwareMetastoreClientFactory.assertEqualHiveClient(metastoreClient2, FALLBACK_CLIENT);
        TestStaticTokenAwareMetastoreClientFactory.assertGetTableException(metastoreClient2);
        ticker.increment(10L, TimeUnit.NANOSECONDS);
        ThriftMetastoreClient metastoreClient3 = clientFactory.createMetastoreClient(Optional.empty());
        TestStaticTokenAwareMetastoreClientFactory.assertEqualHiveClient(metastoreClient3, DEFAULT_CLIENT);
    }

    private static void assertGetTableException(ThriftMetastoreClient client) {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> client.getTable("foo", "bar")).isInstanceOf(TException.class)).hasMessageContaining("Read timeout");
    }

    private static void assertCreateClientFails(TokenAwareMetastoreClientFactory clientFactory, String message) {
        Assertions.assertThatThrownBy(() -> clientFactory.createMetastoreClient(Optional.empty())).hasCauseInstanceOf(TException.class).hasMessage(message);
    }

    private static TokenAwareMetastoreClientFactory createMetastoreClientFactory(StaticMetastoreConfig config, Map<String, Optional<ThriftMetastoreClient>> clients) {
        return TestStaticTokenAwareMetastoreClientFactory.createMetastoreClientFactory(config, clients, Ticker.systemTicker());
    }

    private static TokenAwareMetastoreClientFactory createMetastoreClientFactory(StaticMetastoreConfig config, Map<String, Optional<ThriftMetastoreClient>> clients, Ticker ticker) {
        return new StaticTokenAwareMetastoreClientFactory(config, new ThriftMetastoreAuthenticationConfig(), (ThriftMetastoreClientFactory)new MockThriftMetastoreClientFactory(clients), ticker);
    }

    private static ThriftMetastoreClient createFakeMetastoreClient() {
        return new MockThriftMetastoreClient(){

            @Override
            public Table getTable(String dbName, String tableName) throws TException {
                throw new TException((Throwable)new SocketTimeoutException("Read timeout"));
            }
        };
    }

    private static void assertEqualHiveClient(ThriftMetastoreClient actual, ThriftMetastoreClient expected) {
        if (actual instanceof FailureAwareThriftMetastoreClient) {
            actual = ((FailureAwareThriftMetastoreClient)actual).getDelegate();
        }
        if (expected instanceof FailureAwareThriftMetastoreClient) {
            expected = ((FailureAwareThriftMetastoreClient)expected).getDelegate();
        }
        Assertions.assertThat((Object)actual).isEqualTo((Object)expected);
    }
}

