/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.metastore.thrift;

import io.trino.plugin.hive.metastore.thrift.MetastoreSupportsDateStatistics;
import io.trino.plugin.hive.metastore.thrift.ThriftHiveMetastoreClient;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.thrift.TConfiguration;
import org.apache.thrift.TException;
import org.apache.thrift.transport.TTransport;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestThriftHiveMetastoreClient {
    @Test
    public void testAlternativeCall() throws TException {
        AtomicInteger connectionCount = new AtomicInteger();
        AtomicInteger chosenOption = new AtomicInteger(Integer.MAX_VALUE);
        ThriftHiveMetastoreClient.AlternativeCall failure = () -> {
            throw new RuntimeException("yay! exception");
        };
        ThriftHiveMetastoreClient.AlternativeCall sucesss1 = () -> "first";
        ThriftHiveMetastoreClient.AlternativeCall sucesss2 = () -> "second";
        ThriftHiveMetastoreClient client = new ThriftHiveMetastoreClient(() -> {
            connectionCount.incrementAndGet();
            return new TTransportMock();
        }, "dummy", Optional.empty(), new MetastoreSupportsDateStatistics(), new AtomicInteger(), new AtomicInteger(), new AtomicInteger(), new AtomicInteger());
        Assertions.assertThat((int)connectionCount.get()).isEqualTo(1);
        Assertions.assertThat((String)((String)client.alternativeCall(e -> false, chosenOption, new ThriftHiveMetastoreClient.AlternativeCall[]{sucesss1, sucesss2, failure}))).isEqualTo("first");
        Assertions.assertThat((int)connectionCount.get()).isEqualTo(1);
        Assertions.assertThat((int)chosenOption.get()).isEqualTo(0);
        chosenOption.set(Integer.MAX_VALUE);
        Assertions.assertThat((String)((String)client.alternativeCall(e -> false, chosenOption, new ThriftHiveMetastoreClient.AlternativeCall[]{failure, sucesss1, sucesss2}))).isEqualTo("first");
        Assertions.assertThat((int)connectionCount.get()).isEqualTo(2);
        Assertions.assertThat((int)chosenOption.get()).isEqualTo(1);
        Assertions.assertThat((String)((String)client.alternativeCall(e -> false, chosenOption, new ThriftHiveMetastoreClient.AlternativeCall[]{failure, sucesss1, sucesss2}))).isEqualTo("first");
        Assertions.assertThat((int)connectionCount.get()).isEqualTo(2);
    }

    private static class TTransportMock
    extends TTransport {
        private TTransportMock() {
        }

        public boolean isOpen() {
            throw new UnsupportedOperationException();
        }

        public void open() {
            throw new UnsupportedOperationException();
        }

        public void close() {
        }

        public int read(byte[] bytes, int i, int i1) {
            throw new UnsupportedOperationException();
        }

        public void write(byte[] bytes, int i, int i1) {
            throw new UnsupportedOperationException();
        }

        public TConfiguration getConfiguration() {
            throw new UnsupportedOperationException();
        }

        public void updateKnownMessageSize(long size) {
            throw new UnsupportedOperationException();
        }

        public void checkReadBytesAvailable(long numBytes) {
            throw new UnsupportedOperationException();
        }
    }
}

