/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.metastore.thrift;

import com.google.common.net.HostAndPort;
import io.airlift.units.Duration;
import io.trino.plugin.hive.metastore.thrift.DefaultThriftMetastoreClientFactory;
import io.trino.plugin.hive.metastore.thrift.HiveMetastoreAuthentication;
import io.trino.plugin.hive.metastore.thrift.MetastoreClientAdapterProvider;
import io.trino.plugin.hive.metastore.thrift.NoHiveMetastoreAuthentication;
import io.trino.plugin.hive.metastore.thrift.ThriftMetastoreClient;
import io.trino.plugin.hive.metastore.thrift.TokenAwareMetastoreClientFactory;
import java.net.URI;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.apache.thrift.TException;

public class TestingTokenAwareMetastoreClientFactory
implements TokenAwareMetastoreClientFactory {
    private static final HiveMetastoreAuthentication AUTHENTICATION = new NoHiveMetastoreAuthentication();
    public static final Duration TIMEOUT = new Duration(20.0, TimeUnit.SECONDS);
    private final DefaultThriftMetastoreClientFactory factory;
    private final URI address;
    private final MetastoreClientAdapterProvider metastoreClientAdapterProvider;

    public TestingTokenAwareMetastoreClientFactory(Optional<HostAndPort> socksProxy, URI uri) {
        this(socksProxy, uri, TIMEOUT, delegate -> delegate);
    }

    public TestingTokenAwareMetastoreClientFactory(Optional<HostAndPort> socksProxy, URI address, Duration timeout) {
        this(socksProxy, address, timeout, delegate -> delegate);
    }

    public TestingTokenAwareMetastoreClientFactory(Optional<HostAndPort> socksProxy, URI uri, Duration timeout, MetastoreClientAdapterProvider metastoreClientAdapterProvider) {
        this.factory = new DefaultThriftMetastoreClientFactory(Optional.empty(), socksProxy, timeout, timeout, AUTHENTICATION, "localhost", Optional.empty());
        this.address = Objects.requireNonNull(uri, "uri is null");
        this.metastoreClientAdapterProvider = Objects.requireNonNull(metastoreClientAdapterProvider, "metastoreClientAdapterProvider is null");
    }

    public ThriftMetastoreClient createMetastoreClient(Optional<String> delegationToken) throws TException {
        return this.metastoreClientAdapterProvider.createThriftMetastoreClientAdapter(this.factory.create(this.address, delegationToken));
    }
}

