/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.optimizer;

import com.google.common.collect.ImmutableList;
import com.google.common.io.MoreFiles;
import com.google.common.io.RecursiveDeleteOption;
import io.airlift.slice.Slices;
import io.trino.Session;
import io.trino.metadata.ResolvedFunction;
import io.trino.metadata.TestingFunctionResolution;
import io.trino.metastore.Database;
import io.trino.metastore.HiveMetastore;
import io.trino.metastore.HiveMetastoreFactory;
import io.trino.plugin.hive.TestingHiveConnectorFactory;
import io.trino.plugin.hive.TestingHiveUtils;
import io.trino.spi.connector.ConnectorFactory;
import io.trino.spi.function.OperatorType;
import io.trino.spi.security.PrincipalType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.analyzer.TypeSignatureProvider;
import io.trino.sql.ir.Between;
import io.trino.sql.ir.Booleans;
import io.trino.sql.ir.Call;
import io.trino.sql.ir.Comparison;
import io.trino.sql.ir.Constant;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.In;
import io.trino.sql.ir.Logical;
import io.trino.sql.ir.Reference;
import io.trino.sql.planner.OptimizerConfig;
import io.trino.sql.planner.assertions.BasePlanTest;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.plan.ExchangeNode;
import io.trino.sql.planner.plan.JoinType;
import io.trino.testing.PlanTester;
import io.trino.testing.TestingSession;
import io.trino.type.LikePattern;
import io.trino.type.LikePatternType;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class TestHivePlans
extends BasePlanTest {
    private static final String HIVE_CATALOG_NAME = "hive";
    private static final String SCHEMA_NAME = "test_schema";
    private static final Session HIVE_SESSION = TestingSession.testSessionBuilder().setCatalog("hive").setSchema("test_schema").build();
    private static final TestingFunctionResolution FUNCTIONS = new TestingFunctionResolution();
    private static final ResolvedFunction LIKE = FUNCTIONS.resolveFunction("$like", TypeSignatureProvider.fromTypes((Type[])new Type[]{VarcharType.createVarcharType((int)5), LikePatternType.LIKE_PATTERN}));
    private static final ResolvedFunction SUBSTRING = FUNCTIONS.resolveFunction("substring", TypeSignatureProvider.fromTypes((Type[])new Type[]{VarcharType.createVarcharType((int)5), BigintType.BIGINT}));
    private static final ResolvedFunction MODULUS_INTEGER = FUNCTIONS.resolveOperator(OperatorType.MODULUS, (List)ImmutableList.of((Object)IntegerType.INTEGER, (Object)IntegerType.INTEGER));
    private File baseDir;

    protected PlanTester createPlanTester() {
        try {
            this.baseDir = Files.createTempDirectory(null, new FileAttribute[0]).toFile();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        PlanTester planTester = PlanTester.create((Session)HIVE_SESSION);
        planTester.createCatalog(HIVE_CATALOG_NAME, (ConnectorFactory)new TestingHiveConnectorFactory(this.baseDir.toPath()), Map.of("hive.max-partitions-for-eager-load", "5"));
        HiveMetastore metastore = TestingHiveUtils.getConnectorService(planTester, HiveMetastoreFactory.class).createMetastore(Optional.empty());
        metastore.createDatabase(Database.builder().setDatabaseName(SCHEMA_NAME).setOwnerName(Optional.of("public")).setOwnerType(Optional.of(PrincipalType.ROLE)).build());
        return planTester;
    }

    @BeforeAll
    public void setUp() {
        PlanTester planTester = this.getPlanTester();
        String values = "VALUES ('one', 1), ('two', 2), ('three', 3), ('four', 4), ('five', 5)";
        planTester.executeStatement("CREATE TABLE table_int_partitioned WITH (partitioned_by = ARRAY['int_part']) AS SELECT str_col, int_part FROM (" + values + ") t(str_col, int_part)");
        planTester.executeStatement("CREATE TABLE table_str_partitioned WITH (partitioned_by = ARRAY['str_part']) AS SELECT int_col, str_part FROM (" + values + ") t(str_part, int_col)");
        planTester.executeStatement("CREATE TABLE table_int_with_too_many_partitions WITH (partitioned_by = ARRAY['int_part']) AS SELECT str_col, int_part FROM (" + values + ", ('six', 6)) t(str_col, int_part)");
        planTester.executeStatement("CREATE TABLE table_unpartitioned AS SELECT str_col, int_col FROM (" + values + ") t(str_col, int_col)");
    }

    @AfterAll
    public void cleanup() throws Exception {
        if (this.baseDir != null) {
            MoreFiles.deleteRecursively((Path)this.baseDir.toPath(), (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE});
        }
    }

    @Test
    public void testPruneSimplePartitionLikeFilter() {
        this.assertDistributedPlan("SELECT * FROM table_str_partitioned WHERE str_part LIKE 't%'", PlanMatchPattern.output((PlanMatchPattern)PlanMatchPattern.filter((Expression)new Call(FUNCTIONS.resolveFunction("$like", TypeSignatureProvider.fromTypes((Type[])new Type[]{VarcharType.createVarcharType((int)55), LikePatternType.LIKE_PATTERN})), (List)ImmutableList.of((Object)new Reference((Type)VarcharType.createVarcharType((int)55), "STR_PART"), (Object)new Constant((Type)LikePatternType.LIKE_PATTERN, (Object)LikePattern.compile((String)"t%", Optional.empty())))), (PlanMatchPattern)PlanMatchPattern.tableScan((String)"table_str_partitioned", Map.of("INT_COL", "int_col", "STR_PART", "str_part")))));
    }

    @Test
    public void testPrunePartitionLikeFilter() {
        this.assertDistributedPlan("SELECT l.int_col, r.int_col FROM table_str_partitioned l JOIN table_unpartitioned r ON l.str_part = r.str_col WHERE l.str_part LIKE 't%'", this.noJoinReordering(), PlanMatchPattern.output((PlanMatchPattern)PlanMatchPattern.join((JoinType)JoinType.INNER, builder -> builder.equiCriteria("L_STR_PART", "R_STR_COL").left(PlanMatchPattern.exchange((ExchangeNode.Scope)ExchangeNode.Scope.REMOTE, (ExchangeNode.Type)ExchangeNode.Type.REPARTITION, (PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.filter((Expression)new Call(LIKE, (List)ImmutableList.of((Object)new Reference((Type)VarcharType.createVarcharType((int)5), "L_STR_PART"), (Object)new Constant((Type)LikePatternType.LIKE_PATTERN, (Object)LikePattern.compile((String)"t%", Optional.empty())))), (PlanMatchPattern)PlanMatchPattern.tableScan((String)"table_str_partitioned", Map.of("L_INT_COL", "int_col", "L_STR_PART", "str_part")))})).right(PlanMatchPattern.exchange((ExchangeNode.Scope)ExchangeNode.Scope.LOCAL, (PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.exchange((ExchangeNode.Scope)ExchangeNode.Scope.REMOTE, (ExchangeNode.Type)ExchangeNode.Type.REPARTITION, (PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.filter((Expression)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new In((Expression)new Reference((Type)VarcharType.createVarcharType((int)5), "R_STR_COL"), (List)ImmutableList.of((Object)new Constant((Type)VarcharType.createVarcharType((int)5), (Object)Slices.utf8Slice((String)"three")), (Object)new Constant((Type)VarcharType.createVarcharType((int)5), (Object)Slices.utf8Slice((String)"two")))), (Object)new Call(LIKE, (List)ImmutableList.of((Object)new Reference((Type)VarcharType.createVarcharType((int)5), "R_STR_COL"), (Object)new Constant((Type)LikePatternType.LIKE_PATTERN, (Object)LikePattern.compile((String)"t%", Optional.empty())))))), (PlanMatchPattern)PlanMatchPattern.tableScan((String)"table_unpartitioned", Map.of("R_STR_COL", "str_col", "R_INT_COL", "int_col")))})})))));
    }

    @Test
    public void testSubsumePartitionFilter() {
        this.assertDistributedPlan("SELECT l.str_col, r.str_col FROM table_int_partitioned l JOIN table_unpartitioned r ON l.int_part = r.int_col WHERE l.int_part BETWEEN 2 AND 4", this.noJoinReordering(), PlanMatchPattern.output((PlanMatchPattern)PlanMatchPattern.join((JoinType)JoinType.INNER, builder -> builder.equiCriteria("L_INT_PART", "R_INT_COL").left(PlanMatchPattern.exchange((ExchangeNode.Scope)ExchangeNode.Scope.REMOTE, (ExchangeNode.Type)ExchangeNode.Type.REPARTITION, (PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.filter((Expression)Booleans.TRUE, (PlanMatchPattern)PlanMatchPattern.tableScan((String)"table_int_partitioned", Map.of("L_INT_PART", "int_part", "L_STR_COL", "str_col")))})).right(PlanMatchPattern.exchange((ExchangeNode.Scope)ExchangeNode.Scope.LOCAL, (PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.exchange((ExchangeNode.Scope)ExchangeNode.Scope.REMOTE, (ExchangeNode.Type)ExchangeNode.Type.REPARTITION, (PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.filter((Expression)new Between((Expression)new Reference((Type)IntegerType.INTEGER, "R_INT_COL"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)2L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)4L)), (PlanMatchPattern)PlanMatchPattern.tableScan((String)"table_unpartitioned", Map.of("R_STR_COL", "str_col", "R_INT_COL", "int_col")))})})))));
    }

    @Test
    public void testSubsumePartitionPartOfAFilter() {
        this.assertDistributedPlan("SELECT l.str_col, r.str_col FROM table_int_partitioned l JOIN table_unpartitioned r ON l.int_part = r.int_col WHERE l.int_part BETWEEN 2 AND 4 AND l.str_col != 'three'", this.noJoinReordering(), PlanMatchPattern.output((PlanMatchPattern)PlanMatchPattern.join((JoinType)JoinType.INNER, builder -> builder.equiCriteria("L_INT_PART", "R_INT_COL").left(PlanMatchPattern.exchange((ExchangeNode.Scope)ExchangeNode.Scope.REMOTE, (ExchangeNode.Type)ExchangeNode.Type.REPARTITION, (PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.filter((Expression)new Comparison(Comparison.Operator.NOT_EQUAL, (Expression)new Reference((Type)VarcharType.createVarcharType((int)5), "L_STR_COL"), (Expression)new Constant((Type)VarcharType.createVarcharType((int)5), (Object)Slices.utf8Slice((String)"three"))), (PlanMatchPattern)PlanMatchPattern.tableScan((String)"table_int_partitioned", Map.of("L_INT_PART", "int_part", "L_STR_COL", "str_col")))})).right(PlanMatchPattern.exchange((ExchangeNode.Scope)ExchangeNode.Scope.LOCAL, (PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.exchange((ExchangeNode.Scope)ExchangeNode.Scope.REMOTE, (ExchangeNode.Type)ExchangeNode.Type.REPARTITION, (PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.filter((Expression)new Between((Expression)new Reference((Type)IntegerType.INTEGER, "R_INT_COL"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)2L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)4L)), (PlanMatchPattern)PlanMatchPattern.tableScan((String)"table_unpartitioned", Map.of("R_STR_COL", "str_col", "R_INT_COL", "int_col")))})})))));
    }

    @Test
    public void testSubsumePartitionPartWhenOtherFilterNotConvertibleToTupleDomain() {
        this.assertDistributedPlan("SELECT l.str_col, r.str_col FROM table_int_partitioned l JOIN table_unpartitioned r ON l.int_part = r.int_col WHERE l.int_part BETWEEN 2 AND 4 AND substring(l.str_col, 2) != 'hree'", this.noJoinReordering(), PlanMatchPattern.output((PlanMatchPattern)PlanMatchPattern.join((JoinType)JoinType.INNER, builder -> builder.equiCriteria("L_INT_PART", "R_INT_COL").left(PlanMatchPattern.exchange((ExchangeNode.Scope)ExchangeNode.Scope.REMOTE, (ExchangeNode.Type)ExchangeNode.Type.REPARTITION, (PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.filter((Expression)new Comparison(Comparison.Operator.NOT_EQUAL, (Expression)new Call(SUBSTRING, (List)ImmutableList.of((Object)new Reference((Type)VarcharType.createVarcharType((int)5), "L_STR_COL"), (Object)new Constant((Type)BigintType.BIGINT, (Object)2L))), (Expression)new Constant((Type)VarcharType.createVarcharType((int)5), (Object)Slices.utf8Slice((String)"hree"))), (PlanMatchPattern)PlanMatchPattern.tableScan((String)"table_int_partitioned", Map.of("L_INT_PART", "int_part", "L_STR_COL", "str_col")))})).right(PlanMatchPattern.exchange((ExchangeNode.Scope)ExchangeNode.Scope.LOCAL, (PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.exchange((ExchangeNode.Scope)ExchangeNode.Scope.REMOTE, (ExchangeNode.Type)ExchangeNode.Type.REPARTITION, (PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.filter((Expression)new Between((Expression)new Reference((Type)IntegerType.INTEGER, "R_INT_COL"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)2L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)4L)), (PlanMatchPattern)PlanMatchPattern.tableScan((String)"table_unpartitioned", Map.of("R_STR_COL", "str_col", "R_INT_COL", "int_col")))})})))));
    }

    @Test
    public void testSubsumePartitionFilterNotConvertibleToTupleDomain() {
        this.assertDistributedPlan("SELECT l.str_col, r.str_col FROM table_int_partitioned l JOIN table_unpartitioned r ON l.int_part = r.int_col WHERE l.int_part BETWEEN 2 AND 4 AND l.int_part % 2 = 0", this.noJoinReordering(), PlanMatchPattern.output((PlanMatchPattern)PlanMatchPattern.join((JoinType)JoinType.INNER, builder -> builder.equiCriteria("L_INT_PART", "R_INT_COL").filter((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Call(MODULUS_INTEGER, (List)ImmutableList.of((Object)new Reference((Type)IntegerType.INTEGER, "R_INT_COL"), (Object)new Constant((Type)IntegerType.INTEGER, (Object)2L))), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L))).left(PlanMatchPattern.exchange((ExchangeNode.Scope)ExchangeNode.Scope.REMOTE, (ExchangeNode.Type)ExchangeNode.Type.REPARTITION, (PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.any((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.tableScan((String)"table_int_partitioned", Map.of("L_INT_PART", "int_part", "L_STR_COL", "str_col"))})})).right(PlanMatchPattern.exchange((ExchangeNode.Scope)ExchangeNode.Scope.LOCAL, (PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.exchange((ExchangeNode.Scope)ExchangeNode.Scope.REMOTE, (ExchangeNode.Type)ExchangeNode.Type.REPARTITION, (PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.filter((Expression)new Between((Expression)new Reference((Type)IntegerType.INTEGER, "R_INT_COL"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)2L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)4L)), (PlanMatchPattern)PlanMatchPattern.tableScan((String)"table_unpartitioned", Map.of("R_STR_COL", "str_col", "R_INT_COL", "int_col")))})})))));
    }

    @Test
    public void testFilterDerivedFromTableProperties() {
        this.assertDistributedPlan("SELECT l.str_col, r.str_col FROM table_int_partitioned l JOIN table_unpartitioned r ON l.int_part = r.int_col", this.noJoinReordering(), PlanMatchPattern.output((PlanMatchPattern)PlanMatchPattern.join((JoinType)JoinType.INNER, builder -> builder.equiCriteria("L_INT_PART", "R_INT_COL").left(PlanMatchPattern.exchange((ExchangeNode.Scope)ExchangeNode.Scope.REMOTE, (ExchangeNode.Type)ExchangeNode.Type.REPARTITION, (PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.filter((Expression)Booleans.TRUE, (PlanMatchPattern)PlanMatchPattern.tableScan((String)"table_int_partitioned", Map.of("L_INT_PART", "int_part", "L_STR_COL", "str_col")))})).right(PlanMatchPattern.exchange((ExchangeNode.Scope)ExchangeNode.Scope.LOCAL, (PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.exchange((ExchangeNode.Scope)ExchangeNode.Scope.REMOTE, (ExchangeNode.Type)ExchangeNode.Type.REPARTITION, (PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.filter((Expression)new Between((Expression)new Reference((Type)IntegerType.INTEGER, "R_INT_COL"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)5L)), (PlanMatchPattern)PlanMatchPattern.tableScan((String)"table_unpartitioned", Map.of("R_STR_COL", "str_col", "R_INT_COL", "int_col")))})})))));
    }

    @Test
    public void testQueryScanningForTooManyPartitions() {
        String query = "SELECT l.str_col, r.str_col FROM table_int_with_too_many_partitions l JOIN table_unpartitioned r ON l.int_part = r.int_col";
        this.assertDistributedPlan(query, PlanMatchPattern.output((PlanMatchPattern)PlanMatchPattern.join((JoinType)JoinType.INNER, builder -> builder.equiCriteria("L_INT_PART", "R_INT_COL").left(PlanMatchPattern.filter((Expression)Booleans.TRUE, (PlanMatchPattern)PlanMatchPattern.tableScan((String)"table_int_with_too_many_partitions", Map.of("L_INT_PART", "int_part", "L_STR_COL", "str_col")))).right(PlanMatchPattern.exchange((ExchangeNode.Scope)ExchangeNode.Scope.LOCAL, (PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.exchange((ExchangeNode.Scope)ExchangeNode.Scope.REMOTE, (ExchangeNode.Type)ExchangeNode.Type.REPLICATE, (PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.tableScan((String)"table_unpartitioned", Map.of("R_STR_COL", "str_col", "R_INT_COL", "int_col"))})})))));
    }

    private Session noJoinReordering() {
        return Session.builder((Session)this.getPlanTester().getDefaultSession()).setSystemProperty("join_reordering_strategy", OptimizerConfig.JoinReorderingStrategy.NONE.name()).setSystemProperty("join_distribution_type", OptimizerConfig.JoinDistributionType.PARTITIONED.name()).build();
    }
}

