/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.optimizer;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.io.MoreFiles;
import com.google.common.io.RecursiveDeleteOption;
import io.trino.Session;
import io.trino.metadata.QualifiedObjectName;
import io.trino.metadata.ResolvedFunction;
import io.trino.metadata.TableHandle;
import io.trino.metadata.TestingFunctionResolution;
import io.trino.metastore.Database;
import io.trino.metastore.HiveMetastore;
import io.trino.metastore.HiveMetastoreFactory;
import io.trino.plugin.hive.HiveColumnHandle;
import io.trino.plugin.hive.HiveTableHandle;
import io.trino.plugin.hive.TestHiveReaderProjectionsUtil;
import io.trino.plugin.hive.TestingHiveConnectorFactory;
import io.trino.plugin.hive.TestingHiveUtils;
import io.trino.spi.connector.ConnectorFactory;
import io.trino.spi.function.OperatorType;
import io.trino.spi.predicate.Domain;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.security.PrincipalType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.Type;
import io.trino.sql.ir.Call;
import io.trino.sql.ir.Cast;
import io.trino.sql.ir.Comparison;
import io.trino.sql.ir.Constant;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.FieldReference;
import io.trino.sql.ir.Logical;
import io.trino.sql.ir.Reference;
import io.trino.sql.planner.assertions.BasePushdownPlanTest;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.plan.JoinType;
import io.trino.testing.PlanTester;
import io.trino.testing.TestingSession;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Test;

public class TestHiveProjectionPushdownIntoTableScan
extends BasePushdownPlanTest {
    private static final TestingFunctionResolution FUNCTIONS = new TestingFunctionResolution();
    private static final ResolvedFunction ADD_INTEGER = FUNCTIONS.resolveOperator(OperatorType.ADD, (List)ImmutableList.of((Object)IntegerType.INTEGER, (Object)IntegerType.INTEGER));
    private static final String HIVE_CATALOG_NAME = "hive";
    private static final String SCHEMA_NAME = "test_schema";
    private static final Session HIVE_SESSION = TestingSession.testSessionBuilder().setCatalog("hive").setSchema("test_schema").build();
    private File baseDir;

    protected PlanTester createPlanTester() {
        try {
            this.baseDir = Files.createTempDirectory(null, new FileAttribute[0]).toFile();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        PlanTester planTester = PlanTester.create((Session)HIVE_SESSION);
        planTester.createCatalog(HIVE_CATALOG_NAME, (ConnectorFactory)new TestingHiveConnectorFactory(this.baseDir.toPath()), (Map)ImmutableMap.of());
        HiveMetastore metastore = TestingHiveUtils.getConnectorService(planTester, HiveMetastoreFactory.class).createMetastore(Optional.empty());
        metastore.createDatabase(Database.builder().setDatabaseName(SCHEMA_NAME).setOwnerName(Optional.of("public")).setOwnerType(Optional.of(PrincipalType.ROLE)).build());
        return planTester;
    }

    @Test
    public void testPushdownDisabled() {
        String testTable = "test_disabled_pushdown";
        Session session = Session.builder((Session)this.getPlanTester().getDefaultSession()).setCatalogSessionProperty(HIVE_CATALOG_NAME, "projection_pushdown_enabled", "false").build();
        this.getPlanTester().executeStatement(String.format("CREATE TABLE %s (col0) AS SELECT cast(row(5, 6) as row(a bigint, b bigint)) AS col0 WHERE false", testTable));
        this.assertPlan(String.format("SELECT col0.a expr_a, col0.b expr_b FROM %s", testTable), session, PlanMatchPattern.any((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.project((Map)ImmutableMap.of((Object)"expr", (Object)PlanMatchPattern.expression((Expression)new FieldReference((Expression)new Reference((Type)RowType.anonymousRow((Type[])new Type[]{BigintType.BIGINT, BigintType.BIGINT}), "col0"), 0)), (Object)"expr_2", (Object)PlanMatchPattern.expression((Expression)new FieldReference((Expression)new Reference((Type)RowType.anonymousRow((Type[])new Type[]{BigintType.BIGINT, BigintType.BIGINT}), "col0"), 1))), (PlanMatchPattern)PlanMatchPattern.tableScan((String)testTable, (Map)ImmutableMap.of((Object)"col0", (Object)"col0")))}));
    }

    @Test
    public void testDereferencePushdown() {
        String testTable = "test_simple_projection_pushdown";
        QualifiedObjectName completeTableName = new QualifiedObjectName(HIVE_CATALOG_NAME, SCHEMA_NAME, testTable);
        this.getPlanTester().executeStatement(String.format("CREATE TABLE %s (col0, col1) AS SELECT cast(row(5, 6) as row(x bigint, y bigint)) AS col0, 5 AS col1 WHERE false", testTable));
        Session session = this.getPlanTester().getDefaultSession();
        Optional tableHandle = this.getTableHandle(session, completeTableName);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)tableHandle.isPresent()).describedAs("expected the table handle to be present", new Object[0])).isTrue();
        Map columns = this.getColumnHandles(session, completeTableName);
        HiveColumnHandle column0Handle = (HiveColumnHandle)columns.get("col0");
        HiveColumnHandle column1Handle = (HiveColumnHandle)columns.get("col1");
        HiveColumnHandle columnX = TestHiveReaderProjectionsUtil.createProjectedColumnHandle(column0Handle, (List<Integer>)ImmutableList.of((Object)0));
        HiveColumnHandle columnY = TestHiveReaderProjectionsUtil.createProjectedColumnHandle(column0Handle, (List<Integer>)ImmutableList.of((Object)1));
        PlanMatchPattern[] planMatchPatternArray = new PlanMatchPattern[1];
        planMatchPatternArray[0] = PlanMatchPattern.tableScan(arg_0 -> ((HiveTableHandle)((HiveTableHandle)((TableHandle)tableHandle.get()).connectorHandle()).withProjectedColumns((Set)ImmutableSet.of((Object)columnX, (Object)columnY))).equals(arg_0), (TupleDomain)TupleDomain.all(), (Map)ImmutableMap.of((Object)"col0#x", arg_0 -> ((HiveColumnHandle)columnX).equals(arg_0), (Object)"col0#y", arg_0 -> ((HiveColumnHandle)columnY).equals(arg_0)));
        this.assertPlan("SELECT col0.x expr_x, col0.y expr_y FROM " + testTable, PlanMatchPattern.any((PlanMatchPattern[])planMatchPatternArray));
        PlanMatchPattern[] planMatchPatternArray2 = new PlanMatchPattern[1];
        planMatchPatternArray2[0] = PlanMatchPattern.filter((Expression)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "col0_y"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)2L)), (Object)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "col0_x"), (Expression)new Cast((Expression)new Call(ADD_INTEGER, (List)ImmutableList.of((Object)new Reference((Type)IntegerType.INTEGER, "col1"), (Object)new Constant((Type)IntegerType.INTEGER, (Object)3L))), (Type)BigintType.BIGINT)))), (PlanMatchPattern)PlanMatchPattern.tableScan(table -> {
            HiveTableHandle hiveTableHandle = (HiveTableHandle)table;
            return hiveTableHandle.getCompactEffectivePredicate().equals((Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)columnY, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)2L)))) && hiveTableHandle.getProjectedColumns().equals(ImmutableSet.of((Object)column1Handle, (Object)columnX, (Object)columnY));
        }, (TupleDomain)TupleDomain.all(), (Map)ImmutableMap.of((Object)"col0_y", arg_0 -> ((HiveColumnHandle)columnY).equals(arg_0), (Object)"col0_x", arg_0 -> ((HiveColumnHandle)columnX).equals(arg_0), (Object)"col1", arg_0 -> ((HiveColumnHandle)column1Handle).equals(arg_0))));
        this.assertPlan(String.format("SELECT col0.x FROM %s WHERE col0.x = col1 + 3 and col0.y = 2", testTable), PlanMatchPattern.anyTree((PlanMatchPattern[])planMatchPatternArray2));
        PlanMatchPattern[] planMatchPatternArray3 = new PlanMatchPattern[1];
        planMatchPatternArray3[0] = PlanMatchPattern.filter((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "col0_x"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)5L)), (PlanMatchPattern)PlanMatchPattern.tableScan(table -> {
            HiveTableHandle hiveTableHandle = (HiveTableHandle)table;
            return hiveTableHandle.getCompactEffectivePredicate().equals((Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)columnX, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)5L)))) && hiveTableHandle.getProjectedColumns().equals(ImmutableSet.of((Object)column0Handle, (Object)columnX));
        }, (TupleDomain)TupleDomain.all(), (Map)ImmutableMap.of((Object)"col0", arg_0 -> ((HiveColumnHandle)column0Handle).equals(arg_0), (Object)"col0_x", arg_0 -> ((HiveColumnHandle)columnX).equals(arg_0))));
        this.assertPlan(String.format("SELECT col0, col0.y expr_y FROM %s WHERE col0.x = 5", testTable), PlanMatchPattern.anyTree((PlanMatchPattern[])planMatchPatternArray3));
        this.assertPlan(String.format("SELECT T.col0.x, T.col0, T.col0.y FROM %s T join %s S on T.col1 = S.col1 WHERE (T.col0.x = 2)", testTable, testTable), PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.project((Map)ImmutableMap.of((Object)"expr_0_x", (Object)PlanMatchPattern.expression((Expression)new FieldReference((Expression)new Reference((Type)RowType.anonymousRow((Type[])new Type[]{BigintType.BIGINT, BigintType.BIGINT}), "expr_0"), 0)), (Object)"expr_0", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)RowType.anonymousRow((Type[])new Type[]{BigintType.BIGINT, BigintType.BIGINT}), "expr_0")), (Object)"expr_0_y", (Object)PlanMatchPattern.expression((Expression)new FieldReference((Expression)new Reference((Type)RowType.anonymousRow((Type[])new Type[]{BigintType.BIGINT, BigintType.BIGINT}), "expr_0"), 1))), (PlanMatchPattern)PlanMatchPattern.join((JoinType)JoinType.INNER, builder -> {
            PlanMatchPattern[] planMatchPatternArray = new PlanMatchPattern[1];
            planMatchPatternArray[0] = PlanMatchPattern.filter((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "expr_0_x"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)2L)), (PlanMatchPattern)PlanMatchPattern.tableScan(table -> ((Map)((HiveTableHandle)table).getCompactEffectivePredicate().getDomains().get()).equals(ImmutableMap.of((Object)columnX, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)2L))), (TupleDomain)TupleDomain.all(), (Map)ImmutableMap.of((Object)"expr_0_x", arg_0 -> ((HiveColumnHandle)columnX).equals(arg_0), (Object)"expr_0", arg_0 -> ((HiveColumnHandle)column0Handle).equals(arg_0), (Object)"t_expr_1", arg_0 -> ((HiveColumnHandle)column1Handle).equals(arg_0))));
            PlanMatchPattern[] planMatchPatternArray2 = new PlanMatchPattern[1];
            planMatchPatternArray2[0] = PlanMatchPattern.tableScan(arg_0 -> ((HiveTableHandle)((HiveTableHandle)((TableHandle)tableHandle.get()).connectorHandle()).withProjectedColumns((Set)ImmutableSet.of((Object)column1Handle))).equals(arg_0), (TupleDomain)TupleDomain.all(), (Map)ImmutableMap.of((Object)"s_expr_1", arg_0 -> ((HiveColumnHandle)column1Handle).equals(arg_0)));
            builder.equiCriteria("t_expr_1", "s_expr_1").left(PlanMatchPattern.anyTree((PlanMatchPattern[])planMatchPatternArray)).right(PlanMatchPattern.anyTree((PlanMatchPattern[])planMatchPatternArray2));
        }))}));
    }

    @AfterAll
    public void cleanup() throws Exception {
        if (this.baseDir != null) {
            MoreFiles.deleteRecursively((Path)this.baseDir.toPath(), (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE});
        }
    }
}

